import React from 'react'
import { Box, Typography, Button, Modal,TextField, InputLabel } from '@mui/material'
import { toast } from 'react-toastify';


import api from '../../utils/api';
import routes from '../../utils/routes';
import { apiError } from '../../utils/error';
import styles from '../../styles/gsuitemodal.module.scss'
import CloseSharpIcon from '@mui/icons-material/CloseSharp';

const style = {
    position: 'absolute',
    top: '10%',
    left: '50%',
    transform: 'translateX(-50%)',
    width: 500,
    bgcolor: 'background.paper',
    border: 'unset',
    boxShadow: 24,
    p: 2,
    borderRadius:2
};
export default function AddCredentialOutlook(props) {
    const { handleClose, domainId, open} = props;

    const [getCredential, setCredential] = React.useState({
        clientId:'',
        clientSecret:'',
        tenantId:'',
        domainId: domainId
    })


    const [credentialError, setCredentialError] = React.useState({
        clientId: { status: false, message: ''},
        clientSecret: { status: false, message: ''},
        tenantId: { status: false, message: ''},
    })

    const handleChange = (e) =>{
        setCredentialError({...credentialError, [e.target.name] : { status: false, message: ''}})
        setCredential({...getCredential, [e.target.name]: e.target.value})
    }
    
    const saveCredential = () =>{
        const{clientId, clientSecret, tenantId} = getCredential;
        let error = false;

        if(clientId.length == 0){ 
        error = true,         
        setCredentialError((prevState) => ({...prevState, clientId: { status: true, message: 'Please enter client id.' }}))
    }
        if(clientSecret.length == 0) {
        error = true
        setCredentialError((prevState) => ({...prevState, clientSecret: { status: true, message: 'Please enter client secret.' }}))
    }
        if(tenantId.length == 0) {
        error = true
        setCredentialError((prevState) => ({...prevState, tenantId: { status: true, message: 'Please enter tenant id.' }}))
    }

        if(!error){
        api.post(routes.CREDENTIAL.OUTLOOK,{
            clientId, clientSecret,tenantId, domainId:domainId
        })
        .then(res => res.data)
        .then(data => {
            toast.success(data.message)
            handleClose();
        })
        .catch(err => {
            apiError(err);
        })
        }
    }

    return (
        <Modal
            open={open}
            onClose={handleClose}
            aria-labelledby="modal-modal-title"
            aria-describedby="modal-modal-description"
        >
            <Box className={styles.MainGsuiteModal}>

                 <Box className={styles.modalHeader}>
                        <Typography id="modal-modal-title" variant="h6">
                        Add Outlook Credential
                        </Typography>
                        <CloseSharpIcon className={styles.closeIcon} onClick={handleClose} />
                    </Box>

                <Box className={styles.MidsettingWrap}>
                   
                    <Box className={styles.FormBt}>
                      <InputLabel>Client Id</InputLabel>
                        <TextField 
                            name='clientId'
                            fullWidth  
                            size="small" 
                            placeholder="Enter Client Id"
                            onChange={handleChange}
                            error={credentialError.clientId.status}
                            helperText={credentialError.clientId.message}
                        />
                    </Box>
                    <Box className={styles.FormBt}>
                        <InputLabel>Secret Id</InputLabel>
                        <TextField 
                            name='clientSecret'
                            fullWidth 
                            size="small" 
                            placeholder="Enter Secret Id"
                            onChange={handleChange}
                            error={credentialError.clientSecret.status}
                            helperText={credentialError.clientSecret.message}
                         />
                    </Box>
                    <Box className={styles.FormBt}>
                     <InputLabel>Tenent Id</InputLabel>
                        <TextField
                            name='tenantId' 
                            fullWidth 
                            size="small" 
                            placeholder="Enter Tenent Id"
                            onChange={handleChange}
                            error={credentialError.tenantId.status}
                            helperText={credentialError.tenantId.message}
                         />
                    </Box>
                    <Box display="flex" justifyContent="flex-end" alignItems="flex-end">
                        <Button variant="contained" color="success" onClick={saveCredential}>Update</Button>
                    </Box>
                </Box>
                
            </Box>
        </Modal>
    )
}
