import React from "react";
import { toast } from "react-toastify";
import DatePicker from "react-datepicker";
import { validateEmail } from "../../utils/common";
import {
	Box,
	Typography,
	Grid,
	Modal,
	TextField,
	InputLabel,
	Button,
	FormControl,
	Select,
	MenuItem,
	FormHelperText,
} from "@mui/material";

import CloseSharpIcon from "@mui/icons-material/CloseSharp";

import api from "../../utils/api";
import routes from "../../utils/routes";
import { apiError } from "../../utils/error";
import styles from "../../styles/gsuitemodal.module.scss";

export default function AdvanceSearchModal(props) {
	const { handleClose, open, loadAdvanceSearchList } = props;
	const domainName = props.domains;

	const [formData, setFormData] = React.useState({
		from: "",
		to: "",
		subject: "",
		fromDate: new Date(new Date().setDate(new Date().getDate() - 1)),
		toDate: new Date(),
		domainId: "-1",
	});
	const [formDataError, setFormDataError] = React.useState({
		from: { status: false, message: "" },
		to: { status: false, message: "" },
		subject: { status: false, message: "" },
		fromDate: { status: false, message: "" },
		toDate: { status: false, message: "" },
		domainId: { status: false, message: "" },
	});

	const handleChange = (e) => {
		setFormData({ ...formData, [e.target.name]: e.target.value });
		setFormDataError({
			...formDataError,
			[e.target.name]: { status: false, message: "" },
		});
	};

	const postAdvanceSearchData = () => {
		const { from, domainId } = formData;
		let isError = false;
		if (domainId == "-1") {
			isError = true;
			setFormDataError((prevState) => ({
				...prevState,
				domainId: { status: true, message: "Please select domain" },
			}));
		}
//		if (!validateEmail(from)) {
//			isError = true;
//			setFormDataError((prevState) => ({
//				...prevState,
//				from: { status: true, message: "Please Enter Valid Sender Email" },
//			}));
//			}
		if (formData.fromDate == null) {
			isError = true;
			setFormDataError((prevState) => ({
				...prevState,
				fromDate: { status: true, message: "Date Cannot Be Empty!" },
			}));
		}
		if (formData.toDate == null) {
			isError = true;
			setFormDataError((prevState) => ({
				...prevState,
				toDate: { status: true, message: "Date Cannot Be Empty!" },
			}));
		}

		if (!isError) {
			api.post(routes.ADVANCE_SEARCH.CREATE, formData)
			.then((res) => res.data)
			.then((data) => {
				handleClose();
				loadAdvanceSearchList();
				toast.success(data.message);
			})
			.catch((err) => {
				apiError(err);
			});
		}
	};
        return (
          <Modal
            open={open}
            onClose={handleClose}
            aria-labelledby="modal-modal-title"
            aria-describedby="modal-modal-description"
          >
            <Box className={styles.MainGsuiteModal}>
              <Box className={styles.modalHeader}>
                <Typography id="modal-modal-title" variant="h6">
                  Advance Search
                </Typography>
                <CloseSharpIcon
                  className={styles.closeIcon}
                  onClick={handleClose}
                />
              </Box>
              <Box className={styles.MidsettingWrap}>
                <Grid
                  container
                  alignItems="center"
                  columnSpacing={{ xs: 1, sm: 2, md: 3 }}
                >
                  <Grid item sx={12} md={12} className={styles.FormBt}>
                    <InputLabel>Domain</InputLabel>
                    <FormControl fullWidth size="small">
                      <Select
                        labelId="demo-simple-select-autowidth-label"
                        id="demo-simple-select-autowidth"
                        value={formData.domainId}
                        onChange={handleChange}
                        fullWidth
                        name="domainId"
                        displayEmpty
                        className={styles.InputFieldBox}
                      >
                        <MenuItem value="-1">Select Domain</MenuItem>
                        {domainName.map((data, index) => (
                          <MenuItem
                            key={index}
                            value={data._id}
                            sx={{ fontSize: "14px" }}
                          >
                            {data.domainName}/
                            {data.domainTypeForOutlook == "OFFICE365"
                              ? "Outlook"
                              : data.domainTypeForOutlook == "EXCHANGE"
                              ? "Exchange"
                              : "Gsuite"}
                          </MenuItem>
                        ))}
                      </Select>
                      {formDataError.domainId.status ? (
                        <FormHelperText error>
                          {formDataError.domainId.message}
                        </FormHelperText>
                      ) : (
                        ""
                      )}
                    </FormControl>
                  </Grid>
                  <Grid item sx={12} md={6} className={styles.FormBt}>
                    <InputLabel>From</InputLabel>
                    <Box className={styles.datePicker}>
                      <DatePicker
                        error={formDataError.fromDate.status}
                        helpertext={formDataError.fromDate.message}
                        dateFormat="yyyy/MM/dd"
                        onKeyDown={(e) => e.preventDefault()}
                        disabledKeyboardNavigation
                        selected={formData.fromDate}
                        onChange={(date) => {
                          setFormData({ ...formData, fromDate: date });
                          setFormDataError({
                            ...formDataError,
                            fromDate: { status: false, message: "" },
                          });
                        }}
                        className={styles.InputFieldBox}
                        maxDate={formData.toDate ? formData.toDate : new Date()}
                      />
                      {formDataError.fromDate.status && (
                        <Typography component="span">
                          {formDataError.fromDate.message}
                        </Typography>
                      )}
                    </Box>
                  </Grid>
                  <Grid item sx={12} md={6} className={styles.FormBt}>
                    <InputLabel>To</InputLabel>
                    <Box className={styles.datePicker}>
                      <DatePicker
                        error={formDataError.toDate.status}
                        helperText={formDataError.toDate.message}
                        onKeyDown={(e) => e.preventDefault()}
                        dateFormat="yyyy/MM/dd"
                        selected={formData.toDate}
                        onChange={(date) => {
                          setFormData({ ...formData, toDate: date });
                          setFormDataError({
                            ...formDataError,
                            toDate: { status: false, message: "" },
                          });
                        }}
                        className={styles.InputFieldBox}
										maxDate={new Date()}
										minDate={formData.fromDate}
                      />
                      {formDataError.toDate.status && (
                        <Typography component="span">
                          {formDataError.fromDate.message}
                        </Typography>
                      )}
                    </Box>
                  </Grid>
              
                  <Grid item sx={12} md={6} className={`${styles.FormBt} ${styles.fixerrorMsg}`}>
                    <InputLabel>Sender</InputLabel>
                    <TextField
                      error={formDataError.from.status}
                      helperText={formDataError.from.message}
                      name="from"
                      value={formData.from}
                      size="small"
                      type="text"
                      placeholder="Enter Sender Email"
                      onChange={handleChange}
                      fullWidth
                      keyboard="true"
                      className={styles.InputFieldBox}
                    />
                  </Grid>
                  <Grid item sx={12} md={6} className={`${styles.FormBt} ${styles.fixerrorMsg}`}>
                    <InputLabel>Receiver</InputLabel>
                    <TextField
                      name="to"
                      value={formData.to}
                      size="small"
                      type="text"
                      placeholder="Enter Receiver Email"
                      onChange={handleChange}
                      fullWidth
                      className={styles.InputFieldBox}
                    />
                  </Grid>
                  <Grid item sx={12} md={6}>
                    <InputLabel>Subject</InputLabel>
                    <TextField
                      error={formDataError.subject.status}
                      helperText={formDataError.subject.message}
                      value={formData.subject}
                      name="subject"
                      size="small"
                      type="text"
                      placeholder="Enter Subject"
                      onChange={handleChange}
                      fullWidth
                      className={styles.InputFieldBox}
                    />
                  </Grid>
                </Grid>
                <Box
                  display="flex"
                  justifyContent="flex-end"
                  alignItems="flex-end"
                >
                  <Button
                    variant="contained"
                    color="success"
                    onClick={postAdvanceSearchData}
                    className={styles.primaryBtn}
                  >
                    Save
                  </Button>
                </Box>
              </Box>
            </Box>
          </Modal>
        );
}
