import React, { createContext, useState } from 'react';
import api from '../utils/api';
import Cookies from 'js-cookie';
import routes from '../utils/routes';
import { apiError } from '../utils/error';
import { useRouter } from 'next/router'


const AppContext = createContext();

const AppProvider = ({ children }) => {
  const [domains, setDomains] = useState('');
  const [domainChange, setDomainChange] = useState(false)
  const [isLite, setisLite] = useState(false)
  const [isMessengerEnabled, setIsMessengerEnabled] = useState(false)
  const [features, setFeatures] = useState([])
  const [permissions, setPermissions] = useState([])
  

  const router = useRouter();
  const token = Cookies.get('token');

  const unAuthenticatedPath = [
    // "/login",
    "/logout",
    // "/login/tac/[token]",
    "/register",
    "/forgot-password",
    "/reset-password/[email]/[token]",
    "/email-verification/[email]/[token]"
]


  React.useEffect(()=>{
    if(token && unAuthenticatedPath.indexOf(router.pathname) === -1){
      if(domains==''){
      api.get(routes.DOMAIN.DOMAIN_LIST)
      .then(res => res.data)
      .then(data => {	
        let domainSettings = {
          exchange: false,
          outlookOrGsuite: false,
          };
        for (let i = 0; i < data?.domains.length; i++) {
          const domain = data.domains[i];
          if (
            (domain.domainType === "Outlook" && domain.domainTypeForOutlook === "OFFICE365") ||
            (domain.domainType === "Gsuite" && (domain.domainTypeForOutlook === null || domain.domainTypeForOutlook === "null"))
          ) {
            domainSettings.outlookOrGsuite = true;
          } else {
            domainSettings.exchange = true;
          }
          if (domainSettings.exchange && domainSettings.outlookOrGsuite) break;
          }
          setDomains(domainSettings)
      })
      .catch(err => {
        apiError(err);
      })
    }
  }
},[domainChange])

React.useEffect(()=>{
  if(token && unAuthenticatedPath.indexOf(router.pathname) === -1){
  api.get(routes.SETTINGS.CHECK_PACKAGE)
    .then(res=>res.data)
    .then((data)=>{
      setisLite(data.isLite)
      setFeatures(data.companyFeatures)
      if(data.companyFeatures.includes('TPIR-WA')) setIsMessengerEnabled(true)
      else setIsMessengerEnabled(false)
})
}
},[domainChange, isMessengerEnabled])

React.useEffect(()=>{
  if(token && unAuthenticatedPath.indexOf(router.pathname) === -1){
  api.get(routes.EMPLOYEE.PERMISSIONS)
    .then(res=>res.data)
    .then((data)=>{
      setPermissions(data.policies)
  })
}
},[token])



  return (
    <AppContext.Provider value={{ domains, setDomains, setDomainChange ,isLite, isMessengerEnabled, setIsMessengerEnabled, features, permissions}}>
      {children}
    </AppContext.Provider>
  );
};

export { AppContext, AppProvider };