import * as React from "react";
import Image from "next/image";
import { useRouter } from "next/router";
import {
  IoSettingsOutline,
  IoScanOutline,
  IoPeopleCircleOutline,
  IoFileTrayFullOutline,
  IoArrowBack,
} from "react-icons/io5";
import Link from "next/link";
import Cookies from "js-cookie";
import { Box } from "@mui/material";
import MuiDrawer from "@mui/material/Drawer";
import MuiAppBar from "@mui/material/AppBar";
import Toolbar from "@mui/material/Toolbar";
import List from "@mui/material/List";
import CssBaseline from "@mui/material/CssBaseline";
import Typography from "@mui/material/Typography";
import Divider from "@mui/material/Divider";
import IconButton from "@mui/material/IconButton";
import MenuIcon from "@mui/icons-material/Menu";
import ListItem from "@mui/material/ListItem";
import { styled, useTheme } from "@mui/material/styles";
import Menu from "@mui/material/Menu";
import MenuItem from "@mui/material/MenuItem";
import Button from "@mui/material/Button";
import Tooltip from "@mui/material/Tooltip";
import { TfiHome, TfiPackage, } from "react-icons/tfi";
import { TfiEmail } from "react-icons/tfi";
import { TfiWorld } from "react-icons/tfi";
import { TfiUser } from "react-icons/tfi";
import { TfiHelp } from "react-icons/tfi";
import { TfiBook } from "react-icons/tfi";
import { TfiVector, TfiAnnouncement } from "react-icons/tfi";
import { TfiSearch } from "react-icons/tfi";
import { TfiSettings } from "react-icons/tfi";
import { AiOutlineAudit } from "react-icons/ai";
import { IoLockClosedOutline } from "react-icons/io5";
import { TfiClose } from "react-icons/tfi";
import { TfiCommentAlt, TfiLink } from "react-icons/tfi";
import { TfiTrash } from "react-icons/tfi";
import { TfiAlert } from "react-icons/tfi";
import { TfiShareAlt } from "react-icons/tfi";
import { FaWhatsapp, FaRegCommentAlt } from "react-icons/fa";



import Accordion from "@mui/material/Accordion";
import AccordionSummary from "@mui/material/AccordionSummary";
import AccordionDetails from "@mui/material/AccordionDetails";
import ExpandMoreIcon from "@mui/icons-material/ExpandMore";
import { TfiBarChart } from "react-icons/tfi";
import { ToastContainer } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";

import logo from "../../assets/logo/Tpirlogo.png";
import styles from "../../styles/sidebar.module.scss";
import minilogo from "../../assets/logo/mini_logo.png";
import api from "../../utils/api";
import routes from "../../utils/routes";
import ModalCommon from "../modalCommon";


import { AppContext } from "../appcontext";
import { useFeatures } from "../../utils/features";

import NewconnecttaModal from "../../components/connect-ta-modal/new-connect"

const drawerWidth = 250;

const closedMixin = (theme) => ({
  width: drawerWidth,
  transition: theme.transitions.create("width", {
    easing: theme.transitions.easing.sharp,
    duration: theme.transitions.duration.enteringScreen,
  }),
  overflowX: "hidden",
});

const openedMixin = (theme) => ({
  transition: theme.transitions.create("width", {
    easing: theme.transitions.easing.sharp,
    duration: theme.transitions.duration.leavingScreen,
  }),
  overflowX: "hidden",
  width: `calc(${theme.spacing(7)} + 1px)`,
  [theme.breakpoints.up("sm")]: {
    width: `calc(${theme.spacing(8)} + 1px)`,
  },
});

const DrawerHeader = styled("div")(({ theme }) => ({
  display: "flex",
  alignItems: "center",
  justifyContent: "flex-end",
  padding: theme.spacing(0, 1),
  ...theme.mixins.toolbar,
}));

const AppBar = styled(MuiAppBar, {
  shouldForwardProp: (prop) => prop !== "open",
})(({ theme, open }) => ({
  marginLeft: drawerWidth,
  width: `calc(100% - ${drawerWidth}px)`,
  zIndex: theme.zIndex.drawer + 1,
  transition: theme.transitions.create(["width", "margin"], {
    easing: theme.transitions.easing.sharp,
    duration: theme.transitions.duration.leavingScreen,
  }),
  ...(open && {
    width: `calc(100% - 65px)`,
    transition: theme.transitions.create(["width", "margin"], {
      easing: theme.transitions.easing.sharp,
      duration: theme.transitions.duration.enteringScreen,
    }),
  }),
}));

const Drawer = styled(MuiDrawer, {
  shouldForwardProp: (prop) => prop !== "open",
})(({ theme, open }) => ({
  width: drawerWidth,
  flexShrink: 0,
  whiteSpace: "nowrap",
  boxSizing: "border-box",
  ...(open && {
    ...openedMixin(theme),
    "& .MuiDrawer-paper": openedMixin(theme),
  }),
  ...(!open && {
    ...closedMixin(theme),
    "& .MuiDrawer-paper": closedMixin(theme),
  }),
}));


export default function MiniDrawer(props) {
	const { isDrawerOpen, setIsDrawerOpen } = props;
	const theme = useTheme();
	const router = useRouter();
	const [open, setOpen] = React.useState(false);
	const [shrink, setShrink] = React.useState(false);
	const [anchorEl, setAnchorEl] = React.useState(null);
  const [expanded, setExpanded] = React.useState(false);

  const [logoVersion, setLogoVersion] = React.useState(Date.now());


  const handleChange = (panel) => (event, isExpanded) => {
    setExpanded(isExpanded ? panel : false);
  }

  const openMenu = Boolean(anchorEl);

  const Rightlogo = Cookies.get("logo")? `${Cookies.get("logo")}?v=${logoVersion}`: "";
  const username = Cookies.get("username") ? Cookies.get("username") : "T";
  const email = Cookies.get("email") ? Cookies.get("email") : "undefined";
  const [isTacEnabled, setIsTacEnabled] = React.useState(null);
  const [loginVia, setLoginVia] = React.useState(null);
  const [tacUrl, setTacUrl] = React.useState('');


  // New TA Connect 
const [taConnectopen, setTaOpen] = React.useState(false);
const taConnecthandleOpen = () => setTaOpen(true);
const taConnecthandleClose = () => setTaOpen(false);
const [taStatus, setTaStatus] = React.useState({
  enabled: false,
  connecting: false,
  isNewCompany: false,
});

const [loadingTa, setLoadingTa] = React.useState(true);

  

  const handleDrawerOpen = () => {
	  setOpen(true);
	  setIsDrawerOpen(true);
	  setShrink(true);
	};

	
	const handleDrawerClose = () => {
		setOpen(false);
		setIsDrawerOpen(false);
		setShrink(false);
	};
	const handleClick = (event) => {
    setAnchorEl(event.currentTarget);
};
const handleClose = () => {
	setAnchorEl(null);
};

const { domains, isLite, features } = React.useContext(AppContext);

const { loadFeatures, canAccessFeature, areFeaturesLoaded } = useFeatures();

const [ showLiteModal, setShowLiteModal ] = React.useState(false)

const openLiteModal = () =>{
setShowLiteModal(true)
}
const closeLiteModal = () =>{
setShowLiteModal(false)
}

console.log({Rightlogo})


React.useEffect(() => {
  setLoginVia(Cookies.get("loginVia"));
  setTacUrl(Cookies.get("tacUrl"));
}, []); 


React.useEffect(()=>{
  loadFeatures()
},[])


React.useEffect(() => {
  const scriptId = "clarity-script";
  if (document.getElementById(scriptId)) {
    if (window.clarity) {
      clarity("set", "user_email", email);
      clarity("set", "user_name", username);
    }
    return;
  }

  const script = document.createElement("script");
  script.id = scriptId;
  script.type = "text/javascript";
  script.text = `(function(c,l,a,r,i,t,y){
    c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
    t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
    y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
  })(window, document, "clarity", "script", "quvwvl9cc1");`;

  script.onload = () => {
    if (window.clarity) {
      clarity("set", "user_email", "user@example.com");
      clarity("set", "user_name", "John Doe");
    }
  };

  document.head.appendChild(script);
  }, []);

  React.useEffect(() => {
    api.get(routes.HOME.SYNC_ORGANIZATION_DETAILS)
      .then(res => {
        if (res?.data) {
          const current = Cookies.get("logo");
          if (res.data.logoPath && res.data.logoPath !== current) {
            const expires = new Date(new Date().getTime() + 180 * 60000);
            Cookies.set("logo", res.data.logoPath, { expires });
            setLogoVersion(Date.now());
          }
        } else {
          console.warn('API returned no data');
        }
      })
      .catch(err => {
        console.error('API Error:', err);
      });
  }, []);

  const checkTaConnection = () => {
    setLoadingTa(true);
    api
      .get(routes.TA.CHECK_CONNECTION)
      .then((res) => res.data)
      .then((data) => {
        setLoadingTa(false);
        setTaStatus((prev) => ({ ...prev, ...data.taStatus }));
        Cookies.set("isTacEnabled", data.taStatus.enabled);
      })
      .catch((err) => {
        setLoadingTa(false);
        console.error("Error from TA-Connection", err);
      });
  };

  React.useEffect(() => {
    checkTaConnection();    

    let interval;
    if (taStatus.connecting) {
      interval = setInterval(checkTaConnection, 10_000);
    }
    return () => interval && clearInterval(interval);
  }, [taStatus.connecting]);


  console.log(`status in app bar -------`)
  console.log({taStatus})
  console.log(`loadingTa==============${loadingTa}`)

  return (
    <div>
      <CssBaseline />
      <AppBar position="fixed" open={open} className={styles.appBar}>
        <Toolbar
          sx={{ minHeight: "55px !important" }}
          className={styles.ToolbarHeader}
        >
          <IconButton
            onClick={handleDrawerClose}
            aria-label="open drawer"
            sx={{
              marginRight: 5,
              ...(!open && { display: "none" }),
            }}
            className={styles.closeMenuIcon}
          >
            {theme.direction === "rtl" ? <TfiClose /> : <TfiClose />}
          </IconButton>

          <IconButton
            aria-label="open drawer"
            onClick={handleDrawerOpen}
            edge="start"
            sx={{
              marginRight: 5,
              ...(open && { display: "none" }),
            }}
          >
            <MenuIcon />
          </IconButton>

          
          <Box className={styles.InfoBar}>


        {!loadingTa && !taStatus.isNewCompany && !taStatus.enabled && !taStatus.connecting && 
          <Box sx={{marginRight:"12px"}}>
               <Button variant="contained" className={`${styles.btn} ${styles.taConnectbtn}`} onClick={taConnecthandleOpen}><TfiLink style={{ marginRight: '5px' }}/>Start Integration</Button>
           </Box>
        }



            <Box className={styles.Midinfobar}>
              <Link href="/settings">
                
                  <Tooltip title="Setting" placement="bottom">
                    <Button>
                      <TfiSettings></TfiSettings>
                    </Button>
                  </Tooltip>
               
              </Link>
            </Box>

            <Box className={styles.Midinfobar}>
              <Link href="/guide">
              
                <Tooltip title="Guide" placement="bottom">
                  <Button>
                    <TfiBook></TfiBook>
                  </Button>
                </Tooltip>
                
              </Link>
            </Box>
            <Box className={styles.Midinfobar}>
              <Link href="/">
                <Tooltip title="Help" placement="top-start">
                  <Button>
                    <TfiHelp></TfiHelp>
                  </Button>
                </Tooltip>
              </Link>
            </Box>
            <Box>
              <Button
                id="basic-button"
                aria-controls={open ? "basic-menu" : undefined}
                aria-haspopup="true"
                aria-expanded={open ? "true" : undefined}
                onClick={handleClick}
                className={styles.TopRightDropBtn}
              >
                <Box className={styles.CompLogo}>
                  {Rightlogo && Rightlogo.length && (
                    <img
                      width={100}
                      height={100}
                      src={Rightlogo}
                    />
                  )}
                </Box>
                <Box className={styles.NameRight}>
                  <Typography component="p">
                    {username[0].toUpperCase()}
                  </Typography>
                </Box>
              </Button>
              <Menu
                id="basic-menu"
                anchorEl={anchorEl}
                open={openMenu}
                onClose={handleClose}
                MenuListProps={{
                  "aria-labelledby": "basic-button",
                }}
              >
                <Box className={styles.DropDownMenuItem}>
                  <Box className={styles.NamePro}>
                    <Typography component="p">Hi, {username}</Typography>
                  </Box>
                  <MenuItem onClick={handleClose}>
                    <Link href="/settings">
                      <Box component="a">
                        <IoSettingsOutline className={styles.icon} />
                        <span>Settings</span>
                      </Box>
                    </Link>
                  </MenuItem>

                  <MenuItem onClick={handleClose}>
                    <Link href="/mail-checked">
                      <Box component="a">
                        <IoScanOutline className={styles.icon} />
                        <span>Mail Checked</span>
                      </Box>
                    </Link>
                  </MenuItem>

                  {/* 
								<MenuItem onClick={handleClose} >
									<Link href="/employee">
										<Box component="a">
											<IoPeopleCircleOutline className={styles.icon} />
											<span>IAM User</span>
										</Box>
									</Link>
								</MenuItem> */}

                  <MenuItem onClick={handleClose}>
                    <Link href="/audit-logs">
                      <Box component="a">
                        <AiOutlineAudit className={styles.icon} />
                        <span>Audit Log </span>
                      </Box>
                    </Link>
                  </MenuItem>

                  <MenuItem onClick={handleClose}>
                    <Link href="/logout">
                      <Box component="a">
                        <IoLockClosedOutline className={styles.icon} />
                        <span>Logout</span>
                      </Box>
                    </Link>
                  </MenuItem>
                </Box>
              </Menu>
            </Box>
          </Box>
        </Toolbar>
      </AppBar>

      <Drawer
        variant="permanent"
        open={open}
        className={shrink ? styles.shrinkSidebar : styles.sidebar}
        sx={{
          "& .MuiPaper-root": {
            backgroundColor: "#0E2954",
            // width:"250px",
          },
        }}
      >
        <DrawerHeader>
          <Box className={styles.logoBox}>
            {!isDrawerOpen ? (
              <Image src={logo} />
            ) : (
              <Box className={styles.miniimage}>
                <Image src={minilogo} />
              </Box>
            )}
          </Box>
        </DrawerHeader>


        { loginVia === "TAC" && tacUrl && tacUrl.length &&
          <Box className={styles.connectBackBtn} onClick={()=>{router.push(tacUrl)}}  style={{ cursor: 'pointer' }} >         
          <IoArrowBack className={styles.backArrowIcon} />
            <Typography component="span">
              Threatcop Admin
            </Typography>
        </Box>
        }
        <List id="sidebarMenu">
          <Box className={styles.DividerHeding}>
            <Typography
              component="p"
              className={isDrawerOpen ? styles.mainmenu : ""}
            >
              Main Menu
            </Typography>
          </Box>

          <ListItem
            disablePadding
            className={
              router.pathname === "/" || router.pathname === "/home"
                ? styles.active
                : ""
            }
          >
            <Link href="/home">
              <Box component="a">
                <TfiHome className={styles.icon} />
                <span>Dashboard</span>
              </Box>
            </Link>
          </ListItem>

          <Box className={styles.DividerHeding}>
            <Typography
              component="p"
              className={isDrawerOpen ? styles.mainmenu : ""}
            >
              Mail Box
            </Typography>
          </Box>
		  {domains?.exchange &&
          <ListItem disablePadding className={router.pathname}>
            <Accordion
              className={styles.accordion}
              sx={{
                borderRadius: "0px !important",
                width: "100% !important",
                boxShadow: "none !important",
              }}
              expanded={expanded === 'panel1'} onChange={handleChange('panel1')}>
              <AccordionSummary
                expandIcon={<ExpandMoreIcon />}
                aria-controls="panel1a-content"
                id="panel1a-header"
                sx={{
                  "&.MuiButtonBase-root": {
                    padding: "0px !important",
                    "&.Mui-expanded": {
                      minHeight: "40px !important",
                    },
                  },
                  "& .MuiAccordionSummary-content": {
                    margin: "0px !important",
                  },
                  "& .MuiAccordionSummary-expandIconWrapper": {
                    color: "#dcdee0 !important",
                    marginTop: "0px !important",
                    marginRight: "10px !important",
                    "& .MuiSvgIcon-root": {
                      fontSize: "18px !important",
                    },
                  },
                }}
              >
                <Link href="#">
                  <Box component="a">
                    <TfiEmail className={styles.icon} />
                    <span>MS Exchange</span>
                  </Box>
                </Link>
              </AccordionSummary>
              <AccordionDetails className={styles.subAccordion}>
                <Link href="/exchange" className={styles.submenuItem}>
                  <Box component="a">
                    <TfiAlert className={styles.icon} />
                    <span>Reported</span>
                  </Box>
                </Link>
              </AccordionDetails>
              {isLite ?               
              <AccordionDetails className={styles.subAccordion}>
                  <Box component="a" onClick={openLiteModal}>
                    <TfiTrash className={styles.icon} />
                    <span>Spam</span>
                  </Box>
              </AccordionDetails>:
              <AccordionDetails className={styles.subAccordion}>
                <Link href="/spam" className={styles.submenuItem}>
                  <Box component="a">
                    <TfiTrash className={styles.icon} />
                    <span>Spam</span>
                  </Box>
                </Link>
              </AccordionDetails>
              }
              {isLite ?               
              <AccordionDetails className={styles.subAccordion}>
                  <Box component="a" onClick={openLiteModal}>
                  <TfiClose className={styles.icon} />
                    <span>Threat</span>
                  </Box>
              </AccordionDetails>:
              <AccordionDetails className={styles.subAccordion}>
                <Link href="/threat" className={styles.submenuItem}>
                  <Box component="a">
                    <TfiClose className={styles.icon} />
                    <span>Threat</span>
                  </Box>
                </Link>
              </AccordionDetails>
              }
              {isLite ?               
              <AccordionDetails className={styles.subAccordion}>
                  <Box component="a" onClick={openLiteModal}>
                  <TfiShareAlt className={styles.icon} />
                    <span>Safe</span>
                  </Box>
              </AccordionDetails>:
              <AccordionDetails className={styles.subAccordion}>
                <Link href="/safe" className={styles.submenuItem}>
                  <Box component="a">
                    <TfiShareAlt className={styles.icon} />
                    <span>Safe</span>
                  </Box>
                </Link>
              </AccordionDetails>
              }
            </Accordion>
          </ListItem>
		  }

		{domains?.outlookOrGsuite &&
          <ListItem disablePadding className={router.pathname}>
            <Accordion
              className={styles.accordion}
              sx={{
                borderRadius: "0px !important",
                width: "100% !important",
                boxShadow: "none !important",
              }}
              expanded={expanded === 'panel2'} onChange={handleChange('panel2')}>
              <AccordionSummary
                expandIcon={<ExpandMoreIcon />}
                aria-controls="panel1a-content"
                id="panel1a-header"
                sx={{
                  "&.MuiButtonBase-root": {
                    padding: "0px !important",
                    "&.Mui-expanded": {
                      minHeight: "40px !important",
                    },
                  },
                  "& .MuiAccordionSummary-content": {
                    margin: "0px !important",
                  },
                  "& .MuiAccordionSummary-expandIconWrapper": {
                    color: "#dcdee0 !important",
                    marginTop: "0px !important",
                    marginRight: "10px !important",
                    "& .MuiSvgIcon-root": {
                      fontSize: "18px !important",
                    },
                  },
                }}
              >
                <Link href="#">
                  <Box component="a">
                    <TfiEmail className={styles.icon} />
                    <span>MS Outlook / Gsuite</span>
                  </Box>
                </Link>
              </AccordionSummary>
              <AccordionDetails className={styles.subAccordion}>
                <Link href="/reported-emails" className={styles.submenuItem}>
                  <Box component="a">
                    <TfiAlert className={styles.icon} />
                    <span>Reported</span>
                  </Box>
                </Link>
              </AccordionDetails>
              {isLite ?               
              <AccordionDetails className={styles.subAccordion}>
                  <Box component="a" onClick={openLiteModal}>
                    <TfiTrash className={styles.icon} />
                    <span>Trashed</span>
                  </Box>
              </AccordionDetails>:
              <AccordionDetails className={styles.subAccordion}>
                <Link href="/trashed-emails" className={styles.submenuItem}>
                  <Box component="a">
                    <TfiTrash className={styles.icon} />
                    <span>Trashed</span>
                  </Box>
                </Link>
              </AccordionDetails>
              }
              {isLite ?               
              <AccordionDetails className={styles.subAccordion}>
                  <Box component="a" onClick={openLiteModal}>
                  <TfiShareAlt className={styles.icon} />
                    <span>Recovered</span>
                  </Box>
              </AccordionDetails>:
              <AccordionDetails className={styles.subAccordion}>
                <Link href="/recovered-emails" className={styles.submenuItem}>
                  <Box component="a">
                    <TfiShareAlt className={styles.icon} />
                    <span>Recovered</span>
                  </Box>
                </Link>
              </AccordionDetails>}
              {isLite ?               
              <AccordionDetails className={styles.subAccordion}>
                  <Box component="a" onClick={openLiteModal}>
                  <TfiClose className={styles.icon} />
                    <span>Deleted</span>
                  </Box>
              </AccordionDetails>:
              <AccordionDetails className={styles.subAccordion}>
                <Link href="/deleted-emails" className={styles.submenuItem}>
                  <Box component="a">
                    <TfiClose className={styles.icon} />
                    <span>Deleted</span>
                  </Box>
                </Link>
              </AccordionDetails>
              }
            </Accordion>
          </ListItem>
		}
    <Box className={styles.DividerHeding}>
            <Typography
              component="p"
              className={isDrawerOpen ? styles.mainmenu : ""}
            >
              Messenger
            </Typography>
          </Box>

          <ListItem disablePadding className={router.pathname} >
            <Accordion
              className={styles.accordion}
              sx={{
                borderRadius: "0px !important",
                width: "100% !important",
                boxShadow: "none !important",
              }}
              disabled={!canAccessFeature("TPIR-WA")}
              expanded={expanded === 'panel3'} onChange={handleChange('panel3')}>
              <AccordionSummary
                expandIcon={<ExpandMoreIcon />}
                aria-controls="panel1a-content"
                id="panel1a-header"
                sx={{
                  "&.MuiButtonBase-root": {
                    padding: "0px !important",
                    "&.Mui-expanded": {
                      minHeight: "40px !important",
                    },
                  },
                  "& .MuiAccordionSummary-content": {
                    margin: "0px !important",
                  },
                  "& .MuiAccordionSummary-expandIconWrapper": {
                    color: "#dcdee0 !important",
                    marginTop: "0px !important",
                    marginRight: "10px !important",
                    "& .MuiSvgIcon-root": {
                      fontSize: "18px !important",
                    },
                  },
                }}
              >
                <Link href="#">
                  <Box component="a">
                    <FaWhatsapp className={styles.icon} />
                    <span>Whatsapp</span>
                  </Box>
                </Link>
              </AccordionSummary>
              <AccordionDetails className={styles.subAccordion}>
                <Link href="/whatsapp" className={styles.submenuItem}>
                  <Box component="a">
                    <TfiCommentAlt className={styles.icon} />
                    <span>Messages</span>
                  </Box>
                </Link>
              </AccordionDetails>
              <AccordionDetails className={styles.subAccordion}>
                {/* <Link href="/contacts" className={styles.submenuItem}>
                  <Box component="a">
                    <TfiUser className={styles.icon} />
                    <span>Contacts</span>
                  </Box>
                </Link> */}
              </AccordionDetails>
              
            </Accordion>
          </ListItem>
         

          <Box className={styles.DividerHeding}>
            <Typography
              component="p"
              className={isDrawerOpen ? styles.mainmenu : ""}
            >
           Users and Groups
            </Typography>
          </Box>

         
          <ListItem
            disablePadding
            className={router.pathname === "/users" ? styles.active : ""}
          >
            <Link href="/users">
              <Box component="a">
                <TfiUser className={styles.icon} />
                <span>Users</span>
              </Box>
            </Link>
          </ListItem>
          <ListItem
            disablePadding
            className={router.pathname === "/groups" ? styles.active : ""}
          >
            <Link href="/groups">
              <Box component="a">
                <TfiPackage className={styles.icon} />
                <span>Groups</span>
              </Box>
            </Link>
          </ListItem>

          {/* <Box className={styles.DividerHeding}>
            <Typography
              component="p"
              className={isDrawerOpen ? styles.mainmenu : ""}
            >
              Whatsapp
            </Typography>
          </Box>

          <ListItem
						disablePadding
						className={router.pathname === "/whatsapp" ? styles.active : ""}
						>
						<Link href="/whatsapp">
							<Box component="a">
								<FaWhatsapp className={styles.icon} />
								<span>Whatsapp Reporting<sup className={styles.sup}>Beta</sup></span>
							</Box>
						</Link>
					</ListItem> */}

          <Box className={styles.DividerHeding}>
            <Typography
              component="p"
              className={isDrawerOpen ? styles.mainmenu : ""}
            >
              Other Menu
            </Typography>
          </Box>
          <ListItem
            disablePadding
            className={router.pathname === "/domains" ? styles.active : ""}
          >
            <Link href="/domains">
              <Box component="a">
                <TfiWorld className={styles.icon} />
                <span>Domains</span>
              </Box>
            </Link>
          </ListItem>
          <ListItem
            disablePadding
            className={`${router.pathname === "/advance-search" ? styles.active : ""} ${
              !features?.includes("TPIR-ADVS") ? styles.disabled : ""
            }`}
          >
            {!features?.includes("TPIR-ADVS") ? (
              <Tooltip title="Please upgrade to unlock this functionality!" arrow>
                <Box
                  component="a"
                  // onClick={openLiteModal}
                  className={styles.link}
                  style={{
                    cursor: "not-allowed",
                  }}
                >
                  <TfiSearch className={styles.icon} />
                  <span>Advance Search</span>
                </Box>
              </Tooltip>
            ) : (
              <Link href="/advance-search">
                <Box component="a" className={styles.link}>
                  <TfiSearch className={styles.icon} />
                  <span>Advance Search</span>
                </Box>
              </Link>
            )}
          </ListItem>

          <ListItem
            disablePadding
            className={router.pathname === "/employee" ? styles.active : ""}
          >
            <Link href="/employee">
              <Box component="a">
                <TfiVector className={styles.icon} />
                <span>IAM User</span>
              </Box>
            </Link>
          </ListItem>


          <ListItem
            disablePadding
            className={router.pathname === "/smart-banner" ? styles.active : ""}
          >
          {/* <Link href="/smart-banner">
            <Box component="a" className={styles.linkItem}>
              <TfiAnnouncement className={styles.icon} />
              <span className={styles.textWithBadge}>
                Smart Banner
                <sup className={styles.newSup}>NEW</sup>
              </span>
            </Box>
          </Link> */}

          </ListItem>
        </List>


      </Drawer>
      <Box component="main" sx={{ flexGrow: 1, p: 0, height: "55px" }}>
        <DrawerHeader />
      </Box>
      <ToastContainer />
      <ModalCommon open={showLiteModal} onClick={closeLiteModal}  />

      <NewconnecttaModal
							taConnecthandleClose={taConnecthandleClose}
							taConnectopen={taConnectopen}
							changeConnectionStatusWithTa={() => console.log("Change Connection Status")}
						/>

    </div>

    
  );
}

