import React from "react";
import { toast } from "react-toastify";
import {
  Box,
  Typography,
  Grid,
  Modal,
  TextField,
  InputLabel,
  Button,
  FormControl,
  Select,
  MenuItem,
  FormHelperText,
} from "@mui/material";
import Image from "next/image";
import { IoArrowForward,IoArrowBack,IoLink } from "react-icons/io5";
import CloseSharpIcon from "@mui/icons-material/CloseSharp";
import styles from "../../styles/taConnectModal.module.scss";
import { Carousel } from 'react-responsive-carousel';
import taimgOne from "../../assets/taconnect/Application.png";
import taimgTwo from "../../assets/taconnect/User.png";
import taimgThree from "../../assets/taconnect/usermodal.png";
import taimgFour from "../../assets/taconnect/Intregration.png";
import taimgFive from "../../assets/taconnect/analytics.png";
import "react-responsive-carousel/lib/styles/carousel.min.css";

export default function ConnectTaModal(props) {
  const { taConnecthandleClose, taConnectopen, changeConnectionStatusWithTa, loadingTaConnection, setTaStatus } = props;
  const [nextButtonClicks, setNextButtonClicks] = React.useState(0);
  


  const [currentSlide, setCurrentSlide] = React.useState(0);
  const images = [taimgOne, taimgTwo, taimgThree, taimgFour, taimgFive];

  const slideLegends = [
    "Applications Management", 
    "Centralised Users & Groups",
     "Custom User Fields Management", 
     "Centralized Integrations",
      "Centralized analytics"
    ];

  const slideLegendsPtag = [
    "Effortlessly manage and oversee all ThreatCop applications in one unified platform.",
     "Manage users and groups seamlessly from a single platform with Threatcop Admin.", 
     "Customizable user fields for tailored data management with Threatcop Admin.",
      "Easily manage multiple integrations from one centralized platform with Threatcop Admin.",
       "Simplify analytics with a single dashboard that consolidates all your data for quicker decisions"
      ];

      const handleNextSlide = () => {
        if (currentSlide < 4) {
          setCurrentSlide((prevSlide) => (prevSlide + 1) % images.length);  
          } else finishConnection();
      };

      const finishConnection = () => {
        console.log("TAC Connection finished handler")
        changeConnectionStatusWithTa(true)
      }
  
      
    
  return (
    <Modal
      open={taConnectopen}
      onClose={taConnecthandleClose}
      aria-labelledby="modal-modal-title"
      aria-describedby="modal-modal-description"
      className={styles.taConnectModal}
    >
      <Box className={styles.connectModalWrapper}>
        <CloseSharpIcon
          className={styles.closeIcon}
          onClick={taConnecthandleClose}
        />

        <Box className={styles.modalBody}>
          <Box className={styles.modalHeader}>
            <Typography component="h5" variant="h5">
              Connect TPIR to Threatcop Admin
            </Typography>

            <Typography component="p">
              Integrate TPIR with Threatcop Admin suite for centralized
              management & streamlined operations
            </Typography>
          </Box>

          <Box className={styles.midModalBody}>
          <div className={styles.carouselWrap}>
            <Carousel
              onChange={(index) => {
                index < 4 && setCurrentSlide(index)
              }}
              renderArrowPrev={() => false}
              renderArrowNext={() => false}
              showThumbs={false} 
              selectedItem={currentSlide}
            >
              {images.map((image, index) => (
                        <div key={index}>
                          <Image src={image} alt={`Slide ${index + 1}`} />
                        </div>
                      ))}
            </Carousel>
            <Box className={styles.carouselCaption}>
              <h5 className={styles.carouselLegend}>{slideLegends[currentSlide]}</h5>
              <p className={styles.carouselLegend}>{slideLegendsPtag[currentSlide]}</p>
            </Box>
      
         </div>
        </Box>


        <Box className={styles.modalFooter}>
        {/* <Button
          variant="contained"
          className={`${styles.btn} ${styles.btnPrimary}`}
          onClick={handlePrevSlide} // Call handlePrevSlide for the "Preview" button
        >
          Preview <IoArrowBack style={{ marginLeft: "6px" }} />
        </Button> */}
        <Button
          variant="contained"
          className={`${styles.btn} ${styles.btnPrimary}`}
          onClick={handleNextSlide} 
          disabled = {loadingTaConnection}
        >
          {currentSlide >= 4 ? (
            <>
              <IoLink
              style={{ marginRight: "6px" }}

              /> Start Connecting
            </>
          ) : (
            <>
              Next <IoArrowForward style={{ marginLeft: "6px" }} />
            </>
          )}
        </Button>
      </Box>
        </Box>
      </Box>
    </Modal>
  );
}
