import React from "react";
import { toast } from "react-toastify";
import {
  Box,
  Typography,
  Grid,
  Modal,
  TextField,
  InputLabel,
  Button,
  FormControl,
  Select,
  MenuItem,
  FormHelperText,
  List,
  ListItem,
  ListItemIcon,
  ListItemText,
  Drawer,
} from "@mui/material";
import Image from "next/image";
import Tpirlogo from "../../assets/logo/TPIR.png";
import {
  IoCheckmarkCircleSharp,
  IoWarningSharp,
} from "react-icons/io5";
import { TfiArrowLeft, TfiLink } from "react-icons/tfi";
import CloseSharpIcon from "@mui/icons-material/CloseSharp";
import styles from "../../styles/taConnectModal.module.scss";
import { Carousel } from "react-responsive-carousel";
import taimgOne from "../../assets/taconnect/taImg1.png";
import taimgTwo from "../../assets/taconnect/taImg2.png";
import taimgThree from "../../assets/taconnect/taImg3.png";
import taimgFour from "../../assets/taconnect/taImg4.png";
import taimgFive from "../../assets/taconnect/taImg5.png";
import taimgSix from "../../assets/taconnect/taImg6.png";
import ConnectTaIntegration from "../../components/connect-ta-modal/connect-ta-Integration-modal";
import "react-responsive-carousel/lib/styles/carousel.min.css";

const style = {
  position: "absolute",
  top: "50%",
  left: "50%",
  transform: "translate(-50%, -50%)",
  width: "80%",
  maxWidth: 900,
  bgcolor: "background.paper",
  boxShadow: 24,
  p: 2,
  borderRadius: 2,
};

export default function NewconnecttaModal(props) {
  const {
    taConnecthandleClose,
    taConnectopen,
    changeConnectionStatusWithTa,
    loadingTaConnection,
  } = props;

  const [nextButtonClicks, setNextButtonClicks] = React.useState(0);
  const [currentSlide, setCurrentSlide] = React.useState(0);
  const [openIntegration, setOpenIntegration] = React.useState(false);
  const [open, setOpen] = React.useState(false);
  const [selectedImage, setSelectedImage] = React.useState(null);

  const images = [
    taimgOne,
    taimgTwo,
    taimgThree,
    taimgFour,
    taimgFive,
    taimgSix,
  ];

  const handleOpenIntegration = () => setOpenIntegration(true);
  const handleIntegrationClose = () => setOpenIntegration(false);

  const handleOpen = (image) => {
    setSelectedImage(image);
    setOpen(true);
  };

  const handleClose = () => {
    setOpen(false);
    setSelectedImage(null);
  };

  const features = [
    "Centralized Management – Control all Threatcop products from a single platform.",
    "Single Login Access – Securely log in once and manage all Threatcop applications without hassle.",
    "User & Access Control – Manage users, groups roles, and permissions with ease.",
    "Seamless Integrations – Connect with third-party applications effortlessly like Azure, G Suite.",
    "Centralized Analytics – Access all your application analytics in a unified dashboard.",
  ];

  const integrationImpact = [
    {
      title: "Users and Groups Management",
      description:
        "All your users and groups will be synced with Threatcop Admin. Once connected, you can manage them centrally — including adding, deleting, editing, or updating — directly from Threatcop Admin.",
    },
    {
      title: "SSO Configuration",
      description:
        "You will need to reconfigure Single Sign-On (SSO) specifically for the Threatcop Admin panel. Learner SSO remains unaffected.",
    },
    {
      title: "Domain Management",
      description:
        "Your domains will be automatically synced and managed through Threatcop Admin, ensuring consistent domain-level control.",
    },
    {
      title: "Application Access Routing",
      description:
        "Logins to all applications such as TSAT, TLMS, TDMARC, and TPIR will be routed through Threatcop Admin for unified access management.",
    },
    {
      title: "MFA Setup Required",
      description:
        "You will need to re-enable Multi-Factor Authentication (MFA) specifically for Threatcop Admin access.",
    },
    {
      title: "Domain Type Configuration",
      description:
        "You’ll be required to set the domain type under the Domains section in Threatcop Admin.",
    },
    {
      title: "Integration Reconfiguration",
      description:
        "Integrations with Microsoft Azure and Google Workspace must be set up again within Threatcop Admin for continued functionality.",
    },
  ];

  const CheckIcon = () => (
    <span className={styles.checkIcon} role="img" aria-label="check">
      ✅
    </span>
  );

  const WarningIcon = () => (
    <span className={styles.warningIcon} role="img" aria-label="warning">
      ⚠️
    </span>
  );

  return (
    <div>
      <Drawer
        anchor="right"
        open={taConnectopen}
        onClose={taConnecthandleClose}
        className={styles.taConnectRightModal}
      >
        <Box>
          {/* Modal Header */}
          <Box className={styles.modalHeader}>
            <Typography component="span" variant="span" onClick={taConnecthandleClose}>
              <TfiArrowLeft className={styles.iconArrowLeft} />
              Close
            </Typography>
          </Box>

          {/* Modal Body */}
          <Box className={styles.modalBody}>
            {/* Top Section */}
            <Box className={styles.modalBodyHeader}>
              <Grid container alignItems="center" justifyContent="space-between">
                <Grid item sx={7} md={7}>
                  <Box className={styles.leftContent}>
                    <Typography variant="h5">Threatcop Admin</Typography>
                    <Typography variant="p" component="p">
                      Integrate TPIR to Threatcop Admin to enable seamless synchronization
                    </Typography>
                    <Button
                      variant="contained"
                      className={`${styles.btn} ${styles.btnPrimary}`}
                      onClick={handleOpenIntegration}
                    >
                      <TfiLink style={{ marginRight: "5px" }} />
                      Start Integration
                    </Button>
                  </Box>
                </Grid>
                <Grid item sx={4} md={4} display="flex" alignItems="center">
                  <Box className={styles.rightLogo}>
                    <Image src={Tpirlogo} alt="TPIR Logo" className={styles.tpirLogo} />
                  </Box>
                </Grid>
              </Grid>
            </Box>

            {/* Carousel Section */}
            <Box className={styles.midModalBody}>
              <Box className={styles.carouselWrap}>
                <Carousel
                  onChange={(index) => index < 3 && setCurrentSlide(index)}
                  renderArrowPrev={(onClickHandler, hasPrev, label) => (
                    <button
                      type="button"
                      onClick={onClickHandler}
                      className={`${styles["control-arrow"]} ${styles["control-prev"]}`}
                      aria-label={label}
                    >
                      <span className={styles.controlArrow}>&#8249;</span>
                    </button>
                  )}
                  renderArrowNext={(onClickHandler, hasNext, label) => (
                    <button
                      type="button"
                      onClick={onClickHandler}
                      className={`${styles["control-arrow"]} ${styles["control-next"]}`}
                      aria-label={label}
                    >
                      <span className={styles.controlArrow}>&#8250;</span>
                    </button>
                  )}
                  showThumbs={false}
                  showIndicators={false}
                  showStatus={false}
                  selectedItem={currentSlide}
                  centerMode
                  centerSlidePercentage={40.33}
                >
                  {images.map((image, index) => (
                    <div
                      key={index}
                      className={styles.sliderImg}
                      onClick={() => handleOpen(image)}
                      style={{ cursor: "pointer" }}
                    >
                      <Image
                        src={image}
                        alt={`Slide ${index + 1}`}
                        className={styles.carouselImage}
                      />
                    </div>
                  ))}
                </Carousel>
              </Box>
            </Box>

            {/* Content Sections */}
            <Box className={styles.contentWrap}>
              <Box className={styles.contentInfo}>
                <Typography variant="h4" gutterBottom>
                  Why Integration to Threatcop Admin?
                </Typography>
                <Typography paragraph>
                Threatcop Admin is our new administrative platform that enables you to centrally manage all 
                your apps, users, groups, and AD integrations from one place. To take advantage of this centralized 
                management, you'll need to integrate your current application to Threatcop Admin.
                </Typography>
              </Box>

              <Box className={styles.contentInfo}>
                <Typography variant="h4" gutterBottom>
                  About Threatcop Admin?
                </Typography>
                <Typography paragraph>
                Threatcop Admin is a unified console that allows administrators to manage all Threatcop applications, 
                users, subscriptions, integrations, and security operations in one place. It streamlines data management, 
                enhances decision-making, and boosts productivity by providing contextually integrated applications under 
                a single platform.
                </Typography>
              </Box>

              <Box className={styles.contentInfo}>
                <Typography variant="h4">Key Features & Benefits</Typography>
                <List>
                  {features.map((item, index) => (
                    <ListItem key={index}>
                      <ListItemIcon className={styles.icon}>
                        <CheckIcon />
                      </ListItemIcon>
                      <ListItemText primary={item} />
                    </ListItem>
                  ))}
                </List>
              </Box>

              <Box className={styles.contentInfo}>
                <Typography variant="h4">Integration Impact</Typography>
                <List>
                  {integrationImpact.map((item, index) => (
                    <ListItem key={index} alignItems="flex-start">
                      <ListItemIcon className={styles.icon}>
                        <WarningIcon />
                      </ListItemIcon>
                      <ListItemText
                        primary={<strong>{item.title}</strong>}
                        secondary={item.description}
                      />
                    </ListItem>
                  ))}
                </List>
              </Box>
            </Box>
          </Box>
        </Box>
      </Drawer>

      {/* Image Preview Modal */}
      <Modal open={open} onClose={handleClose}>
        <Box className={styles.previewmodalBox}>
          <Box className={styles.modalHeader}>
            <Typography variant="h5">Preview</Typography>
            <CloseSharpIcon className={styles.closeIcon} onClick={handleClose} />
          </Box>
          <Box className={styles.modalBody}>
            {selectedImage && (
              <Image
                src={selectedImage}
                alt="Selected Preview"
                width={800}
                height={500}
                style={{ width: "100%", height: "auto", borderRadius: 8 }}
              />
            )}
          </Box>
        </Box>
      </Modal>

      {/* Integration Modal */}
      <ConnectTaIntegration
        handleIntegrationClose={handleIntegrationClose}
        newtaConnectopen={openIntegration}
      />
    </div>
  );
}
