import React, { useEffect, useRef } from "react";

function HeaderEditor({ onChange, headereditorLoaded, name, value }) {
  const editorRef = useRef();
  const { CKEditor, ClassicEditor } = editorRef.current || {};
  console.log(ClassicEditor, CKEditor )

  useEffect(() => {
    editorRef.current = {
      CKEditor: require("@ckeditor/ckeditor5-react").CKEditor, // v3+
      ClassicEditor: require("@ckeditor/ckeditor5-build-classic")
    };

    console.log(editorRef.current)
  }, []);

  return (
    <div>
      {headereditorLoaded ? (
        <CKEditor
          type=""
          name={name}
          editor={ClassicEditor}
          config={{
            ckfinder: {
              // Upload the images to the server using the CKFinder QuickUpload command
              // You have to change this address to your server that has the ckfinder php connector
              uploadUrl: "", //Enter your upload url
            },
            toolbar: [
              "heading",
              "|",
              "bold",
              "italic",
              "link",
              "|",
              "bulletedList",
              "numberedList",
              "|",
              "blockQuote",
              "|",
              "undo",
              "redo",
            ],
            removePlugins: [
              "ImageUpload",
              "CKFinder",
              "EasyImage",
              "BlockQuote",
            ],
          }}
          data={value}
          onChange={(event, editor) => {
            const data = editor.getData();
            onChange(data);
          }}
        />
      ) : (
        <div>Editor loading</div>
      )}
    </div>
  );
}

export default HeaderEditor;
