import * as React from 'react';
import Box from '@mui/material/Box';
import Button from '@mui/material/Button';
import Typography from '@mui/material/Typography';
import Modal from '@mui/material/Modal';
import { styled } from '@mui/material/styles';
import styles from "../styles/reported.module.scss";

const style = {
  padding: '20px 25px 25px 25px',
  border: 'none',
  borderRadius: '10px',
  width: '500px',
  position: 'absolute',
  top: '50%',
  left: '50%',
  transform: 'translate(-50%, -50%)',
  bgcolor: 'background.paper',
  boxShadow: 24,
};

export default function ModalCommon(props) {
    const {open, onClick} = props
  return (
    <div>
      <Modal
        open={open}
        onClose={onClick}
        aria-labelledby="modal-modal-title"
        aria-describedby="modal-modal-description"
      >
        <Box sx={style} className={styles.reportModal}>
          <Typography id="modal-modal-title" variant="h6" component="h2">
            Feature Unavailable
          </Typography>
          <Typography id="modal-modal-description" sx={{ mt: 2 }}>
          This feature is not available, please upgrade to unlock its functionality
          </Typography>
        </Box>
      </Modal>
    </div>
  );
}