import React from 'react'
import { Box, Typography, Button, Modal,TextField } from '@mui/material'

import LinearProgress, { linearProgressClasses } from '@mui/material/LinearProgress';
import { Chart as ChartJS, ArcElement, Tooltip, Legend } from 'chart.js';
import { Pie } from 'react-chartjs-2';
import styles from '../../../styles/home.module.scss'

import api from '../../../utils/api';
import routes from '../../../utils/routes';
import { apiError } from '../../../utils/error';

export default function AttachmentRisk(props) {
    const data = {
        labels: [
            'Green',
            'Red'
        ],
        datasets: [{
            label: 'My First Dataset',
            data: [300, 20],
            backgroundColor: [
                'rgb(0, 194, 87)',
                'rgb(219,7,14)'
            ],
            hoverOffset: 2
        }]
    };


    return (
        <Box className={styles.MainCard}>
        <Box className={styles.CardHeading}>
            <Typography variant='h4'>
                Attachment Risk
            </Typography>
        </Box>

        <Box className={styles.PieChart}>
            <Pie data={data} />
        </Box>

    </Box>
     )
}
