import * as React from "react";
import { Box, Typography, } from '@mui/material'
import {  TableRow, TableContainer, TableCell, TableBody, Table } from "@mui/material";

import styles from '../../../styles/home.module.scss'

export default function DomainAuthRisk(props) {

	const { headers = {} } = props;
	
	return (
		<Box className="cardWrapper tabMailAnalysis">
			<Typography variant="h2" className="cardTitle">Domain Authentication Risk</Typography>
			<Box className="internalCardsec">
				<TableContainer className={`${styles.tabMailAnalysisContainer} ${styles.tableContainer}`}>
					<Table sx={{ minWidth: 300 }} aria-label="simple table">
						<TableBody className={styles.mailRepWrap}>
							<TableRow>
								<TableCell component="td" scope="row">SPF</TableCell>
								<TableCell component="td" scope="row" sx={{textTransform:"uppercase"}} style={{color: headers.spf === 'pass'? 'green': 'red'}}>{headers?.spf}</TableCell>
							</TableRow>
							<TableRow>
								<TableCell component="td" scope="row">DKIM</TableCell>
								<TableCell component="td" scope="row" sx={{textTransform:"uppercase"}} style={{color: headers.dkim === 'pass'? 'green': 'red'}}>{headers?.dkim}</TableCell>   
							</TableRow>
							<TableRow>
								<TableCell component="td" scope="row">DMARC</TableCell>
								<TableCell component="td" scope="row" sx={{textTransform:"uppercase"}} style={{color: headers.dmarc === 'pass'? 'green': 'red'}}>{headers?.dmarc}</TableCell>
							</TableRow>
						</TableBody>   
					</Table>
				</TableContainer>
				</Box>
		</Box>
    )
}
