import * as React from "react";
import dynamic from 'next/dynamic';
import { Box, Typography, } from '@mui/material';

const Chart = dynamic(() => import('react-apexcharts'), { ssr: false });

export default function IPReputation(props) {

	const { blackListCount = 0, notBlackListCount = 0 } = props;
	
    const donut = {
        series: [notBlackListCount, blackListCount],
        options: {
          	colors:["#68e497","#E91E63"],
          	chart: {
				width: 380,
				type: 'donut',
			},
    		labels: ['Not Listed', 'Blacklist'],
			fill: {
				colors: ['#68e497', '#E91E63',]
			},
			plotOptions: {
				pie: {
					donut: {
						labels: {
							show: true,
							total: {
								showAlways: true,
								show: true
							}
						}
					}
				}
			},
			dataLabels: {
				enabled: false
			},
			responsive: [{
				breakpoint: 480,
				options: {
					chart: {
						width: 200
					},
					legend: {
						show: false
					}
				}
			}],
			legend: {
				position: 'bottom',
				offsetY: 0,
				height: 0,
          	} 
        },
    };
    
    return (
        <Box className="cardWrapper tabMailAnalysis">
            <Typography variant="h2" className="cardTitle">IP Reputation</Typography>
               <Chart 
                    options={donut.options}
                    series={donut.series}
                    type="donut"
                    width="100%"
                    height="80%"
                />	
        </Box>
    )
}



