import React from 'react'
import { Box, Typography, } from '@mui/material'
import { IoShieldCheckmarkOutline } from "react-icons/io5";

import styles from '../../../styles/home.module.scss'

export default function SenderDomainRisk(props) {

    const { senderDomain='', senderDomainDeceptive=false } = props;
    
    return (
        <Box className="cardWrapper tabMailAnalysis">
            <Typography variant="h2" className="cardTitle"> Sender Domain Deceptive Risk</Typography>
            <Box className="internalCardsec">
            <Box className={styles.SenderDomain}>
                <Typography component='p'> {senderDomain}</Typography>
                {!senderDomainDeceptive?
                    <IoShieldCheckmarkOutline />:
                    <IoShieldCheckmarkOutline className={styles.Checkmailrisk}/>
                }
                <Typography component='p'>
                    Sender's Domain Detected As <b>{!senderDomainDeceptive?"Safe":"Risk"}</b>
                </Typography>
            </Box>
            </Box>
        </Box>
    )
}
