import * as React from "react";
import { Box, Typography, } from '@mui/material'
import styles from '../../../styles/home.module.scss'
import {List, ListItem, ListItemIcon } from "@mui/material";

export default function Toemail(props) {
	
	const { to = [] } = props;
	
    return (
        <Box className="cardWrapper tabMailAnalysis" sx={{maxHeight:"100px", overflowX:"auto"}}>
          	<Typography variant="h2" className="cardTitle">To Email</Typography>
			  <Box className="internalCardsec">
				<Box className={styles.tabMailAnalysisContainer}>
					<List className={styles.toMailUl} sx={{ listStyleType: 'disc',pl: 3,'& .MuiListItem-root': {  display: 'list-item'}}}>
						{to && to.length? to.map((email, index) => {
						return <ListItem key={index}>
								{email?.address}
							</ListItem>
							}):
							<Box className={`${styles.noRecordPara} ${styles.noRecordMail}`}>
								<Typography component="p">No To Email found!</Typography>
							</Box>
						}
					</List>
				</Box>
		</Box>
{/* 
            <TableContainer className={`${styles.tabMailAnalysisContainer} ${styles.tableContainer}`}>
					<Table sx={{ minWidth: 300 }} aria-label="simple table">
						<TableBody className={styles.mailRepWrap}>
							{to.map((email, index) => {
								return <TableRow key={index}>
									<TableCell component="td" scope="row">{email?.address}</TableCell>
								</TableRow>
							})}
						</TableBody>   
					</Table>
			</TableContainer> */}
        </Box>
    )
}
