import React from 'react'
import { toast } from 'react-toastify';
import { useRouter } from 'next/router'
import { TfiDownload, TfiSearch } from "react-icons/tfi";
import AttachmentDrawer from './drawer/attachment-drawer';
import { 
    Box, Button, TableRow, TableHead, TableContainer, 
    TableCell, TableBody, Table, Typography 
} from '@mui/material';

import api from '../../utils/api';
import routes from '../../utils/routes';
import { apiError } from '../../utils/error';
import { download } from '../../utils/common';
import styles from '../../styles/home.module.scss'
import Tooltip from '@mui/material/Tooltip';

export default function AttachmentTab({ attachments, mailId, loadAttachmentReportedEmails, isScanAllowed }) {
    const router = useRouter()

    const [stateAttach, setStateAttach] = React.useState({right: false });
    const [scanResult, setScanResult ] = React.useState({ result: {}, attachment: '' });
    const [showScanAll, setShowScanAll] = React.useState(false)
    const [attachmentName, setAttachmentName] = React.useState('')

    const toggleDrawerAttachment = (open, result, attachment) => (event) => {
        if (event.type === 'keydown' && (event.key === 'Tab' || event.key === 'Shift')) {
            return;
        }
        setScanResult({ result, attachment })
        setStateAttach({ ...stateAttach, right: open });
        setAttachmentName(attachment)
    };

    // const downloadAttachment = (id,fileName)=>{
    //     api.get(routes.FILES.DOWNLOAD,{
    //         params:{
    //             attachmentId:id
    //         },
    //         responseType: 'blob',
    //     })
    //     .then(response => {
            // download(response.data,fileName)
    //       })
    //       .catch(error => {
    //         console.error('Error fetching file:', error);
    //         toast.error("Error Downloading File!")
    //     });  
    // }

    const downloadAttachment = (id,fileName)=>{
        api.get(routes.FILES.DOWNLOAD,{
            params:{
                attachmentId:id
            },
            responseType: 'blob',
        })
        .then(response => {
            const url = window.URL.createObjectURL(new Blob([response.data]));
            const link = document.createElement('a');
            link.href = url;
            link.setAttribute('download', fileName);
            link.setAttribute('rel', 'noopener noreferrer'); 
            document.body.appendChild(link);
            link.click();
            })
          .catch(error => {
            console.log('Error fetching file:', error);
            toast.error("Error Downloading File!")
        });  
    }


    
    const scanAttachment = (attachmentId) =>{
        const reportedMailId = mailId    
        let attachmentIds = [];
        if(attachmentId){
            attachmentIds.push(attachmentId)
            api.post(routes.ATTACHMENT.SCAN,{
                reportedMailId,
                attachmentIds
            })
            .then(res=>res.data)
            .then((data)=>{
                toast.success(data.message)
                loadAttachmentReportedEmails()
            })
            .catch((error)=>{
                apiError(error)
            })
        }  
        else{
            attachments.forEach(attachment=>{
                if(attachment.status == "NOT SCANNED" || attachment.status == "FAILED" ) attachmentIds.push(attachment._id)
            })
            setShowScanAll(false)
            api.post(routes.ATTACHMENT.SCAN,{
                reportedMailId,
                attachmentIds
            })
            .then(res=>res.data)
            .then((data)=>{
                toast.success(data.message)
                loadAttachmentReportedEmails()
            })
            .catch((error)=>{
                apiError(error)
            })
        } 
    }

    const updateResults = (attachmentId) =>{
        api.get(routes.ATTACHMENT.SYNC_RESULTS,{
            params:{
                attachmentId: attachmentId
            }
        })
        .then(res=>res.data)
        .then((data)=>{
            loadAttachmentReportedEmails()
        })
        .catch((error)=>{
            console.log('Error from Sync Results')
            apiError(error)
        })
    }
   
    const generateAttachments = () =>{
        let data = [];
        attachments.forEach((element,index)=>{    
            data.push(
                <TableRow sx={{ '&:last-child td, &:last-child th': { border: 0 }}} key={index} id ={element.attachmentId} className={styles.attachWidthset}>
                      <TableCell component="td" scope="row" sx={{display:"flex", alignItems:"center"}}>
                      {/* <a variant="contained" href={`${process.env.NEXT_PUBLIC_API_URL}/api/v1${routes.FILES.DOWNLOAD}?attachmentId=${element._id}`} target="_blank" download> <TfiDownload/></a> */}
                      <Button className={styles.ScanResult} onClick={()=>downloadAttachment(element._id,element.originalName)}><TfiDownload/></Button>
                    </TableCell>  
                    <TableCell component="td" scope="row">{element.originalName}</TableCell>
                    <TableCell component="td" scope="row" sx={{width:"0%"}}>{element.mimeType.toUpperCase()}</TableCell>
                    
                    {element.status === 'COMPLETED' && <TableCell component="td" scope="row" style={{ cursor: "pointer" }} onClick={
                    toggleDrawerAttachment(true,element?.result?.scans?element.result.scans: {}, element.originalName) }>
                    <Button className={styles.ScanResult}>View Results</Button></TableCell>}
                    {element.status === 'NOT SCANNED' && <TableCell component="td" scope="row" >Scan Pending</TableCell>}
                    {element.status === 'FAILED' && <TableCell component="td" scope="row" >Failed</TableCell>}
                    {element.status === 'IN PROGRESS' && <TableCell component="td" scope="row" >Result Queued</TableCell>}

                    {element.status === 'COMPLETED' && <TableCell component="td" scope="row" >Completed</TableCell>}
                    {(element.status === 'NOT SCANNED' || element.status === 'FAILED' ) && 
                    <TableCell component="td" scope="row"> 
                        {isScanAllowed ?
                        <Button variant="contained" className={styles.ScanBtn} onClick = {()=>scanAttachment(element._id)} id={element._id}>
                            <TfiSearch className={styles.icon_position}/>Start Scan
                        </Button>
                        :
                        <Tooltip title="Please upgrade to unlock this functionality">
                            <span>
                                <Button variant="contained" className={styles.ScanBtn}  id={element._id}>
                                    <TfiSearch className={styles.icon_position}/>Start Scan
                                </Button>
                            </span>
                        </Tooltip>    
                        }
                    </TableCell>}
                    {element.status === 'IN PROGRESS' && <TableCell component="td" scope="row" >In Progress</TableCell>}

                    {/* <TableCell component="td" scope="row" className={element.status !=='FAILED' ? element.status === 'NOT SCANNED' ? styles.LinkWarn : styles.LinkSafe : styles.LinkDanger}>
                    {(element.status === 'FAILED' || element.status === 'NOT SCANNED') ? <Button variant="contained" className={styles.ScanBtn} onClick = {()=>scanAttachment(element._id)} id={element._id}>Scan</Button>:'' }</TableCell> */}
                    {/* <TableCell component="td" scope="row" sx={{display:"flex", alignItems:"center"}}>
                        <TfiDownload href={`${process.env.NEXT_PUBLIC_API_URL}/api/v1${routes.FILES.DOWNLOAD}?attachmentId=${element._id}`} target="_blank" download/>
                        <a variant="contained" className={styles.AttachementDownloadBtn} href={`${process.env.NEXT_PUBLIC_API_URL}/api/v1${routes.FILES.DOWNLOAD}?attachmentId=${element._id}`} target="_blank" download >Download</a>
                    </TableCell>      */}
                </TableRow>
            )
        })
        return data;
    }

    React.useEffect(()=>{
        for(let i=0;i<attachments.length;i++){
            if(attachments[i].status== 'NOT SCANNED' || attachments[i].status== 'FAILED') {
                setShowScanAll(true)
                break;
            }
        }
    },[attachments])
    return (
        <Box className={styles.AnalyticsReport}>

            <Box className={`${styles.commonTableHeader} ${styles.LinkTableHeader}`}>
                <Typography component="p">
                    Showing all attachment existing in the mail
                </Typography>
                {showScanAll &&
                <Box>
                    {!isScanAllowed ? 
                    <Tooltip title="Please upgrade to unlock this functionality">
                    <span>
                     <Button variant="contained" onClick={()=>scanAttachment()} className={`${styles.commonBtn} ${styles.scanAll}` }><TfiSearch className={styles.icon_position}/>Scan All</Button>
                    </span>
                    </Tooltip>
                    :
                    <Button variant="contained" onClick={()=>scanAttachment()} className={`${styles.commonBtn} ${styles.scanAll}` }><TfiSearch className={styles.icon_position}/>Scan All</Button>
                    }
                </Box>
                }
            </Box> 
                <Box className={`${styles.contentbarWrap} ${styles.contentbarPadding}`}>
                    <Box className={styles.TableTopM}>
                        <Box className={`${styles.MailLink} ${styles.linktabrow}`}>
                            <TableContainer className={styles.tableContainer}>
                                <Table sx={{ minWidth: 650 }} aria-label="simple table">
                                    <TableHead className={styles.thead_background}>
                                        <TableRow>
                                        <TableCell sx={{width:"2%"}}></TableCell>
                                            <TableCell sx={{width:"50%"}}>Attachment</TableCell>
                                            <TableCell sx={{width:"8%"}}>File Type</TableCell>
                                            <TableCell >Result</TableCell>
                                            <TableCell>Status</TableCell>
                                        
                                        </TableRow>
                                    </TableHead>
                                    <TableBody>
                                        {generateAttachments()}
                                    </TableBody>
                                </Table>
                            </TableContainer>
                        </Box>
                    </Box>
                </Box>
            { attachments.length === 0 && 
             <Box className={`${styles.noRecordPara} ${styles.noRecordMail}`}>
                 <Typography component="p">No attachment found in this email</Typography>
             </Box>
             }
            <AttachmentDrawer toggleDrawerAttachment={toggleDrawerAttachment} stateAttach={stateAttach} scanResult={scanResult} attachmentName = {attachmentName} ></AttachmentDrawer>
        </Box>
    )
}
