import React from 'react'
import Alert from '@mui/material/Alert';
import { Box, Typography, TableRow, TableHead, TableContainer, TableCell, TableBody, Table, Grid } from '@mui/material'

import styles from '../../styles/home.module.scss'

export default function DNSBL(props) {
    const { dnsblList = [], senderIP = '' } = props;
    let blackListCount = 0;
    let notBlackListCount = 0;
    for(let i=0; i<dnsblList.length; i++){
        dnsblList[i].listed? blackListCount++: notBlackListCount++;
    }
    return (
        <Box className={styles.DnsblBox}>
            <Grid container justifyContent="space-between">
                <Grid item md={3}>
                    <Box className={styles.DnsblBlacklistTest}>
                        <Typography variant='h4'>DNSBL Blacklist Test Summary</Typography>
                        <Typography component="p">Client IP - <span>{senderIP}</span></Typography>
                    </Box>
                    <Box className={styles.AlertSuccess}>
                        <Alert severity="success" className={styles.ErrorSuccess}>Not Listed: <span>{notBlackListCount}</span></Alert>
                        <Alert severity="error" className={styles.ErrorSuccess}>Blacklist: <span>{blackListCount}</span></Alert>
                    </Box>
                </Grid>
                <Grid item md={7}>
                 <Box className={`${styles.contentbarWrap} ${styles.contentbarPadding}`}>
                        <Box className={styles.DnsblTable}>
                            <TableContainer className={`${styles.tableContainer} ${styles.DnsblTableBg}`} sx={{ maxHeight: 580 }}>
                                <Table sx={{ minWidth: 650 }} aria-label="simple table">
                                    <TableHead className={styles.thead_background}>
                                        <TableRow>
                                            <TableCell>Url</TableCell>
                                            <TableCell>Listed</TableCell>
                                        </TableRow>
                                    </TableHead>
                                    <TableBody>
                                        {dnsblList.map((data, key) => {
                                            return <TableRow key={`abc-${key}`} sx={{ '&:last-child td, &:last-child th': { border: 0 } }} >
                                                <TableCell component="td" scope="row">{data.blacklist}</TableCell>
                                                <TableCell component="td" scope="row" style={{color: data.listed?'red':'green'}}>{data.listed?"Yes": "No"}</TableCell>
                                            </TableRow>
                                        })}
                                    </TableBody>
                                </Table>
                            </TableContainer>
                        </Box>
                   </Box> 
                </Grid>
            </Grid>
        </Box>
    )
}
