import React from 'react'
import Drawer from '@mui/material/Drawer';
import { IoCloseOutline } from "react-icons/io5";
import { Box, Typography, TableRow, TableHead, TableContainer, TableCell, TableBody, Table } from '@mui/material'

import styles from '../../../styles/home.module.scss'

export default function AttachmentDrawer(props) {
    const { toggleDrawerAttachment, stateAttach, scanResult = {}, attachmentName } = props;
    const { result = {}, attahcment = '' } = scanResult;
    const getList = () => {
        let data = [];
        Object.keys(result).forEach((key, index) => {
            console.log(result[key]);
            data.push(
                <TableRow key={index} sx={{ '&:last-child td, &:last-child th': { border: 0 } }}>
                    <TableCell component="td" scope="row">{key}</TableCell>
                    <TableCell component="td" scope="row" style={{color: result[key].detected?'red':'green'}}>{result[key].detected?"Yes":"No"}</TableCell>
                    <TableCell component="td" scope="row" style={{color: result[key].result?'red':'green'}}>{result[key].result?result[key].result:'Undetected'}</TableCell>
                </TableRow>
            )
        })
        if(data.length == 0){
            data.push(
                <TableRow key={0} sx={{ '&:last-child td, &:last-child th': { border: 0 } }}>
                    <TableCell component="td" scope="row">Result Not Found</TableCell>
                </TableRow>
            )
        }
        return data;
    }
    return (
        <Box>
            <Drawer
                anchor="right"
                open={stateAttach.right}
                onClose={toggleDrawerAttachment(false)}
                className={styles.Linkmaindrawer}
            >
                <Box className={styles.closebtn}>
                    <IoCloseOutline onClick={toggleDrawerAttachment(false)} />
                </Box>
                <Box className={styles.TableHeader}>
                    <Typography component="p">
                        Scan Results
                        <br></br><span>{attachmentName ? attachmentName : ''}</span>
                    </Typography>
                </Box>
                <Box className={styles.LinkResultDrawer}>
                    <Box className={styles.ResultName}>
                        <Typography component="p">
                            {attahcment}
                        </Typography>
                    </Box>
                    <Box className={styles.AnalyticsReport}>
                        <Box className={`${styles.MailLink} ${styles.linktabrow}`}>
                            <TableContainer className={styles.tableContainer}>
                                <Table sx={{ minWidth: 450 }} aria-label="simple table">
                                    <TableHead className={styles.thead_background}>
                                        <TableRow>
                                            <TableCell >Anti Virus</TableCell>
                                            <TableCell >Detected</TableCell>
                                            <TableCell >Result</TableCell>
                                        </TableRow>
                                    </TableHead>
                                    <TableBody>
                                        {getList()}
                                    </TableBody>
                                </Table>
                            </TableContainer>
                        </Box>
                    </Box>
                </Box>
            </Drawer>
        </Box>
    )
}
