import React from "react";
import Drawer from "@mui/material/Drawer";
import { IoCloseOutline } from "react-icons/io5";
import dynamic from "next/dynamic";
import styles from "../../../styles/home.module.scss";
import {
  Box,
  Typography,
  MenuItem,
  Select,
  TextField,
  Button,
  TableRow,
  InputLabel,
  TableHead,
  Stack,
  Modal,
  TableContainer,
  TableCell,
  TableBody,
  Table,
  Grid,
  Tab,
  Tabs,
} from "@mui/material";
import { TfiSearch, TfiTrash } from "react-icons/tfi";
import api from "../../../utils/api";
import routes from "../../../utils/routes";
import { toast } from "react-toastify";
import CloseSharpIcon from "@mui/icons-material/CloseSharp";
import { checkNullByteInjection } from "../../../utils/common";
import { apiError } from "../../../utils/error";
const Chart = dynamic(() => import("react-apexcharts"), { ssr: false });

export default function customDrawer(props) {
  const {
    open,
    onClose,
    searchButtonOnClickHandler,
    group,
    groupUsers,
    setGroup,
    setGroupUsers,
    isEditingGroup,
    setIsEditingGroup,
    setIdToAddUsersToGroup,
    usersToAddToGroup,
    setUsersToAddToGroup,
    loadGroups,
    loadGroup,
    isTacEnabled
  } = props;

  const [newGroup, setNewGroup] = React.useState({
    name: "",
    users: [],
    groupId: null,
    isDefaultGroup: false,
    type:"Custom"
  });

  const [fileData, setFileData] = React.useState(null);
  const [openModal, setOpenModal] = React.useState(false);

  const handleCloseModal = () => {
    setOpenModal(false);
  };

  const [domains, setDomains] = React.useState([]);
  const [shouldRunEffect, setShouldRunEffect] = React.useState(true);
  const [selectedDomain, setSelectedDomain] = React.useState("-1");



  const [page, setPage] = React.useState(1);
  const [limit, setLimit] = React.useState(10);
  const [search, setSearch] = React.useState("");

  const fileInputRef = React.useRef(null);

  const loadDomainList = () => {
    api
      .get(routes.DOMAIN.LIST)
      .then((res) => res.data)
      .then((data) => {
        setDomains(data.domains);
      })
      .catch((error) => {
        apiError(error);
      });
  };

  const handleOpenModal = () => {
    setOpenModal(true);
    loadDomainList();
    setSelectedDomain("-1");
    setDomains([]);
  };

  const handleDomainSelect = (event) => {
    const domainId = event.target.value;
    setSelectedDomain(domainId);
  };

  console.log({check: newGroup.name.toLowerCase() != "all-users-tpir" && !newGroup.isDefaultGroup , 1: newGroup.name.toLowerCase() != "all-users-tpir",2: !newGroup.isDefaultGroup, newGroup})
  console.log("Condition Result: ", isTacEnabled 
    ? (newGroup.name.toLowerCase() !== "all-users-tpir" && !newGroup.isDefaultGroup && newGroup.type !== "Admin") 
    : (newGroup.name.toLowerCase() !== "all-users-tpir"));
  
  const uploadUsersFile = (e) => {
    console.log("event triggereed", selectedDomain);
    const file = e.target.files[0]; // Get the selected file
    console.log("event triggered", selectedDomain);

    if (!file) {
      setFileData(null);
      e.target.value = null;
      return;
    }

    if (selectedDomain && selectedDomain !== "-1") {

      if (file && file.name && checkNullByteInjection(file.name)) {
        setFileData(null);
        e.target.value = null;
        file = null;
        toast.error(
          "Please remove any null byte characters from the file and try again."
        );
      } else if (
        file &&
        file.type == "text/csv" &&
        !checkNullByteInjection(file.name)
      ) {
        setFileData({ domainId: selectedDomain, csvFile: file });
      } else {
        setFileData(null);
        e.target.value = null;
        toast.error("Only CSV file is allowed");
      }
    } else {
      toast.error("Please select a domain to sync!");
      setFileData(null);
      e.target.value = null;
    }
  };

  const UploadUsers = (filedata) => {
    console.log({ filedata });
    if (selectedDomain == "-1") toast.error("Please select a domain!");
    if (!fileData) {
      toast.error("Please upload a csv file!");
      setFileData(null);
    } else {
      api
        .post(routes.USERS.UPLOAD_USER, filedata, {
          headers: {
            "Content-Type": "multipart/form-data",
          },
        })
        .then((res) => res.data)
        .then(async (data) => {
          console.log(data);
          toast.success(data.message);
          if (
            fileInputRef &&
            fileInputRef.current &&
            fileInputRef.current.value
          )
            fileInputRef.current.value = null;
          handleCloseModal();
          closeCustomGroupDrawer();
          loadGroups();
          console.log("accessErrorrrrrrrrrrrr", data.showAccessError);
          if (
            data?.showAccessError?.email ||
            data?.showAccessError?.messenger
          ) {
            const decision = await swal({
              title: "User Limit Exceeded",
              text: "The number of users in csv exceeds remaining limit of users that can be granted access so only users that already belong to group with current access and accordingly access of group will be updated!",
              icon: "warning",
              dangerMode: true,
              closeOnEsc: true,
              buttons: {
                Close: true,
              },
            });
          } else if (data?.showExceededUsersInCsvThanRemaningLimitError) {
            const decision = await swal({
              title: "User Limit Exceeded",
              text: `The number of users in the CSV exceeds your maximum user license limit. Only unique users will be added and existing users will be updated and accordingly the access of the group will be updated!`,
              icon: "warning",
              dangerMode: true,
              closeOnEsc: true,
              buttons: {
                Close: true,
              },
            });
          }
        })
        .catch(async (err) => {
          setFileData(null);
          if (
            fileInputRef &&
            fileInputRef.current &&
            fileInputRef.current.value
          )
            fileInputRef.current.value = null;
          document.getElementById("myFile").value = "";
          handleCloseModal();
          closeCustomGroupDrawer();
          loadGroups();
          apiError(err);
        });
    }
  };

  const handleChangeGroupName = (e) => {
    setNewGroup({ ...newGroup, name: e.target.value });
  };

  const addUsers = () => {
    if (group && group._id) setIdToAddUsersToGroup(group._id);
    searchButtonOnClickHandler();
  };

  const addOrCreateGroup = (isCreatingGroupBeforeUploadingUser) => {
    console.log({ isCreatingGroupBeforeUploadingUser, newGroup });
    if (!isCreatingGroupBeforeUploadingUser && newGroup.name == "")
      toast.error("Please input the group name!");
    else {
      api
        .post(routes.GROUPS.ADDOREDIT, {
          groupId: group?._id,
          groupName: newGroup.name,
          users: newGroup.users,
          isCreatingGroupBeforeUploadingUser,
        })
        .then((res) => res.data)
        .then(async (data) => {
          if (isCreatingGroupBeforeUploadingUser) {
            setFileData({ ...fileData, groupId: data.groupId });
            UploadUsers({ ...fileData, groupId: data.groupId });
          } else {
            if (data.message == "Please select users to add to group!")
              toast.error(data.message);
            else if (data?.showRemainingLimitError?.error) {
              const decision = await swal({
                title: "User Limit Exceeded",
                text: data?.showRemainingLimitError?.message,
                icon: "error",
                dangerMode: true,
                closeOnEsc: true,
                buttons: {
                  Close: true,
                },
              });
            } else toast.success(data.message);
            closeCustomGroupDrawer();
            loadGroups();
          }
        })
        .catch((err) => {
          apiError(err);
          handleCloseModal();
          closeCustomGroupDrawer();
        });
    }
  };

  const removeUserFromGroup = (userId, groupId) => {
    let isUserAlreadyInGroup = usersToAddToGroup.some(
      (user) => user._id === userId
    );
    console.log({ isUserAlreadyInGroup });

    // if (isUserAlreadyInGroup) {
      let removeUserFromUsersToAddToGroup = usersToAddToGroup.filter(
        (user) => user._id !== userId
      );
      let removeUserFromUsersNewGroup = newGroup.users.filter(
        (user) => user._id !== userId
      );
      setShouldRunEffect(false);
      setNewGroup({ ...newGroup, users: removeUserFromUsersNewGroup });
      setUsersToAddToGroup(removeUserFromUsersToAddToGroup);
  };

  const closeCustomGroupDrawer = () => {
    setNewGroup({ name: "", users: [], groupId: null, isDefaultGroup: false, type:"Custom" });
    setIsEditingGroup(false);
    setGroup("");
    setGroupUsers([]);
    setIdToAddUsersToGroup(null);
    setUsersToAddToGroup([]);
    onClose(false)({ type: "click" });
    setSelectedDomain("-1");
    setDomains([]);
    setFileData(null);
    loadGroups();
  };

  React.useEffect(() => {
    if (!shouldRunEffect) {
      setShouldRunEffect(true);
      return;
    }
 
    const newUsers = [
      ...newGroup.users,
      ...usersToAddToGroup.filter(
        (userToAdd) =>
          !newGroup.users.some(
            (existingUser) => existingUser._id === userToAdd._id
          )
      ),
    ];

    setNewGroup({ ...newGroup, users: newUsers });
    // setNewGroup({...newGroup, users: [...newGroup.users, ...usersToAddToGroup]})
  }, [usersToAddToGroup]);

  React.useEffect(() => {
    if (isEditingGroup) {
      setNewGroup({
        name: group.groupName,
        users: groupUsers,
        groupId: group._id,
        isDefaultGroup: group.isDefaultGroup,
        type: group.type
      });
    }
  }, [isEditingGroup]);
console.log({newGroup, isTacEnabled, check:newGroup.name.toLowerCase() != "all-users-tpir" && !newGroup.isDefaultGroup && newGroup.type!=="Admin"})

  return (
    <Drawer
      anchor="right"
      open={open}
      onClose={closeCustomGroupDrawer}
      className={`${styles.Linkmaindrawer} ${styles.customeUserDrawer}`}
    >
      <Box className={styles.closebtn}>
        <IoCloseOutline onClick={closeCustomGroupDrawer} />
      </Box>

      <Box className={styles.commonModalWrapper}>
        <Box className={styles.modalHeader}>
          <Typography variant="h6">
            {isEditingGroup ? "Edit" : "Create"} Custom Group
          </Typography>
          <Typography component="p">
            Select the users you want to add
          </Typography>
        </Box>

        <Box className={styles.custominfoBox}>
          <Box className={styles.InputField}>
            <InputLabel>Group Name</InputLabel>
            {/* <label sx={{ fontWeight:"600", fontSize:"14px", color:" #6c757d" }}>Group Name</label> */}
            <TextField
              name="name"
              value={newGroup.name}
              // disabled={(newGroup.name.toLowerCase() == "all-users-tpir" && newGroup.isDefaultGroup) || isTacEnabled}
              disabled={
              isEditingGroup?
              isTacEnabled
                ? !(newGroup?.type === "Custom" && newGroup?.name.toLowerCase() !== "all-users-tpir" && !newGroup?.isDefaultGroup)
                : (newGroup?.name.toLowerCase() === "all-users-tpir" && newGroup?.isDefaultGroup) : false
              }
              onChange={handleChangeGroupName}
              variant="outlined"
            />
          </Box>

          <Box styles={styles.addUserbtn}>
            <Typography component="p">
              Group Members<sup>*</sup>
             
              {/* {isTacEnabled ?  (newGroup.name.toLowerCase() != "all-users-tpir" && !newGroup.isDefaultGroup && newGroup.type!=="Admin") :  (newGroup.name.toLowerCase() != "all-users-tpir")  &&  (
                <span>
                  <Button
                    variant="contained"
                    className={`${styles.btn} ${styles.btnPrimary}`}
                    onClick={() => addUsers()}
                  >
                    <TfiSearch className={styles.icon_position} /> Select Users
                  </Button>
                {!isTacEnabled &&
                  <Button
                    variant="contained"
                    onClick={handleOpenModal}
                    className={`${styles.btn} ${styles.btnPrimary}`}
                  >
                    <TfiSearch className={styles.icon_position} /> Upload CSV
                  </Button>
                }
                </span>
              )} */}
              {(isTacEnabled 
                ? (newGroup.name.toLowerCase() !== "all-users-tpir" && !newGroup.isDefaultGroup && newGroup.type !== "Admin") 
                : (newGroup.name.toLowerCase() !== "all-users-tpir")
              ) && (
                <>
                  <span>
                    <Button
                      variant="contained"
                      className={`${styles.btn} ${styles.btnPrimary}`}
                      onClick={() => addUsers()}
                    >
                      <TfiSearch className={styles.icon_position} /> Select Users
                    </Button>
                    {!isTacEnabled && (
                      <Button
                        variant="contained"
                        onClick={handleOpenModal}
                        className={`${styles.btn} ${styles.btnPrimary}`}
                      >
                        <TfiSearch className={styles.icon_position} /> Upload CSV
                      </Button>
                    )}
                  </span>
                </>
              )}


            </Typography>
          </Box>

          <Box
            sx={{ marginTop: "15px", padding: "0px" }}
            className={styles.contentbarWrap}
          >
            <TableContainer className={styles.tableContainer}>
              <Table aria-label="simple table">
                <TableHead className={styles.thead_background}>
                  <TableRow>
                    <TableCell>Name</TableCell>
                    <TableCell>Type</TableCell>
                    <TableCell>Action</TableCell>
                  </TableRow>
                </TableHead>

                <TableBody className={styles.DomainUser}>
                  {newGroup &&
                    newGroup.users &&
                    newGroup.users.map((user) => (
                      <TableRow key={user._id}>
                        {/* Name + avatar */}
                        <TableCell
                          component="td"
                          scope="row"
                          className={styles.onlyForPinter}
                        >
                          <Box className={styles.flexTableData}>
                            <Box className={styles.circle}>
                              <Typography
                                component="p"
                                className={styles.circleInner}
                              >
                                {user.name && user.name[0]}
                              </Typography>
                            </Box>
                            <Box>
                              <Typography variant="h5">{user.name}</Typography>
                            </Box>
                          </Box>
                        </TableCell>

                        {/* New “Type” column */}
                        <TableCell component="td" scope="row">
                          {user.emailType}
                        </TableCell>

                        {/* Delete action */}
                        {(isTacEnabled 
                            ? newGroup.type === "Custom" &&
                              newGroup.name.toLowerCase() !== "all-users-tpir" &&
                              !newGroup.isDefaultGroup
                            : newGroup.name.toLowerCase() !== "all-users-tpir" &&
                              !newGroup.isDefaultGroup
                          ) ? (
                          <TableCell component="td" scope="row">
                            <TfiTrash onClick={() => removeUserFromGroup(user._id, group?._id)} />
                          </TableCell>
                        ) : (
                          <TableCell component="td" scope="row" />
                        )}
                      </TableRow>
                    ))}
                </TableBody>
              </Table>
            </TableContainer>
          </Box>

          <Box className={styles.modalFooter}>
            <Grid container>
              <Grid item xs={12} md={12} align="right" position="relative">
                <Button
                  variant="contained"
                  onClick={closeCustomGroupDrawer}
                  className={`${styles.btn} ${styles.btnSecondary}`}
                  sx={{ marginRight: "16px" }}
                >
                  Cancel
                </Button>

                {/* {(isTacEnabled 
                            ? newGroup?.type === "Custom" && newGroup?.name.toLowerCase() !== "all-users-tpir" && !newGroup?.isDefaultGroup 
                            : newGroup?.name.toLowerCase() !== "all-users-tpir" && !newGroup?.isDefaultGroup
                          ) ? (
                            <Button
                              variant="contained"
                              onClick={() => addOrCreateGroup(false)}
                              className={`${styles.btn} ${styles.btnSuccess}`}
                            >
                              {isEditingGroup ? "Save" : "Create"} Group
                            </Button>
                        ) : ''} */}
                        {!isEditingGroup && (newGroup?.name.toLowerCase() === "all-users-tpir" || newGroup?.isDefaultGroup)
                          ? ""
                          : (isTacEnabled
                              ? newGroup?.type === "Custom" && newGroup?.name.toLowerCase() !== "all-users-tpir" && !newGroup?.isDefaultGroup
                              : newGroup?.name.toLowerCase() !== "all-users-tpir" ||  !newGroup?.isDefaultGroup
                            ) && (
                              <Button
                                variant="contained"
                                onClick={() => addOrCreateGroup(false)}
                                className={`${styles.btn} ${styles.btnSuccess}`}
                              >
                                {isEditingGroup ? "Save" : "Create"} Group
                              </Button>
                            )
                        }


                {/* {newGroup?.name.toLowerCase() != "all-users-tpir" && !newGroup.isDefaultGroup && (
                  <Button
                    variant="contained"
                    onClick={() => addOrCreateGroup(false)}
                    className={`${styles.btn} ${styles.btnSuccess}`}
                  >
                    {isEditingGroup ? "Save" : "Create"} Group
                  </Button>
                )} */}
              </Grid>
            </Grid>
          </Box>
        </Box>
      </Box>
      <Modal
        open={openModal}
        onClose={handleCloseModal}
        aria-labelledby="modal-title"
        aria-describedby="modal-description"
        className={styles.mainModalBox}
      >
        <Box className={styles.modalBox}>
          <Box className={styles.modalHeader}>
            <Box>
              <Typography variant="h6">Import Users From CSV</Typography>
              <Typography component="p">
                Select the domain and group for which you want to add users
              </Typography>
            </Box>

            <CloseSharpIcon
              className={styles.closeIcon}
              onClick={handleCloseModal}
            />
          </Box>

          <Box className={styles.modalBody}>
            <label
              sx={{
                fontWeight: "600",
                fontSize: "14px",
                color: " #6c757d",
              }}
            >
              Domains
            </label>
            <Select
              value={selectedDomain}
              onChange={handleDomainSelect}
              fullWidth
              displayEmpty
              className={styles.inputSelect}
            >
              <MenuItem value="-1" disabled>
                Select a Domain
              </MenuItem>
              {domains?.map((domain) => (
                <MenuItem key={domain._id} value={domain._id}>
                  <Box display="flex" justifyContent="space-between" width="100%">
                    <Typography component="span">
                      {domain.domainName}
                    </Typography>
                    <Typography
                      component="span"
                      className={`${styles.badge} ${styles.badgePrimary}`}
                    >
                      {domain.domainType === 'Outlook'
                        ? domain.domainTypeForOutlook
                        : domain.domainType}
                    </Typography>
                  </Box>
                </MenuItem>

              ))}
            </Select>

            {/* {selectedDomain && selectedDomain !== "-1" && selectedGroupForUploadingUser ? ( */}
            <Box className={styles.rightContent}>
              <label
                sx={{
                  fontWeight: "600",
                  fontSize: "14px",
                  color: " #6c757d",
                }}
              >
                Upload File
              </label>

              <TextField
                size="small"
                type="file"
                id="myFile"
                inputRef={fileInputRef}
                onChange={uploadUsersFile}
                name="filename"
                accept=".csv, .xlsx, .xls"
                fullWidth
                sx={{ mb: "14px" }}
              />
            </Box>
            {/* ) : null} */}
            <a
              href={`${process.env.NEXT_PUBLIC_API_URL}/api/static/csv/sample/Users.csv`}
              className={styles.TextSuccess}
              Download
              style={{fontSize:"12px"}}
            >
              Download Sample CSV{" "}
            </a>

          </Box>

          {!isEditingGroup && (
            <Box className={styles.modalFooter}>
              <Grid container>
                <Grid item xs={12} md={12} align="right" position="relative">
                  <Button
                  disabled={
                      selectedDomain == "-1" ||
                      fileData == null || newGroup.name == ""                   
                    }
                    variant="contained"
                    onClick={() => addOrCreateGroup(true)}
                  >
                    Upload users
                  </Button>
                </Grid>
              </Grid>
            </Box>
          )}
          { isEditingGroup && (
            <Box className={styles.modalFooter}>
              <Grid container>
                <Grid item xs={12} md={12} align="right" position="relative">
                  <Button
                    variant="contained"
                    disabled={
                      selectedDomain == "-1" ||
                      fileData == null || newGroup.name == ""                            
                    }
                    onClick={() =>
                      UploadUsers({ ...fileData, groupId: newGroup.groupId })
                    }
                  >
                    Upload users
                  </Button>
                </Grid>
              </Grid>
            </Box>
          )}
        </Box>
      </Modal>
    </Drawer>
  );
}
