import React from 'react'
import Drawer from '@mui/material/Drawer';
import { IoCloseOutline } from "react-icons/io5";
import { 
    Box, Typography, TableRow, TableHead, 
    TableCell, TableBody, Table, TableContainer
} from '@mui/material'

import styles from '../../../styles/home.module.scss'

export default function LinkDrawer(props) {
    const { toggleDrawerInner, stateLink, scanResult = {} } = props;
    const { result = {}, url = '' } = scanResult;
    const getList = () => {
        let data = [];
        Object.keys(result).forEach((key, index) => {
            data.push(
                <TableRow key={index} sx={{ '&:last-child td, &:last-child th': { border: 0 } }}>
                    
                    <TableCell component="td" scope="row">{key}</TableCell>
                    <TableCell component="td" scope="row">{result[key].result}</TableCell>
                    <TableCell component="td" scope="row" style={{color: result[key].detected?'red':'green'}}>{result[key].detected?"Yes":"No"}</TableCell>
                </TableRow>
            )
        })
        if(data.length == 0){
            data.push(
                <TableRow key={0} sx={{ '&:last-child td, &:last-child th': { border: 0 } }}>
                    <TableCell component="td" scope="row">Result Not Found</TableCell>
                </TableRow>
            )
        }
        return data;
    }
    return (
        <Box>
            <Drawer
                anchor="right"
                open={stateLink.right}
                onClose={toggleDrawerInner(false)}
                className={styles.Linkmaindrawer}>
                <Box className={styles.closebtn}>
                    <IoCloseOutline onClick={toggleDrawerInner(false)} />
                </Box>
                <Box className={styles.TableHeader}>
                    <Typography component="p">
                        Scan Results
                    </Typography>
                </Box>
                <Box className={styles.LinkResultDrawer}>
                    <Box className={styles.ResultName}>
                        <Typography component="p">
                            {url}
                        </Typography>
                    </Box>
                    <Box className={styles.AnalyticsReport}>
                        <Box className={`${styles.MailLink} ${styles.linktabrow}`}>
                            <TableContainer className={styles.tableContainer}>
                                <Table sx={{ minWidth: 450 }} aria-label="simple table">
                                    <TableHead className={styles.thead_background}>
                                        <TableRow>
                                            
                                            <TableCell >Anti Virus</TableCell>
                                            <TableCell >Result</TableCell>
                                            <TableCell >Detected</TableCell>
                                        </TableRow>
                                    </TableHead>
                                    <TableBody>
                                        {getList()}
                                    </TableBody>
                                </Table>
                            </TableContainer>
                        </Box>
                    </Box>
                </Box>
            </Drawer>
        </Box>
    )
}
