import React from 'react';
import Drawer from '@mui/material/Drawer';
import { IoCloseOutline, IoSearchOutline } from 'react-icons/io5';
import dynamic from 'next/dynamic';
import styles from '../../../styles/home.module.scss';
import { Box, Typography, TextField, FormGroup, Button, FormControlLabel, TableRow, TableHead, Stack, TableContainer, TableCell, TableBody, Table, Grid,Tab, Tabs, } from '@mui/material'
import { TfiSearch, TfiTrash } from "react-icons/tfi";
import Checkbox from '@mui/material/Checkbox';
import api from '../../../utils/api';
import routes from '../../../utils/routes';
import Pagination from '../../globlePagination';
const Chart = dynamic(() => import('react-apexcharts'), { ssr: false });

export default function SearchUserDrawer(props) {
  const { open, onClose, idToAddUsersToGroup, setIdToAddUsersToGroup, setUsersToAddToGroup, usersToAddToGroup } = props;
  
  const [selectedUsers, setSelectedUsers] = React.useState([]);
  const [selectAllCurrentPage, setSelectAllCurrentPage] = React.useState(false);   
  const [usersToAddToGroupBeforeClickingAddUsers, setUsersToAddToGroupBeforeClickingAddUsers] = React.useState([])
  const [selectedUsersBeforeClickingAddUsers, setSelectedUsersBeforeClickingAddUsers] = React.useState([]) 

  const [users, setUsers] = React.useState([])
  const [ page, setPage ] = React.useState(1);
  const [ limit, setLimit ] = React.useState(10);
  const [ search, setSearch ] = React.useState('');
  const [ count, setCount ] = React.useState(1)

  const [debouncedSearchItem, setDebouncedSearchItem] = React.useState('')

  const closeAddUsersDrawer = () =>{
    onClose(false)({ type: 'click' })
  }

  const handleSearch = (e) =>{
    setSearch(e.target.value)
  }
 

  const handlePageChange = (event, value) => {
    setPage(value);
};

  const loadUsers = () =>{
    api.get(routes.USERS.LIST,{ params: { group: idToAddUsersToGroup, page, limit, search }})
    .then(res=>res.data)
    .then((data)=>{
      setUsers(data.users)
      setCount(data.count)
    })
  }


const handleSelectAllUsersOnPage = (event) => {
  if (event.target.checked) {
    const currentUserIds = users.map((user) => user._id);
    const updatedUsers = [...new Set([...selectedUsersBeforeClickingAddUsers, ...currentUserIds])]; 
    
    let addUsersToAddUsersToGroup = users.filter(user => updatedUsers.includes(user._id));
    setUsersToAddToGroupBeforeClickingAddUsers([...usersToAddToGroupBeforeClickingAddUsers, ...addUsersToAddUsersToGroup])
    setSelectedUsersBeforeClickingAddUsers(updatedUsers);
    setSelectAllCurrentPage(true);
  } else {
    const currentUserIds = users.map((user) => user._id);
    const updatedUsers = selectedUsersBeforeClickingAddUsers.filter((id) => !currentUserIds.includes(id));
    let addUsersToAddUsersToGroup = users.filter(user => updatedUsers.includes(user._id));
    setUsersToAddToGroupBeforeClickingAddUsers([...usersToAddToGroupBeforeClickingAddUsers, ...addUsersToAddUsersToGroup])
    setSelectedUsersBeforeClickingAddUsers(updatedUsers);
    setSelectAllCurrentPage(false);
  }
};


const handleSelectUser = (id) => {
  let updatedUsers;
  //removing user on unchecking checkbox
  if (selectedUsersBeforeClickingAddUsers.includes(id)) {
    updatedUsers = selectedUsersBeforeClickingAddUsers.filter((userId) => userId !== id);
  } else { //adding user to updatedUsers on checking checkbox
    updatedUsers = [...selectedUsersBeforeClickingAddUsers, id];
  }
  let addUsersToAddUsersToGroup = users.filter(user => updatedUsers.includes(user._id));
  setUsersToAddToGroupBeforeClickingAddUsers([...addUsersToAddUsersToGroup])
  setSelectedUsersBeforeClickingAddUsers(updatedUsers);


  const currentPageUserIds = users.map((user) => user._id);
  setSelectAllCurrentPage(currentPageUserIds.every((userId) => updatedUsers.includes(userId)));
};

  console.log('adddd users in dusre wala',usersToAddToGroup)

  const addUsersToGroup = () =>{
    // const selectedUserObjects = users.filter(user => selectedUsers.includes(user._id));
    // setUsersToAddToGroup(selectedUserObjects)
    // closeAddUsersDrawer()
    setUsersToAddToGroup([...usersToAddToGroupBeforeClickingAddUsers])
    setSelectedUsers([...selectedUsersBeforeClickingAddUsers])
    console.log({usersToAddToGroupBeforeClickingAddUsers, selectedUsersBeforeClickingAddUsers})
    onClose(false)({ type: 'click' })
  }

  React.useEffect(()=>{
    loadUsers()
  },[page])

  React.useEffect(() => {
    const currentPageUserIds = users.map(user => user._id);
    const allSelectedOnPage = currentPageUserIds.every(id => selectedUsersBeforeClickingAddUsers.includes(id));
  
    setSelectAllCurrentPage(allSelectedOnPage);  
  }, [users, selectedUsersBeforeClickingAddUsers]);  
  

  React.useEffect(() => {
    loadUsers(search);       
  }, [debouncedSearchItem])

  React.useEffect(() => {
    const handler = setTimeout(()=>{
        setDebouncedSearchItem(search)
        setPage(1)
    },1000)

    return () => {
        clearTimeout(handler);
    };
},
[search]);

  return (
    <Drawer
      anchor="right"
      open={open}
      onClose={closeAddUsersDrawer}
      className={`${styles.Linkmaindrawer} ${styles.customeUserDrawer}`}
    >
      <Box className={styles.closebtn}>
        <IoCloseOutline onClick={onClose(false)} />
      </Box>

            <Box className={styles.commonModalWrapper}>
               
                     <Box className={styles.modalHeader}>
                      <Typography variant='h6'>
                          Search User
                      </Typography>

                     <Typography component="p">
                           Select users to add to the group
                        </Typography>
                      
                      </Box> 



                      <Box className={styles.filterWrapper}>
                        <Grid container direction="row" justifyContent="center" alignItems="center" >
                            <Grid item xs={12} md={4} align="left" position="relative">
                                <Box className={styles.filterSearchBar}>
                                    <TextField 
                                        className={styles.searchBar} 
                                        placeholder='Users Emails' 
                                        size="small" 
                                        fullWidth 
                                        value={search}
                                        onChange={handleSearch}
                                      
                                    />
                                    <Typography component="span" className={styles.search_icon} ><IoSearchOutline /> </Typography>
                                </Box>
                            </Grid>

                    <Grid item xs={12} md={8}>
                        
                    </Grid>
                 
                   
                </Grid>
            </Box>
              
                    <Box className={styles.custominfoBox}>
                       <Box sx={{ padding:"0px"}} className={styles.contentbarWrap}>
                        <TableContainer className={styles.tableContainer}>
                            <Table aria-label="simple table">
                                <TableHead className={styles.thead_background}>

                                    <TableRow>
                                      <TableCell className='w-0'> 
                                        <FormGroup> 
                                          <FormControlLabel
                                              control={
                                                <Checkbox
                                                checked={selectAllCurrentPage}
                                                onChange={handleSelectAllUsersOnPage}
                                                inputProps={{ 'aria-label': 'controlled' }}
                                                style={{marginLeft:"9px"}}
                                              />
                                              }
                                              size="small"
                                            />
                                     </FormGroup></TableCell>
                                        <TableCell>Name</TableCell>
                                    </TableRow>
                                </TableHead>

                                <TableBody className={styles.DomainUser}>
                                {users && users.length ? users.map((user)=>(
                                
                                    <TableRow>
                                      <TableCell>
                                      <FormGroup> 
                                      <FormControlLabel
                                          control={
                                            <Checkbox
                                            checked={selectedUsersBeforeClickingAddUsers.includes(user._id)}
                                            onChange={()=>handleSelectUser(user._id)}
                                            inputProps={{ 'aria-label': 'controlled' }}
                                          />
                                          }
                                          size="small"
                                        />
                                     </FormGroup>
                                      </TableCell>
                                        <TableCell component="td" scope="row" className={styles.onlyForPinter}>
                                            <Box className={styles.flexTableData}>
                                                        <Box className={styles.circle}>
                                                            <Typography component="p" className={styles.circleInner}>
                                                               {user && user.name && user.name[0]}
                                                            </Typography>
                                                        </Box>

                                                        <Box>
                                                            <Typography variant='h5'>
                                                            {user && user.name}  
                                                            </Typography>
                                                            <Typography component="span">
                                                           {user && user.email}
                                                            </Typography>
                                                        </Box>

                                                    </Box>
                                        </TableCell>
                                        
                                    </TableRow>
                                  )) : ''}
                                </TableBody>
                            </Table>
                        </TableContainer>
                            {users && users.length > 0?
                        <Stack spacing={2} direction="row" justifyContent='space-between' alignItems="center">
                            <Pagination 
                                count={count} 
                                page={page}
                                limit={limit}
                                handlePageChange={handlePageChange}
                            ></Pagination>                    
                        </Stack>:
                            <>{ 
                                    <Box className={styles.noRecordMail}>
                                        <Typography component="p">No Records Found!</Typography>
                                    </Box>
                                }
                            </>
                        }      
                    </Box>

                       
                  </Box>

                  <Box className={styles.modalFooter}>
                              <Grid container>
                                  <Grid item xs={12} md={12} align="right" position="relative">

                                  <Button
                                    variant="contained"
                                    onClick={closeAddUsersDrawer}
                                    className={`${styles.btn} ${styles.btnSecondary}`} sx={{ marginRight: '16px' }}>
                                     Cancel
                                  </Button>

                                  <Button
                                    variant="contained"
                                    onClick={addUsersToGroup}
                                    className={`${styles.btn} ${styles.btnSuccess }`}>
                                  Add Users
                                  </Button>

                                   
                                    </Grid>
                                
                              </Grid>

                           </Box>

            </Box>

   
    </Drawer>
  );
}
