import React from 'react'
import Drawer from '@mui/material/Drawer';
import { IoCloseOutline } from "react-icons/io5";
import { Box, Typography, TableRow, TableHead, Stack, TableContainer, TableCell, TableBody, Table, Grid,Tab, Tabs, } from '@mui/material'
import PropTypes from 'prop-types';
import dynamic from 'next/dynamic';
import styles from '../../../styles/home.module.scss'
import Pagination from '../../../components/globlePagination';
import { extractInitials, getDate } from '../../../utils/common';
const Chart = dynamic(() => import('react-apexcharts'), { ssr: false });


  
export default function UserDrawer(props) {

    const [value, setValue] = React.useState(0)
    const { toggleUserDrawer, userDrawerState, userStats, reportedMails, reportedMessages, userReportPagination, setUserReportPagination, userReportMessagePagination, setUserReportMessagePagination, handlePageChangeReports, handlePageChangeMessageReports } = props;
    const [mail,setMail] = React.useState("")
    const [message,setMessage] = React.useState("")

    function TabPanel(props) {
        const { children, value, index, ...other } = props;
      
        return (
          <div
            role="tabpanel"
            hidden={value !== index}
            id={`vertical-tabpanel-${index}`}
            aria-labelledby={`vertical-tab-${index}`}
            {...other}
          >
            {value === index && (
              <Box sx={{ p: 3 }}>
                <Typography>{children}</Typography>
              </Box>
            )}
          </div>
        );
      }
    
      TabPanel.propTypes = {
        children: PropTypes.node,
        index: PropTypes.number.isRequired,
        value: PropTypes.number.isRequired,
      };
      function a11yProps(index) {
        return {
          id: `vertical-tab-${index}`,
          'aria-controls': `vertical-tabpanel-${index}`,
        };
      }
    
      const areaNew = {      
        series: [{
            name: 'Mails Reported',
            data: mail ? [...mail] : [],
            connect:true
        }],
        
        options: {
          chart: {
            id: 'area-datetime',
            type: 'area',
            height: 350,
            toolbar:{
              show:false
            },    
            zoom: {
              autoScaleYaxis: true
            }
          },
          dataLabels: {
            enabled: false,
          },
         
          markers: {
            size: 0,
            style: 'hollow',
          },
        
          
          xaxis: {
            type: 'datetime',
            min: new Date(Date.now() - 90 * 24 * 60 * 60 * 1000).getTime(),
            tickAmount: 6,
            labels: {
                style: {
                    fontSize: '11px'
                }
           }
    
          },
    
          fill: {
            type: 'gradient',
            colors: ['#3583cc'],
        
            gradient: {
              shadeIntensity: 1,
              opacityFrom: 0.7,
              opacityTo: 0.9,
              stops: [0, 100],
            }
          },
        },
      
      
        selection: 'one_year',
      
      }; 

      const areaNewMessenger = {      
        series: [{
            name: 'Messages Reported',
            data: message ? [...message] : [],
            connect:true
        }],
        
        options: {
          chart: {
            id: 'area-datetime',
            type: 'area',
            height: 350,
            toolbar:{
              show:false
            },    
            zoom: {
              autoScaleYaxis: true
            }
          },
          dataLabels: {
            enabled: false,
          },
         
          markers: {
            size: 0,
            style: 'hollow',
          },
        
          
          xaxis: {
            type: 'datetime',
            min: new Date(Date.now() - 90 * 24 * 60 * 60 * 1000).getTime(),
            tickAmount: 6,
            labels: {
                style: {
                    fontSize: '11px'
                }
           }
    
          },
    
          fill: {
            type: 'gradient',
            colors: ['#3583cc'],
        
            gradient: {
              shadeIntensity: 1,
              opacityFrom: 0.7,
              opacityTo: 0.9,
              stops: [0, 100],
            }
          },
        },
      
      
        selection: 'one_year',
      
      }; 



    const handleChange = (event, newValue) =>{
        setValue(newValue)
    }
    

    React.useEffect(()=>{
        setMail(userStats.reportedMailsWithCount)
        setMessage(userStats.reportedMessagesWithCount)
    },[userStats.reportedMailsWithCount, userStats.reportedMessagesWithCount])

    return (
        <Box>
            <Drawer
                anchor="right"
                open={userDrawerState.right}
                onClose={() => toggleUserDrawer(false)}
                className={`${styles.Linkmaindrawer} ${styles.adminUserDrawer}`}>
                <Box className={styles.closebtn}>
                    <IoCloseOutline onClick={() => toggleUserDrawer(false)} />
                </Box>
            
         <Box className={styles.LinkResultDrawer}>
               

                <Box className={styles.AnalyticsReport}>
                    <Box className={styles.tabHeader}>
                     <Box className={styles.ResultName}>
                        <Typography component="p">
                            Admin User <br></br><span>Showing user analytics below</span>
                        </Typography>
                      </Box>
                         <Grid container >
                                <Grid item sx={6} md={6}>
                                    <Box className={styles.nameFlex}>
                                            <Box className={styles.nameCircul}>
                                                <Typography component="p">
                                                        {userStats.name && extractInitials(userStats.name)}
                                                </Typography>
                                            </Box>

                                        <Box className={styles.rightnameInfo}>
                                            <Typography variant="h4">
                                                {userStats.name}
                                            </Typography>
                                            <Typography component="p">
                                                    {userStats.email}
                                            </Typography>

                                            <Box className={styles.badges}>
                                                <Typography variant="h5" className={`${styles.bgColor} ${styles.bgFirst}`}>
                                                    {userStats.emailType}
                                                </Typography>

                                                <Typography variant="h5" className={userStats.isActive ? `${styles.bgColor} ${styles.bgSecond}`: `${styles.bgColor} ${styles.bgDanger}`}>
                                                    {userStats.isActive ? 'Active' : 'Inactive'}
                                                </Typography>

                                                <Typography variant="h5" className={`${styles.bgColor} ${styles.bgThird}`}>
                                                    {userStats.role}
                                                </Typography>
                                                
                                            </Box>
                                        </Box> 
                                    </Box>

                                </Grid>
                                <Grid item sx={6} md={6} className={styles.colFlex}>
                                    <Box className={styles.rightBox}>
                                    <Typography component="p">
                                        Last Active: <span>
                                            {userStats.lastActive !== "No mail reported yet." && userStats.lastActiveMessenger !== "No message reported yet."
                                                ? new Date(Math.max(new Date(userStats.lastActive), new Date(userStats.lastActiveMessenger))).toLocaleDateString('en-GB')
                                                : userStats.lastActive !== "No mail reported yet."
                                                    ? new Date(userStats.lastActive).toLocaleDateString('en-GB')
                                                    : userStats.lastActiveMessenger !== "No message reported yet."
                                                        ? new Date(userStats.lastActiveMessenger).toLocaleDateString('en-GB')
                                                        : "No Mail/Message reported yet."
                                            }
                                        </span>
                                    </Typography>
                                    </Box>
                                </Grid>
                            </Grid>
                            </Box>  

                                <Box className={styles.clickTab} sx={{ borderBottom: 1, borderColor: 'divider' }}>
                                        <Tabs value={value} onChange={handleChange} aria-label="basic tabs example" className={styles.TabItemButton}>
                                        <Tab label="Email Reporting" {...a11yProps(0)} />
                                        <Tab label="Whatsapp Reporting" {...a11yProps(1)} />
                                    </Tabs>
                                </Box>

                            <Box className={styles.userTabBar}>
                                <Box className={styles.TabPanelWrap}>
                                            <TabPanel value={value} index={0}>  
                                                <Grid container spacing={2}>
                                                    <Grid item sx={6} md={6}>
                                                        <Box className={styles.cardSummary}>
                                                                <Box className={styles.cardHeader}>
                                                                    <Typography variant="h1">Reporting Summary</Typography>
                                                                </Box>
                                                                    <Box className={styles.midCard}>
                                                                        <Box className={styles.DnsblTable}>
                                                                            <TableContainer sx={{ maxHeight: 580 }}>
                                                                                <Table sx={{ minWidth: 300 }} aria-label="simple table">
                                                                                
                                                                                    <TableBody>
                                                                                        <TableRow  >
                                                                                                <TableCell component="td" scope="row"><b>Total Mails Reported</b></TableCell>
                                                                                                <TableCell component="td" scope="row" >{userStats.totalMails}</TableCell>
                                                                                            </TableRow>

                                                                                            <TableRow  >
                                                                                                <TableCell component="td" scope="row"><b>Trashed</b></TableCell>
                                                                                                <TableCell component="td" scope="row" >{userStats.trashedMails}</TableCell>
                                                                                            </TableRow>

                                                                                            <TableRow  >
                                                                                                <TableCell component="td" scope="row"><b>Recovered</b></TableCell>
                                                                                                <TableCell component="td" scope="row" >{userStats.recoveredMails}</TableCell>
                                                                                            </TableRow>

                                                                                            <TableRow  >
                                                                                                <TableCell component="td" scope="row"><b>Deleted</b></TableCell>
                                                                                                <TableCell component="td" scope="row" >{userStats.deletedMails}</TableCell>
                                                                                            </TableRow>
                                                                                            <TableRow  >
                                                                                                <TableCell component="td" scope="row"><b>Action Pending</b></TableCell>
                                                                                                <TableCell component="td" scope="row" >{userStats.pendingMails}</TableCell>
                                                                                            </TableRow>
                                                                                    
                                                                                    </TableBody>
                                                                                </Table>
                                                                            </TableContainer>
                                                                        </Box>
                                                                    </Box> 
                                                            </Box>
                                                        </Grid>

                                                        <Grid item sx={6} md={6}>
                                                            <Box className={styles.cardSummary}>
                                                                    <Box className={styles.cardHeader}>
                                                                        <Typography variant="h1">Phishing Awareness Scrore</Typography>
                                                                    </Box>
                                                                        <Box className={styles.midCard}>
                                                                            <Box className={styles.userAwareness}>
                                                                                <Typography variant="h2">
                                                                                    {userStats.score > 0 ? userStats.score : parseInt(userStats.score)}% 
                                                                                </Typography>
                                                                                <Typography component="p">
                                                                                User <br></br>Awareness 
                                                                                </Typography>
                                                                            </Box>
                                                                            <Typography component="p" className={styles.pTag}><sup>*</sup>Represents the user's awareness level achieved through the reporting of genuine phishing emails.</Typography>
                                                                            </Box>
                                                                </Box>

                                                        </Grid>
                                                </Grid>

                                                <Box className={styles.cardSummary}>
                                                    <Box className={styles.cardHeader}>
                                                                    <Typography variant="h1">Report Frequency</Typography>
                                                                </Box>
                                                            <Box className="internalCardsec">	
                                                            <Chart 
                                                            options={areaNew.options}
                                                            series={areaNew.series}
                                                                type="area"
                                                                height="210"
                                                            />
                                                        
                                                        </Box>	
                                                </Box>
                                                <Box>
                                                <Box className={`${styles.tableBody} ${styles.setScroll}`}>
                                                    <Box className="internalCardsec">
                                                        <TableContainer className={styles.tableContainer}>
                                                            <Table aria-label="simple table">
                                                                <TableHead className={styles.thead_background}>
                                                                    <TableRow>
                                                                        <TableCell className="w-25">Sender</TableCell>
                                                                        <TableCell className="w-30">Subject</TableCell>
                                                                        <TableCell className="w-10">Other Reporters</TableCell>
                                                                        <TableCell className="w-20">Date</TableCell>
                                                                        <TableCell className="w-15">Status</TableCell>	
                                                                    </TableRow>
                                                                </TableHead>
                                                                <TableBody className={styles.mailRepWrap}>
                                                                            {reportedMails && reportedMails.map((data,index)=>(
                                                                            <TableRow >

                                                                                <TableCell component="td" scope="row">
                                                                                {data.from}
                                                                                </TableCell>
                                                                                <TableCell component="td" scope="row">{data.subject}</TableCell>
                                                                                <TableCell component="td" scope="row">{data.reporters.length}</TableCell>
                                                                                <TableCell component="td" scope="row" >{getDate(data.createdAt)}</TableCell>
                                                                                <TableCell component="td" scope="row">{data.isRecoveredEmail == 'true' ? 'Recovered' : data.isTrashedEmail == 'true' ? 'Trashed' : data.isDeletedEmail == 'true' ? 'Deleted' : 'No Action taken' }</TableCell>
                                                                            </TableRow>
                                                                                ))}
                                                                    
                                                                </TableBody>   
                                                            </Table>
                                                        </TableContainer>	
                                                        {reportedMails && reportedMails.length > 0?
                                                                <Stack spacing={2} direction="row" justifyContent='space-between' alignItems="center">
                                                                    <Pagination 
                                                                        count={userReportPagination.count} 
                                                                        page={userReportPagination.page}
                                                                        limit={userReportPagination.limit}
                                                                        handlePageChange={handlePageChangeReports}
                                                                    ></Pagination>                    
                                                                </Stack>:
                                                                    <>{ 
                                                                        <Box className={styles.noRecordMail}>
                                                                            <Typography component="p">No Records Found!</Typography>
                                                                        </Box>
                                                                        }
                                                                    </>
                                                                }  
                                                        </Box>							
                                            </Box>
                                        </Box>
                                     </TabPanel>

                                            <TabPanel value={value} index={1}>
                                            <Grid container spacing={2}>
                                                    <Grid item sx={6} md={6}>
                                                        <Box className={styles.cardSummary}>
                                                                <Box className={styles.cardHeader}>
                                                                    <Typography variant="h1">Reporting Summary</Typography>
                                                                </Box>
                                                                    <Box className={styles.midCard}>
                                                                        <Box className={styles.DnsblTable}>
                                                                            <TableContainer sx={{ maxHeight: 580 }}>
                                                                                <Table sx={{ minWidth: 300 }} aria-label="simple table">
                                                                                
                                                                                    <TableBody>
                                                                                        <TableRow  >
                                                                                                <TableCell component="td" scope="row"><b>Total Messages Reported</b></TableCell>
                                                                                                <TableCell component="td" scope="row" >{userStats.totalMessages}</TableCell>
                                                                                            </TableRow>

                                                                                            <TableRow  >
                                                                                                <TableCell component="td" scope="row"><b>Safe</b></TableCell>
                                                                                                <TableCell component="td" scope="row" >{userStats.safeMessages}</TableCell>
                                                                                            </TableRow>

                                                                                            <TableRow  >
                                                                                                <TableCell component="td" scope="row"><b>Dubious</b></TableCell>
                                                                                                <TableCell component="td" scope="row" >{userStats.dubiousMessages}</TableCell>
                                                                                            </TableRow>

                                                                                            <TableRow  >
                                                                                                <TableCell component="td" scope="row"><b>Unsafe</b></TableCell>
                                                                                                <TableCell component="td" scope="row" >{userStats.unsafeMessages}</TableCell>
                                                                                            </TableRow>
                                                                                            <TableRow  >
                                                                                                <TableCell component="td" scope="row"><b>No Admin Intervention</b></TableCell>
                                                                                                <TableCell component="td" scope="row" >{userStats.noAdminActionMessages}</TableCell>
                                                                                            </TableRow>
                                                                                    
                                                                                    </TableBody>
                                                                                </Table>
                                                                            </TableContainer>
                                                                        </Box>
                                                                    </Box> 
                                                            </Box>
                                                        </Grid>

                                                        <Grid item sx={6} md={6}>
                                                            <Box className={styles.cardSummary}>
                                                                    <Box className={styles.cardHeader}>
                                                                        <Typography variant="h1">Phishing Awareness Scrore</Typography>
                                                                    </Box>
                                                                        <Box className={styles.midCard}>
                                                                            <Box className={styles.userAwareness}>
                                                                                <Typography variant="h2">
                                                                                    {userStats.messengerScore > 0 ? userStats.messengerScore : parseInt(userStats.messengerScore)}% 
                                                                                </Typography>
                                                                                <Typography component="p">
                                                                                User <br></br>Awareness 
                                                                                </Typography>
                                                                            </Box>
                                                                            <Typography component="p" className={styles.pTag}><sup>*</sup>Represents the user's awareness level achieved through the reporting of genuine phishing messages.</Typography>
                                                                            </Box>
                                                                </Box>

                                                        </Grid>
                                                </Grid>

                                                <Box className={styles.cardSummary}>
                                                    <Box className={styles.cardHeader}>
                                                                    <Typography variant="h1">Report Frequency</Typography>
                                                                </Box>
                                                            <Box className="internalCardsec">	
                                                            <Chart 
                                                            options={areaNewMessenger.options}
                                                            series={areaNewMessenger.series}
                                                                type="area"
                                                                height="210"
                                                            />
                                                        
                                                        </Box>	
                                                </Box>
                                                <Box>
                                                <Box className={`${styles.tableBody} ${styles.setScroll}`}>
                                                    <Box className="internalCardsec">
                                                        <TableContainer className={styles.tableContainer}>
                                                            <Table aria-label="simple table">
                                                                <TableHead className={styles.thead_background}>
                                                                    <TableRow>
                                                                        <TableCell className="w-25">Reporter</TableCell>
                                                                        <TableCell className="w-25">Sender</TableCell>
                                                                        <TableCell className="w-20">Date</TableCell>
                                                                        <TableCell className="w-15">Status</TableCell>	
                                                                    </TableRow>
                                                                </TableHead>
                                                                <TableBody className={styles.mailRepWrap}>
                                                                            {reportedMessages && reportedMessages.map((data,index)=>(
                                                                            <TableRow >

                                                                                <TableCell component="td" scope="row">
                                                                                {data?.from}
                                                                                </TableCell>
                                                                                <TableCell component="td" scope="row">
                                                                                {data?.sender}
                                                                                </TableCell>
                                                                                <TableCell component="td" scope="row" >{getDate(data.createdAt)}</TableCell>
                                                                                <TableCell component="td" scope="row">{data?.result}</TableCell>
                                                                            </TableRow>
                                                                                ))}
                                                                    
                                                                </TableBody>   
                                                            </Table>
                                                        </TableContainer>	
                                                        {reportedMessages && reportedMessages.length > 0?
                                                                <Stack spacing={2} direction="row" justifyContent='space-between' alignItems="center">
                                                                    <Pagination 
                                                                        count={userReportMessagePagination.count} 
                                                                        page={userReportMessagePagination.page}
                                                                        limit={userReportMessagePagination.limit}
                                                                        handlePageChange={handlePageChangeMessageReports}
                                                                    ></Pagination>                    
                                                                </Stack>:
                                                                    <>{ 
                                                                        <Box className={styles.noRecordMail}>
                                                                            <Typography component="p">No Records Found!</Typography>
                                                                        </Box>
                                                                        }
                                                                    </>
                                                                }  
                                                        </Box>							
                                            </Box>
                                        </Box>
                                            </TabPanel>
                                 </Box>
                             </Box> 

                     </Box>

                </Box>
            </Drawer>
        </Box>
    )
}
