import React from 'react'
import Table from '@mui/material/Table';
import Paper from '@mui/material/Paper';
import TableRow from '@mui/material/TableRow';
import { Box, Typography } from '@mui/material';
import TableBody from '@mui/material/TableBody';
import TableCell from '@mui/material/TableCell';
import TableContainer from '@mui/material/TableContainer';

import styles from '../../styles/home.module.scss';
import { downloadEmail } from '../../utils/common';

export default function Header(props) {
    const { headerData = {} } = props;
    const getHeader = () => {
        let data = [];
        Object.keys(headerData).forEach((key, index) => {
            data.push(
                <TableRow key={index}>
                    <TableCell width="200">{key}: </TableCell>
                    <TableCell >{headerData[key]}</TableCell>
                </TableRow>
            )
        })
        return data;
    }

    return (
        <Box className={styles.AnalyticsReport}>
           <Box className={styles.HeaderDownloadBox}>
                <Typography component="p">
                    Showing header details
                </Typography>
                <Box className={styles.HeaderDownload}>
                    {/* <a href='#' onClick={()=>downloadEmail('Header', headerData, '')} className={styles.TextSuccess}>Dowload Header</a> */}
                </Box>
            </Box> 
           
            <Box className={styles.MailHeader}>
               <Box className={styles.HeaderTableMainBox}>
                    <TableContainer component={Paper} className={styles.tableContent}>
                        <Table sx={{ minWidth: 650 }} aria-label="simple table">
                            <TableBody>
                                { getHeader() }
                            </TableBody>
                        </Table>
                    </TableContainer>
                </Box> 
            </Box>
        </Box>
    )
}
