import React, { useEffect } from 'react'
import { IoSearchOutline, IoSyncSharp } from "react-icons/io5";
import { 
    Box, Typography, Button, TableRow, TableHead, 
    TableContainer, TableCell, 
    TableBody, Table, TextField 
} from '@mui/material';
import { TfiReload } from "react-icons/tfi";


import api from '../../utils/api';
import routes from '../../utils/routes';
import { apiError } from '../../utils/error';
import Pagination from '../globlePagination';
import styles from '../../styles/home.module.scss';

export default function SimiliarEmailsTab({ similiarEmails = [], page, limit, count, handleSimiliarEmailPageChange, reportedEmail, loadSimiliarEmailForReportedEmail, handleSearch, startSimiliarEmailSearch }) {
    const label = { inputProps: { 'aria-label': 'Checkbox demo' } };
    const onRefresh = () => {
        if(reportedEmail?.isSimiliarEmailProcessing == false && reportedEmail?.isSimiliarEmailCompleted == false){
            startSimiliarEmailSearch && startSimiliarEmailSearch();
        } else {
            loadSimiliarEmailForReportedEmail && loadSimiliarEmailForReportedEmail();
        }
    }
    return (
        <Box className={styles.AnalyticsReport}>
            <Box className={styles.HeaderDownloadBox}>
                <Typography component="p">
                Showing users who have received similar mail 
                </Typography>
               
                <Box className={styles.WhoElseSearch} position="relative">
                <Button variant="contained" className={styles.backgroundUnset} onClick={onRefresh}  ><TfiReload className={styles.refreshIcon}/></Button>
                     <TextField className={styles.searchBar} placeholder='Users Emails' size="small" onChange={e=>handleSearch(e.target.value)} fullWidth />
                        <Typography component="span" className={styles.search_icon} ><IoSearchOutline /> </Typography>
                </Box>
            </Box> 

            <Box className={`${styles.contentbarWrap} ${styles.contentbarPadding}`}>
            <TableContainer className={styles.tableContainer} >
                <Table sx={{ minWidth: 650 }} aria-label="simple table">
                    <TableHead className={styles.thead_background}>
                        <TableRow>
                            {/* <TableCell ><Checkbox {...label} className={styles.CheckedBox} checked={selectAll} onClick={checkAll} style={{paddingLeft:'0'}}/></TableCell> */}
                            <TableCell >Receiver's Email</TableCell>
                            {/* <TableCell >Email</TableCell> */}
                            <TableCell >Subject</TableCell>
                            {/* <TableCell >Status</TableCell> */}
                            {/* <TableCell >Trashed</TableCell>
                            <TableCell >Deleted</TableCell> */}
                            {/* <TableCell >Error while Moving</TableCell> */}
                        </TableRow>
                    </TableHead>
                    <TableBody>
                        { similiarEmails.map((data, index) =>(
                            <TableRow key={index} sx={{ '&:last-child td, &:last-child th': { border: 0 } }}>
                                <TableCell component="td" scope="row">{data.to}</TableCell>
                                {/* <TableCell component="td" scope="row">{data.from}</TableCell> */}
                                {/* <TableCell component="td" scope="row">{data.subject}</TableCell> */}
                                <TableCell component="td" scope="row">{data.subject}</TableCell>
                            </TableRow>
                        ))}
                    </TableBody>
                </Table>
                {similiarEmails.length > 0 &&
                    <>
                        <Pagination
                            count={count}
                            page={page}
                            limit={limit}
                            handlePageChange={handleSimiliarEmailPageChange}
                        ></Pagination>
                    </>
                }
            </TableContainer>
            </Box>
            { (reportedEmail?.isSimiliarEmailProcessing == false && reportedEmail?.isSimiliarEmailCompleted && similiarEmails.length === 0) && 
             <Box className={`${styles.noRecordPara} ${styles.noRecordMail}`}>
                 <Typography component="p">No similar mail found</Typography>
             </Box> 
             }
                 { (reportedEmail?.isSimiliarEmailProcessing == false && reportedEmail?.isSimiliarEmailCompleted == false)  && 
                     <Box className={`${styles.noRecordPara} ${styles.noRecordMail}`}>
                     <Typography component="p">Similar email search not started yet.</Typography>
                 </Box> 
                 }
            
             { (reportedEmail?.isSimiliarEmailProcessing == true && reportedEmail?.isSimiliarEmailCompleted == false) &&
                <Box className={`${styles.noRecordPara} ${styles.noRecordMail}`}>
                 <Typography component="p">Please wait while records are being updated!</Typography>
             </Box>
             }
        </Box>
    )
}

