import React from 'react'
import { Box, Grid, Typography } from '@mui/material'
import Image from "next/image";
// import whatsappImg from '../../assets/logo/RRR.webp'
import styles from '../../styles/home.module.scss';

export async function getServerSideProps() {
    return {
        props: {},
    };
}

const MessageBox = ({ message, sender, time, safetyParameter, description }) => {
    const [hovered, setHovered] = React.useState(false);
  
    const messageContainerStyle = {
      width:"100%",
      position: "relative", // Important for positioning the tooltip
    };
  
    const messageBubbleStyle = {
      backgroundColor: "#f1f1f1",
      borderRadius: "15px",
      padding: "10px 20px",
      maxWidth: "100%",
      position: "relative",
      boxShadow: "0px 2px 5px rgba(0, 0, 0, 0.1)",
      marginBottom: "15px",
      border: "1px solid #e0e0e0",
    };
  
    const messageTailStyle = {
      content: '""',
      position: "absolute",
      top: "10px",
      left: "-10px",
      borderWidth: "10px",
      borderStyle: "solid",
      borderColor: "transparent #f1f1f1 transparent transparent",
    };
  
    const messageTextStyle = {
      fontSize: "13px",
      margin: "0",
      color: "#333",
    };
  
    const messageInfoStyle = {
      display: "flex",
      justifyContent: "space-between",
      fontSize: "12px",
      color: "#999",
      marginTop: "5px",
    };
  
    const senderStyle = {
      fontWeight: "bold",
    };
  
    const timeStyle = {
      fontStyle: "italic",
    };
  
    const tooltipStyle = {
      visibility: hovered ? "visible" : "hidden",
      backgroundColor: "#333",
      color: "#fff",
      textAlign: "left",
      borderRadius: "8px",
      padding: "10px",
      position: "absolute",
      top: "-70px",
      left: "16%",
      zIndex: 1,
      boxShadow: "0px 4px 10px rgba(0, 0, 0, 0.2)",
      fontSize: "12px",
      lineHeight: "1.5",
      width: "250px",
    };
  
    const tooltipArrowStyle = {
      content: '""',
      position: "absolute",
      bottom: "-10px",
      left: "20px",
      borderWidth: "10px",
      borderStyle: "solid",
      borderColor: "#333 transparent transparent transparent",
    };
  
    const tooltipTitleStyle = {
      fontWeight: "bold",
      marginBottom: "5px",
      color: "#ffcc00", // A nice golden color for titles
    };
  
    return (
      <div
        style={messageContainerStyle}
        onMouseEnter={() => setHovered(true)}
        onMouseLeave={() => setHovered(false)}
      >
        <div style={messageBubbleStyle}>
          <div style={messageTailStyle}></div>
          <p style={messageTextStyle}>{message}</p>
          <div style={messageInfoStyle}>
            <span style={senderStyle}>{sender}</span>
            <span style={timeStyle}>{time}</span>
          </div>
  
          {/* Tooltip */}
          <div style={tooltipStyle}>
            <div style={tooltipArrowStyle}></div>
            <div style={tooltipTitleStyle}>Safety Parameter: {safetyParameter}</div>
            <div>Description: {description}</div>
          </div>
        </div>
      </div>
    )
}

const ErrorMessageBox = ({ errorMessage, description }) => {
    const errorContainerStyle = {
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      padding: "20px",
      margin: "70px",
      backgroundColor: "#ffe0e0", // Soft red background for error message
      border: "1px solid #ffcccc",
      borderRadius: "15px",
      boxShadow: "0px 2px 5px rgba(0, 0, 0, 0.1)",
      maxWidth: "80%",
      position: "relative",
      fontSize: "16px",
      color: "#a94442",
    };
  
    const errorIconStyle = {
      fontSize: "30px",
      color: "#a94442",
      marginRight: "10px",
    };
  
    const errorTextContainerStyle = {
      textAlign: "left",
      fontSize: "14px",
    };
  
    const errorMessageStyle = {
      fontWeight: "bold",
      marginBottom: "10px",
      color: "#a94442", // Dark red for error messages
    };
  
    const descriptionStyle = {
      fontSize: "13px",
      color: "#a94442",
    };
  
    return (
      <div style={errorContainerStyle}>
        <div style={errorTextContainerStyle}>
          <div style={errorMessageStyle}>{errorMessage}</div>
          {description && <div style={descriptionStyle}>{description}</div>}
        </div>
      </div>
    );
  };

export default function BodyTab(props) {
        let { bodyData, image } = props;

        const [ showMainMessageBox, setShowMainMessageBox ] = React.useState(false)
        const [ parsedBodyData, setParsedBodyData ] = React.useState() 
    
        React.useEffect(()=>{
            if(bodyData && bodyData.length ) {
                let parsedBodyData = JSON.parse(bodyData)
                setParsedBodyData(parsedBodyData)
                if(Array.isArray(parsedBodyData)) setShowMainMessageBox(true)
            }
        },[bodyData])


    return (        
      
            <Box className={styles.WhatsappBody}>
                <Grid container>
                    <Grid item sx={7} md={7}>
                        <Box className="wtsWrapper wtswrapperLeft">
                            <Box className={styles.whatsappImg}>
                                <img src={image} style={{width:"100%"}} alt="WhatsApp"/>
                            </Box> 
                        </Box> 
                    </Grid>

                    <Grid item sx={5} md={5}>
                        <Box className="wtsWrapper wtswrapperRight">
                             <Typography component="p">Content Processed</Typography>
                              {showMainMessageBox ? <div>
                              {parsedBodyData && parsedBodyData.length && parsedBodyData[0].length &&  parsedBodyData[0].map((message)=>{
                                console.log("<----->",message)
                                return (<MessageBox 
                                    message={message['Message Body']}
                                    sender={message.Sender}
                                    safetyParameter={message['Safety Parameter']}
                                    description={message.Description}
                                />)
                              })
                              }
                              </div> :
                                <ErrorMessageBox errorMessage={'The image appears to be non-textual or contains visual elements!'} description={parsedBodyData}></ErrorMessageBox>
                              }
                        </Box> 
                    </Grid>
                </Grid>
            </Box>
    
    )
}