import React from 'react'
import { toast } from 'react-toastify';
import { IoEyeSharp } from "react-icons/io5";
import { Box, Typography, Button, TableRow, TableHead, TableContainer, TableCell, TableBody, Table } from '@mui/material'
import Link from 'next/link';
import { TfiSearch } from "react-icons/tfi";
import api from '../../utils/api';
import routes from '../../utils/routes';
import { apiError } from '../../utils/error';
import LinkDrawer from './drawer/link-drawer';
import styles from '../../styles/home.module.scss'

export default function WaLinkTab({urls, messageId, loadLinkWhatsappMessage}) {

    const [ stateLink, setStateLink ] = React.useState({ right: false });
    const [ scanResult, setScanResult ] = React.useState({ result: {}, urls: '' });

    const toggleDrawerInner = (open, result, url) => (event) => {
        if (event.type === 'keydown' && (event.key === 'Tab' || event.key === 'Shift')) {
            return;
        }
        setScanResult({ result, url })
        setStateLink({ ...stateLink, right: open });
    };

    const scanLink = (urlId) =>{
        const whatsappMessageId = messageId        
        api.post(routes.WA_LINK.SCAN,{
            whatsappMessageId,
            urlIds: [urlId]
        })
        .then(res=>res.data)
        .then((data)=>{
            toast.success(data.Message)    
            loadLinkWhatsappMessage()
        })
        .catch((error)=>{
            apiError(error)
        })    
    }

    return (
        <Box className={styles.AnalyticsReport}>
            <Box className={`${styles.commonTableHeader} ${styles.LinkTableHeader}`}>
                <Typography component="p">
                    Showing all links existing in the whatsapp Message
                </Typography>

                {/* <Box>
                     <Button variant="contained" className={`${styles.commonBtn} ${styles.scanAll}`}><TfiSearch className={styles.icon_position}/>Scan All</Button>
                </Box> */}
                
            </Box> 
            <Box className={styles.MidSectionBradcrum}>
                <Typography component="p" className={styles.ShowingMailHeading}>
                </Typography>
            </Box>

            <Box className={styles.contentbarWrap} sx={{padding:"0px"}}>
                <Box className={`${styles.MailLink} ${styles.linktabrow}`}>
                    <TableContainer className={`${styles.tableContainer} ${styles.CommonTableClass}`} sx={{ maxHeight: 650 }}>
                        <Table sx={{ minWidth: 650 }} aria-label="simple table">
                            <TableHead className={styles.thead_background}>
                                <TableRow>
                                    <TableCell sx={{width:"50%"}}>Link</TableCell>
                                    <TableCell >Scan Status</TableCell>
                                    {/* <TableCell >Actions</TableCell> */}
                                    <TableCell >Result</TableCell>
                                </TableRow>
                            </TableHead>
                            <TableBody>
                                {urls.map((data, index) =>
                                {
                                    let result = JSON.parse(data.result)
                                return(
                                    <TableRow key={index} sx={{ '&:last-child td, &:last-child th': { border: 0 } }}>
                                        <TableCell component="td" scope="row">{data.domain && data.domain.href ? data.domain.href : data.url }</TableCell>
                                    
                                        <TableCell component="td" scope="row" className={data.status !=='FAILED' ? data.status === 'NOT SCANNED' ? styles.LinkWarn : styles.LinkSafe : styles.LinkDanger}>
                                                {data.status == "NOT SCANNED" ? 
                                                <Button variant="contained" className={styles.ScanBtn} onClick={() => scanLink(data._id)}><TfiSearch className={styles.icon_position}/>Start Scan</Button> : 
                                                data.status == "FAILED" ?  <Button variant="contained" className={styles.ScanBtn} onClick={() => scanLink(data._id)}>Start Scan</Button> : data.status == "IN PROGRESS" ? 
                                                "In Progress" : data.status == "COMPLETED" ? 'completed' : '' }
                                        </TableCell>
                                        {/* <TableCell component="td" scope="row">
                                            {data.status==='PENDING' || data.status==='FAILED' || data.status === 'NOT SCANNED'? <Button variant="contained" className={styles.ScanBtn} onClick={() => scanLink(data._id)}>Scan Link</Button>:''}
                                        </TableCell> */}
                                        <TableCell component="td" scope="row"  >
                                        { data.status === 'COMPLETED' ?
                                                <Button 
                                                    onClick={toggleDrawerInner(true, result?.scans ? result.scans : {}, data.domain && data.domain.href ? data.domain.href : data.url)} 
                                                    variant="contained" className={styles.ScanResult}
                                                >View Results </Button> : data.status === 'FAILED' ? "failed" : data.status === 'NOT SCANNED' ? ' Scan Pending' : 'Result Awaited'
                                            }
                                        </TableCell>
                                    </TableRow>
                                )})
                                }
                            </TableBody>
                        </Table>
                    </TableContainer>
                </Box>
            </Box>


            { urls.length === 0 && 
                <Box className={`${styles.noRecordPara} ${styles.noRecordMail}`}>
                    <Typography component="p">No link found in this email</Typography>
                </Box>
            }
            <LinkDrawer 
                toggleDrawerInner={toggleDrawerInner} 
                stateLink={stateLink}
                scanResult={scanResult}
            ></LinkDrawer>
        </Box>
    )
}
