import React, { useEffect } from 'react'
import { IoSearchOutline, IoSyncSharp } from "react-icons/io5";
import { 
    Box, Typography, Button, TableRow, TableHead, 
    TableContainer, TableCell, 
    TableBody, Table, TextField 
} from '@mui/material';
import { TfiReload } from "react-icons/tfi";


import api from '../../utils/api';
import routes from '../../utils/routes';
import { apiError } from '../../utils/error';
import Pagination from '../globlePagination';
import styles from '../../styles/home.module.scss';

export default function WhoElseTab({ whoElse = [], page, limit, search, count, startWhoelseSearch, handlePageChange, reportedEmail, loadWhoElseReportedEmails, loadSingleReportedEmails, handleSearch, reportedMailId, fromName, from }) {
    const label = { inputProps: { 'aria-label': 'Checkbox demo' } };
    const onRefresh = () => {
        const flagsLoaded = typeof reportedEmail?.isWhoElseProcessing !== 'undefined' && typeof reportedEmail?.isWhoElseCompleted !== 'undefined';
        // Only attempt start if flags loaded and explicitly both false
        if(flagsLoaded && reportedEmail?.isWhoElseProcessing === false && reportedEmail?.isWhoElseCompleted === false){
            startWhoelseSearch && startWhoelseSearch();
        } else if(flagsLoaded) {
            loadWhoElseReportedEmails && loadWhoElseReportedEmails();
        }
    }
    return (
        <Box className={styles.AnalyticsReport}>
            <Box className={styles.HeaderDownloadBox}>
                <Typography component="p">
                Showing users who else have received the same mail from <b>{fromName}</b> {` <${from}>`}
                </Typography>
               
                <Box className={styles.WhoElseSearch} position="relative">
                    <Button variant="contained" className={styles.backgroundUnset} onClick={onRefresh} ><TfiReload className={styles.refreshIcon}/></Button>
                    <Box className={styles.whoElse}>
                        <TextField 
                            placeholder='Users Emails'
                            size="small" 
                            fullWidth
                            value={search} 
                            onChange={e=>handleSearch(e.target.value)}
                        />
                         <Typography component="span" className={styles.search_icon} ><IoSearchOutline /> </Typography>
                    </Box>
                </Box>
            </Box> 

            <Box className={`${styles.contentbarWrap} ${styles.contentbarPadding}`}>
            <TableContainer className={styles.tableContainer} >
                <Table sx={{ minWidth: 650 }} aria-label="simple table">
                    <TableHead className={styles.thead_background}>
                        <TableRow>
                            {/* <TableCell ><Checkbox {...label} className={styles.CheckedBox} checked={selectAll} onClick={checkAll} style={{paddingLeft:'0'}}/></TableCell> */}
                            <TableCell >Receiver's Email</TableCell>
                            {/* <TableCell >Email</TableCell> */}
                            {/* <TableCell >Subject</TableCell> */}
                            <TableCell >Status</TableCell>
                            {/* <TableCell >Trashed</TableCell>
                            <TableCell >Deleted</TableCell> */}
                            {/* <TableCell >Error while Moving</TableCell> */}
                        </TableRow>
                    </TableHead>
                    <TableBody>
                        { whoElse.map((data, index) =>(
                            <TableRow key={index} sx={{ '&:last-child td, &:last-child th': { border: 0 } }}>
                                <TableCell component="td" scope="row">{data.to}</TableCell>
                                {/* <TableCell component="td" scope="row">{data.from}</TableCell> */}
                                {/* <TableCell component="td" scope="row">{data.subject}</TableCell> */}
                                <TableCell component="td" scope="row">{data.isDeleted ? 'Deleted' : data.isTrashed ? 'Trashed' : 'No Action Taken'}</TableCell>
                            </TableRow>
                        ))}
                    </TableBody>
                </Table>
                {whoElse.length > 0 &&
                    <>
                        <Pagination
                            count={count}
                            page={page}
                            limit={limit}
                            handlePageChange={handlePageChange}
                        ></Pagination>
                    </>
                }
            </TableContainer>
            </Box>
            { (reportedEmail?.isWhoElseProcessing == false && reportedEmail?.isWhoElseCompleted && whoElse.length === 0) && 
             <Box className={`${styles.noRecordPara} ${styles.noRecordMail}`}>
                 <Typography component="p">No whoelse mail found</Typography>
             </Box> 
             }
                 { (reportedEmail?.isWhoElseProcessing === false && reportedEmail?.isWhoElseCompleted === false)  && 
                     <Box className={`${styles.noRecordPara} ${styles.noRecordMail}`}>
                     <Typography component="p">Who-Else search not started yet.</Typography>
                 </Box> 
                 }
            
             { (reportedEmail?.isWhoElseProcessing == true && reportedEmail?.isWhoElseCompleted == false) &&
                <Box className={`${styles.noRecordPara} ${styles.noRecordMail}`}>
                 <Typography component="p">Please wait while records are being updated!</Typography>
             </Box>
             }
        </Box>
    )
}

