import React from "react";
import styles from "../../styles/home.module.scss";
import {
  Box,
  FormControlLabel,
  Radio,
  RadioGroup,
  Typography,
} from "@mui/material";

function LogoContent(props) {
  const { bannerDetail, handleBannerDetailChange } = props;
  return (
    <>
      <Box>
        <Typography className={styles.heading} variant="body1">
          Logo
        </Typography>
        <Typography className={styles.subHeading}>Upload brand logo</Typography>
        <Box sx={{ mt: 2 }}>
          <RadioGroup
            row
            aria-labelledby="demo-row-radio-buttons-group-label"
            name="showLogo"
            value={bannerDetail.showLogo}
            onChange={handleBannerDetailChange}
          >
            <FormControlLabel
              sx={{
                "& .MuiTypography-root": { fontSize: "14px" },
              }}
              value="withLogo"
              control={<Radio />}
              label="With Logo"
            />
            <FormControlLabel
              sx={{
                "& .MuiTypography-root": { fontSize: "14px" },
              }}
              value="withoutLogo"
              control={<Radio />}
              label="Without Logo"
            />
          </RadioGroup>
        </Box>

        {bannerDetail.showLogo === "withLogo" && (
          <Box className={styles.uploadLogoBox}>
            <Box className={styles.uploadLogoIcon}>
              <Typography variant="body2" sx={{ ml: 1 }} htmlFor="imageUpload">
                Drop an image or Browse
              </Typography>
              <input 
              id="imageUpload"
              type="file"
              style={{display:"none"}}
              />
            </Box>
          </Box>
        )}
      </Box>
    </>
  );
}

export default React.memo(LogoContent);
