import React from "react";
import styles from "../../styles/home.module.scss";
import {
  Box,
  FormControlLabel,
  Radio,
  RadioGroup,
  ToggleButton,
  ToggleButtonGroup,
  Typography,
} from "@mui/material";
import ColorPicker from "./ColorPicker";

function StylesContent(props) {
  const {
    bannerDetail,
    handleBannerDetailChange,
    handleChangeBorderThickness,
  } = props;
  return (
    <>
      <Box>
        <Typography className={styles.heading} variant="body1">
          Styles
        </Typography>
        <Typography className={styles.subHeading}>
          Set colors & borders
        </Typography>
      </Box>
      <Box>
        <Typography className={styles.heading} variant="body1">
          Background Color
        </Typography>
        <Box>
          <ColorPicker
            name={"backgroundColor"}
            selectedColor={bannerDetail.backgroundColor}
            handleChangeColor={handleBannerDetailChange}
          />
        </Box>
      </Box>
      <Box>
        <Typography className={styles.heading} variant="body1">
          Border Color
        </Typography>
        <Box sx={{ mt: 1 }}>
          <RadioGroup
            row
            aria-labelledby="demo-row-radio-buttons-group-label"
            name="showBorder"
            value={bannerDetail.showBorder}
            onChange={handleBannerDetailChange}
          >
            <FormControlLabel
              sx={{
                "& .MuiTypography-root": { fontSize: "14px" },
              }}
              value={"true"}
              control={<Radio />}
              label="Color"
            />
            <FormControlLabel
              sx={{
                "& .MuiTypography-root": { fontSize: "14px" },
              }}
              value={"false"}
              control={<Radio />}
              label="No Border"
            />
          </RadioGroup>
        </Box>
        {bannerDetail.showBorder == "true" && (
          <Box>
            <ColorPicker
              name={"borderColor"}
              selectedColor={bannerDetail.borderColor}
              handleChangeColor={handleBannerDetailChange}
            />
          </Box>
        )}
      </Box>
      <Box>
        <Typography className={styles.heading} variant="body1">
          Border Thickness
        </Typography>
        <Box sx={{ mt: 1 }}>
          <ToggleButtonGroup
            color="primary"
            value={bannerDetail.borderThickness}
            exclusive
            onChange={(event, value) =>
              handleChangeBorderThickness("borderThickness", value)
            }
            aria-label="Platform"
            sx={{
              border: "1px solid #CED4DA",
              padding: "5px",
              borderRadius: "5px",
            }}
          >
            <ToggleButton value="small">Small</ToggleButton>
            <ToggleButton value="medium">Medium</ToggleButton>
            <ToggleButton value="large">Large</ToggleButton>
          </ToggleButtonGroup>
        </Box>
      </Box>
    </>
  );
}

export default React.memo(StylesContent);
