import React from "react";
import {
  Box,
  TextField,
  ToggleButton,
  ToggleButtonGroup,
  Typography,
} from "@mui/material";
import FormatAlignLeftIcon from "@mui/icons-material/FormatAlignLeft";
import FormatAlignCenterIcon from "@mui/icons-material/FormatAlignCenter";
import FormatAlignRightIcon from "@mui/icons-material/FormatAlignRight";
import FormatAlignJustifyIcon from "@mui/icons-material/FormatAlignJustify";
import FormatBoldIcon from "@mui/icons-material/FormatBold";
import FormatItalicIcon from "@mui/icons-material/FormatItalic";
import styles from "../../styles/home.module.scss";
import ColorPicker from "./ColorPicker";

function SubjectContent(props) {
  const {
    handleChangeAlignment,
    handleChangeFormat,
    bannerDetail,
    handleBannerDetailChange,
  } = props;

  return (
    <>
      <Box>
        <Typography className={styles.heading} variant="body1">
          Subject
        </Typography>
        <Typography className={styles.subHeading}>
          Add main & sub text
        </Typography>
      </Box>
      <Box className={styles.primaryMsgStyle}>
        <Typography className={styles.heading} variant="body1">
          Primary Message
        </Typography>
        <TextField
          id="outlined-multiline-static"
          placeholder="Enter your primary message here"
          multiline
          rows={5}
          name={"primaryMessage"}
          value={bannerDetail.primaryMessage}
          onChange={handleBannerDetailChange}
        />
        <Box sx={{ display: "flex", gap: "5px" }}>
          <ToggleButtonGroup
            size="small"
            value={bannerDetail.primaryAlignment}
            onChange={(event, newValue) =>
              handleChangeAlignment("primaryAlignment", newValue)
            }
            exclusive={true}
            aria-label="primaryAlignment"
            name="primaryAlignment"
            sx={{
              border: "1px solid #CED4DA",
              padding: "5px",
              borderRadius: "5px",
            }}
          >
            <ToggleButton value="left" key="left">
              <FormatAlignLeftIcon />
            </ToggleButton>

            <ToggleButton value="center" key="center">
              <FormatAlignCenterIcon />
            </ToggleButton>

            <ToggleButton value="right" key="right">
              <FormatAlignRightIcon />
            </ToggleButton>

            <ToggleButton value="justify" key="justify">
              <FormatAlignJustifyIcon />
            </ToggleButton>
          </ToggleButtonGroup>
          <ToggleButtonGroup
            value={bannerDetail.primaryFormat}
            onChange={(event, value) =>
              handleChangeFormat("primaryFormat", value)
            }
            aria-label="text formatting"
            sx={{
              border: "1px solid #CED4DA",
              padding: "5px",
              borderRadius: "8px",
            }}
          >
            <ToggleButton value="bold" aria-label="bold">
              <FormatBoldIcon />
            </ToggleButton>
            <ToggleButton value="italic" aria-label="italic">
              <FormatItalicIcon />
            </ToggleButton>
          </ToggleButtonGroup>
          <ColorPicker
            name={"primaryTextColor"}
            selectedColor={bannerDetail.primaryTextColor}
            handleChangeColor={handleBannerDetailChange}
          />
        </Box>
      </Box>
      <Box className={styles.primaryMsgStyle}>
        <Typography className={styles.heading} variant="body1">
          Secondary Message
        </Typography>
        <TextField
          id="outlined-multiline-static"
          placeholder="Enter your secondary message here"
          multiline
          rows={3}
          name={"secondaryMessage"}
          value={bannerDetail.secondaryMessage}
          onChange={handleBannerDetailChange}
        />
        <Box sx={{ display: "flex", gap: "5px" }}>
          <ToggleButtonGroup
            size="small"
            value={bannerDetail.secondaryAlignment}
            onChange={(event, newValue) =>
              handleChangeAlignment("secondaryAlignment", newValue)
            }
            exclusive={true}
            aria-label="secondaryAlignment"
            name="secondaryAlignment"
            sx={{
              border: "1px solid #CED4DA",
              padding: "5px",
              borderRadius: "5px",
            }}
          >
            <ToggleButton value="left" key="left">
              <FormatAlignLeftIcon />
            </ToggleButton>

            <ToggleButton value="center" key="center">
              <FormatAlignCenterIcon />
            </ToggleButton>

            <ToggleButton value="right" key="right">
              <FormatAlignRightIcon />
            </ToggleButton>

            <ToggleButton value="justify" key="justify">
              <FormatAlignJustifyIcon />
            </ToggleButton>
          </ToggleButtonGroup>

          <ToggleButtonGroup
            value={bannerDetail.secondaryFormat}
            onChange={(event, value) =>
              handleChangeFormat("secondaryFormat", value)
            }
            aria-label="text formatting"
            sx={{
              border: "1px solid #CED4DA",
              padding: "5px",
              borderRadius: "8px",
            }}
          >
            <ToggleButton value="bold" aria-label="bold">
              <FormatBoldIcon />
            </ToggleButton>
            <ToggleButton value="italic" aria-label="italic">
              <FormatItalicIcon />
            </ToggleButton>
          </ToggleButtonGroup>
          <ColorPicker
            name="secondaryTextColor"
            selectedColor={bannerDetail.secondaryTextColor}
            handleChangeColor={handleBannerDetailChange}
          />
        </Box>
      </Box>
    </>
  );
}

export default React.memo(SubjectContent);
