/**
 * @license Copyright (c) 2003-2023, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md.
 */
import React, { type ReactNode } from 'react';
import PropTypes, { type InferProps } from 'prop-types';
import { ContextWatchdog } from '@ckeditor/ckeditor5-watchdog';
import type { WatchdogConfig } from '@ckeditor/ckeditor5-watchdog/src/watchdog';
import type { Context, ContextConfig } from '@ckeditor/ckeditor5-core';
export declare const ContextWatchdogContext: React.Context<ContextWatchdog<Context> | "contextWatchdog" | null>;
export default class CKEditorContext<TContext extends Context = Context> extends React.Component<Props<TContext>, {}> {
    contextWatchdog: ContextWatchdog<TContext> | null;
    constructor(props: Props<TContext>, context: any);
    shouldComponentUpdate(nextProps: Readonly<Props<TContext> & {
        children?: ReactNode | undefined;
    }>): boolean;
    /**
     * Wrapper for the async handler. Note that this is an implementation bug, see https://github.com/ckeditor/ckeditor5-react/issues/312.
     */
    private _shouldComponentUpdate;
    render(): ReactNode;
    componentWillUnmount(): void;
    private _initializeContextWatchdog;
    private _destroyContext;
    static defaultProps: Partial<Props<Context>>;
    static propTypes: {
        id: PropTypes.Requireable<string>;
        isLayoutReady: PropTypes.Requireable<boolean>;
        context: PropTypes.Validator<{
            create(...args: any): Promise<any>;
        } | undefined>;
        watchdogConfig: PropTypes.Requireable<object>;
        config: PropTypes.Requireable<object>;
        onReady: PropTypes.Requireable<(...args: any[]) => any>;
        onError: PropTypes.Requireable<(...args: any[]) => any>;
    };
}
interface Props<TContext extends Context> extends InferProps<typeof CKEditorContext.propTypes> {
    context?: {
        create(...args: any): Promise<TContext>;
    };
    watchdogConfig?: WatchdogConfig;
    config?: ContextConfig;
    onReady?: (context: Context) => void;
    onError: (error: Error, details: ErrorDetails) => void;
    children?: ReactNode;
}
interface ErrorDetails {
    phase: 'initialization' | 'runtime';
    willContextRestart: boolean;
}
export {};
