/**
 * @license Copyright (c) 2003-2023, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * @module ui/colorpicker/colorpickerview
 */
import { type ColorPickerConfig } from './utils';
import { type Locale } from '@ckeditor/ckeditor5-utils';
import View from '../view';
import type ViewCollection from '../viewcollection';
import 'vanilla-colorful/hex-color-picker.js';
import '../../theme/components/colorpicker/colorpicker.css';
export default class ColorPickerView extends View {
    /**
     * Element with saturation and hue sliders.
     */
    picker: HTMLElement;
    /**
     * Container for a `#` sign prefix and an input for displaying and defining custom colors
     * in HEX format.
     */
    hexInputRow: ColorPickerInputRowView;
    /**
     * Current color state in color picker.
     */
    color: string;
    /**
     * List of slider views of the color picker.
     */
    slidersView: ViewCollection<SliderView>;
    /**
     * An internal representation of a color.
     *
     * Since the picker uses a hex format, that's how we store it.
     *
     * Since this is unified color format it won't fire a change event if color is changed
     * from `#f00` to `#ff0000` (same value, different format).
     *
     * @observable
     * @private
     */
    _hexColor: string;
    /**
    * Debounced event method. The `colorPickerEvent()` method is called the specified `waitingTime` after
    * `debouncedPickerEvent()` is called, unless a new action happens in the meantime.
    */
    private _debounceColorPickerEvent;
    /**
     * The output format (the one in which colors are applied in the model) of color picker.
     */
    private _format;
    /**
     * Creates a view of color picker.
     *
     * @param locale
     * @param config
     */
    constructor(locale: Locale | undefined, config: ColorPickerConfig);
    /**
     * Renders color picker in the view.
     */
    render(): void;
    /**
     * Focuses the first pointer in color picker.
     *
     */
    focus(): void;
    /**
     * Creates collection of sliders in color picker.
     *
     * @private
     */
    private _createSlidersView;
    /**
     * Creates input row for defining custom colors in color picker.
     *
     * @private
     */
    private _createInputRow;
    /**
     * Creates the input where user can type or paste the color in hex format.
     *
     * @private
     */
    private _createColorInput;
}
declare class SliderView extends View {
    /**
     * @param element HTML elemnt of slider in color picker.
     */
    constructor(element: HTMLElement);
    /**
     * Focuses element.
     */
    focus(): void;
}
declare class ColorPickerInputRowView extends View {
    /**
     * A collection of row items (buttons, dropdowns, etc.).
     */
    readonly children: ViewCollection;
    /**
     * Creates an instance of the form row class.
     *
     * @param locale The locale instance.
     */
    constructor(locale: Locale, children?: Array<View>);
}
export {};
