import { SyntheticEvent, MouseEvent, TouchEvent, FocusEvent } from 'react';
import { PopoverPosition, PopoverReference } from '@mui/material';
export type Variant = 'popover' | 'popper' | 'dialog';
export type PopupState = {
    open: (eventOrAnchorEl?: SyntheticEvent | Element | null) => void;
    close: () => void;
    toggle: (eventOrAnchorEl?: SyntheticEvent | Element | null) => void;
    onBlur: (event: FocusEvent) => void;
    onMouseLeave: (event: MouseEvent) => void;
    setOpen: (open: boolean, eventOrAnchorEl?: SyntheticEvent | Element | null) => void;
    isOpen: boolean;
    anchorEl: Element | undefined;
    anchorPosition: PopoverPosition | undefined;
    setAnchorEl: (anchorEl: Element | null | undefined) => any;
    setAnchorElUsed: boolean;
    disableAutoFocus: boolean;
    popupId: string | undefined;
    variant: Variant;
    _openEventType: string | null | undefined;
    _childPopupState: PopupState | null | undefined;
    _setChildPopupState: (popupState: PopupState | null | undefined) => void;
};
export type CoreState = {
    isOpen: boolean;
    setAnchorElUsed: boolean;
    anchorEl: Element | undefined;
    anchorPosition: PopoverPosition | undefined;
    hovered: boolean;
    focused: boolean;
    _openEventType: string | null | undefined;
    _childPopupState: PopupState | null | undefined;
    _deferNextOpen: boolean;
    _deferNextClose: boolean;
};
export declare const initCoreState: CoreState;
export declare function usePopupState({ parentPopupState, popupId, variant, disableAutoFocus, }: {
    parentPopupState?: PopupState | null | undefined;
    popupId?: string;
    variant: Variant;
    disableAutoFocus?: boolean | null | undefined;
}): PopupState;
/**
 * Creates a ref that sets the anchorEl for the popup.
 *
 * @param {object} popupState the argument passed to the child function of
 * `PopupState`
 */
export declare function anchorRef({ setAnchorEl, }: PopupState): (el: Element | null | null | undefined) => any;
type ControlAriaProps = {
    'aria-controls'?: string;
    'aria-describedby'?: string;
    'aria-haspopup'?: true;
};
/**
 * Creates props for a component that opens the popup when clicked.
 *
 * @param {object} popupState the argument passed to the child function of
 * `PopupState`
 */
export declare function bindTrigger(popupState: PopupState): ControlAriaProps & {
    onClick: (event: MouseEvent) => void;
    onTouchStart: (event: TouchEvent) => void;
};
/**
 * Creates props for a component that opens the popup on its contextmenu event (right click).
 *
 * @param {object} popupState the argument passed to the child function of
 * `PopupState`
 */
export declare function bindContextMenu(popupState: PopupState): ControlAriaProps & {
    onContextMenu: (event: MouseEvent) => void;
};
/**
 * Creates props for a component that toggles the popup when clicked.
 *
 * @param {object} popupState the argument passed to the child function of
 * `PopupState`
 */
export declare function bindToggle(popupState: PopupState): ControlAriaProps & {
    onClick: (event: MouseEvent) => void;
    onTouchStart: (event: TouchEvent) => void;
};
/**
 * Creates props for a component that opens the popup while hovered.
 *
 * @param {object} popupState the argument passed to the child function of
 * `PopupState`
 */
export declare function bindHover(popupState: PopupState): ControlAriaProps & {
    onTouchStart: (event: TouchEvent) => any;
    onMouseOver: (event: MouseEvent) => any;
    onMouseLeave: (event: MouseEvent) => any;
};
/**
 * Creates props for a component that opens the popup while focused.
 *
 * @param {object} popupState the argument passed to the child function of
 * `PopupState`
 */
export declare function bindFocus(popupState: PopupState): ControlAriaProps & {
    onFocus: (event: FocusEvent) => any;
    onBlur: (event: FocusEvent) => any;
};
/**
 * Creates props for a component that opens the popup while double click.
 *
 * @param {object} popupState the argument passed to the child function of
 * `PopupState`
 */
export declare function bindDoubleClick({ isOpen, open, popupId, variant, }: PopupState): {
    'aria-controls'?: string;
    'aria-describedby'?: string;
    'aria-haspopup'?: true;
    onDoubleClick: (event: MouseEvent) => any;
};
/**
 * Creates props for a `Popover` component.
 *
 * @param {object} popupState the argument passed to the child function of
 * `PopupState`
 */
export declare function bindPopover({ isOpen, anchorEl, anchorPosition, close, popupId, onMouseLeave, disableAutoFocus, _openEventType, }: PopupState): {
    id?: string;
    anchorEl?: Element | null;
    anchorPosition?: PopoverPosition;
    anchorReference: PopoverReference;
    open: boolean;
    onClose: () => void;
    onMouseLeave: (event: MouseEvent) => void;
    onContextMenu: (event: MouseEvent) => void;
    disableAutoFocus?: boolean;
    disableEnforceFocus?: boolean;
    disableRestoreFocus?: boolean;
};
/**
 * Creates props for a `Menu` component.
 *
 * @param {object} popupState the argument passed to the child function of
 * `PopupState`
 */
/**
 * Creates props for a `Popover` component.
 *
 * @param {object} popupState the argument passed to the child function of
 * `PopupState`
 */
export declare function bindMenu({ isOpen, anchorEl, anchorPosition, close, popupId, onMouseLeave, disableAutoFocus, _openEventType, }: PopupState): {
    id?: string;
    anchorEl?: Element | null;
    anchorPosition?: PopoverPosition;
    anchorReference: PopoverReference;
    open: boolean;
    onClose: () => void;
    onMouseLeave: (event: MouseEvent) => void;
    onContextMenu: (event: MouseEvent) => void;
    autoFocus?: boolean;
    disableAutoFocusItem?: boolean;
    disableAutoFocus?: boolean;
    disableEnforceFocus?: boolean;
    disableRestoreFocus?: boolean;
};
/**
 * Creates props for a `Popper` component.
 *
 * @param {object} popupState the argument passed to the child function of
 * `PopupState`
 */
export declare function bindPopper({ isOpen, anchorEl, popupId, onMouseLeave, }: PopupState): {
    id?: string;
    anchorEl?: Element | null;
    open: boolean;
    onMouseLeave: (event: MouseEvent) => void;
};
/**
 * Creates props for a `Dialog` component.
 *
 * @param {object} popupState the argument passed to the child function of
 * `PopupState`
 */
export declare function bindDialog({ isOpen, close }: PopupState): {
    open: boolean;
    onClose: (event: SyntheticEvent) => any;
};
export {};
