import React from 'react';
import reactCSS from 'reactcss';
import map from 'lodash-es/map';

import SwatchesColor from './SwatchesColor';

export var SwatchesGroup = function SwatchesGroup(_ref) {
  var onClick = _ref.onClick,
      onSwatchHover = _ref.onSwatchHover,
      group = _ref.group,
      active = _ref.active;

  var styles = reactCSS({
    'default': {
      group: {
        paddingBottom: '10px',
        width: '40px',
        float: 'left',
        marginRight: '10px'
      }
    }
  });

  return React.createElement(
    'div',
    { style: styles.group },
    map(group, function (color, i) {
      return React.createElement(SwatchesColor, {
        key: color,
        color: color,
        active: color.toLowerCase() === active,
        first: i === 0,
        last: i === group.length - 1,
        onClick: onClick,
        onSwatchHover: onSwatchHover
      });
    })
  );
};

export default SwatchesGroup;