import React from 'react';
import Cookies from 'js-cookie';
import { Box } from '@mui/system';
import { useRouter } from 'next/router'

import Appbar from '../../components/common/appbar';
// import Footer from '../../components/common/footer';
import styles from '../../styles/sidebar.module.scss';

export default function Layout(props) {
    
    const { children } = props;
    const router = useRouter();
    const token = Cookies.get('token');
    const [ isDrawerOpen, setIsDrawerOpen ] = React.useState(false);

    const unAuthenticatedPath = [
        "/login",
        "/login/tac/[token]",
        "/logout",
        "/register",
        "/forgot-password",
        "/reset-password/[email]/[token]",
        "/email-verification/[email]/[token]"
    ]

    React.useEffect(() => {
        if(!token && unAuthenticatedPath.indexOf(router.pathname) === -1){
            router.push('/login');
        }
    }, [])
    
    return (
        <>
            { token && unAuthenticatedPath.indexOf(router.pathname) === -1 ?
                <>
                    <Appbar isDrawerOpen={isDrawerOpen} setIsDrawerOpen={setIsDrawerOpen}/>
                    <Box className={ isDrawerOpen? styles.shrinkMainSection: styles.mainSection}>
                        {children}
                    </Box>
                    {/* <Footer isDrawerOpen={isDrawerOpen} setIsDrawerOpen={setIsDrawerOpen}/> */}
                </>:
                <Box>
                    { unAuthenticatedPath.indexOf(router.pathname) > -1 && children }
                </Box>
            }
        </>
    );  
}