import React from "react";
import App from "next/app";
import Head from 'next/head';

import Layout from "./Layout/Layout";
import '../styles/globals.scss';
import { AppProvider } from "../components/appcontext";

class TAB extends App {
    render(){
        const { Component, pageProps } = this.props;
        return (
            <AppProvider>
            <Layout>
                <Head>
                    <title>TPIR</title>
                    <link rel="shortcut icon" href="/favicon.png" />
                    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
                </Head>
                <Component {...pageProps} />
            </Layout>
            </AppProvider>
        )
    }
}
export default TAB;