import * as React from 'react';
import { Box, Typography, Grid, TableRow, Select, FormControl, MenuItem, TableHead, TableContainer, TableCell, TableBody, Table, Stack 
} from '@mui/material';

import api from '../utils/api';
import routes from '../utils/routes';
import { apiError } from '../utils/error';
import styles from '../styles/home.module.scss';
import Pagination from '../components/globlePagination';

import Loader from '../components/loader/loader';
import { getDate } from '../utils/common';

export default function AuditLogs() {
    const [ page, setPage ] = React.useState(1);
    const [ count, setCount ] = React.useState(1);
    const [ limit, setLimit ] = React.useState(10);
    const [ logs, setLogs] = React.useState([])
    const [ loader, setLoader ] = React.useState(false);


    const handlePageChange = (event, value) => {
        setPage(value);
    };

    const loadAuditLogs =  () =>{
        setLoader(true)
        api.get(routes.AUDIT_LOGS.GET,{
            params: {
                page, limit
            }
        })
        .then(res => res.data)
        .then(async data => {
            let ips = {}
            for(let i=0; i<data.results.length; i++){
                if(data.results[i] && data.results[i].ip){
                    if(ips[data.results[i].ip]){
                        data.results[i]['location'] = ips[data.results[i].ip];
                    } else {
                        let city = await getIpLocation(data.results[i].ip)
                        ips[data.results[i].ip] = city;
                        data.results[i]['location'] = city ? city : null;
                    }
                }
            }
            setLoader(false)
            setCount(data.count);
            setLogs(data.results)
        })
        .catch(err => {
            apiError(err);
        })
    }

    let getIpLocation = async (ipAddress) => {
         try{
             let ipDetails = await api.get(`https://ipapi.co/${ipAddress}/json`, {})
             return ipDetails?.data?.city?? null
         }
         catch(error){
                console.log(error)
                return null
         }
    }



    React.useEffect(()=>{
        loadAuditLogs()
    },[page, limit, count])
    
    React.useEffect(() => {
        setPage(1)
    }, [ ])


    return (

            <Box className={styles.contentbar}>
                <Box className={styles.containerbar}>
                <Box className={styles.breadcrumbBar}>
                    <Grid container direction="row" justifyContent="center" alignItems="center" >
                        <Grid item xs={12} align="left">
                            <Typography component='h4' variant='h4' className={styles.page_title}>Audit Logs</Typography>
                        </Grid>
                        {/* <Grid item xs={8} align="right">
                            <Button variant="contained" className={styles.primaryBtn} onClick={handleOpen}><TfiSearch className={styles.icon_position}/> New Search</Button>
                        </Grid> */}
                    </Grid>
                </Box>

                <Box className={styles.filterWrapper}>
                        <Grid item xs={12} md={2} align="right" position="relative">
                                <FormControl sx={{ minWidth: 100, borderLeft:'1px solid #e4e4e4;', textAlign:'center' }} size="small">
                                    <Select
                                        labelId="demo-simple-select-autowidth-label"
                                        id="demo-simple-select-autowidth"
                                        value={limit}
                                        onChange={e => setLimit(e.target.value)}
                                        autoWidth
                                        displayEmpty
                                        sx={{ boxShadow: 'none', '.MuiOutlinedInput-notchedOutline': { borderRadius: '0px', border: '1px solid #f8f8f8', paddginLeft: '20px' } }}
                                    >
                                        <MenuItem value="10">10 </MenuItem>
                                        <MenuItem value="25">25 </MenuItem>
                                        <MenuItem value="50">50 </MenuItem>
                                        <MenuItem value="100">100 </MenuItem>
                                    </Select>
                                </FormControl>
                        </Grid>
                </Box>


                <Box className={styles.contentbarWrap}>
                <TableContainer className={styles.tableContainer}>
                    <Table sx={{ minWidth: 650 }} aria-label="simple table" className={styles.ReportedMailTable}>
                        
                        <TableHead className={styles.thead_background}>
                            <TableRow className={styles.advanceSearchTable}>
                                <TableCell >Activity</TableCell>
                                <TableCell >Name</TableCell>
                                <TableCell >Type</TableCell>
                                <TableCell >Date</TableCell>
                                <TableCell >Old Data</TableCell>
                                <TableCell >New Data</TableCell>
                                <TableCell >IP</TableCell>
                                <TableCell >Location</TableCell>

                                {/* <TableCell >New Date</TableCell> */}
                                {/* <TableCell >Ip</TableCell>                                */}
                            </TableRow>
                        </TableHead>
                        {logs && logs.length && logs.length > 0 ? <TableBody>
                        {logs.map((data,index) => (
                        <TableRow key={index} sx={{ '&:last-child td, &:last-child th': { border: 0 } }}>
                            <TableCell component="td" scope="row">{data?.activity?? '--'}</TableCell>
                            <TableCell component="td" scope="row">{data?.firstName && data?.lastName ? `${data.firstName} ${data.lastName}` : data?.firstName || '--'}</TableCell>
                            <TableCell component="td" scope="row">{data?.userType?? '--'}</TableCell>
                            <TableCell component="td" scope="row">{getDate(data.createdAt)} </TableCell>
                            <TableCell component="td" scope="row">{data? data.oldData.length!=0 ? data.oldData : '--' : '--' }</TableCell>
                            <TableCell component="td" scope="row">{data? data.newData.length!=0 ? data.newData : '--' : '--'}</TableCell>
                            <TableCell component="td" scope="row">{data?.ip?? '--'}</TableCell>
                            <TableCell component="td" scope="row">{data?.location?? '--'}</TableCell>
                        </TableRow>
                        ))}
                        
                        </TableBody>:
                            <Typography>No Record Found</Typography> 
                        }    
                    </Table>
                    <Pagination
                        count={count}
                        page={page}
                        limit={limit}
                        handlePageChange={handlePageChange}
                    ></Pagination>
                </TableContainer>
                { loader && <Loader />}
                 </Box>
             </Box>
            </Box>

    )
}