import * as React from 'react';
import QRCode from "qrcode";
import { router } from 'next/router';
import { toast } from 'react-toastify';
import { LoadingButton } from '@mui/lab';
import { TfiArrowLeft } from "react-icons/tfi";
import { Box, Button, Typography, Grid, TextField, Link } from '@mui/material';

import routes from '../utils/routes';
import { apiError } from '../utils/error';
import api from '../utils/api';
import styles from '../styles/setting.module.scss';

export default function Auth() {

    const [otp, setOtp] = React.useState('')

    const handleChange = (e) => {
        setOtp(e.target.value);
    };

    const verify =()=>{
        if(/^[0-9]{6}$/.test(otp)){
            api.post(routes.TWOFA.VERIFY_QR,{ otp })
            .then(res=>res.data)
            .then(data=>{
                toast.success("Two factor enabled successfully ");
                router.push('/settings')
            })
            .catch((error)=>{
                apiError(error)
            })
        } else {
            toast.error('Otp must be 6 character numerical only.')
        }
    }


    React.useEffect(()=>{
        api.get(routes.TWOFA.QR)
        .then(res => res.data)
        .then((data) =>{
            var canvas = document.getElementById('canvas')
            QRCode.toCanvas(canvas, data.uri, function (error) {
                if (error) console.error(error)
                console.log('success!');
            })
        })
        .catch((error) => {
            apiError(error)
        })
    }, [])


	return (
	    <Box className={styles.settingWrap}>
                <Box className={styles.breadcrumbBar}>
                    <Grid container direction="row" justifyContent="center" alignItems="center" >
                        <Grid item xs={4}>
                            <Typography component='h4' variant='h4' className={styles.page_title}>Authentication</Typography>
                        </Grid>
                        <Grid item xs={8}>
                            <Box className={styles.flex_btn}>
                               <Link href="/settings">
                                <Button variant="contained" className={styles.btn_new_project} ><TfiArrowLeft className={styles.icon_position} /> Back </Button>
                                </Link>
                            </Box>
                        </Grid>
                    </Grid>
                </Box>

			<Box className={styles.authBox}>
                 <Box className={styles.settingHeading}>
						<Typography variant='h5'>Authentication Steps:</Typography>	
				</Box>
                <Box className={styles.authParaBox}>
                    <Typography component="p">
                        1. Install an authenticator app on your mobile device
                    </Typography>

                    <Typography component="p">
                      2. Scan the following QR code in your authenticator app
                    </Typography>

                        <Box className={styles.barCodeBox}>
                            <canvas id="canvas"></canvas>                     
                        </Box>
                        <Typography component="p">
                             3. Enter the code from your authenticator app below
                         </Typography>
                            <TextField
                            placeholder='Enter your code'
                            value={otp}
                            name="totp"
                            id="otp"
                            size='small'
                            type="password"
                            onChange={handleChange}
                            variant="outlined"  />	
                          </Box>

                     <Box className={styles.UpdateBtn}>
                          <LoadingButton loadingPosition="start" id="socMail" variant="contained" className={styles.primaryBtn} onClick = {verify} >Verify</LoadingButton>
                    </Box>

			</Box>
		</Box>
	)
}