import React from 'react';
import { useRouter } from 'next/router';
import { IoSearchOutline } from "react-icons/io5";
import {
    Box, Grid, TextField, Typography, MenuItem,
    Select, FormControl, TableRow, TableHead,
    TableContainer, TableCell, TableBody, Table, Button
} from '@mui/material'
import { TfiReload, TfiAnnouncement } from "react-icons/tfi";
import api from '../utils/api';
import routes from '../utils/routes';
import { apiError } from '../utils/error';
import { getDate } from '../utils/common';
import { IoInformation } from "react-icons/io5"
import styles from '../styles/home.module.scss';
import Loader from '../components/loader/loader';
import Tooltip from '@mui/material/Tooltip';
import { TfiEmail } from "react-icons/tfi";
import Pagination from '../components/globlePagination';
import { ToastContainer } from "react-toastify";
import { toast } from 'react-toastify'; 
import ModalCommon from '../components/modalCommon';
import Popover from '@mui/material/Popover';
import Radio from '@mui/material/Radio';
import RadioGroup from '@mui/material/RadioGroup';
import FormControlLabel from '@mui/material/FormControlLabel';
import DatePicker from "react-datepicker";
import "react-datepicker/dist/react-datepicker.css";
import { TfiDownload } from "react-icons/tfi";
import CircularProgress from '@mui/material/CircularProgress';
import Checkbox from '@mui/material/Checkbox';
import FormGroup from '@mui/material/FormGroup';
import { TfiArrowLeft } from "react-icons/tfi";
import { AppContext } from '../components/appcontext';
import { useFeatures } from '../utils/features';

export default function Reported() {
    const router = useRouter()
    const { loadFeatures, canAccessFeature, areFeaturesLoaded } = useFeatures();

    const [ page, setPage ] = React.useState(1);
    const [ count, setCount ] = React.useState(1);
    const [ limit, setLimit ] = React.useState(10);
    const [ search, setSearch ] = React.useState('');
    const [ loader, setLoader ] = React.useState(false);
    const [ domains, setDomains ] = React.useState([]);
    const [ reportedMails, setReportedMails ] = React.useState([]);
    const [ selectedDomainId, setSelectedDomainId ] = React.useState('-1')
    const [anchorEl, setAnchorEl] = React.useState(null);
    const [startDate, setStartDate] = React.useState(new Date());
    const [broadcastThreshold, setbroadcastThreshold] = React.useState(0)


    const [filter, setFilter] = React.useState({
        last15:false,
        last30:false,
        custom:false,
        none:false,
        fromDate: new Date(new Date().setDate(new Date().getDate() - 1)),
        toDate: new Date()
    })

    const [ selectedMails, setSelectedMails ] = React.useState([])
    const [ selectAllMails, setSelectAllMails ] = React.useState(false)

    const [filterError, setFilterError] = React.useState({
        fromDate: { status: false, message: ''},
        toDate: { status: false, message: ''}
    })
    
    const handleClick = (event) => {

        setAnchorEl(event.currentTarget);
      };
    
      const handleClose = () => {
        setAnchorEl(null);
      };
    
      const open = Boolean(anchorEl);
      const id = open ? 'simple-popover' : undefined;
    
    const handleSelectedDomain = (event) => {
        const domainId = event.target.value
        setSelectedDomainId(domainId);
        setPage(1)
    };
    const handlePageChange = (event, value) => {
        setPage(value);
    };

    const loadReportedEmails = () => {
        setLoader(true);
        api.get(routes.BROADCAST.LIST, { 
            params: { 
                page, limit, search, 
                domainId: selectedDomainId && selectedDomainId !== '-1' ? selectedDomainId : null,
                isRecoveredEmail: false, isTrashedEmail: false, isDeletedEmail: false,
                mailType:'',last15: filter.last15,last30: filter.last30,custom: filter.custom,toDate: filter.toDate, 
                fromDate: filter.fromDate,
            } 
        })
        .then(res => res.data)
        .then(data => {
            setLoader(false)
            setCount(data.countReportedEmails)
            setReportedMails(data.reportedEmails);
            console.log('fdnsjknfjkdsnkjfnsdkj',data.broadcastThreshold)
            setbroadcastThreshold(data.broadcastThreshold)
            
            const flag = data.reportedEmails.every(email => selectedMails.includes(email._id));
            
            // for(let i=0;i<data.reportedEmails.length;i++){
            //     if(!selectedMails.includes(data.reportedEmails[i]._id)) flag =false
            // }
            if(data.countReportedEmails>0)
            setSelectAllMails(flag)
            // setFilter({...filter, last15:false, last30:false, custom:false})
        })
        .catch(err => {
            setLoader(false)
            apiError(err);
        })
    }

    const reportedMail = (reportId, mailType) =>{
        if(mailType == "Exchange") router.push(`/exchange/${reportId}`)
        else router.push(`/reported-emails/${reportId}`)
    }

    const [showDomain, setShowDomain] = React.useState(false)

    const domainList = () =>{
        api.get(routes.DOMAIN.LIST)
        .then(res=>res.data)
        .then((data) =>{
            if(data.domains.length && data.domains.length > 0) {
                const domain=data.domains
                setDomains(domain)
                setShowDomain(true)
            }
        })
        .catch((error)=>{
                if(!(error && error.response && error.response && error.response.status === 403 )) apiError(error)
                else {
                setShowDomain(false)
                }        
            })
    }

    const [isLite, setisLite] = React.useState(false)
    const [ showLiteModal, setShowLiteModal ] = React.useState(false)

	const openLiteModal = () =>{
		setShowLiteModal(true)
	}
	const closeLiteModal = () =>{
		setShowLiteModal(false)
	}


	const checkPackage = () =>{
		api.get(routes.SETTINGS.CHECK_PACKAGE)
		.then(res=>res.data)
		.then((data)=>{
			setisLite(data.isLite)
		})
	}

    const [showSearch, setShowSearch] = React.useState(false)
    const showResultsbetweenDate = (e) =>{
        if(e.target.value == 'none'){
            setFilter({...filter, last15:false ,last30: false, custom: false, none:true})
            setShowSearch(false)
            handleClose()
        }
        if(e.target.value == 'last15'){
            setFilter({...filter, last15: new Date(new Date().setDate(new Date().getDate() - 15)).setHours(0,0,0,0), last30: false, custom: false, none:false})
            setShowSearch(false)
            handleClose()
        }
        else if(e.target.value == 'last30'){
            setFilter({...filter, last30: new Date(new Date().setDate(new Date().getDate() - 30)).setHours(0,0,0,0), last15: false, custom: false, none:false})
            setShowSearch(false)
            handleClose()
        }
        else if(e.target.value == 'date'){
            setShowSearch(true)
        }

    }


    const broadcastMails = () =>{
        api.post(routes.BROADCAST.SEND_BROADCAST,{mailIds: selectedMails})
        .then(res=>res.data)
        .then((data) =>{
            toast.success("Email(s) will be broadcasted soon!")
            setReportedMails((prevMails) => prevMails.filter(mail => !selectedMails.includes(mail._id)));
            setSelectedMails([]);
        })
        .catch((error)=>{
            apiError(error)      
        })    
    }

    const broadcastSingleMail = (mailId) =>{
        api.post(routes.BROADCAST.SEND_BROADCAST,{mailIds: [mailId]})
        .then(res=>res.data)
        .then((data) =>{
            toast.success(data.message);
            setReportedMails((prevMails) => prevMails.filter(mail => mail._id !== mailId));
        })
        .catch((error)=>{
            apiError(error)      
        })    
    }
    React.useEffect(()=>{
        loadFeatures()
    },[])
    
    React.useEffect(() => {
        if(filter.last15 || filter.last30 || filter.custom || filter.none) { 
            setPage(1)
            loadReportedEmails()
        }
    }, [filter.last15, filter.last30, filter.custom, filter.none])

    React.useEffect(() => {
        domainList();
        checkPackage()
    }, []);

    React.useEffect(() => {
        loadReportedEmails();
    }, [ limit, page, selectedDomainId, search ])

    React.useEffect(() => {
        setPage(1)
    }, [ search ])
    
    React.useEffect(() => {
        if(canAccessFeature("TPIR-EB")){
            loadReportedEmails()
        }
        else{
            if(areFeaturesLoaded) router.push('/feature-unavailable')
        }
    }, [ areFeaturesLoaded ])

    return (
        !areFeaturesLoaded ? <box>Loading</box> :
        <Box className={styles.ReportedBox}>
            <Box className={styles.containerbar}>
                <Box className={styles.breadcrumbBar}>

                    <Grid container direction="row" justifyContent="center" alignItems="center" >
                        <Grid item xs={4}>
                            <Typography component='h4' variant='h4' className={styles.page_title} onClick={()=>router.back()}><span className={styles.commonBackbtn}><TfiArrowLeft className={styles.icon_position}/></span>Broadcast Mails</Typography>

                        </Grid>
                        <Grid item xs={8} align="right">
                           {selectedMails && selectedMails.length>0 ? <Button variant="contained" className={`${styles.btn} ${styles.btnPrimary}`} onClick={() => broadcastMails()}>Broadcast Mails</Button>: ''}
                        </Grid>
                    </Grid>
                    
                </Box>
                <Box className={styles.filterWrapper}>
                    <Grid container direction="row" justifyContent="center" alignItems="center" >
                        <Grid item xs={12} md={4} align="left" position="relative">
                             <Box className={styles.filterSearchBar}>
                                <TextField 
                                    className={styles.searchBar} 
                                    placeholder='Search' 
                                    size="small" 
                                    fullWidth
                                    value={search} 
                                    onChange={e => setSearch(e.target.value)}
                                />
                                <Typography component="span" className={styles.search_icon} ><IoSearchOutline /> </Typography>
                            </Box>
                            </Grid>
                        <Grid item xs={12} md={8}>
                        <Box className={styles.reportFitter}>
                        <Button variant="contained" className={styles.backgroundUnset} onClick={loadReportedEmails} ><TfiReload className={styles.refreshIcon}/>Refresh</Button>

                        {showDomain && 
                            <Box>
                                <FormControl>
                                    <Select
                                     className={`${styles.btn} ${styles.btnPrimaryDrop}`}
                                        labelId="demo-simple-select-autowidth-label"
                                        id="demo-simple-select-autowidth"
                                        value={selectedDomainId}
                                        onChange={handleSelectedDomain}
                                        autoWidth
                                        displayEmpty
                                        sx={{ boxShadow: 'none', '.MuiOutlinedInput-notchedOutline': { borderRadius: '0px', paddginLeft: '20px' } }}
                                    >
                                        <MenuItem value="-1">Domains</MenuItem>
                                        {domains.map((data) => <MenuItem value={data._id} key={data._id}>{data.domainName} ({data.domainType}) </MenuItem>)}
                                    </Select>
                                </FormControl>
                            </Box>

                        }

                            <Box className={styles.datepickerWrap}>
                                    <div aria-describedby={id} variant="contained" onClick={handleClick}  className={`${styles.btn} ${styles.btnPrimaryDrop}`}>
                                        Date
                                    </div>
                                    <Popover
                                        id={id}
                                        open={open}
                                        anchorEl={anchorEl}
                                        onClose={handleClose}
                                        anchorOrigin={{
                                        vertical: 'bottom',
                                        }}
                                      sx={{borderRadius:"5px", overflow:"visible"}} className={styles.abc}>
                                       <Box className={styles.dateinnerBox}>
                                         <FormControl>
                                            <RadioGroup
                                                aria-labelledby="demo-radio-buttons-group-label"
                                                defaultValue="female"
                                                name="radio-buttons-group"
                                                onChange={(e)=>showResultsbetweenDate(e)}
                                                >
                                                <FormControlLabel className={styles.svgCircle} value="none" control={<Radio />}    
                                                    label={<Typography component="p">
                                                        None
                                                        </Typography>
                                                    }>
                                                </FormControlLabel>
                                                <FormControlLabel className={styles.svgCircle} value="last15" control={<Radio />}    
                                                    label={<Typography component="p">
                                                    Within the last 15 Days
                                                        </Typography>
                                                    }>
                                                </FormControlLabel>

                                                <FormControlLabel value="last30" className={styles.svgCircle} control={<Radio />} 
                                                label={
                                                     <Typography component="p">
                                                        Within the last 30 Days
                                                     </Typography>
                                                   }>
                                                </FormControlLabel>

                                        
                                                <Box className={styles.fromtoDate}>
                                                <FormControlLabel className={styles.svgCircle} value="date" control={<Radio />}
                                               sx={{marginRight:"0px"}}>
                                                </FormControlLabel>  
                                                           <Box>
                                                            <Box className={styles.datePicker}>
                                                            <Typography component="p">From</Typography>
                                                                <DatePicker
                                                                    error={filterError.fromDate.status}
								                                    helperText={filterError.fromDate.message}
                                                                    dateFormat="yyyy/MM/dd"
                                                                    selected={filter.fromDate}
                                                                    onChange={(date) => {
                                                                        setFilter({ ...filter, fromDate: new Date(new Date(date).setHours(0, 0, 0, 0)) });
                                                                        setFilterError({
                                                                        ...filterError,
                                                                        fromDate: { status: false, message: "" },
                                                                        });
                                                                    }}
                                                                    disabledKeyboardNavigation
                                                                    className={styles.InputFieldBox}
                                                                />
                                                    
                                                            </Box>

                                                            <Box className={styles.datePicker}>
                                                                <Typography component="p">To</Typography>
                                                                <DatePicker
                                                                    error={filterError.toDate.status}
								                                    helperText={filterError.toDate.message}
                                                                    dateFormat="yyyy/MM/dd"
                                                                    selected={filter.toDate}
                                                                    disabledKeyboarsdNavigation
                                                                    onChange={(date) => {
                                                                        setFilter({ ...filter, toDate: new Date(new Date(date).setHours(23, 59, 59, 999)) });
                                                                        setFilterError({
                                                                        ...filterError,
                                                                        toDate: { status: false, message: "" },
                                                                        });
                                                                    }}
                                                                    className={styles.InputFieldBox}
                                                                />
                                                                </Box>
						                                
                                                                </Box>
                                                             
                                                         
                                                     </Box>

                                            </RadioGroup>
                                        </FormControl>
                                        {showSearch ? <Box className={styles.searchBtn}>
                                                 <Button variant="contained" className={styles.primaryBtn} onClick={(e)=>{
                                                    setFilter({...filter, last15:false, last30:false, custom:true, none:false })
                                                    handleClose()
                                                    setShowSearch(false)
                                                    if(filter.custom){ 
                                                    setPage(1)
                                                    loadReportedEmails()
                                                    }
                                                 }} >Search</Button>
                                            </Box> : ''}
                                        
                                       </Box>
                                        </Popover>
                            </Box>
                                <FormControl sx={{ minWidth: 100, textAlign:'center' }} size="small">
                                        <Select
                                         className={`${styles.btn} ${styles.btnPrimaryDrop}`}
                                            labelId="demo-simple-select-autowidth-label"
                                            id="demo-simple-select-autowidth"
                                            value={limit}
                                            onChange={e => setLimit(e.target.value)}
                                            autoWidth
                                            displayEmpty
                                            sx={{ boxShadow: 'none', '.MuiOutlinedInput-notchedOutline': { borderRadius: '0px', border: '1px solid #f8f8f8', paddginLeft: '20px' } }}
                                        >
                                            <MenuItem value="10">10 </MenuItem>
                                            <MenuItem value="25">25 </MenuItem>
                                            <MenuItem value="50">50 </MenuItem>
                                            <MenuItem value="100">100 </MenuItem>
                                        </Select>
                                    </FormControl>
                         </Box>
                        </Grid>

                        
                    </Grid>
                </Box>
              
                <Box className={styles.contentbarWrap}>

                <Box>
                    <Grid container>
                        <Grid xs={12}>
                            <Box className={styles.infoContainer}>
                                <IoInformation className={styles.infoIcon}/>These emails have exceeded the reporting threshold limit. You may broadcast them for awareness. Your current threshold limit is min {broadcastThreshold} reporters.
                            </Box>
                        </Grid>
                    </Grid>
                </Box>

                    <TableContainer className={styles.tableContainer}>
                        <Table sx={{ minWidth: 650 }} aria-label="simple table" className={styles.ReportedMailTable}>
                            <TableHead className={styles.thead_background}>
                                <TableRow className={styles.broadcastTable}>
                                <TableCell sx={{width:"0%"}} className={styles.checkBox}>
                                     <FormGroup> 
                                        <FormControlLabel sx={{marginLeft: "0", }}
                                            control={
                                            <Checkbox 
                                                    key={`allMails`}
                                                    checked={selectAllMails}
                                                    size="small"
                                            />}
                                            name='SelectAll'
                                            onClick={(e) => {
                                                if(!selectAllMails) {
                                                    setSelectedMails([...selectedMails, ...reportedMails.map((mail)=>mail._id)])
                                                    setSelectAllMails(true)
                                                }
                                                else{
                                                    let reportedMailsId = reportedMails.map((email)=> email._id)
                                                    setSelectedMails(selectedMails.filter(id => !reportedMailsId.includes(id)))
                                                    setSelectAllMails(false)
                                                }
                                            }}
                                            size="small"
                                        />
                                        </FormGroup>
                                </TableCell>
                                    <TableCell className={styles.td1} >Sender</TableCell>
                                    <TableCell className={styles.td2}>Subject</TableCell>
                                    <TableCell className={styles.td3}>Type</TableCell>
                                    <TableCell className={styles.td4}>Reporters</TableCell>
                                    <TableCell className={styles.td5}>Reported Time</TableCell>
                                    <TableCell className={styles.td6}>Action</TableCell>

                                </TableRow>
                            </TableHead>
                            {reportedMails && reportedMails.length > 0 &&
                                <TableBody className={styles.reportedMail}>
                                    {reportedMails.map((data, index) => (
                                        <TableRow key={index} sx={{ '&:last-child td, &:last-child th': { border: 0 } }} onClick={isLite ? openLiteModal :()=>reportedMail(data._id, data.mailType)}>
                                            <TableCell className={styles.checkBox}>
                                            <FormGroup className={styles.hideSpan}> 
                                                <FormControlLabel
                                                        control={
                                                            <Checkbox 
                                                                key={`${data._id}`}
                                                                checked={selectedMails.includes(data._id)}
                                                                size="small"
                                                            />}
                                                        name={`${data._id}`}
                                                        onClick={(e) => {
                                                            e.stopPropagation()
                                                            setSelectAllMails(false)
                                                            if(selectedMails.includes(data._id)) setSelectedMails(selectedMails.filter((id)=> id !== data._id))
                                                            else setSelectedMails([...selectedMails, data._id])
                                                        }}
                                                        size="small"
                                                    />
                                                </FormGroup>
                                            </TableCell>

                                            <TableCell component="td" scope="row">
                                                <Typography component="p"><b className={styles.reportName}>{data.fromName && data.fromName}</b></Typography>
                                                <Typography component="p"> {` ${data.from}`}</Typography>
                                            </TableCell>

                                            <TableCell component="td" scope="row">{data && data.subject && data.subject.slice(0, 50) + "..."}</TableCell>
                                            <TableCell component="td" scope="row">{data.mailType}</TableCell>
                                            <TableCell component="td" scope="row" sx={{textAlign: "center", fontWeight:"700" }}>{data.reporters.length+1}</TableCell>
                                            <TableCell component="td" scope="row">
                                                <Box className={styles.mddelete}>
                                                    <Typography component="p">{getDate(data.createdAt)}</Typography>
                                                </Box>
                                            </TableCell>
                                            
                                            <TableCell component="td" scope="row">
                                                

                                                <Box className={styles.brdButton} onClick={(e)=>{
                                                        e.stopPropagation()
                                                        broadcastSingleMail(data._id)
                                                     }}>
                                                <TfiAnnouncement/>
                                            
                                                </Box>
                                            </TableCell>
                                            
                                        </TableRow>
                                    ))}
                                </TableBody>
                            }
                        </Table>
                        {reportedMails && reportedMails.length > 0?
                        <Pagination
                            count={count}
                            page={page}
                            limit={limit}
                            handlePageChange={handlePageChange}
                        ></Pagination>:
                        <>{ !loader?
                                <Box className={styles.noRecordMail}>
                                    <Typography component="p">No Records Found!</Typography>
                                </Box>:
                                <Box className={styles.noRecordMail}>
                                    <Typography component="p" style={{color: "green"}}>Loading...</Typography>
                                </Box>
                            }
                        </>
                    }
                    </TableContainer>
                </Box>
                {/* { loader && <Loader />} */}
				<ModalCommon open={showLiteModal} onClick={closeLiteModal}  />

            </Box>
        {/* <ToastContainer /> */}
        </Box> 
    ) 
}