import swal from "sweetalert";
import * as React from "react";
import { useRouter } from "next/router";
import {
  Box,
  Grid,
  Modal,
  TextField,
  Tooltip,
  Typography,
  MenuItem,
  Select,
  FormControl,
  Button,
  TableRow,
  TableHead,
  TableContainer,
  TableCell,
  FormGroup,
  FormControlLabel,
  TableBody,
  Table,
  Switch,
  IconButton,
  Menu,
} from "@mui/material";
import { IoSearchOutline } from "react-icons/io5";
import PopupState, { bindTrigger, bindMenu } from "material-ui-popup-state";

import {
  IoAdd,
  IoCheckmarkOutline,
  IoCloseSharp,
  IoSyncSharp,
} from "react-icons/io5";
import { toast } from "react-toastify";

import { SiGmail } from "react-icons/si";
import { FaMicrosoft } from "react-icons/fa";
import CloseSharpIcon from "@mui/icons-material/CloseSharp";
import Radio from "@mui/material/Radio";
import RadioGroup from "@mui/material/RadioGroup";
import api from "../../utils/api";
import routes from "../../utils/routes";
import { apiError } from "../../utils/error";
import styles from "../../styles/home.module.scss";
import Loader from "../../components/loader/loader";
import AddCredentialOutlook from "../../components/add-new-domain/AddCredentialOutlook";
import AddCredentialGsuite from "../../components/add-new-domain/AddCredentialGsuite";
import { AppContext } from "../../components/appcontext";
import { TfiCalendar } from "react-icons/tfi";
import Checkbox from "@mui/material/Checkbox";
import { CleaningServices } from "@mui/icons-material";
import { checkIsTacEnabled } from "../../utils/common";

const timezones = [
  "Africa/Abidjan",
  "Africa/Accra",
  "Africa/Addis_Ababa",
  "Africa/Algiers",
  "Africa/Asmara",
  "Africa/Asmera",
  "Africa/Bamako",
  "Africa/Bangui",
  "Africa/Banjul",
  "Africa/Bissau",
  "Africa/Blantyre",
  "Africa/Brazzaville",
  "Africa/Bujumbura",
  "Africa/Cairo",
  "Africa/Casablanca",
  "Africa/Ceuta",
  "Africa/Conakry",
  "Africa/Dakar",
  "Africa/Dar_es_Salaam",
  "Africa/Djibouti",
  "Africa/Douala",
  "Africa/El_Aaiun",
  "Africa/Freetown",
  "Africa/Gaborone",
  "Africa/Harare",
  "Africa/Johannesburg",
  "Africa/Juba",
  "Africa/Kampala",
  "Africa/Khartoum",
  "Africa/Kigali",
  "Africa/Kinshasa",
  "Africa/Lagos",
  "Africa/Libreville",
  "Africa/Lome",
  "Africa/Luanda",
  "Africa/Lubumbashi",
  "Africa/Lusaka",
  "Africa/Malabo",
  "Africa/Maputo",
  "Africa/Maseru",
  "Africa/Mbabane",
  "Africa/Mogadishu",
  "Africa/Monrovia",
  "Africa/Nairobi",
  "Africa/Ndjamena",
  "Africa/Niamey",
  "Africa/Nouakchott",
  "Africa/Ouagadougou",
  "Africa/Porto-Novo",
  "Africa/Sao_Tome",
  "Africa/Timbuktu",
  "Africa/Tripoli",
  "Africa/Tunis",
  "Africa/Windhoek",
  "America/Adak",
  "America/Anchorage",
  "America/Anguilla",
  "America/Antigua",
  "America/Araguaina",
  "America/Argentina/Buenos_Aires",
  "America/Argentina/Catamarca",
  "America/Argentina/ComodRivadavia",
  "America/Argentina/Cordoba",
  "America/Argentina/Jujuy",
  "America/Argentina/La_Rioja",
  "America/Argentina/Mendoza",
  "America/Argentina/Rio_Gallegos",
  "America/Argentina/Salta",
  "America/Argentina/San_Juan",
  "America/Argentina/San_Luis",
  "America/Argentina/Tucuman",
  "America/Argentina/Ushuaia",
  "America/Aruba",
  "America/Asuncion",
  "America/Atikokan",
  "America/Atka",
  "America/Bahia",
  "America/Bahia_Banderas",
  "America/Barbados",
  "America/Belem",
  "America/Belize",
  "America/Blanc-Sablon",
  "America/Boa_Vista",
  "America/Bogota",
  "America/Boise",
  "America/Buenos_Aires",
  "America/Cambridge_Bay",
  "America/Campo_Grande",
  "America/Cancun",
  "America/Caracas",
  "America/Catamarca",
  "America/Cayenne",
  "America/Cayman",
  "America/Chicago",
  "America/Chihuahua",
  "America/Ciudad_Juarez",
  "America/Coral_Harbour",
  "America/Cordoba",
  "America/Costa_Rica",
  "America/Creston",
  "America/Cuiaba",
  "America/Curacao",
  "America/Danmarkshavn",
  "America/Dawson",
  "America/Dawson_Creek",
  "America/Denver",
  "America/Detroit",
  "America/Dominica",
  "America/Edmonton",
  "America/Eirunepe",
  "America/El_Salvador",
  "America/Ensenada",
  "America/Fort_Nelson",
  "America/Fort_Wayne",
  "America/Fortaleza",
  "America/Glace_Bay",
  "America/Godthab",
  "America/Goose_Bay",
  "America/Grand_Turk",
  "America/Grenada",
  "America/Guadeloupe",
  "America/Guatemala",
  "America/Guayaquil",
  "America/Guyana",
  "America/Halifax",
  "America/Havana",
  "America/Hermosillo",
  "America/Indiana/Indianapolis",
  "America/Indiana/Knox",
  "America/Indiana/Marengo",
  "America/Indiana/Petersburg",
  "America/Indiana/Tell_City",
  "America/Indiana/Vevay",
  "America/Indiana/Vincennes",
  "America/Indiana/Winamac",
  "America/Indianapolis",
  "America/Inuvik",
  "America/Iqaluit",
  "America/Jamaica",
  "America/Jujuy",
  "America/Juneau",
  "America/Kentucky/Louisville",
  "America/Kentucky/Monticello",
  "America/Knox_IN",
  "America/Kralendijk",
  "America/La_Paz",
  "America/Lima",
  "America/Los_Angeles",
  "America/Louisville",
  "America/Lower_Princes",
  "America/Maceio",
  "America/Managua",
  "America/Manaus",
  "America/Marigot",
  "America/Martinique",
  "America/Matamoros",
  "America/Mazatlan",
  "America/Mendoza",
  "America/Menominee",
  "America/Merida",
  "America/Metlakatla",
  "America/Mexico_City",
  "America/Miquelon",
  "America/Moncton",
  "America/Monterrey",
  "America/Montevideo",
  "America/Montreal",
  "America/Montserrat",
  "America/Nassau",
  "America/New_York",
  "America/Nipigon",
  "America/Nome",
  "America/Noronha",
  "America/North_Dakota/Beulah",
  "America/North_Dakota/Center",
  "America/North_Dakota/New_Salem",
  "America/Nuuk",
  "America/Ojinaga",
  "America/Panama",
  "America/Pangnirtung",
  "America/Paramaribo",
  "America/Phoenix",
  "America/Port-au-Prince",
  "America/Port_of_Spain",
  "America/Porto_Acre",
  "America/Porto_Velho",
  "America/Puerto_Rico",
  "America/Punta_Arenas",
  "America/Rainy_River",
  "America/Rankin_Inlet",
  "America/Recife",
  "America/Regina",
  "America/Resolute",
  "America/Rio_Branco",
  "America/Rosario",
  "America/Santa_Isabel",
  "America/Santarem",
  "America/Santiago",
  "America/Santo_Domingo",
  "America/Sao_Paulo",
  "America/Scoresbysund",
  "America/Shiprock",
  "America/Sitka",
  "America/St_Barthelemy",
  "America/St_Johns",
  "America/St_Kitts",
  "America/St_Lucia",
  "America/St_Thomas",
  "America/St_Vincent",
  "America/Swift_Current",
  "America/Tegucigalpa",
  "America/Thule",
  "America/Thunder_Bay",
  "America/Tijuana",
  "America/Toronto",
  "America/Tortola",
  "America/Vancouver",
  "America/Virgin",
  "America/Whitehorse",
  "America/Winnipeg",
  "America/Yakutat",
  "America/Yellowknife",
  "Antarctica/Casey",
  "Antarctica/Davis",
  "Antarctica/DumontDUrville",
  "Antarctica/Macquarie",
  "Antarctica/Mawson",
  "Antarctica/McMurdo",
  "Antarctica/Palmer",
  "Antarctica/Rothera",
  "Antarctica/South_Pole",
  "Antarctica/Syowa",
  "Antarctica/Troll",
  "Antarctica/Vostok",
  "Arctic/Longyearbyen",
  "Asia/Aden",
  "Asia/Almaty",
  "Asia/Amman",
  "Asia/Anadyr",
  "Asia/Aqtau",
  "Asia/Aqtobe",
  "Asia/Ashgabat",
  "Asia/Ashkhabad",
  "Asia/Atyrau",
  "Asia/Baghdad",
  "Asia/Bahrain",
  "Asia/Baku",
  "Asia/Bangkok",
  "Asia/Barnaul",
  "Asia/Beirut",
  "Asia/Bishkek",
  "Asia/Brunei",
  "Asia/Calcutta",
  "Asia/Chita",
  "Asia/Choibalsan",
  "Asia/Chongqing",
  "Asia/Chungking",
  "Asia/Colombo",
  "Asia/Dacca",
  "Asia/Damascus",
  "Asia/Dhaka",
  "Asia/Dili",
  "Asia/Dubai",
  "Asia/Dushanbe",
  "Asia/Famagusta",
  "Asia/Gaza",
  "Asia/Harbin",
  "Asia/Hebron",
  "Asia/Ho_Chi_Minh",
  "Asia/Hong_Kong",
  "Asia/Hovd",
  "Asia/Irkutsk",
  "Asia/Istanbul",
  "Asia/Jakarta",
  "Asia/Jayapura",
  "Asia/Jerusalem",
  "Asia/Kabul",
  "Asia/Kamchatka",
  "Asia/Karachi",
  "Asia/Kashgar",
  "Asia/Kathmandu",
  "Asia/Katmandu",
  "Asia/Khandyga",
  "Asia/Kolkata",
  "Asia/Krasnoyarsk",
  "Asia/Kuala_Lumpur",
  "Asia/Kuching",
  "Asia/Kuwait",
  "Asia/Macao",
  "Asia/Macau",
  "Asia/Magadan",
  "Asia/Makassar",
  "Asia/Manila",
  "Asia/Muscat",
  "Asia/Nicosia",
  "Asia/Novokuznetsk",
  "Asia/Novosibirsk",
  "Asia/Omsk",
  "Asia/Oral",
  "Asia/Phnom_Penh",
  "Asia/Pontianak",
  "Asia/Pyongyang",
  "Asia/Qatar",
  "Asia/Qostanay",
  "Asia/Qyzylorda",
  "Asia/Rangoon",
  "Asia/Riyadh",
  "Asia/Saigon",
  "Asia/Sakhalin",
  "Asia/Samarkand",
  "Asia/Seoul",
  "Asia/Shanghai",
  "Asia/Singapore",
  "Asia/Srednekolymsk",
  "Asia/Taipei",
  "Asia/Tashkent",
  "Asia/Tbilisi",
  "Asia/Tehran",
  "Asia/Tel_Aviv",
  "Asia/Thimbu",
  "Asia/Thimphu",
  "Asia/Tokyo",
  "Asia/Tomsk",
  "Asia/Ujung_Pandang",
  "Asia/Ulaanbaatar",
  "Asia/Ulan_Bator",
  "Asia/Urumqi",
  "Asia/Ust-Nera",
  "Asia/Vientiane",
  "Asia/Vladivostok",
  "Asia/Yakutsk",
  "Asia/Yangon",
  "Asia/Yekaterinburg",
  "Asia/Yerevan",
  "Atlantic/Azores",
  "Atlantic/Bermuda",
  "Atlantic/Canary",
  "Atlantic/Cape_Verde",
  "Atlantic/Faeroe",
  "Atlantic/Faroe",
  "Atlantic/Jan_Mayen",
  "Atlantic/Madeira",
  "Atlantic/Reykjavik",
  "Atlantic/South_Georgia",
  "Atlantic/St_Helena",
  "Atlantic/Stanley",
  "Australia/ACT",
  "Australia/Adelaide",
  "Australia/Brisbane",
  "Australia/Broken_Hill",
  "Australia/Canberra",
  "Australia/Currie",
  "Australia/Darwin",
  "Australia/Eucla",
  "Australia/Hobart",
  "Australia/LHI",
  "Australia/Lindeman",
  "Australia/Lord_Howe",
  "Australia/Melbourne",
  "Australia/North",
  "Australia/NSW",
  "Australia/Perth",
  "Australia/Queensland",
  "Australia/South",
  "Australia/Sydney",
  "Australia/Tasmania",
  "Australia/Victoria",
  "Australia/West",
  "Australia/Yancowinna",
  "Brazil/Acre",
  "Brazil/DeNoronha",
  "Brazil/East",
  "Brazil/West",
  "Canada/Atlantic",
  "Canada/Central",
  "Canada/Eastern",
  "Canada/Mountain",
  "Canada/Newfoundland",
  "Canada/Pacific",
  "Canada/Saskatchewan",
  "Canada/Yukon",
  "CET",
  "Chile/Continental",
  "Chile/EasterIsland",
  "CST6CDT",
  "Cuba",
  "EET",
  "Egypt",
  "Eire",
  "EST",
  "EST5EDT",
  "Etc/GMT",
  "Etc/GMT+0",
  "Etc/GMT+1",
  "Etc/GMT+10",
  "Etc/GMT+11",
  "Etc/GMT+12",
  "Etc/GMT+2",
  "Etc/GMT+3",
  "Etc/GMT+4",
  "Etc/GMT+5",
  "Etc/GMT+6",
  "Etc/GMT+7",
  "Etc/GMT+8",
  "Etc/GMT+9",
  "Etc/GMT-0",
  "Etc/GMT-1",
  "Etc/GMT-10",
  "Etc/GMT-11",
  "Etc/GMT-12",
  "Etc/GMT-13",
  "Etc/GMT-14",
  "Etc/GMT-2",
  "Etc/GMT-3",
  "Etc/GMT-4",
  "Etc/GMT-5",
  "Etc/GMT-6",
  "Etc/GMT-7",
  "Etc/GMT-8",
  "Etc/GMT-9",
  "Etc/GMT0",
  "Etc/Greenwich",
  "Etc/UCT",
  "Etc/Universal",
  "Etc/UTC",
  "Etc/Zulu",
  "Europe/Amsterdam",
  "Europe/Andorra",
  "Europe/Astrakhan",
  "Europe/Athens",
  "Europe/Belfast",
  "Europe/Belgrade",
  "Europe/Berlin",
  "Europe/Bratislava",
  "Europe/Brussels",
  "Europe/Bucharest",
  "Europe/Budapest",
  "Europe/Busingen",
  "Europe/Chisinau",
  "Europe/Copenhagen",
  "Europe/Dublin",
  "Europe/Gibraltar",
  "Europe/Guernsey",
  "Europe/Helsinki",
  "Europe/Isle_of_Man",
  "Europe/Istanbul",
  "Europe/Jersey",
  "Europe/Kaliningrad",
  "Europe/Kiev",
  "Europe/Kirov",
  "Europe/Kyiv",
  "Europe/Lisbon",
  "Europe/Ljubljana",
  "Europe/London",
  "Europe/Luxembourg",
  "Europe/Madrid",
  "Europe/Malta",
  "Europe/Mariehamn",
  "Europe/Minsk",
  "Europe/Monaco",
  "Europe/Moscow",
  "Europe/Nicosia",
  "Europe/Oslo",
  "Europe/Paris",
  "Europe/Podgorica",
  "Europe/Prague",
  "Europe/Riga",
  "Europe/Rome",
  "Europe/Samara",
  "Europe/San_Marino",
  "Europe/Sarajevo",
  "Europe/Saratov",
  "Europe/Simferopol",
  "Europe/Skopje",
  "Europe/Sofia",
  "Europe/Stockholm",
  "Europe/Tallinn",
  "Europe/Tirane",
  "Europe/Tiraspol",
  "Europe/Ulyanovsk",
  "Europe/Uzhgorod",
  "Europe/Vaduz",
  "Europe/Vatican",
  "Europe/Vienna",
  "Europe/Vilnius",
  "Europe/Volgograd",
  "Europe/Warsaw",
  "Europe/Zagreb",
  "Europe/Zaporozhye",
  "Europe/Zurich",
  "Factory",
  "GB",
  "GB-Eire",
  "GMT",
  "GMT+0",
  "GMT-0",
  "GMT0",
  "Greenwich",
  "Hongkong",
  "HST",
  "Iceland",
  "Indian/Antananarivo",
  "Indian/Chagos",
  "Indian/Christmas",
  "Indian/Cocos",
  "Indian/Comoro",
  "Indian/Kerguelen",
  "Indian/Mahe",
  "Indian/Maldives",
  "Indian/Mauritius",
  "Indian/Mayotte",
  "Indian/Reunion",
  "Iran",
  "Israel",
  "Jamaica",
  "Japan",
  "Kwajalein",
  "Libya",
  "MET",
  "Mexico/BajaNorte",
  "Mexico/BajaSur",
  "Mexico/General",
  "MST",
  "MST7MDT",
  "Navajo",
  "NZ",
  "NZ-CHAT",
  "Pacific/Apia",
  "Pacific/Auckland",
  "Pacific/Bougainville",
  "Pacific/Chatham",
  "Pacific/Chuuk",
  "Pacific/Easter",
  "Pacific/Efate",
  "Pacific/Enderbury",
  "Pacific/Fakaofo",
  "Pacific/Fiji",
  "Pacific/Funafuti",
  "Pacific/Galapagos",
  "Pacific/Gambier",
  "Pacific/Guadalcanal",
  "Pacific/Guam",
  "Pacific/Honolulu",
  "Pacific/Johnston",
  "Pacific/Kanton",
  "Pacific/Kiritimati",
  "Pacific/Kosrae",
  "Pacific/Kwajalein",
  "Pacific/Majuro",
  "Pacific/Marquesas",
  "Pacific/Midway",
  "Pacific/Nauru",
  "Pacific/Niue",
  "Pacific/Norfolk",
  "Pacific/Noumea",
  "Pacific/Pago_Pago",
  "Pacific/Palau",
  "Pacific/Pitcairn",
  "Pacific/Pohnpei",
  "Pacific/Ponape",
  "Pacific/Port_Moresby",
  "Pacific/Rarotonga",
  "Pacific/Saipan",
  "Pacific/Samoa",
  "Pacific/Tahiti",
  "Pacific/Tarawa",
  "Pacific/Tongatapu",
  "Pacific/Truk",
  "Pacific/Wake",
  "Pacific/Wallis",
  "Pacific/Yap",
  "Poland",
  "Portugal",
  "PRC",
  "PST8PDT",
  "ROC",
  "ROK",
  "Singapore",
  "Turkey",
  "UCT",
  "Universal",
  "US/Alaska",
  "US/Aleutian",
  "US/Arizona",
  "US/Central",
  "US/East-Indiana",
  "US/Eastern",
  "US/Hawaii",
  "US/Indiana-Starke",
  "US/Michigan",
  "US/Mountain",
  "US/Pacific",
  "US/Samoa",
  "UTC",
  "W-SU",
  "WET",
  "Zul",
];

export default function Domain() {
  const router = useRouter();
  const { query } = router;
  const isTacEnabled = checkIsTacEnabled()
  const [domainStatus, setDomainStatus] = React.useState("-1");
  const [value, onChange] = React.useState("10:00");
  const [openModal, setOpen] = React.useState(false);
  const [setopenModal, setnowOpen] = React.useState(false);
  // const [domainModalType, setDomainModalType] = React.useState(false);
  const [domainName, setDomainName] = React.useState("");
  const [loader, setLoader] = React.useState(false);
  const [domainData, setDomainData] = React.useState([]);
  const [domainData_1, setDomainData_1] = React.useState([]);

  const [copySuccess, setCopySuccess] = React.useState("");
  const [openCron, setOpenCron] = React.useState(false);
  const handleOpen = () => setOpen(true);
  const handleClose = () => setOpen(false);
  const [selectedTime, setSelectedTime] = React.useState("12:00"); // State to manage the selected time
  const [userCron, setUserCron] = React.useState({
    isActive: false,
    days: [],
    hour: "12",
    minute: "00",
    timeZone: "Asia/Kolkata",
  });
  const [timeZone, setTimeZone] = React.useState("");

  const handleChange = (event) => {
    setTimeZone(event.target.value);
  };

  const [idForCronModal, setIdForCronModal] = React.useState("");

  const sethandleOpen = () => setnowOpen(true);
  // const handleCloseAddDomain = () => setDomainModalType(false);
  const [anchorEl, setAnchorEl] = React.useState(null);
  const [donainCheck, setDomailCheck] = React.useState(false);

  const open = Boolean(anchorEl);

  const { domains, setDomains, setDomainChange } = React.useContext(AppContext);
  const handleTimeChange = (e) => {
    let time = e.target.value.split(":");
    setUserCron({ ...userCron, hour: time[0], minute: time[1] });
  };

  const [modalDomainID, setModalDomainID] = React.useState("");
  const [outlookCredentialModal, setOutlookCredentialModal] =
    React.useState(false);
  const [gsuiteCredentialModal, setGsuiteCredentialModal] =
    React.useState(false);

  const handleCloseOutlookModal = () => {
    setOutlookCredentialModal(false);
    setModalDomainID("");
  };
  const handleCloseGsuiteModal = () => {
    setGsuiteCredentialModal(false);
    setModalDomainID("");
  };

  const resetCron = () => {
    setUserCron({
      ...userCron,
      isActive: false,
      days: [],
      hour: "12",
      minute: "00",
    });
  };

  const handleDomainStatus = (event) => {
    setDomainStatus(event.target.value);
    if (event.target.value == "-1") {
      setDomainData(domainData_1);
    } else {
      if (event.target.value == "1") {
        let domains = domainData_1.filter((domain) => {
          if (domain.isVerified) return true;
        });
        setDomainData(domains);
      } else {
        let domains = domainData_1.filter((domain) => {
          if (!domain.isVerified) return true;
        });
        setDomainData(domains);
      }
    }
  };
  const [domainTypeForOutlook, setDomainTypeForOutlook] =
    React.useState("OFFICE365");

  const enableDomainTypeModal = () => {
    setOpen(false);
    router.push(`domains/create/${domainName}/${domainTypeForOutlook}`);
  };

  const [getDomainType, setDomainType] = React.useState({
    gsuite: false,
    outlook: false,
    enableDomainType: false,
  });
  const [addDomainModalData, setAddDomainModalData] = React.useState({
    domainName: "",
    domainType: "",
  });
  // const addDomainHandle = (e) =>{
  //     setAddDomainModalData({ ...addDomainModalData, [e.target.name]: e.target.value });
  // }

  const domainType = (type) => {
    setDomainName(type);
    getDomainType.enableDomainType = true;
    if (type === "Gsuite") {
      setDomainType({ ...getDomainType, gsuite: true, outlook: false });
      setDomainTypeForOutlook(null);
      setDomailCheck(false);
    } else if (type === "Outlook") {
      setDomainType({ ...getDomainType, outlook: true, gsuite: false });
      setDomainTypeForOutlook("OFFICE365");
      setDomailCheck(true);
    }
  };

  // const addDomain = () => {
  //     const {domainName } = addDomainModalData;
  //     api.post(routes.DOMAIN.CREATE, {
  //         domainName, domainType: getDomainType.gsuite ? 'Gsuite': 'Outlook'
  //     })
  //     .then(res => res.data)
  //     .then(data => {
  //         loadDomainList();
  //         handleCloseAddDomain();
  //         router.push(`/domains/${data.domainId}`)
  //     })
  //     .catch(err => {
  //         apiError(err);
  //     })
  // }

  // const addNewDomain = (DomainId,type) => {
  //     if(type == 'Outlook'){
  //         setOutlookCredentialModal(true)
  //         setModalDomainID(DomainId)
  //     }
  //     else{
  //         setGsuiteCredentialModal(true)
  //         setModalDomainID(DomainId)
  //     }
  // }

  const loadDomainList = () => {
    setLoader(true);
    const { id } = router.query;
    api
      .get(routes.DOMAIN.DOMAIN_LIST, {
        params: {
          reportedMailId: id,
        },
      })
      .then((res) => res.data)
      .then((data) => {
        setLoader(false);
        setDomainData(data.domains);
        setDomainData_1(data.domains);
      })
      .catch((err) => {
        setLoader(false);
        apiError(err);
      });
  };

  const syncUsers = (domainId, groups) => {
    api
      .post(routes.USERS.SYNC, {
        groups: groups.length > 0 ? groups : null,
        domainId,
      })
      .then((res) => res.data)
      .then((data) => {
        toast.success(data.message);
        loadDomainList();
      })
      .catch((err) => {
        apiError(err);
      });
  };

  const deleteDomainSwal = async (domainId) => {
    const willDelete = await swal({
      title: "Are you sure?",
      text: "Are you sure you want to Delete this Domain?",
      icon: "warning",
      dangerMode: true,
      closeOnEsc: true,
      buttons: {
        cancel: true,
        confirm: true,
      },
    });

    console.log({ willDelete });
    if (willDelete) {
      deleteDomain(domainId);
    }
  };

  const deleteDomain = (domainId) => {
    api
      .delete(routes.DOMAIN.DELETE, {
        params: {
          domainId,
        },
      })
      .then((res) => res.data)
      .then((data) => {
        console.log("Domain deleted....");
        setDomains("");
        setDomainChange((prevState) => !prevState);
        swal("Deleted!", "Your domain has been deleted!", "success", {
          buttons: false,
          timer: 1000,
        });
        loadDomainList();
      })
      .catch((err) => {
        if (err.response.status == 403) apiError(err);
        else
          swal("Some error occured!", "Error Deleting Domain!", "error", {
            buttons: false,
            timer: 1000,
          });
      });
  };

  const updateCron = () => {
    let { isActive, days, hour, minute, timeZone } = userCron;

    if (isActive && days.length == 0)
      toast.error("Kindly select days on which you would like to sync user!");
    else if (!isActive && days.length != 0)
      toast.error("Kindly toggle active to schedule syncing!");
    else {
      api
        .post(routes.DOMAIN.UPDATE_CRON, {
          domainId: idForCronModal,
          isActive,
          days,
          hour,
          minute,
          timeZone,
        })
        .then(() => {
          if (!isActive || days.length == 0)
            toast.success("User sync scheduling turned off!");
          else toast.success("User syncing scheduled successfully!");
          setOpenCron(false);
          resetCron();
          loadDomainList();
        })
        .catch((err) => {
          apiError(err);
        });
    }
  };

  const handleTimeZoneChange = (e) => {
    console.log(e.target.value);
    setUserCron({ ...userCron, timeZone: e.target.value });
  };

  React.useEffect(() => {
    loadDomainList();
  }, []);

  React.useEffect(() => {
    const timeZone = Intl.DateTimeFormat().resolvedOptions().timeZone;
    setUserCron({ ...userCron, timeZone });
  }, []);

   React.useEffect(() => {
        if(query.success){
          toast.success(query.message);
        }
      }, [query]);

  return (
    <Box className={styles.contentbar}>
      <Box className={styles.containerbar}>
        <Box className={styles.breadcrumbBar}>
          <Grid
            container
            direction="row"
            justifyContent="center"
            alignItems="center"
          >
            <Grid item xs={4}>
              <Typography
                component="h4"
                variant="h4"
                className={styles.page_title}
              >
                Domains
              </Typography>
            </Grid>
            <Grid item xs={8} align="right">
              <Box className={styles.flex_btn}>
              {isTacEnabled ?
                (<Button
                  variant="contained"
                  className={`${styles.btn} ${styles.btnPrimary}`}
                  onClick={()=> router.push(`${process.env.NEXT_PUBLIC_TAC_URL}/directory/domain`)}
                >
                  <IoAdd className={styles.icon_position} /> Add Domain{" "}
                </Button>) :
                (<Button
                  variant="contained"
                  className={`${styles.btn} ${styles.btnPrimary}`}
                  onClick={handleOpen}
                >
                  <IoAdd className={styles.icon_position} /> Add Domain{" "}
                </Button>)
              }
              </Box>
            </Grid>
          </Grid>
        </Box>
        <Box className={styles.filterWrapper}>
  <Grid
    container
    direction="row"
    justifyContent="space-between"
    alignItems="center"
  >
    <Grid item md={8}>
      <Box className={styles.filterSearchBar} style={{position:"relative"}}>
        {/* <TextField
          className={styles.searchBar}
          placeholder="Search"
          size="small"
          fullWidth
          value={"search"}
                  onChange={e => {
                    domain
          }}
        /> */}
        {/* <Typography component="span" className={styles.search_icon}>
          <IoSearchOutline />{" "}
        </Typography> */}
      </Box>
    </Grid>
    <Grid item md={4} style={{ display: "flex", justifyContent: "flex-end" }}>
      <Box>
        <FormControl>
          <Select
            className={`${styles.btn} ${styles.btnPrimaryDrop}`}
            labelId="demo-simple-select-autowidth-label"
            id="demo-simple-select-autowidth"
            value={domainStatus}
            onChange={handleDomainStatus}
            autoWidth
            displayEmpty
            sx={{
              boxShadow: "none",
              ".MuiOutlinedInput-notchedOutline": {
                borderRadius: "0px",
                paddginLeft: "20px",
              },
            }}
          >
            <MenuItem value="-1" key="-1">
              Status
            </MenuItem>
            <MenuItem value="1" key="1">
              Verified
            </MenuItem>
            <MenuItem value="0" key="0">
              Not Verified
            </MenuItem>
          </Select>
        </FormControl>
      </Box>
    </Grid>
  </Grid>
</Box>




        <Box className={styles.contentbarWrap}>
          <TableContainer
            className={`${styles.tableContainer} ${styles.domainsTable}`}
          >
            <Table aria-label="simple table">
              <TableHead className={styles.thead_background}>
                <TableRow>
                  <TableCell>Domain</TableCell>
                  <TableCell>Mailbox</TableCell>
                  {/* <TableCell sx={{width:'15% !important'}}>TXT value</TableCell> */}
                  {/* <TableCell className={`${styles.ThFour} ${styles.thCenter}`}> Users</TableCell> */}
                  <TableCell className={`${styles.ThSix} ${styles.thCenter}`} >Status</TableCell>
                  <TableCell className={`${styles.ThSix} ${styles.thCenter}`} >Credentials</TableCell>
                  {/* {!isTacEnabled && <TableCell className={`${styles.ThSeven} ${styles.thCenter}`}>Sync Users</TableCell>} */}
                  {/* {!isTacEnabled && <TableCell className={styles.thCenter}>Scheduled Auto Sync</TableCell>} */}
                  <TableCell>Actions</TableCell>
                </TableRow>
              </TableHead>

              <TableBody>
                {domainData.map((data, index) => (
                  <TableRow
                    key={index}
                    sx={{ "&:last-child td, &:last-child th": { border: 0 } }}
                  >
                    <TableCell scope="row">{data.domainName}</TableCell>
                    <TableCell className={styles.tdCap}>
                      {data.domainType == "Outlook"
                        ? `${data.domainTypeForOutlook}`
                        : `${data.domainType}`}{" "}
                    </TableCell>

                    {/* <TableCell sx={{ textAlign: "center", fontWeight: "700" }}>
                      <Box className={styles.userdFlex}>
                        <p>
                          <span
                            className={`${styles.usCircle} ${styles.colorblue}`}
                          ></span>
                          {data.totalUser}
                        </p>
                        <p>
                          <span
                            className={`${styles.usCircle} ${styles.colorgreen}`}
                          ></span>
                          {data.activeUser}
                        </p>
                      </Box>
                    </TableCell> */}
                    <TableCell sx={{ textAlign: "center" }}>
                      {data.isVerified ? (
                        <p className={styles.LinkSafe}>Verified</p>
                      ) : (
                        <p className={styles.LinkDanger}>Not Verified</p>
                      )}
                    </TableCell>
                    <TableCell sx={{ textAlign: "center" }}>
                      {data.isCredential ? (
                        <p className={styles.LinkSafe}>Uploaded</p>
                      ) : (
                        <p className={styles.LinkDanger}>Not Uploaded</p>
                      )}
                    </TableCell>

                    {/* {!isTacEnabled && <TableCell sx={{ textAlign: "center" }}>
                      {data.isVerified && data.isCredential ? (
                        <Tooltip title="Sync" placement="top-start">
                          <IconButton
                            aria-label="Add Crendential"
                            className={`${styles.actionBtn} ${styles.successActionIcon}`}
                            onClick={() => syncUsers(data._id, data.userGroups)}
                          >
                            <IoSyncSharp />
                          </IconButton>
                        </Tooltip>
                      ) : (
                        "-"
                      )}
                    </TableCell>
                    } */}

                    {/* {!isTacEnabled && <TableCell sx={{ textAlign: "center", fontWeight: "700" }}>
                      {data.isCredential ? (
                        <Box className={styles.flex_btn}>
                          <Button
                            variant="contained"
                            className={`${styles.btn} ${styles.btnPrimary}`}
                            onClick={() => {
                              setOpenCron(true);
                              setIdForCronModal(data._id);
                              let domain = domainData.find(
                                (doc) => doc._id === data._id
                              );
                              if (domain.isScheduledSyncing.isActive) {
                                setUserCron({
                                  ...userCron,
                                  hour: domain.isScheduledSyncing.hour,
                                  minute: domain.isScheduledSyncing.minute,
                                  days: domain.isScheduledSyncing.daysOfWeek,
                                  isActive: domain.isScheduledSyncing.isActive,
                                });
                              }
                            }}
                          >
                            <TfiCalendar className={styles.icon_position} /> Set
                            Now{" "}
                          </Button>
                        </Box>
                      ) : (
                        "-"
                      )}
                    </TableCell>} */}

                    { <TableCell className={styles.selectOptions}>
                      <PopupState variant="popover" popupId="demo-popup-menu">
                        {(popupState) => (
                          <React.Fragment>
                            <Button {...bindTrigger(popupState)} className={styles.btndottedSize}>...</Button>
                            <Menu {...bindMenu(popupState)}>
                              <MenuItem
                                onClick={() => {
                                  router.push(`/domains/${data._id}`);
                                }}
                              >
                                Edit
                              </MenuItem>
                              {!isTacEnabled && <MenuItem
                                onClick={() => {
                                  popupState.close();
                                  deleteDomainSwal(data._id);
                                }}
                              >
                                Delete
                              </MenuItem>}
                            </Menu>
                          </React.Fragment>
                        )}
                      </PopupState>
                    </TableCell>}
                  </TableRow>
                ))}
              </TableBody>
            </Table>
          </TableContainer>
        </Box>

        <Modal
          open={openModal}
          onClose={handleClose}
          aria-labelledby="add domain"
          aria-describedby="add domain"
          className={styles.modal}
        >
          <Box className={styles.modalBox}>
            <Box className={styles.modalHeader}>
              <Typography id="modal-modal-title" variant="h6" component="h2">
                Add New Domain
              </Typography>
              <CloseSharpIcon
                className={styles.closeIcon}
                onClick={handleClose}
              />
            </Box>
            <Box className={styles.commonpaddingDomainType}>
              <Typography component="p">
                Select domain type to add new domain
              </Typography>
              <Box className={styles.domain_type}>
                <Box
                  className={
                    getDomainType.gsuite
                      ? styles.active_domain_box
                      : styles.common_domainBox
                  }
                  onClick={() => domainType("Gsuite")}
                >
                  <SiGmail className={styles.SelectDomainIcon} />
                  <Typography
                    variant="h6"
                    style={{ fontSize: "1rem" }}
                    className={
                      getDomainType.gsuite ? styles.color_domain_type : ""
                    }
                  >
                    G-suite{" "}
                    {getDomainType.gsuite ? (
                      <IoCheckmarkOutline
                        style={{ marginLeft: "10px", marginTop: "6px" }}
                      />
                    ) : (
                      ""
                    )}
                  </Typography>
                </Box>
                <Box
                  className={
                    getDomainType.outlook
                      ? styles.active_domain_box
                      : styles.common_domainBox
                  }
                  onClick={() => domainType("Outlook")}
                >
                  <FaMicrosoft className={styles.SelectDomainIcon} />
                  <Typography
                    variant="h6"
                    style={{ fontSize: "1rem" }}
                    className={
                      getDomainType.outlook ? styles.color_domain_type : ""
                    }
                  >
                    {" "}
                    Outlook{" "}
                    {getDomainType.outlook ? (
                      <IoCheckmarkOutline
                        style={{ marginLeft: "10px", marginTop: "6px" }}
                      />
                    ) : (
                      ""
                    )}{" "}
                  </Typography>
                </Box>
              </Box>

              <Box className={styles.MaindomainCheckBox}>
                {donainCheck ? (
                  <Box className={styles.domainCheckBox}>
                    <FormControl>
                      <RadioGroup
                        aria-labelledby="demo-radio-buttons-group-label"
                        defaultValue="Office 365"
                        name="radio-buttons-group"
                      >
                        <FormControlLabel
                          onClick={(e) => setDomainTypeForOutlook("OFFICE365")}
                          value="Office 365"
                          control={<Radio />}
                          label="Office 365"
                        />
                        <FormControlLabel
                          onClick={(e) => setDomainTypeForOutlook("EXCHANGE")}
                          value="Exchange"
                          control={<Radio />}
                          label="Exchange"
                        />
                      </RadioGroup>
                    </FormControl>
                  </Box>
                ) : (
                  ""
                )}
              </Box>

              {getDomainType.enableDomainType && (
                <Box className={styles.domain_enable_btn}>
                  <Button
                    variant="contained"
                    color="success"
                    onClick={() => enableDomainTypeModal("outlook")}
                    className={styles.primaryBtn}
                  >
                    Proceed to Next
                  </Button>
                </Box>
              )}
            </Box>
          </Box>
        </Modal>

        {/* Set Now Modal */}

        <Modal
          open={openCron}
          onClose={() => {
            setOpenCron(false);
            resetCron();
          }}
          aria-labelledby="add domain"
          aria-describedby="add domain"
          className={styles.modal}
        >
          <Box className={styles.modalBox}>
            <Box className={styles.modalHeader}>
              <Typography id="modal-modal-title" variant="h6" component="h2">
                Set Now <br></br>
                <span>Configure your settings</span>
              </Typography>
              <CloseSharpIcon
                className={styles.closeIcon}
                onClick={() => {
                  setOpenCron(false);
                  resetCron();
                }}
              />
            </Box>

            <Box className={`${styles.EpmloyeeModal} ${styles.timePacker}`}>
              <Box className={styles.AddEmployeeModal}>
                <Box sx={{ marginBottom: "14px" }}>
                  Active:
                  <Switch
                    className={styles.SwitchTab}
                    size="small"
                    color="success"
                    checked={userCron && userCron.isActive}
                    onClick={() => {
                      if (userCron.isActive) {
                        setUserCron({
                          ...userCron,
                          isActive: !userCron.isActive,
                          hour: "12",
                          minute: "00",
                          days: [],
                        });
                      } else
                        setUserCron({
                          ...userCron,
                          isActive: !userCron.isActive,
                        });
                    }}
                  />
                </Box>
                {userCron.isActive && (
                  <>
                    <Box className={styles.modalinputField}>
                      <FormControl fullWidth>
                        <label>Select Timezone</label>
                        <Select
                          labelId="demo-simple-select-label"
                          id="demo-simple-select"
                          value={userCron.timeZone}
                          onChange={handleTimeZoneChange}
                          displayEmpty
                          size="small"
                          className="selectTimeZone"
                          sx={{ marginBottom: "14px", fontSize: "14px" }}
                        >
                          <MenuItem value="" disabled>
                            Select Timezone
                          </MenuItem>
                          {timezones.map((timezone, index) => (
                            <MenuItem
                              key={index}
                              value={timezone}
                              sx={{ fontSize: "14px", marginTop: "0.5rem" }}
                            >
                              {timezone}
                            </MenuItem>
                          ))}
                        </Select>
                      </FormControl>
                    </Box>

                    <Box className={styles.modalinputField}>
                      <label>Select Time</label>

                      <TextField
                        className={styles.inputfild}
                        id="time"
                        type="time"
                        value={`${userCron.hour}:${userCron.minute}`}
                        onChange={handleTimeChange}
                        InputLabelProps={{
                          shrink: true,
                        }}
                        inputProps={{
                          step: 300, // 5-minute increments
                        }}
                      />
                    </Box>

                    <Box className={styles.checkBox}>
                      <label
                        sx={{
                          fontWeight: "600",
                          fontSize: "14px",
                          color: " #6c757d",
                        }}
                      >
                        Select Days
                      </label>

                      <Box className={styles.dFlex}>
                        <Box>
                          <FormGroup>
                            <FormControlLabel
                              control={
                                <Checkbox
                                  name="All"
                                  checked={
                                    userCron &&
                                    userCron.days &&
                                    userCron.days.includes("All")
                                  }
                                />
                              }
                              onClick={(e) => {
                                if (userCron.days.includes("All"))
                                  setUserCron((prevState) => ({
                                    ...prevState,
                                    days: [],
                                  }));
                                else
                                  setUserCron((prevState) => ({
                                    ...prevState,
                                    days: [
                                      "All",
                                      "Monday",
                                      "Tuesday",
                                      "Wednesday",
                                      "Thursday",
                                      "Friday",
                                      "Saturday",
                                      "Sunday",
                                    ],
                                  }));
                              }}
                              label="All Days"
                            />
                            <FormControlLabel
                              control={
                                <Checkbox
                                  name="Monday"
                                  checked={
                                    userCron &&
                                    userCron.days &&
                                    userCron.days.includes("Monday")
                                  }
                                />
                              }
                              onClick={(e) => {
                                if (
                                  e.target.name != undefined &&
                                  e.target.name != ""
                                ) {
                                  if (userCron.days.includes("Monday"))
                                    setUserCron({
                                      days: userCron.days.filter(
                                        (day) => day !== e.target.name
                                      ),
                                    });
                                  else
                                    setUserCron((prevState) => ({
                                      ...prevState,
                                      days: [...userCron.days, e.target.name],
                                    }));
                                }
                              }}
                              label="Monday"
                            />
                            <FormControlLabel
                              control={
                                <Checkbox
                                  name="Tuesday"
                                  checked={
                                    userCron &&
                                    userCron.days &&
                                    userCron.days.includes("Tuesday")
                                  }
                                />
                              }
                              onClick={(e) => {
                                if (
                                  e.target.name != undefined &&
                                  e.target.name != ""
                                ) {
                                  if (userCron.days.includes("Tuesday"))
                                    setUserCron((prevState) => ({
                                      ...prevState,
                                      days: userCron.days.filter(
                                        (day) => day !== e.target.name
                                      ),
                                    }));
                                  else
                                    setUserCron((prevState) => ({
                                      ...prevState,
                                      days: [...userCron.days, e.target.name],
                                    }));
                                }
                              }}
                              label="Tuesday"
                            />
                            <FormControlLabel
                              control={
                                <Checkbox
                                  name="Wednesday"
                                  checked={
                                    userCron &&
                                    userCron.days &&
                                    userCron.days.includes("Wednesday")
                                  }
                                />
                              }
                              onClick={(e) => {
                                if (
                                  e.target.name != undefined &&
                                  e.target.name != ""
                                ) {
                                  if (userCron.days.includes("Wednesday"))
                                    setUserCron((prevState) => ({
                                      ...prevState,
                                      days: userCron.days.filter(
                                        (day) => day !== e.target.name
                                      ),
                                    }));
                                  else
                                    setUserCron((prevState) => ({
                                      ...prevState,
                                      days: [...userCron.days, e.target.name],
                                    }));
                                }
                              }}
                              label="Wednesday"
                            />
                          </FormGroup>
                        </Box>

                        <Box>
                          <FormGroup>
                            <FormControlLabel
                              control={
                                <Checkbox
                                  name="Thursday"
                                  checked={
                                    userCron &&
                                    userCron.days &&
                                    userCron.days.includes("Thursday")
                                  }
                                />
                              }
                              onClick={(e) => {
                                if (
                                  e.target.name != undefined &&
                                  e.target.name != ""
                                ) {
                                  if (userCron.days.includes("Thursday"))
                                    setUserCron((prevState) => ({
                                      ...prevState,
                                      days: userCron.days.filter(
                                        (day) => day !== e.target.name
                                      ),
                                    }));
                                  else
                                    setUserCron((prevState) => ({
                                      ...prevState,
                                      days: [...userCron.days, e.target.name],
                                    }));
                                }
                              }}
                              label="Thursday"
                            />
                            <FormControlLabel
                              control={
                                <Checkbox
                                  name="Friday"
                                  checked={
                                    userCron &&
                                    userCron.days &&
                                    userCron.days.includes("Friday")
                                  }
                                />
                              }
                              onClick={(e) => {
                                if (
                                  e.target.name != undefined &&
                                  e.target.name != ""
                                ) {
                                  if (userCron.days.includes("Friday"))
                                    setUserCron((prevState) => ({
                                      ...prevState,
                                      days: userCron.days.filter(
                                        (day) => day !== e.target.name
                                      ),
                                    }));
                                  else
                                    setUserCron((prevState) => ({
                                      ...prevState,
                                      days: [...userCron.days, e.target.name],
                                    }));
                                }
                              }}
                              label="Friday"
                            />
                            <FormControlLabel
                              control={
                                <Checkbox
                                  name="Saturday"
                                  checked={
                                    userCron &&
                                    userCron.days &&
                                    userCron.days.includes("Saturday")
                                  }
                                />
                              }
                              onClick={(e) => {
                                if (
                                  e.target.name != undefined &&
                                  e.target.name != ""
                                ) {
                                  if (userCron.days.includes("Saturday"))
                                    setUserCron((prevState) => ({
                                      ...prevState,
                                      days: userCron.days.filter(
                                        (day) => day !== e.target.name
                                      ),
                                    }));
                                  else
                                    setUserCron((prevState) => ({
                                      ...prevState,
                                      days: [...userCron.days, e.target.name],
                                    }));
                                }
                              }}
                              label="Saturday"
                            />
                            <FormControlLabel
                              control={
                                <Checkbox
                                  name="Sunday"
                                  checked={
                                    userCron &&
                                    userCron.days &&
                                    userCron.days.includes("Sunday")
                                  }
                                />
                              }
                              onClick={(e) => {
                                if (
                                  e.target.name != undefined &&
                                  e.target.name != ""
                                ) {
                                  if (userCron.days.includes("Sunday"))
                                    setUserCron((prevState) => ({
                                      ...prevState,
                                      days: userCron.days.filter(
                                        (day) => day !== e.target.name
                                      ),
                                    }));
                                  else
                                    setUserCron((prevState) => ({
                                      ...prevState,
                                      days: [...userCron.days, e.target.name],
                                    }));
                                }
                              }}
                              label="Sunday"
                            />
                          </FormGroup>
                        </Box>
                      </Box>
                    </Box>
                  </>
                )}

                <Box className={styles.AddBtn}>
                  <button
                    loadingPosition="start"
                    id="employee"
                    variant="contained"
                    className={styles.primaryBtn}
                    sx={{ mb: "30px" }}
                    onClick={updateCron}
                  >
                    Save
                  </button>
                </Box>
              </Box>
            </Box>
          </Box>
        </Modal>
        {/*End Modal  */}

        {loader && <Loader />}
        {outlookCredentialModal && (
          <AddCredentialOutlook
            handleClose={handleCloseOutlookModal}
            open={outlookCredentialModal}
            domainId={modalDomainID}
          />
        )}
        {gsuiteCredentialModal && (
          <AddCredentialGsuite
            handleClose={handleCloseGsuiteModal}
            open={gsuiteCredentialModal}
            domainId={modalDomainID}
          />
        )}
      </Box>
    </Box>
  );
}
