import React, { useState, useRef, useEffect} from "react";
import Cookies from "js-cookie";
import PropTypes from "prop-types";
import { useRouter } from "next/router";
import Link from "next/link";
import { createPortal } from 'react-dom'
import Frame from 'react-frame-component';
import dynamic from "next/dynamic";
import {
  Box,
  Button,
  Typography,
  Grid,
  InputLabel,
  Switch,
  TextField,
  Tab,
  Tabs,
  Modal,
  TableContainer,
  Table,
  TableHead,
  TableRow,
  TableCell,
  TableBody,
} from "@mui/material";
import CloseSharpIcon from "@mui/icons-material/CloseSharp";
import Image from 'next/image';
import { LoadingButton } from "@mui/lab";
import styles from "../styles/editTemplate.module.scss";
import { TfiArrowLeft } from "react-icons/tfi";
import { TfiReload } from "react-icons/tfi";
import Editor from "../components/ckeditor";
import HeaderEditor from '../components/headerckeditor'
import Accordion from '@mui/material/Accordion';
import AccordionSummary from '@mui/material/AccordionSummary';
import AccordionDetails from '@mui/material/AccordionDetails';
import ExpandMoreIcon from '@mui/icons-material/ExpandMore';
import FooterEditor from '../components/footerckediter'
import { SketchPicker, ChromePicker } from 'react-color'
import Radio from '@mui/material/Radio';
import RadioGroup from '@mui/material/RadioGroup';
import FormControlLabel from '@mui/material/FormControlLabel';
import FormControl from '@mui/material/FormControl';



export default function EditTemplates(props) {
    const [headereditorLoaded, setHeaderEditorLoaded] = useState(false);
    const [editorLoaded, setEditorLoaded] = useState(false);
    const [footereditorLoaded, setFooterEditorLoaded] = useState(false);
    const [headerdata, setheaderData] = useState("");
    const [data, setData] = useState("");
    const [file, setFile] = useState("");
    const [footerdata, setFooterData] = useState("");
    const [addBackgroundColor, setBackgroundColor] = useState("");
    const [contentRef, setContentRef] = useState(null)
    const [expanded, setExpanded] = React.useState('panel1');
    const [showUploadimgfirst, setshowUploadimgfirst] = useState(true);
    const [showUploadimg, setshowUploadimg] = useState(false);
  
    const mountNode =
    contentRef?.contentWindow?.document?.body
  
  const handleChange = (panel) => (event, newExpanded) => {
    setExpanded(newExpanded ? panel : false);
  };


  const handleButtonClickFirst = () => {
    setshowUploadimgfirst(true);
    setshowUploadimg(false);
    setFile("")
  };
  const handleButtonClick = () => {
    setshowUploadimg(true);
  };

  const handleChangeColor = (color) =>{
    console.log({color})
    setBackgroundColor(color.hex)
    
  }

  const fileChange = (event) =>{
    var file = event.target.files[0];
    var reader = new FileReader();
    reader.onload = function(event) {
      // The file's text will be printed here
      setFile(event.target.result)
    };
  
    reader.readAsDataURL(file);

  }
  console.log(addBackgroundColor)

  useEffect(() => {
    setHeaderEditorLoaded(true);
    setFooterEditorLoaded(true);
    setEditorLoaded(true);
  }, []);




  return (
    <Box className={styles.contentbar}>
      <Box className={styles.breadcrumbBar}>
        <Grid
          container
          direction="row"
          justifyContent="center"
          alignItems="center"
        >
          <Grid item xs={4}>
            <Typography
              component="h4"
              variant="h4"
              className={styles.page_title}
            >
              Templates Name
            </Typography>
          </Grid>
          <Grid item xs={8} align="right">
            <Button
              variant="contained"
              sx={{ marginRight: "8px" }}
              className={styles.primaryBtn}
            >
              <TfiArrowLeft className={styles.icon_position} />
              Back
            </Button>
            <Button variant="contained" className={styles.primaryBtn}>
              <TfiReload className={styles.icon_position} />
              Update
            </Button>
          </Grid>
        </Grid>
      </Box>

      <Box className={styles.TemplatesSection}>
        <Grid container spacing={1} justifyContent="space-between">
          <Grid item xs={4} md={4}>
            <Box className={styles.tableSection}>
              <TableContainer className={styles.tableContainer}>
                <Table
                  sx={{ minWidth: "400", border: "1px solid #d8d8d8" }}
                  aria-label="simple table"
                  className={styles.ReportedMailTable}
                >
                  <TableHead className={styles.thead_background}>
                    <TableRow>
                      <TableCell>Variable</TableCell>
                      <TableCell className={styles.thCenter}>
                        Key
                      </TableCell>
                    </TableRow>
                  </TableHead>
                  <TableBody className={styles.reportedMail}>
                    <TableRow
                      sx={{ "&:last-child td, &:last-child th": { border: 0 } }}
                    >
                      <TableCell component="td" scope="row">
                        First Name
                      </TableCell>
                      <TableCell
                        component="td"
                        scope="row"
                        className={styles.tdCenter}
                      >
                           <b>{"{{f.name}}"}</b>
                      </TableCell>
                    </TableRow>

                    <TableRow
                      sx={{ "&:last-child td, &:last-child th": { border: 0 } }}
                    >
                      <TableCell component="td" scope="row">
                        Last Name
                      </TableCell>
                      <TableCell
                        component="td"
                        scope="row"
                        className={styles.tdCenter}
                      >
                          <b>{"{{l.name}}"}</b>
                      </TableCell>
                    </TableRow>

                    <TableRow
                      sx={{ "&:last-child td, &:last-child th": { border: 0 } }}
                    >
                      <TableCell component="td" scope="row">
                        Subject
                      </TableCell>
                      <TableCell
                        component="td"
                        scope="row"
                        className={styles.tdCenter}
                      >
                             <b>{"{{subject}}"}</b>
                      </TableCell>
                    </TableRow>


                    <TableRow
                      sx={{ "&:last-child td, &:last-child th": { border: 0 } }}
                    >
                      <TableCell component="td" scope="row">
                        Result
                      </TableCell>
                      <TableCell
                        component="td"
                        scope="row"
                        className={styles.tdCenter}
                      >
                           <b>{"{{result}}"}</b>
                      </TableCell>
                    </TableRow>

                  </TableBody>
                </Table>
              </TableContainer>
            </Box>

       

            <div>

               <Accordion expanded={expanded === 'panel1'} onChange={handleChange('panel1')} className={styles.ckAccordion}>
                  <AccordionSummary aria-controls="panel1d-content" id="panel1d-header"  expandIcon={<ExpandMoreIcon />}>
                    <Typography component="p">Color</Typography>
                  </AccordionSummary>
                  <AccordionDetails>
                    <Box className={styles.cktextEditer}>
                    <SketchPicker 
                     onChange={ handleChangeColor }
                     color={addBackgroundColor}
                    />
                    </Box>
                   
                  </AccordionDetails>
                </Accordion>

                <Accordion className={styles.ckAccordion}>
                  <AccordionSummary aria-controls="panel1d-content" id="panel1d-header"  expandIcon={<ExpandMoreIcon />}>
                    <Typography component="p">Upload Image</Typography>
                  </AccordionSummary>
                  <AccordionDetails>
                    <Box className={styles.cktextEditer}>
                    <FormControl>
                        <RadioGroup
                          aria-labelledby="demo-radio-buttons-group-label"
                          defaultValue="Default"
                          name="radio-buttons-group"
                          row
                        className={styles.radioButton}>
                         {showUploadimgfirst &&(
                            <FormControlLabel value="Default" control={<Radio />} label="Default" onClick={handleButtonClickFirst}/>
                         )} 
                         
                          <FormControlLabel value="Custom" control={<Radio />} label="Custom" onClick={handleButtonClick}/>
                          {showUploadimg && (
                          <Box className={styles.uploadImg}>
                              <Typography variant="p" component="p">Upload Image</Typography>
									        	    <TextField size="small" type="file" name="filename" onChange={fileChange}  accept="image/*" fullWidth  />
                          </Box>)}
                        </RadioGroup>
                      </FormControl>
                    </Box>
                  
                   
                  </AccordionDetails>
                </Accordion>

                <Accordion className={styles.ckAccordion}>
                  <AccordionSummary aria-controls="panel1d-content" id="panel1d-header"  expandIcon={<ExpandMoreIcon />}>
                    <Typography component="p">Heading</Typography>
                  </AccordionSummary>
                  <AccordionDetails>
                    <Box className={styles.cktextEditer}>
                      <HeaderEditor
                        name="description"
                        onChange={(headerdata) => {
                          var plainString = headerdata.replace("", );
                          setheaderData(headerdata);
                        }}
                      headereditorLoaded={headereditorLoaded}
                      />
                    </Box>
                   
                  </AccordionDetails>
                </Accordion>
                <Accordion expanded={expanded === 'panel2'} onChange={handleChange('panel2')} className={styles.ckAccordion}>
                  <AccordionSummary aria-controls="panel2d-content" id="panel2d-header" expandIcon={<ExpandMoreIcon />}>
                    <Typography>Middle Content </Typography>
                  </AccordionSummary>

                  <AccordionDetails>
                     <Box className={styles.cktextEditer}>
                        <Editor
                            name="description"
                            onChange={(data) => {
                                var plainString = data.replace("", );
                            setData(data);
                            }}
                            editorLoaded={editorLoaded}
                        />
                    </Box>
                  </AccordionDetails>

                </Accordion>
                <Accordion expanded={expanded === 'panel3'} onChange={handleChange('panel3')} className={styles.ckAccordion}>
                  <AccordionSummary aria-controls="panel3d-content" id="panel3d-header" expandIcon={<ExpandMoreIcon />}>
                    <Typography>Footer</Typography>
                  </AccordionSummary>

                  <AccordionDetails>
                     <Box className={styles.cktextEditer}>
                        <FooterEditor
                            name="description"
                            onChange={(footerdata) => {
                                var plainString = footerdata.replace("", );
                                setFooterData(footerdata);
                            }}
                            footereditorLoaded={footereditorLoaded}
                        />
                     </Box>
                  </AccordionDetails>
                </Accordion>
           </div>
          </Grid>

          <Grid item xs={7} md={7}>
            <Box className={styles.rightSection}>
                <Frame height="550" width="600">
                 <Box style={{backgroundColor: "#f5f5f5", margin:"0", padding:"0", webkitTextSizeAdjust: "none",textSizeAdjust: "none"}}  width="500">
                        <table border="0" cellpadding="0" cellspacing="0" role="presentation" style={{msoTableLspace:"0pt", msoTableRspace:"0pt", backgroundColor:"#f5f5f5",maxWidth:"100%",minWidth:"100%",tableLayout: "fixed"}} width="100%">
                        <tbody>
                            <tr>
                            <td>
                               
                                 <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style={{msoTableLspace:"0pt",msoTableRspace:"0pt",backgroundColor:addBackgroundColor != "" ? addBackgroundColor : "#2c5596" ,backgroundImage:"url('https://stag-tpir.threatcop.com/api/static/logo/heasder-bg.png')", backgroundRepeat:"no-repeat",color:"#000000",backgroundSize:"cover",borderRadius:"0",width:"600px",maxWidth:"100%",minWidth:"100%",tableLayout: "fixed"}} width="600">
                                    <tbody>
                                        <tr>
                                        <td style={{msoTableLspace:"0pt",msoTableRspace:"0pt",fontWeight:"400",textAlign:"left",verticalAlign:"top",paddingTop:"0px",paddingBottom:"25px",borderTop:"0px",borderRight:"0px",borderBottom:"0px",borderLeft:"0px"}} width="100%">

                                                
                                            <div align="left" style={{lineHeight:"10px"}}>
                                                <img src={ file === "" ? "https://stag-tpir.threatcop.com/api/static/logo/Tpirlogo.png" : file } style={{display:"block",height:"auto",border:"0",width:"170px",maxWidth:"100%"}} width="170" />
                                            </div>
                                                 
                                                
                                                   
                                              
                                                    <div style={{fontFamily: "sans-serif"}}>
                                                        <div class="" style={{fontSize:"12px",fontFamily:"Poppins, Arial, Helvetica, sans-serif",msoLineHeightAlt:"18px",color:"#ffffff",lineHeight:"1.5"}}>
                                                        <p style={{margin:"0",fontSize:"17px",textAlign:"center",msoLineHeightAlt:"24px",lineHeight: "14px"}}>
                                                            <span dangerouslySetInnerHTML={{ __html: headerdata }}  style={{fontSize:"16px",marginTop: "4px"}}></span>
                                                        </p>
                                                        </div>
                                                    </div>
                                            </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                 
                                 <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style={{msoTableLspace:"0pt", msoTableRspace:"0pt", backgroundColor:"#f5f5f5",maxWidth:"100%",minWidth:"100%",tableLayout: "fixed"}}  width="100%">
                                <tbody>
                                    <tr>
                                    <td>
                                        <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style={{msoTableLspace:"0pt", msoTableRspace:"0pt", backgroundColor:"#f5f5f5",maxWidth:"100%",minWidth:"100%",tableLayout: "fixed"}}  width="600">
                                        <tbody>
                                            <tr>
                                            <td style={{msoTableLspace:"0pt",msoTableRspace:"0pt",fontWeight:"400",textAlign:"left",paddingLeft:"30px",paddingRight:"30px",verticalAlign:"top",paddingTop:"0px",paddingBottom:"25px",borderTop:"0px",borderRight:"0px",borderBottom:"0px",borderLeft:"0px"}} width="100%">
                                                <table border="0" cellpadding="0" cellspacing="0" class="paragraph_block block-1" role="presentation" style={{msoTableLspace:"0pt",msoTableRspace:"0pt",wordBreak:"break-word"}} width="100%">
                                                <tr>
                                                    <td >
                                                    <div style={{color:"#333954",fontSize:"15px",fontFamily:"'Lato', Tahoma, Verdana, Segoe, sans-serif",fontWeight:"400",lineHeight:"180%",textAlign:"left",direction:"ltr",letterSpacing:"0px",msoLineHeightAlt:"27px"}}>
                                                         <div style={{lineHeight: "14px"}} dangerouslySetInnerHTML={{ __html: data }} /> 
                                                    </div>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>
                                            </tr>
                                        </tbody>
                                        </table>
                                    </td>
                                    </tr>
                                </tbody>
                            </table>


                            <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style={{msoTableLspace:"0pt", msoTableRspace:"0pt",maxWidth:"100%",minWidth:"100%",tableLayout: "fixed"}} width="100%">
                                <tbody>
                                    <tr>
                                    <td>
                                        <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style={{msoTableLspace:"0pt",msoTableRspace:"0pt",backgroundColor:addBackgroundColor != "" ? addBackgroundColor : "#2c5596",color:"#000000",width:"600px",maxWidth:"100%",minWidth:"100%",tableLayout: "fixed"}} width="600">
                                        <tbody>
                                            <tr>
                                            <td style={{msoTableLspace:"0pt",msoTableRspace:"0pt",fontWeight:"400",textAlign:"left",verticalAlign:"top",paddingTop:"10px",paddingBottom:"0px",borderTop:"0px",borderRight:"0px",borderBottom:"0px",borderLeft:"0px"}} width="100%">
                                                <table border="0" cellpadding="0" cellspacing="0" role="presentation" style={{msoTableLspace:"0pt",msoTableRspace:"0pt",wordBreak:"break-word"}} width="100%">
                                                <tr>
                                                    <td style={{paddingTop:"10px",paddingRight:"10px",paddingLeft:"10px"}}>
                                                    <div style={{color:"#ffffff",fontSize:"11px",fontFamily:"Poppins, Arial, Helvetica, sans-serif",fontWeight:"400",lineHeight:"120%",textAlign:"center",direction:"ltr",letterSpacing:"0px",msoLineHeightAlt:"13px"}}>
                                                        <p style={{lineHeight: "14px"}} dangerouslySetInnerHTML={{ __html: footerdata }}></p>
                                                       
                                                
                                                       
                                                    </div>
                                                    </td>
                                                </tr>
                                                </table>
                                                <table border="0" cellpadding="20" cellspacing="0" role="presentation" style={{msoTableLspace:"0pt",msoTableRspace:"0pt",wordBreak:"break-word"}} width="100%">
                                                <tr>
                                                    <td class="pad">
                                                    <div style={{fontFamily: "sans-serif"}}>
                                                        <div style={{fontSize:"12px",fontFamily:"Poppins, Arial, Helvetica, sans-serif",msoLineHeightAlt:"18px",color:"#fafafa",lineHeight:"1px"}}>
                                                        <p style={{margin:"0",fontSize:"10px",textAlign:"center",msoLineHeightAlt:"15px"}}>
                                                            <span style={{fontSize:"10px"}}>
                                                            <span >© 2023 ThreatCop </span>
                                                            </span>
                                                            <span style={{fontSize:"10px"}}>
                                                            <span > All Rights Reserved.</span>
                                                            </span>
                                                        </p>
                                                        </div>
                                                    </div>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>
                                            </tr>
                                        </tbody>
                                        </table>
                                    </td>
                                    </tr>
                                </tbody>
                                </table> 
                             {/* <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style={{msoTableLspace:"0pt",msoTableRspace:"0pt",maxWidth:"100%",minWidth:"100%",tableLayout: "fixed"}} width="100%">
                                <tbody>
                                    <tr>
                                    <td>
                                        <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style={{msoTableLspace:"0pt",msoTableRspace:"0pt",color:"#000000",width:"600px",maxWidth:"100%",minWidth:"100%",tableLayout: "fixed"}} width="600">
                                        <tbody>
                                            <tr>
                                            <td style={{msoTableLspace:"0pt",msoTableRspace:"0pt",fontWeight:"400",textAlign:"left",verticalAlign:"top",paddingTop:"5px",paddingBottom:"5px",borderTop:"0px",borderRight:"0px",borderBottom:"0px",borderLeft:"0px"}} width="100%">
                                                <table border="0" cellpadding="0" cellspacing="0" role="presentation" style={{msoTableLspace:"0pt",msoTableRspace:"0pt",maxWidth:"100%",minWidth:"100%",tableLayout: "fixed"}} width="100%">
                                                <tr>
                                                    <td style={{verticalAlign:"middle",paddingBottom:"5px",paddingTop:"5px",textAlign:"center",color:"#9d9d9d",fontFamily:"inherit",fontSize:"15px"}}>
                                                    <table cellpadding="0" cellspacing="0" role="presentation" style={{msoTableLspace:"0pt",msoTableRspace:"0pt",maxWidth:"100%",minWidth:"100%",tableLayout: "fixed"}} width="100%">
                                                        <tr>
                                                        <td style={{verticalAlign:"middle",textAlign:"center"}}></td>
                                                        </tr>
                                                    </table>
                                                    </td>
                                                </tr>
                                                </table>
                                            </td>
                                            </tr>
                                        </tbody>
                                        </table>
                                    </td>
                                    </tr>
                                </tbody>
                             </table>  */}
                            </td>
                            </tr>
                        </tbody>
                        </table>
                    </Box>
                </Frame>
            </Box>
          </Grid>               
        </Grid>
      </Box>
    </Box>
  );
}
