import React, { useEffect, useState } from "react";

import { LoadingButton } from '@mui/lab';
import { Box,Chip,Grid, Modal, TextField, ListItemText, InputLabel, Tooltip, MenuItem, FormControl, Select, Menu, Typography, Stack, Tab, Tabs, Button, TableRow, TableHead, TableContainer, TableCell, TableBody, Table, IconButton} from "@mui/material";
import swal from 'sweetalert'
import CircularProgress from "@mui/material/CircularProgress"; 
import Backdrop from "@mui/material/Backdrop";
import Autocomplete from '@mui/material/Autocomplete';
import FormGroup from '@mui/material/FormGroup';
import {IoSearchOutline, IoTrash, IoAdd, IoAddCircleOutline, IoMailOutline} from "react-icons/io5";
import PopupState, { bindTrigger, bindMenu } from 'material-ui-popup-state';
import FormControlLabel from '@mui/material/FormControlLabel';
import Checkbox from '@mui/material/Checkbox';
import { FiEdit } from "react-icons/fi";
import Cookies from 'js-cookie';
import PropTypes from 'prop-types';
import styles from "../styles/home.module.scss";
import { checkIsTacEnabled, validateEmail } from "../utils/common";
import routes from '../utils/routes';
import api from "../utils/api";
import { toast } from "react-toastify";
import { apiError } from "../utils/error";
import Link from 'next/link';
import CloseSharpIcon from '@mui/icons-material/CloseSharp';
import Divider from '@mui/material/Divider';
import Drawer from '@mui/material/Drawer';
import { useRouter } from "next/router";
import { AppContext } from "../components/appcontext";


export default function Domain() {
  const [openModal, setOpen] = React.useState(false);
  const [loading, setLoading] = React.useState(false)
  const [employees, setEmployees] = React.useState([])
  const [policies, setPolicies] = React.useState([])
  const [selectedPolicies, setSelectedPolicies] = React.useState([])
  const [allChecked, setAllChecked] = useState(false);
  const [roles, setRoles ] = React.useState([])
  const [isDrawerOpenedForUpdate, setIsDrawerOpenedForUpdate] = React.useState(false)
  const [isModalOpenedForUpdate, setIsModalOpenedForUpdate] = React.useState(false)
  const handleOpen = () => setOpen(true);
  const router = useRouter()
  const { permissions } = React.useContext(AppContext);

  const isTacEnabled = checkIsTacEnabled()
  
  const handleCloseDrawer = () => {
    setSelectedPolicies([]);
    setNewRole({ name: '', description: ''})
    setrightOpen(false)
    setIsDefaultRole(false)
  };

  const handleCloseModal = () => {
    setOpen(false)
    setNewEmployee({
      firstName:'',
      lastName: '',
      email: ''
    })
    setNewEmployeeSelectedRoles([])
    setIsModalOpenedForUpdate(false)
    setNewEmployeeError({
      firstName: { status: false, message:''},
      lastName: { status: false, message:''},
      email: { status: false, message:''}
    })
    
  };

  const [value, setValue] = React.useState(0);
  const [open, setrightOpen] = React.useState(false);
  
  const [newRole, setNewRole] = React.useState({
    name: '',
    description: '',
  })

  const [ roleId, setRoleId ] = React.useState('')

  const [isDefaultRole, setIsDefaultRole] = React.useState(false)

  const [newRoleError, setNewRoleError] = React.useState({
    name: { status: false, message:''},
    description: { status: false, message:''},
  })

  const [ newEmployeeSelectedRoles, setNewEmployeeSelectedRoles ] = React.useState([])


  const style = {
    position: "absolute",
    top: "10%",
    left: "50%",
    transform: "translate( -50%)",
    width: 500,
    bgcolor: "background.paper",
    border: "unset",
   
  };
  
  const isHyperLink = /^[a-zA-Z]+$/


  const toggleDrawer = (newOpen) => () => {
    setIsDrawerOpenedForUpdate(false)
    setrightOpen(newOpen);
  };
 

  const switchTab = (event, newValue) => {
    setValue(newValue);
  };

  const [newEmployee, setNewEmployee] = React.useState({
    firstName: '',
    lastName:'',
    email: ''
  })

  const [newEmployeeError, setNewEmployeeError] = React.useState({
    firstName: { status: false, message:''},
    lastName: { status: false, message:''},
    email: { status: false, message:''}
  })
  
  const loadEmployee = async () =>{
    api.get(routes.EMPLOYEE.LIST)
    .then(res => res.data)
    .then((data) =>{
      setEmployees(data.employees)
    })
    .catch((error) => {
      apiError(error)
    })
  }

  const loadRoles = async () =>{
    api.get(routes.ROLES.LIST)
    .then(res => res.data)
    .then((data) =>{
      setRoles(data.roles)
    })
    .catch((error) => {
      apiError(error)
    })
  }
  const loadSingleRole = async (roleName, roleType) =>{
    setLoading(true)
    setIsDrawerOpenedForUpdate(true)
    api.post(routes.ROLES.GET,{
      roleName, roleType
    })
    .then(res => res.data)
    .then((data) =>{
      console.log('loadsingleroleeee',data)
      if(data.role.roleType == "Default") setIsDefaultRole(true)
      setrightOpen(true)
      setRoleId(data.role.roleId)
      setNewRole({...newRole, name: data.role.roleName, description: data.role.description})
      setSelectedPolicies(data.role.policies)
    })
    .catch((error) => {
      apiError(error)
    })
  }

  const loadEmployeeDetails = async (firstName, lastName, email, roleIds) =>{
    setNewEmployee({
      firstName,
      lastName: lastName ? lastName :'',
      email
    })
    setOpen(true) 
    setIsModalOpenedForUpdate(true)
    setNewEmployeeSelectedRoles(roleIds)
  }




  const loadPolicies = async () =>{
    api.get(routes.POLICY.LIST)
    .then(res => res.data)
    .then((data) =>{
      setPolicies(data.policies)
    })
    .catch((error) => {
      apiError(error)
    })
  }

  const handleChange = (e) => {
    console.log(e.target.name)
    switch(e.target.name){

      case 'firstName':{
        const name = e.target.value;

        if(!name || !name.length) setNewEmployeeError({ ...newEmployeeError, firstName: { status: true, message: 'First Name cannot be empty!' } });
        else setNewEmployeeError({ ...newEmployeeError, firstName: { status: false, message: '' } }); 
        
        break;
      }

      case 'lastName':{
        setNewEmployeeError({ ...newEmployeeError, lastName: { status: false, message: '' } }); 
        break;
      }


      case 'email':{
        const email = e.target.value;

        if(!email || !email.length || !validateEmail(email)) setNewEmployeeError({ ...newEmployeeError, email: { status: true, message: 'Please enter a valid mail!' } });
        else setNewEmployeeError({ ...newEmployeeError, email: { status: false, message: '' } }); 

        break;
      }
    }

    setNewEmployee({ ...newEmployee, [e.target.name]: e.target.value });
};

const handleChangeRole = (e) => {
  console.log(e.target)
  switch(e.target.name){

    case 'name':{
      const name = e.target.value;

      if(!name || !name.length) setNewRoleError({ ...newRoleError, name: { status: true, message: 'Role Name cannot be empty!' } });
      else setNewRoleError({ ...newRoleError, name: { status: false, message: '' } }); 
      
      break;
    }

    case 'description': {
      const description = e.target.value;

      if(!description || !description.length) setNewRoleError({ ...newRoleError, description: { status: true, message: 'Description cannot be empty!' } });
      else setNewRoleError({ ...newRoleError, description: { status: false, message: '' } }); 

      break;
    }

  }

  setNewRole({ ...newRole, [e.target.name]: e.target.value });
};


const handleCheckboxChange = (policyName) => {
  setSelectedPolicies((prevSelectedPolicies) => {
    const newSelectedPolicies = prevSelectedPolicies.includes(policyName)
      ? prevSelectedPolicies.filter((name) => name !== policyName)
      : [...prevSelectedPolicies, policyName];
    return newSelectedPolicies;
  });
};

const handleCheckAllChange = () => {
  setAllChecked((prevAllChecked) => {
    const newCheckedState = !prevAllChecked;
    setSelectedPolicies(newCheckedState ? policies.map(policy => policy.name) : []);
    return newCheckedState;
  });
};


  const addRole = async () =>{
    const { name, description } = newRole
    const error = false;
    console.log({selectedPolicies})
    if(!name || !name.length) {
      error = true
      setNewRoleError((prevState)=> ({...prevState, name: {status: true, message: 'Name cannot be empty!'}}))
    }
    
    if(!description || !description.length) {
      error = true
      setNewRoleError((prevState)=> ({...prevState, description: {status: true, message: 'Description cannot be empty!'}}))
    }
 

    if(!error){
      setLoading(true)
      api.post(routes.ROLES.ADD, { roleName: name, description, policyData: selectedPolicies })
      .then((res) => res.data)
      .then((data) =>{
        setLoading(false)
        toast.success(data.message)
        setOpen(false)
        setAllChecked(false)
        setSelectedPolicies([])
        setNewRole({name:"", description:''})
        setrightOpen(false)
        setIsDrawerOpenedForUpdate(false)
        loadRoles()

      })
      .catch((error) =>{
        setLoading(false)
        apiError(error)
      })

    }

  }

  const updateRole = async () =>{
    const { name, description } = newRole
    const error = false;
    console.log({selectedPolicies})
    if(!name || !name.length) {
      error = true
      setNewRoleError((prevState)=> ({...prevState, name: {status: true, message: 'Name cannot be empty!'}}))
    }
    
    if(!description || !description.length) {
      error = true
      setNewRoleError((prevState)=> ({...prevState, description: {status: true, message: 'Description cannot be empty!'}}))
    }
    console.log({roleId})
    if(!error){
      setLoading(true)
      api.post(routes.ROLES.UPDATE, { roleName: name, description, policyData: selectedPolicies, roleId })
      .then((res) => res.data)
      .then((data) =>{
        setLoading(false)
        toast.success(data.message)
        setOpen(false)
        setAllChecked(false)
        setSelectedPolicies([])
        setNewRole({name:"", description:''})
        setrightOpen(false)
        setIsDrawerOpenedForUpdate(false)
        loadRoles()
        setRoleId('')
      })
      .catch((error) =>{
        setLoading(false)
        apiError(error)
      })

    }

  }

  const assignRolesToUser = (employeeId,action) =>{
    api.post(routes.ROLES.ASSIGN_ROLES,{
      employeeId, roleIds: newEmployeeSelectedRoles.map(role=>role._id)
    })
    .then(res=>res.data)
    .then((data)=>{
      setLoading(false)
      if(action == "added") toast.success(`IAM user ${action} successfully and set password link has been sent!`)
      else toast.success(`IAM user ${action} successfully!`)
      handleCloseModal()
      loadEmployee()
    })
  }

  const addEmployee = async () =>{
    const {firstName, lastName='', email} = newEmployee
    const error = false;

    if(!firstName || !firstName.length) {
      error = true
      setNewEmployeeError((prevState)=> ({...prevState, firstName: {status: true, message: 'First Name cannot be empty!'}}))
    }
    else{
      console.log('asdhjasdbhjsda',isHyperLink.test(firstName))
      if(!isHyperLink.test(firstName)){
        error = true
        setNewEmployeeError((prevState)=> ({...prevState, firstName: {status: true, message: 'Invalid First Name!'}}))
      } 
    }
    
    if(lastName.length > 0 && !isHyperLink.test(lastName)){
      error = true
      setNewEmployeeError((prevState)=> ({...prevState, lastName: {status: true, message: 'Invalid Last Name!'}}))
    } 
    if(!email || !email.length || !validateEmail(email)) {
      error=true
      setNewEmployeeError((prevState)=> ({...prevState, email: {status: true, message: 'Please Enter a valid email!'}}))
    }

    if(!error){
      setLoading(true)
      api.post(routes.EMPLOYEE.ADD, { firstName, lastName, email: email })
      .then((res) => res.data)
      .then((data) =>{
        assignRolesToUser(data.employeeId,"added")
      })
      .catch((error) =>{
        setLoading(false)
        apiError(error)
      })

    }

  }

  const updateEmployee = async () =>{
    const {firstName, lastName = '', email } = newEmployee
    const error = false;

    console.log({newEmployee})

    if(!firstName || !firstName.length) {
      error = true
      setNewEmployeeError((prevState)=> ({...prevState, firstName: {status: true, message: 'First Name cannot be empty!'}}))
    }
    else{
      if(!isHyperLink.test(firstName)){
        error = true
        setNewEmployeeError((prevState)=> ({...prevState, firstName: {status: true, message: 'Invalid First Name!'}}))
      } 
    }
  
    if(lastName.length > 0 && !isHyperLink.test(lastName)){
        error = true
        setNewEmployeeError((prevState)=> ({...prevState, lastName: {status: true, message: 'Invalid Last Name!'}}))
    } 
    console.log({error})
  
    if(!error){
      setLoading(true)
      api.post(routes.EMPLOYEE.UPDATE, { firstName, lastName, email })
      .then((res) => res.data)
      .then((data) =>{
        assignRolesToUser(data.employeeId, "updated")
      })
      .catch((error) =>{
        setLoading(false)
        apiError(error)
      })

    }

  }

  const deleteEmplyeeSwal = async (employeeId) =>{
    const willDelete = await swal({
        title: "Are you sure?",
        text: "Are you sure you want to Delete this Employee?",
        icon: "warning",
        dangerMode: true,
        closeOnEsc: true,
        buttons: {
            cancel: true,
            confirm: true,
          },
    });
       
    console.log({willDelete});
    if (willDelete) {
        deleteEmployee(employeeId)
    }
}

const deleteRoleSwal = async (roleId) =>{
  const willDelete = await swal({
      title: "Are you sure?",
      text: "Are you sure you want to Delete this Role?",
      icon: "warning",
      dangerMode: true,
      closeOnEsc: true,
      buttons: {
          cancel: true,
          confirm: true,
        },
  });
     
  console.log({willDelete});
  if (willDelete) {
      deleteRole(roleId)
  }
}

  const deleteEmployee = async (id) =>{

    if(id && id.length){

      api.delete(routes.EMPLOYEE.DELETE,{
        params:{
          employeeId: id
        }
      })
      .then((res) => res.data)
      .then((data) =>{
        swal("Deleted!", "Employee has been deleted!", "success", { buttons: false, timer: 1000 });
        loadEmployee()
      })
      .catch((error)=>{
        if(error?.response?.status == 403) apiError(error)
        else swal("Some Error Occured!","Error occured while deleting employee!", "error", { buttons: false, timer: 1000 });

      })
    }
  }

  const deleteRole = async (id) =>{
    console.log({id})
    if(id && id.length){

      api.post(routes.ROLES.DELETE,{
          roleId: id
        }
    )
      .then((res) => res.data)
      .then((data) =>{
        swal("Deleted!", "Role has been deleted!", "success", { buttons: false, timer: 1000 });
        loadRoles()
        loadEmployee()
      })
      .catch((error)=>{
        if(error?.response?.status == 403) apiError(error)
        else swal("Some Error Occured!","Error occured while deleting role!", "error", { buttons: false, timer: 1000 });

      })
    }
  }


  console.log({roles})
  const sendResetPasswordLink = (id) => {
    if(id && id.length){
      api.get(routes.EMPLOYEE.RESET_PASSWORD+'?employeeId='+id)
      .then((res) => res.data )
      .then((data) =>{
        setLoading(true)
        toast.success(data.message)
      })
      .catch((error) =>{
        setLoading(false)
        apiError(error)
      })
    }
  }
  React.useEffect(()=>{
    loadEmployee()
    loadRoles()
    loadPolicies()
  }, [])

  React.useEffect(() => {
    setAllChecked(selectedPolicies?.length === policies.length);
  }, [selectedPolicies]);

  console.log({permissions})

    function TabPanel(props) {
      const { children, value, index, ...other } = props;
    
      return (
        <div
          role="tabpanel"
          hidden={value !== index}
          id={`simple-tabpanel-${index}`}
          aria-labelledby={`simple-tab-${index}`}
          {...other}
        >
          {value === index && <Box sx={{ p: 3 }}>{children}</Box>}
        </div>
      );
    }
    
    TabPanel.propTypes = {
      children: PropTypes.node,
      index: PropTypes.number.isRequired,
      value: PropTypes.number.isRequired,
    };
    
    function a11yProps(index) {
      return {
        id: `simple-tab-${index}`,
        'aria-controls': `simple-tabpanel-${index}`,
      };
    }    

    const availableRoles = roles.filter(
      (role) => !newEmployeeSelectedRoles.some((selectedRole) => selectedRole._id === role._id)
    );
    
    
  return (
    <Box className={styles.contentbar}>
       <Box className={styles.containerbar}>
      {/*============ breadcrumbBar Starts ============= */}
      <Box className={styles.breadcrumbBar}>
        <Grid
          container        
          direction="row"
          justifyContent="center"
          alignItems="center"
        >
          <Grid item xs={4}>
            <Typography
              component="h4"
              variant="h4"
              className={styles.page_title}
            >
              IAM Users
            </Typography>
          </Grid>
          <Grid item xs={8} align="right">
          {(value === 0 && !isTacEnabled) && (<Button
              variant="contained"
              className={`${styles.btn} ${styles.btnPrimary}`}
              onClick={handleOpen}
              disabled={!permissions?.includes("IAM-Write")}
            >
              <IoAdd className={styles.icon_position} /> Add User
            </Button>) 
            }
            {(value === 0 && isTacEnabled) &&   (<Button
              variant="contained"
              className={`${styles.btn} ${styles.btnPrimary}`}
              disabled={!permissions?.includes("IAM-Write")}
              onClick={() =>
                window.open(
                  `${process.env.NEXT_PUBLIC_TAC_URL}/directory/applications?action=iam&appName=TPIR`,
                  "_blank"
                )
              }           
              >
              <IoAdd className={styles.icon_position} /> Add User
            </Button>)
            }

          
            {value === 1 && !isTacEnabled && <Button
              variant="contained"
              className={`${styles.btn} ${styles.btnPrimary}`}
              onClick={toggleDrawer(true)}
            >
              <IoAdd className={styles.icon_position} /> Create Role
            </Button>}
          </Grid>
        </Grid>
      </Box>
      {/*============ breadcrumbBar Ends ============= */}





      {/*============ filterWrapper Starts ============= */}
      <Box className={styles.TABAnalysis}>
      <Box sx={{ borderBottom: 1, borderColor: 'divider' }}>
        <Tabs value={value} onChange={switchTab} aria-label="basic tabs example" className={styles.TabItemButton}>
          <Tab label="Users" {...a11yProps(0)} />
          <Tab label="Roles" {...a11yProps(1)} />
        </Tabs>
      </Box>
      </Box>
      {/*============ filterWrapper Ends ============= */}

      {/*============ TableContainer Ends ============= */}

      <TabPanel value={value} index={0} className={styles.commontabPanel}>	
        <Box className={styles.contentbarWrap}>
            <TableContainer className={styles.tableContainer}>
              <Table sx={{ minWidth: 650 }} aria-label="simple table">
                <TableHead className={styles.thead_background}>
                  <TableRow>
                    <TableCell>Name</TableCell>
                    <TableCell>Email</TableCell>
                    <TableCell>Role</TableCell>
                    <TableCell>Status</TableCell>
                    {!isTacEnabled && <TableCell>RESET PASSWORD LINK	</TableCell>}
                    {!isTacEnabled && <TableCell>Action</TableCell>}
                  </TableRow>
                </TableHead>

                <TableBody className={styles.tableBgcolor}>
                  {employees && employees.length > 0 && employees.map((employee, index)=>(
                    <TableRow key={index} sx={{ "&:last-child td, &:last-child th": { border: 0 } }}>
                    <TableCell component="td" scope="row">
                     {employee?.employeeId?.firstName} {employee?.employeeId?.lastName}
                    </TableCell>
                    <TableCell component="td" scope="row">
                     {employee?.employeeId?.email}
                    </TableCell>
                    <TableCell component="td" scope="row">
                     {employee?.roleIds.length > 1 ? 'Multiple' : employee?.roleIds.length == 0 ? "None" : employee?.roleIds[0]?.roleName}
                    </TableCell>
                    <TableCell component="td" scope="row">
                     {employee?.employeeId?.isVerify ? 'VERIFIED' : 'NOT VERIFIED'}
                    </TableCell>
                    {!isTacEnabled &&
                    <TableCell component="td" scope="row">
                        <Chip
                            label="Send"
                            variant="outlined"
                            size="small"
                            color="success"
                            onClick = {()=> sendResetPasswordLink(employee.employeeId._id)}
                          />
                    </TableCell>
                    }
                    {!isTacEnabled &&<TableCell component="td" scope="row">
                  
                    <PopupState variant="popover" popupId="demo-popup-menu">
                        {(popupState) => <>
                          <Button {...bindTrigger(popupState)}>...</Button>
                          <Menu {...bindMenu(popupState)}>
                            <MenuItem onClick={()=>loadEmployeeDetails(employee.employeeId.firstName, employee.employeeId.lastName, employee.employeeId.email, employee.roleIds)}>
                                Edit
                              </MenuItem>
                              {!isTacEnabled &&
                              <MenuItem
                              onClick={()=>deleteEmplyeeSwal(employee.employeeId._id)}
                              >
                                Delete
                              </MenuItem>
                              }
                          </Menu>
                        </>}
                    </PopupState>
                    </TableCell>
                    }
                  </TableRow>
                  ))}
                </TableBody>
              </Table>
            </TableContainer>
          </Box>
	  	</TabPanel>



    <TabPanel value={value} index={1} className={styles.commontabPanel}>
        <Box className={styles.contentbarWrap}>
          <TableContainer className={styles.tableContainer}>
            <Table sx={{ minWidth: 650 }} aria-label="simple table">
              <TableHead className={styles.thead_background}>
                <TableRow>
                  <TableCell>Role</TableCell>
                  <TableCell>Description</TableCell>
                  <TableCell>Action</TableCell>
                 
                </TableRow>
              </TableHead>

              <TableBody className={styles.tableBgcolor}>
              {roles && roles.length > 0 && roles?.map((role, index)=>(
                <TableRow key={index} sx={{ "&:last-child td, &:last-child th": { border: 0 } }}>
                  <TableCell component="td" scope="row">
                  {role.roleName}
                  </TableCell>
                  <TableCell component="td" scope="row">
                  {role.description}
                  </TableCell>
                  <TableCell component="td" scope="row">
                  <PopupState variant="popover" popupId="demo-popup-menu">
                        {(popupState) => <>
                          <Button {...bindTrigger(popupState)}>...</Button>
                          <Menu {...bindMenu(popupState)}>
                            <MenuItem onClick={()=>loadSingleRole(role.roleName, role.roleType)}>
                                Edit
                              </MenuItem>
                              {!isTacEnabled &&
                              <MenuItem
                              onClick={()=> deleteRoleSwal(role._id)}
                              >
                                Delete
                              </MenuItem>
                              }
                          </Menu>
                        </>}
                    </PopupState>
                  </TableCell>
                  </TableRow>
                ))}
              </TableBody>
            </Table>
          </TableContainer>
        </Box>
    </TabPanel>

      {/*============ TableContainer Ends ============= */}

      {/* =========Modal for Add Project========  */}

      <Modal
        open={openModal}
        onClose={handleCloseModal}
        aria-labelledby="modal-modal-title"
        aria-describedby="modal-modal-description"
      >
        <Box sx={style} className={styles.EpmloyeeModal}>
                 <Box className={`${styles.modalHeader} ${styles.modalHeaderIam}`}>
                        <Typography id="modal-modal-title" variant="h6" component="h2">
                        Add Employee
                        </Typography>
                        <CloseSharpIcon className={styles.closeIcon} onClick={handleCloseModal} />
                    </Box>
                        <Box className={styles.AddEmployeeModal}>
                          <Box className={styles.InputField}>
                            <label sx={{ fontWeight:"600", fontSize:"14px", color:" #6c757d" }}>First Name</label>
                            <TextField
                              className={styles.inputfild}
                              id="outlined-basic"
                              placeholder='First Name'
                              name='firstName'
                              value={newEmployee.firstName}
                              error={newEmployeeError.firstName.status}
                              helperText={newEmployeeError.firstName.message}
                              variant="outlined"
                              onChange={handleChange}
                            />
                          </Box>
                          <Box className={styles.InputField}>
                            <label sx={{ fontWeight:"600", fontSize:"14px", color:" #6c757d" }}>Last Name</label>
                            <TextField
                              className={styles.inputfild}
                              id="outlined-basic"
                              placeholder='Last Name'
                              name='lastName'
                              value={newEmployee.lastName}
                              error={newEmployeeError.lastName.status}
                              helperText={newEmployeeError.lastName.message}
                              variant="outlined"
                              onChange={handleChange}
                            />
                          </Box>

                          <Box className={styles.InputField}>
                           <label sx={{ fontWeight:"600", fontSize:"14px", color:" #6c757d" }}>Email Address</label>
                            <TextField
                              className={styles.inputfild}
                              id="outlined-basic"
                              placeholder='Email'
                              name='email'
                              value={newEmployee.email}
                              disabled={isModalOpenedForUpdate}
                              variant="outlined"
                              error={newEmployeeError.email.status}
                              helperText={newEmployeeError.email.message}
                              onChange={handleChange}
                            />
                          </Box>

                          <Box className={styles.selectMultipaldropdown}>
                            <label sx={{ fontWeight:"600", fontSize:"14px", color:" #6c757d" }}>Role</label>
                            <Autocomplete
                            className={styles.inputfild}
                                  multiple
                                  id="tags-outlined"
                                  options={availableRoles}
                                  getOptionLabel={(option) => option.roleName}
                                  filterSelectedOptions
                                  value={newEmployeeSelectedRoles}
                                  onChange={(event, newValue) => {
                                    setNewEmployeeSelectedRoles(newValue);
                                  }}
                                  renderInput={(params) => (
                                    <TextField {...params} placeholder={newEmployeeSelectedRoles.length === 0 ? "Multiselect" : ""} />
                                  )}
                                />
                         </Box>
                         

                        {!isModalOpenedForUpdate ? 
                <Box className={styles.AddBtn}>
                  <Backdrop
                    sx={{ color: '#fff', zIndex: (theme) => theme.zIndex.drawer + 1 }}
                    open={loading}
                  >
                    <CircularProgress color="inherit" /> {/* Loader Spinner */}
                  </Backdrop>
                        <LoadingButton disabled={loading} loading={loading} loadingPosition="start" id="employee" variant="contained" className={styles.primaryBtn} sx={{ mb: '30px' }} onClick={addEmployee}>Add</LoadingButton>
                        </Box>:
                        <Box className={styles.AddBtn}>
                        <LoadingButton disabled={loading} loading={loading} loadingPosition="start" id="employee" variant="contained" className={styles.primaryBtn} sx={{ mb: '30px' }} onClick={updateEmployee}>Update</LoadingButton>
                        </Box>
                        }
          </Box>
        </Box>
      </Modal>



  
          {/* =========Modal Drawer========  */}
      
        <Drawer anchor={"right"} open={open} onClose={handleCloseDrawer}  >
          <Box sx={{ width:"600px"}} className={styles.rightdrawerModal}>
         
                 <Box className={styles.modalHeader}>
                  <Box> 
                    <Typography id="modal-modal-title" variant="h6" component="h2">
                    Create New Role
                        </Typography>
                        <Typography component="p">
                        Fill the details to create new role
                        </Typography>
                        </Box>
                        <CloseSharpIcon className={styles.closeIcon} onClick={handleCloseDrawer} />
                    </Box>

                    <Box className={styles.modalBody}>
                      <Box className={styles.InputField}>
                            <label sx={{ fontWeight:"600", fontSize:"14px", color:" #6c757d" }}>Role Name</label>
                            <TextField
                              name='name'
                              value={newRole.name}
                              error={newRoleError.name.status}
                              helperText={newRoleError.name.message}
                              onChange={handleChangeRole}
                              disabled={isDefaultRole}
                              variant="outlined"/>
                        </Box>

                        <Box className={styles.InputField}>
                            <label sx={{ fontWeight:"600", fontSize:"14px", color:" #6c757d" }}>Description</label>
                            <TextField
                              multiline
                              rows={2}
                              value={newRole.description}
                              name='description'
                              disabled={isDefaultRole}
                              error={newRoleError.description.status}
                              helperText={newRoleError.description.message}
                              onChange={handleChangeRole}
                              variant="outlined"
                            
                            />
                        </Box>

                      <Box className={styles.modalTable}>
                            <Box className={styles.addUserFilter}>
                              <Typography component="p">
                                Select action for this role
                              </Typography>
                            </Box>

                         <Box className={styles.contentbarWrap}>
                          <TableContainer className={styles.tableContainer}>
                            <Table sx={{ minWidth: 400 }} aria-label="simple table">
                              <TableHead className={styles.thead_background}>
                                <TableRow>
                                  <TableCell>
                                  <FormGroup> 
                            <FormControlLabel
                                control={
                                <Checkbox 
                                        style={{marginLeft:"9px"}}/>}
                                        size="small"
                                        checked={allChecked}
                                        disabled={isDefaultRole}
                                        onChange={handleCheckAllChange}
                            />
                            </FormGroup>
                                  </TableCell>
                                  <TableCell>Policy</TableCell>
                                  <TableCell>Type</TableCell>
                                </TableRow>
                              </TableHead>

                              <TableBody className={styles.tableBgcolor}>
                                {policies.map((policy) => (
                                  <TableRow key={policy.name}>
                                    <TableCell component="td" scope="row">
                                      <FormGroup>
                                        <FormControlLabel
                                          control={<Checkbox 
                                          disabled={isDefaultRole}
                                          checked={selectedPolicies?.indexOf(policy.name)>-1}
                                          onChange={() => handleCheckboxChange(policy.name)}
                                          />
                                          }
                                          size="small"
                                        />
                                      </FormGroup>
                                    </TableCell>
                                    <TableCell component="td" scope="row">
                                      {policy.name}
                                    </TableCell>
                                    <TableCell component="td" scope="row">
                                      managed
                                    </TableCell>
                                  </TableRow>
                                ))}
                              </TableBody>
                            </Table>
                          </TableContainer>
                         </Box>
                        </Box>
                        {!isDefaultRole ? isDrawerOpenedForUpdate ? <Box className={styles.AddBtn} sx={{ textAlign:"right", marginTop:"20px"}}>
                        <LoadingButton variant="contained" className={styles.primaryBtn} sx={{ mb: '30px' }} onClick={ updateRole }>Update</LoadingButton>
                        </Box> : 
                        <Box className={styles.AddBtn} sx={{ textAlign:"right", marginTop:"20px"}}>
                        <LoadingButton variant="contained" className={styles.primaryBtn} sx={{ mb: '30px' }} onClick={ addRole }>Save</LoadingButton>
                        </Box> 
                        : ''
                        }

                    </Box>

                 
                    
          </Box>
       
        </Drawer>
      
      
   
       </Box>
    </Box>
  );
}
