import React from "react";
import { Box, Typography, Button } from "@mui/material";
import Link from "next/link";

const FeatureUnavailable = () => {
  return (
    <Box
      sx={{
        display: "flex",
        flexDirection: "column",
        alignItems: "center",
        justifyContent: "center",
        height: "100vh",
        textAlign: "center",
        padding: "20px",
        bgcolor: "#f9f9f9",
      }}
    >
      <Typography variant="h4" gutterBottom>
        Feature Not Available
      </Typography>
      <Typography variant="body1" color="textSecondary" mb={3}>
        This feature is not included in your current package. Upgrade now to
        unlock access to this feature.
      </Typography>
    
      <Link href="/" passHref>
        <Button variant="text" color="secondary" sx={{ textTransform: "none", mt: 2 }}>
          Go Back to Home
        </Button>
      </Link>
    </Box>
  );
};

export default FeatureUnavailable;
