import React, { useState, useEffect, useRef } from 'react';
import { IoSearchOutline, IoCloseOutline, IoTrash } from "react-icons/io5";
import { 
    Box, Grid, Chip, TextField, Switch, Typography, 
    MenuItem, Select, FormControl, Stack, Button, TableRow, Autocomplete,
    TableHead, TableContainer, TableCell, Modal, TableBody, Table, Menu, Tabs, Tab, Tooltip, IconButton, 
    FormGroup,
    FormControlLabel,
    FormLabel,
    Radio,RadioGroup,
    Checkbox,
    Card
} from '@mui/material';
import Drawer from "@mui/material/Drawer";
import PopupState, { bindTrigger, bindMenu } from 'material-ui-popup-state';
import { TfiPlus, TfiCalendar, TfiTrash } from "react-icons/tfi";
import { FaRegEdit } from "react-icons/fa";
import PropTypes from 'prop-types';
import ArrowDropDownIcon from '@mui/icons-material/ArrowDropDown';
import styles from '../styles/home.module.scss';
import Pagination from '../components/globlePagination';
import CloseSharpIcon from "@mui/icons-material/CloseSharp";
import CustomGroupDrawer from '../components/reported-mails/drawer/create-custom-group';
import SearchUserDrawer from '../components/reported-mails/drawer/searchuser-modal';
import api from '../utils/api';
import routes from '../utils/routes';
import { checkIsTacEnabled, checkNullByteInjection, getDate } from '../utils/common';
import { AppContext } from '../components/appcontext';
import { toast } from 'react-toastify';
import { apiError } from '../utils/error';
import swal from 'sweetalert'
import Alert from '@mui/material/Alert';
import CloseIcon from '@mui/icons-material/Close';
import Collapse from '@mui/material/Collapse';
import Cookies from 'js-cookie';
import CircularProgress from '@mui/material/CircularProgress';
import { useFeatures } from '../utils/features';
import { timezones } from '../utils/common';
import PublicIcon from '@mui/icons-material/Public';




function getScheduleDescription({ daysOfWeek = [], timeZone = null, hour = null, minute = null }) {
  const formattedHour = parseInt(hour, 10);
  const formattedMinute = minute.padStart(2, '0');
  const ampm = formattedHour >= 12 ? 'PM' : 'AM';
  const displayHour = formattedHour % 12 === 0 ? 12 : formattedHour % 12;
  const timeString = `${displayHour.toString().padStart(2, '0')}:${formattedMinute} ${ampm}`;

  const daysText = daysOfWeek.length === 0
    ? 'Daily'
    : daysOfWeek.length === 7
      ? 'Daily'
      : daysOfWeek.join(', ');

  return `${daysText} at ${timeString} (${timeZone})`;
}


export default function Groups() {
  const [anchorEl, setAnchorEl] = React.useState(null);
  const [openModal, setOpenModal] = React.useState(false);
  const [selectedAction, setSelectedAction] = React.useState(null);

  const isMessengerLimitReached = Cookies.get("MessengerLimitReached")
	const isEmailLimitReached = Cookies.get("EmailLimitReached")

  //Modal Manipulation
  const [isAdSync, setIsAdSync] = React.useState(false);
  

  //Importing all-users-tpir of a domain
  const [selectedDomain, setSelectedDomain] = React.useState("-1");

  //Importing Grous of a domain
  const [groups, setGroups] = React.useState([]);
  const [selectedGroups, setSelectedGroups] = React.useState([]);
  const [searchQuery, setSearchQuery] = React.useState("");
  const [debouncedSearchItem, setDebouncedSearchItem] = React.useState("");
  const [debouncedGroupSearch, setDebouncedGroupSearch] = React.useState('')


  const open = Boolean(anchorEl);

  const { canAccessFeature, loadFeatures, areFeaturesLoaded } = useFeatures()
  const isInitialRender = React.useRef(true);
  const [value, setValue] = React.useState(0);

  const [isTacEnabled, setIsTacEnabled] = React.useState(false);

  const [adminGroups, setAdminGroups] = React.useState([]);
  const [customGroups, setCustomGroups] = React.useState([]);
  const [group, setGroup] = React.useState("");
  const [groupUsers, setGroupUsers] = React.useState([]);
  const [isEditingGroup, setIsEditingGroup] = React.useState(false);
  const [idToAddUsersToGroup, setIdToAddUsersToGroup] = React.useState(null);
  const [usersToAddToGroup, setUsersToAddToGroup] = React.useState([]);
  const [domains, setDomains] = React.useState([]);
  const [loader, setLoader] = React.useState(false);
  const [showRetrySyncing, setShowRetrySyncing]  = React.useState(false)
  const [showSyncingInProgress, setShowSyncingInProgress] = React.useState(false)


  const [page, setPage] = React.useState(1);
  const [limit, setLimit] = React.useState(10);
  const [search, setSearch] = React.useState("");
  const [count, setCount] = React.useState(1);

  const [customGroupDrawerState, setCustomGroupDrawer] = React.useState(false);
  const [showSearchModal, setShowSearchModal] = React.useState(false);

  const [alertopen, setalertOpen] = React.useState(true);
  const remainingUserLimit = Cookies.get("URL")


  const [alertTwoopen, setalertTwoOpen] = React.useState(true);
  

  const handleClose = () => setOpenModal(false);

  // Configure Modal
  const [openConfigure, setConfigureOpen] = React.useState(false);
  const handleConfigureOpen = () => {setConfigureOpen(true), loadDomainList()};
  const handleConfigureClose = () => {setConfigureOpen(false), resetCron()};

// Drawer Configure your settings
  const [openSettime, setSettimeOpen] = useState(false);
  const closeSettingDrawer = () => {
    setSettimeOpen(false)
    setUserCron({
      ...userCron,
      days: [],
      hour: "12",
      minute: "00",
      timeZone: "Asia/Kolkata",
      selectedDomain: {domainId: "-1"},
      targetOption: "allUsers", 
      selectedGroups: [],    
      isEditingConfig: false,
      selectedDomainForEdit: null,
      isUserSyncMirrored: false
    })
    setTriggerLoadDomains(true)
  }

  const [triggerLoadDomains, setTriggerLoadDomains] = useState(false);

  React.useEffect(() => {
    if (triggerLoadDomains) {
      loadDomainList();
      setTriggerLoadDomains(false);
    }
  }, [triggerLoadDomains]);
  const toggleDrawer = (state, domainId) => () => {
    setSettimeOpen(state);
    console.log("ismsmsmsmmemememememe",userCron)
    if(!state){
      setUserCron({
        ...userCron,
        days: [],
        hour: "12",
        minute: "00",
        timeZone: "Asia/Kolkata",
        selectedDomain: {domainId: "-1"},
        targetOption: "allUsers", 
        selectedGroups: [],    
        isEditingConfig: false,
        selectedDomainForEdit: null,
        isUserSyncMirrored  : false
      })
    }
    if(domainId) handleEditDomainConfig(domainId)
  };



//-----
  const [autoSyncAnchorEl, setAutoSyncAnchorEl] = useState(null);
  const [openCron, setOpenCron] = React.useState(false);
  const autoSyncMenuOpen = Boolean(autoSyncAnchorEl);

  const [userCron, setUserCron] = React.useState({
    days: [],
    hour: "12",
    minute: "00",
    timeZone: "Asia/Kolkata",
    selectedDomain: {domainId: "-1"},
    targetOption: "allUsers", 
    selectedGroups: [],    
    autoSyncDomains: [], 
    isEditingConfig: false,
    selectedDomainForEdit: null,
    isUserSyncMirrored: false
  });

  const resetCron = () => {
    setUserCron({
     days: [],
     hour: "12",
     minute: "00",
     timeZone: "Asia/Kolkata",
     selectedDomain: {domainId: "-1"},
     targetOption: "allUsers",
     selectedGroups: [],
     availableGroups: [],
     autoSyncDomains: [],
     isEditingConfig: false,
     selectedDomainForEdit: null,
     isUserSyncMirrored  : false
    });
  };

  const handleEditDomainConfig = (domainId) => {
    const domainToEdit = userCron.autoSyncDomains.find(domain => domain._id === domainId);
    if (!domainToEdit) return;
  
    const sync = domainToEdit.isScheduledSyncing || {};
    console.log({sync})
  
    setUserCron(prev => ({
      ...prev,
      days: sync.daysOfWeek || [],
      hour: sync.hour || "12",
      minute: sync.minute || "00",
      timeZone: sync.timeZone || "Asia/Kolkata",
      targetOption: sync.syncType === "allUsers" ? "allUsers" : "specificGroups",
      selectedGroups: sync.groupIds || [],
      selectedDomain: {
        domainId: domainToEdit._id
      },
      isEditingConfig: true,
      selectedDomainForEdit: domainToEdit,
      isUserSyncMirrored: sync.isUserSyncMirrored || false
    }));

    console.log('groororo',userCron)
  };
  

  console.log("autoSyncDomains", userCron.autoSyncDomains)


  const handleTimeChange = (e) => {
    let time = e.target.value.split(":");
    setUserCron({ ...userCron, hour: time[0], minute: time[1] });
  };

  const handleTimeZoneChange = (e) => {
    console.log(e.target.value);
    setUserCron({ ...userCron, timeZone: e.target.value });
  };

  const handleDomainChangeForAutoSync = (e) => { 
    setUserCron(({ ...userCron, selectedDomain: { domainId:e.target.value } }));
  }

  const handleAutoSyncDropdownClick = (event) => {
    setAutoSyncAnchorEl(event.currentTarget);
  };

  const handleAutoSyncDropdownClose = () => {
    setAutoSyncAnchorEl(null);
  };

  const handleAutoSyncMenuItemClick = (action) => {
    if (action === "EnableAutoSync") {
      // enable auto sync logic
      setOpenCron(true);
    } else if (action === "DisableAutoSync") {
      // disable auto sync logic
    }
    handleAutoSyncDropdownClose();
  };


  const [availableGroups, setAvailableGroups] = useState([]);
  const debounceRef = useRef(null);

  useEffect(() => {
    setAvailableGroups([]);
  }, [userCron.selectedDomain.domainId, userCron.targetOption]);
  
  const validateAutoSyncInput = ({ days, userCron }) => {
    const { selectedDomain, selectedGroups, targetOption } = userCron;
  
    if ( days.length === 0) {
      toast.error("Kindly select days on which you would like to sync user!");
      return false;
    }
  
    if (selectedDomain.domainId === "-1") {
      toast.error("Kindly select a domain to schedule auto sync!");
      return false;
    }
  
    if (targetOption === "specificGroups" && selectedGroups.length === 0) {
      toast.error("Kindly select groups to schedule auto sync!");
      return false;
    }
  
    if (targetOption === "allUsers" && selectedDomain.domainId === "-1") {
      toast.error("Kindly select a domain to schedule auto sync!");
      return false;
    }
  
  
    return true;
  };
  

  const updateAutoSync = () => {
      let { days, hour, minute, timeZone } = userCron;
      if (!validateAutoSyncInput({ days, userCron })) return;
        api
          .post(routes.AUTO_SYNC.SCHEDULE, {
            domainId: userCron.selectedDomain.domainId,
            isActive: true,
            days,
            hour,
            minute,
            timeZone,
            syncType: userCron.targetOption,
            groupIds: userCron?.selectedGroups,
            isUserSyncMirrored: userCron.isUserSyncMirrored
          })
          .then(() => {
            toast.success("User syncing scheduled successfully!");
            // setOpenCron(false);
            closeSettingDrawer();
            console.log("---->",{userCron})
          })
          .catch((err) => {
            apiError(err);
          });
    };
console.log({grrrrrrr: userCron.selectedGroups})

  const removeAutoSync = (domainId) =>{
    api
      .post(routes.AUTO_SYNC.SCHEDULE, {
        isActive: false,
        domainId
      })
      .then(() => {
        toast.success("User syncing removed successfully!");
        loadDomainList();
      })
      .catch((err) => {
        apiError(err);
      });
  }

//----
    
  const handleDropdownClick = (event) => {
    setAnchorEl(event.currentTarget);
  };

  const handleDropdownClose = () => {
    setAnchorEl(null);
  };
  const handleMenuItemClick = (action) => {
    setSelectedAction(action);
    setOpenModal(true); // Open modal on selecting an action
    handleDropdownClose();
  };

  const handleCloseModal = () => {
    setOpenModal(false);
    //when a single domain's all-users-tpir are synced these state have to be emptied
    setSelectedDomain("-1");
    setIsAdSync(false);
    // setDomains([]);
    setGroups([]);
    setSelectedGroups([]);
    setSelectedAction(null); // Reset action on close
    loadDomainList();
  };

  const handleDomainSelect = (event) => {
    const domainId = event.target.value;
    setSelectedDomain(domainId);
  };

  const fetchGroups = async (domainId, query) => {
    if (selectedDomain !== "-1" || domainId) {
    let params = {
      domainId: domainId ? domainId : selectedDomain 
      // selectedDomain == "-1" ? domainId : selectedDomain, 
    };
    if (query != "") params["groupName"] = query;
    api
      .post(routes.USER_GROUPS.GET, params)
      .then((res) => res.data)
      .then((data) => {
        let arr = [];
        for (let i = 0; i < data.groups.length; i++) {
          let group = data.groups[i];
          if (group?.displayName)
            arr.push({ value: group.id, label: group.displayName });
          else arr.push({ value: group.id, label: group.name });
        }
        const mergedGroups = [
          ...selectedGroups,
          ...arr.filter(
            (group) =>
              !selectedGroups.some((selected) => selected.value === group.value)
          ),
        ];
        setGroups(mergedGroups);
      })
      .catch((error) => {
        apiError(error);
      });
    }
  };


  const fetchGroupsAutoSync = async (domainId, query) => {
    if (!domainId || domainId === "-1" || !query.trim()) return;
  
    try {
      const params = { domainId, groupName: query };
      const res = await api.post(routes.USER_GROUPS.GET, params);
      const data = res.data;
  
      const fetchedGroups = data.groups.map(group => ({
        _id: group.id,
        name: group.displayName || group.name,
      }));
  
      // Exclude already selected
      const selectedIds = userCron.selectedGroups.map(g => g._id);
      const uniqueGroups = fetchedGroups.filter(
        group => !selectedIds.includes(group._id)
      );
  
      setAvailableGroups(uniqueGroups);
    } catch (error) {
      apiError(error);
    }
  };
  
  


  const handleDomainSelectForGroups = async (event) => {
    const domainId = event.target.value;
    setSelectedDomain(domainId);
    setGroups([]);
    setSelectedGroups([]);
    setSearchQuery("");
    fetchGroups(domainId, "");
  };

  const handleGroupSelect = (event, newSelectedGroups) => {
    setSelectedGroups(newSelectedGroups);
  };

  const syncGroups = () => {
    if (selectedDomain && selectedDomain == '-1') {
      toast.error("Please select a domain.");
      return;
    }
    if (selectedGroups.length === 0) {
      toast.error("Please select at least one group to sync.");
      return;
    } 
    const groups = selectedGroups && selectedGroups.length > 0 ? selectedGroups : null;

    api
      .post(routes.USERS.SYNC, { groups: groups, domainId: selectedDomain })
      .then((res) => res.data)
      .then(async (data) => {
        toast.success(data.message);
        loadGroups();
        handleCloseModal();
        const decision = await swal({
          text:"Only unique users will be added and users that already belong to group with current access and accordingly access of group will be updated!",
          icon: "warning",
          dangerMode: true,
          closeOnEsc: true,
          buttons: {
            Close: true,
          },
        });
      })
      .catch((err) => {
        console.log(err);
        if (err.response.data.messages[0].code)
          toast.error(err.response.data.messages[0].code);
        else apiError(err);
      });
  };

  const toggleCustomGroupDrawer = (open) => (event) => {
    if (
      event.type === "keydown" &&
      (event.key === "Tab" || event.key === "Shift")
    ) {
      return;
    }
    setCustomGroupDrawer(open);
  };

  const toggleShowSearchModal = (open) => (event) => {
    if (
      event.type === "keydown" &&
      (event.key === "Tab" || event.key === "Shift")
    ) {
      return;
    }
    setShowSearchModal(open);
  };

  const handlePageChange = (event, value) => {
    setPage(value);
  };

  const switchTab = (event, newValue) => {
    setValue(newValue);
    loadGroups()
  };

  function TabPanel(props) {
    const { children, value, index, ...other } = props;
    return (
      <div
        role="tabpanel"
        hidden={value !== index}
        id={`simple-tabpanel-${index}`}
        aria-labelledby={`simple-tab-${index}`}
        {...other}
      >
        {value === index && <Box sx={{ p: 3 }}>{children}</Box>}
      </div>
    );
  }

  TabPanel.propTypes = {
    children: PropTypes.node,
    index: PropTypes.number.isRequired,
    value: PropTypes.number.isRequired,
  };

  function a11yProps(index) {
    return {
      id: `simple-tab-${index}`,
      "aria-controls": `simple-tabpanel-${index}`,
    };
  }


  const loadGroups = async () => {
    try {
      if(isTacEnabled) await fetchGroupUserCount();
    } catch (error) {
      console.error("Unexpected error in fetchGroupUserCount:", error);
    }
  
    console.log({ value });
  
    api
      .post(routes.GROUPS.LIST, { search, page })
      .then((res) => res.data)
      .then((data) => {
        setAdminGroups(data.adminGroups);
        if (data.customGroups && data.customGroups.length) setCustomGroups(data.customGroups);
  
        if (value == 0) setCount(data.adminGroupsCount);
        else setCount(data.customGroupsCount);
  
        setShowRetrySyncing(data?.showRetrySyncing);
        setShowSyncingInProgress(data?.showSyncingInProgress)
      })
      .catch((err) => {
        console.error("Error in loading groups", err);
        apiError(err);
      });
  };

  const [showRetry, setShowRetry] = React.useState(false)

  const fetchGroupUserCount = async () => {
    try {
      const res = await api.get(routes.ADMIN_CENTRAL.FETCH_GROUP_USER_COUNT);
      const data = res.data;
      setShowRetry(data?.showRetry)
    } catch (error) {
      console.error("Error from TA syncing group user counts", error);
    }
  };
  
  const loadGroup = (groupId) => {
    api
      .post(routes.GROUPS.GET, { groupId })
      .then((res) => res.data)
      .then((data) => {
        setGroup(data.group);
        setGroupUsers(data.groupUsers);
        setIsEditingGroup(true);
        toggleCustomGroupDrawer(true)({ type: "click" });
      });
  };
  const deleteGroup = (groupId) => {
    api
      .post(routes.GROUPS.DELETE, { groupId })
      .then((res) => res.data)
      .then((data) => {
        toast.success(data.message);
        loadGroups();
      })
      .catch((error) => {
        apiError(error);
      });
  };

  

  const changeAccess = (groupId, accessType, status) => {
    api
      .post(routes.GROUPS.CHANGE_ACCESS, { groupId, accessType, status })
      .then((res) => res.data)
      .then((data) => {
        loadGroups();
        toast.success(data.message);
      })
      .catch((err) => {
        apiError(err);
      });
  };

  const loadDomainList = () => {
    api
      .get(routes.DOMAIN.LIST)
      .then((res) => res.data)
      .then((data) => {
        let domainsWithCredentials = data?.domains.filter((domain) => domain.isCredential)
        let domainsWithAutoSyncEnabled = data?.domains.filter((domain) => domain.isScheduledSyncing.isActive)
        setDomains(domainsWithCredentials);
        setUserCron({...userCron, autoSyncDomains: domainsWithAutoSyncEnabled})

      })
      .catch((error) => {
        apiError(error);
      });
  };


  const retrySyncing = () =>{
    api
    .get(routes.ADMIN_CENTRAL.RETRY_SYNCING)
    .then((res) => res.data)
    .then((data) => {
      toast.success("Users will be synced shortly!")
      loadGroups()
    })
    .catch((error) => {
      apiError(error);
    });
  }

  const handleSearchInputChange = (event, newInputValue) => {
    setSearchQuery(newInputValue);
  };

  const loadLicence = () => {
		api.get(routes.HOME.LICENCE)
		.then(res=>res.data)
		.then((data)=>{
 			Cookies.set("URL",data.remainingUserLimit)
			Cookies.set("EmailLimitReached",data.utilisedEmailLimit >= data.user)
			Cookies.set("MessengerLimitReached",data.utilisedMessengerLimit >= data.messenger)
      isEmailLimitReached = Cookies.get("EmailLimitReached")
      isMessengerLimitReached = Cookies.get("MessengerLimitReached")
		})
		.catch((error)=>{
			apiError(error)
		})
	}


  console.log({test: (adminGroups && adminGroups.length>0)})

  React.useEffect(() => {
    console.log({isAdSync})
    if (isAdSync) loadDomainList();
    loadLicence()
  }, [isAdSync]);

  React.useEffect(() => {
    loadDomainList();
  }, []);

  React.useEffect(() => {
    setIsTacEnabled(checkIsTacEnabled());
    loadGroups();
  }, []);

  React.useEffect(() => {
    if(isTacEnabled) fetchGroupUserCount()
  }, [isTacEnabled]);

  React.useEffect(() => {
    loadGroups();
  }, [page]);

  React.useEffect(() => {
    fetchGroups(null, searchQuery);
  }, [debouncedSearchItem]);

  React.useEffect(() => {
      const handler = setTimeout(() => {
      setDebouncedSearchItem(searchQuery);
    }, 1000);

    return () => {
      clearTimeout(handler);
    };
  }, [searchQuery]);


  React.useEffect(() => {
    loadGroups();
  }, [debouncedGroupSearch]);

  React.useEffect(() => {
    const handler = setTimeout(()=>{
      setDebouncedGroupSearch(search)
    },2000)

    return ()=>{
      clearTimeout(handler)
    }
}, [search]);

React.useEffect(() => {
  setPage(1)
}, [search]);

React.useEffect(()=>{
 loadFeatures()
},[])

  return (
    <Box className={styles.contentbar}>
      <Box className={styles.containerbar}>
        <Box className={styles.breadcrumbBar}>
          <Grid
            container
            direction="row"
            justifyContent="center"
            alignItems="center"
          >
            <Grid item xs={4}>
              <Typography
                component="h4"
                variant="h4"
                className={styles.page_title}
              >
                Groups
              </Typography>
            </Grid>
            <Grid item xs={8} align="right">
              {!isTacEnabled && <Button
                variant="contained"
                className={`${styles.btn} ${styles.btnSecondary}`}
                onClick={handleDropdownClick}
                style={{ marginLeft: "10px" }} // Adjust spacing between buttons
                endIcon={<ArrowDropDownIcon />}
              >
                Bulk Operation
              </Button>}

              {/* Dropdown Menu */}
              <Menu
                anchorEl={anchorEl}
                open={open}
                onClose={handleDropdownClose}
              >
                <MenuItem onClick={() => handleMenuItemClick("ImportGroups")}>
                  Import Groups From AD
                </MenuItem>
              </Menu>

              {!isTacEnabled && (
              <Button
                variant="contained"
                className={`${styles.btn} ${styles.btnSecondary}`}
                onClick={handleAutoSyncDropdownClick}
                style={{ marginLeft: "10px" }}
                endIcon={<ArrowDropDownIcon />}
              >
                Auto Sync
              </Button>
            )}

            <Menu
              anchorEl={autoSyncAnchorEl}
              open={autoSyncMenuOpen}
              onClose={handleAutoSyncDropdownClose}
            >
              <MenuItem onClick={handleConfigureOpen}>
                Enable Auto Sync
              </MenuItem>

            </Menu>


              <Button
                variant="contained"
                className={`${styles.btn} ${styles.btnPrimary}`}
                onClick={toggleCustomGroupDrawer(true)}
              >
                <TfiPlus className={styles.icon_position} /> Create{" "}
                {isTacEnabled ? "Custom" : "New"} Group
              </Button>
            </Grid>
          </Grid>
        </Box>

        <Box className={styles.filterWrapper}>
          <Grid
            container
            direction="row"
            justifyContent="center"
            alignItems="center"
          >
            <Grid item xs={12} md={4} align="left" position="relative">
              <Box className={styles.TABAnalysis}>
                <Box sx={{ borderColor: "divider" }}>
                  <Tabs
                    value={value}
                    onChange={switchTab}
                    aria-label="basic tabs example"
                    className={styles.TabItemButton}
                  >
                    <Tab label="TA Directory" {...a11yProps(0)} />
                    {isTacEnabled && <Tab label="Custom" {...a11yProps(1)} />}
                  </Tabs>
                </Box>
              </Box>
            </Grid>

            <Grid item xs={12} md={8}>
              <Box className={styles.reportFitter}>
                <Box
                  className={`${styles.filterSearchBar} ${styles.groupsearchIcon}`}
                >
                  <TextField
                    className={styles.searchBar}
                    placeholder="Groups"
                    size="small"
                    fullWidth
                    value={search}
                    onChange={(e) => setSearch(e.target.value)}
                  />
                  <Typography component="span" className={styles.search_icon}>
                    <IoSearchOutline />
                  </Typography>
                </Box>
              </Box>
            </Grid>
          </Grid>
        </Box>

        <TabPanel value={value} index={0} className={styles.commontabPanel}>
          <Box className={styles.contentbarWrap}>
          {isEmailLimitReached && isEmailLimitReached == "true" &&
              <Collapse in={alertopen}>
              <Alert sx={{ mb: 2 }} severity="error" className={styles.alert} 
                action={
                        <IconButton
                          aria-label="close"
                          color="inherit"
                          onClick={() => {
                            setalertOpen(false);
                          }}
                        >
                          <CloseIcon fontSize="medium" />
                        </IconButton>
                      }
                >
                
                Your user license limit for Email Reporting has been reached.
                To add more users, please upgrade your license or remove existing users</Alert>
                </Collapse> 
          }


          {areFeaturesLoaded && canAccessFeature("TPIR-WA") && isMessengerLimitReached && isMessengerLimitReached == "true" && 
                <Collapse in={alertTwoopen}>
              <Alert sx={{ mb: 2 }} severity="error" className={styles.alert} 
                action={
                        <IconButton
                          aria-label="close"
                          color="inherit"
                          onClick={() => {
                            setalertTwoOpen(false);
                          }}
                        >
                          <CloseIcon fontSize="medium" />
                        </IconButton>
                      }
                >
                
                Your user license limit for Whatsapp Reporting has been reached.
                To add more users, please upgrade your license or remove existing users</Alert>
                </Collapse> 
          }
          {
            isTacEnabled && showRetry &&  showSyncingInProgress &&  
            <Alert className='alert' sx={{ mb: 2 }} severity="success"> Sycning in progress. Please Wait...</Alert>

          }
          {isTacEnabled && showRetry && showRetrySyncing &&
            <Alert className='alert' sx={{ mb: 2 }} severity="error"> Something went wrong while syncing users and groups. To resolve this, please click Retry to re-initiate the process. <a href='#' onClick={retrySyncing}>Retry</a></Alert>
          }

            <TableContainer className={styles.tableContainer}>
              <Table sx={{ minWidth: 650 }} aria-label="simple table">
                <TableHead className={styles.thead_background}>
                  <TableRow>
                    <TableCell>Group Name</TableCell>
                    <TableCell className="commonthCenter">Users</TableCell>
                    <TableCell>Created On</TableCell>
                    <TableCell>Last Updated</TableCell>
                    <TableCell>Email</TableCell>
                    {canAccessFeature("TPIR-WA") && <TableCell>Whatsapp</TableCell>}
                    {!isTacEnabled && (
                      <TableCell className="commonthCenter">Action</TableCell>
                    )}
                  </TableRow>
                </TableHead>

                <TableBody className={styles.DomainUser}>
                  {adminGroups &&
                    adminGroups.length != 0 &&
                    [...adminGroups].sort((a, b) => (a.isDefaultGroup ? -1 : b.isDefaultGroup ? 1 : 0)).map((group) => (
                      <TableRow>
                        <TableCell onClick={()=>loadGroup(group._id)}
                          component="td"
                          scope="row"
                          className={styles.onlyForPinter}
                        >
                          <Box className={styles.flexTableData}>                      
                            <Box className={styles.circle}>
                              <Typography
                                component="p"
                                className={styles.circleInner}
                              >
                                {group && group.groupName && group.groupName[0]}
                              </Typography>
                            </Box>
                                 
                            <Box>
                              <Typography variant="h5" sx={{display:'flex', alignItems:'center'}}>
                              {(group && group.groupName && group.isDefaultGroup ? 'All-Users-TPIR' : group.groupName) }
                              {group?.isSyncingUsers && <CircularProgress className="circularLoader" size={15} />}    
                              </Typography>
                            </Box>
                          </Box>
                        </TableCell>
                        <TableCell
                          component="td"
                          scope="row"
                          className="commontdCenter"
                        >
                          {group.userCount}
                        </TableCell>
                        <TableCell component="td" scope="row">
                          {getDate(group.createdAt)}
                        </TableCell>
                        <TableCell>{getDate(group.updatedAt)}</TableCell>
                        <TableCell component="td" scope="row">
                          <Switch
                            className={styles.SwitchTab}
                            onClick={() =>
                              changeAccess(
                                group._id,
                                "email",
                                group.emailAccess
                              )
                            }
                            checked={group?.emailAccess}
                            size="small"
                            color="success"
                          />
                        </TableCell>
                        {canAccessFeature("TPIR-WA") && (
                          <TableCell component="td" scope="row">
                            <Switch
                              className={styles.SwitchTab}
                              onClick={() =>
                                changeAccess(
                                  group._id,
                                  "messenger",
                                  group.messengerAccess
                                )
                              }
                              checked={group?.messengerAccess}
                              size="small"
                              color="success"
                            />
                          </TableCell>
                        )}
                        {!isTacEnabled &&  (
                          <TableCell
                            component="td"
                            scope="row"
                            className="commontdCenter"
                          >
                            <PopupState
                              variant="popover"
                              popupId="demo-popup-menu"
                            >
                              {(popupState) => (
                                <>
                                  <Button {...bindTrigger(popupState)} className={styles.btndottedSize}>
                                    ...
                                  </Button>
                                  <Menu {...bindMenu(popupState)}>
                                    {/* Admin Panel Case When TA is Disabled */}
                                    {!isTacEnabled &&
                                       (
                                        <MenuItem
                                          onClick={() => loadGroup(group._id)}
                                        >
                                          View
                                        </MenuItem>
                                      )}
                                    {!isTacEnabled &&
                                      group.groupName != "all-users-tpir" &&
                                      !group.isDefaultGroup && (
                                        <MenuItem
                                          onClick={() => deleteGroup(group._id)}
                                        >
                                          Delete
                                        </MenuItem>
                                      )}

                                    {/* Admin Panel Case When TA is Enabled - No Action can be taken on admin groups when ta is disabled */}
                                  </Menu>
                                </>
                              )}
                            </PopupState>
                          </TableCell>
                        )}
                      </TableRow>
                    ))}
                </TableBody>
              </Table>
            </TableContainer>
          </Box>
        </TabPanel>

        {isTacEnabled && (
          <TabPanel value={value} index={1} className={styles.commontabPanel}>
            <Box className={styles.contentbarWrap}>
              <TableContainer className={styles.tableContainer}>
                <Table sx={{ minWidth: 650 }} aria-label="simple table">
                  <TableHead className={styles.thead_background}>
                    <TableRow>
                      <TableCell>Group Name</TableCell>
                      <TableCell className="commonthCenter">Users</TableCell>
                      <TableCell>Created On</TableCell>
                      <TableCell>Last Updated</TableCell>
                      <TableCell>Email</TableCell>
                      {canAccessFeature("TPIR-WA") && <TableCell>Whatsapp</TableCell>}
                      <TableCell className="commonthCenter">Action</TableCell>
                    </TableRow>
                  </TableHead>
                  <TableBody className={styles.DomainUser}>
                    {customGroups &&
                      customGroups.map((group) => (
                        <TableRow
                          sx={{
                            "&:last-child td, &:last-child th": { border: 0 },
                          }}
                        >
                          <TableCell onClick={()=> loadGroup(group._id)}
                            component="td"
                            scope="row"
                            className={styles.onlyForPinter}
                          >
                            <Box className={styles.flexTableData}>
                              <Box className={styles.circle}>
                                <Typography
                                  component="p"
                                  className={styles.circleInner}
                                >
                                  {group &&
                                    group.groupName &&
                                    group.groupName[0]}
                                </Typography>
                              </Box>
                              <Box>
                                <Typography variant="h5">
                                {(group && group.groupName && group.isDefaultGroup ? 'All-Users-TPIR' : group.groupName) }
                                </Typography>
                              </Box>
                            </Box>
                          </TableCell>
                          <TableCell
                            component="td"
                            scope="row"
                            className="commontdCenter"
                          >
                            {group.userCount}
                          </TableCell>
                          <TableCell component="td" scope="row">
                            {getDate(group.createdAt)}
                          </TableCell>
                          <TableCell>{getDate(group.updatedAt)}</TableCell>
                          <TableCell component="td" scope="row">
                            <Switch
                              className={styles.SwitchTab}
                              checked={group?.emailAccess}
                              onClick={() =>
                                changeAccess(
                                  group._id,
                                  "email",
                                  group.emailAccess
                                )
                              }
                              size="small"
                              color="success"
                            />
                          </TableCell>
                          {canAccessFeature("TPIR-WA") && (
                            <TableCell component="td" scope="row">
                              <Switch
                                className={styles.SwitchTab}
                                checked={group?.messengerAccess}
                                onClick={() =>
                                  changeAccess(
                                    group._id,
                                    "messenger",
                                    group.messengerAccess
                                  )
                                }
                                size="small"
                                color="success"
                              />
                            </TableCell>
                          )}
                          <TableCell
                            component="td"
                            scope="row"
                            className="commontdCenter"
                          >
                            <PopupState
                              variant="popover"
                              popupId="demo-popup-menu"
                            >
                              {(popupState) => (
                                <>
                                  <Button {...bindTrigger(popupState)}>
                                    ...
                                  </Button>
                                  <Menu {...bindMenu(popupState)}>
                                    {group && group.type == "Custom" && (
                                      <MenuItem
                                        onClick={() => loadGroup(group._id)}
                                      >
                                        View
                                      </MenuItem>
                                    )}
                                    {group && group.type == "Custom" && !group.isDefaultGroup && (
                                      <MenuItem
                                        onClick={() => deleteGroup(group._id)}
                                      >
                                        Delete
                                      </MenuItem>
                                    )}
                                  </Menu>
                                </>
                              )}
                            </PopupState>
                          </TableCell>
                        </TableRow>
                      ))}
                  </TableBody>
                </Table>
                <Stack
                  spacing={2}
                  direction="row"
                  justifyContent="space-between"
                  alignItems="center"
                >
                </Stack>
              </TableContainer>
            </Box>
          </TabPanel>
        )}
        {(value === 0 || value === 1) && (
        (value === 0 ? adminGroups?.length > 0 : customGroups?.length > 0) ? (
            <Stack spacing={2} direction="row" justifyContent="space-between" alignItems="center">
                <Pagination 
                    count={count} 
                    page={page}
                    limit={limit}
                    handlePageChange={handlePageChange}
                />
            </Stack>
        ) : (
            <Box className={styles.noRecordMail}>
                <Typography component="p" style={!loader ? {} : { color: "green" }}>
                    {!loader ? "No Records Found!" : "Loading..."}
                </Typography>
            </Box>
        )
    )}

                      
      </Box>

      <CustomGroupDrawer
        open={customGroupDrawerState}
        onClose={toggleCustomGroupDrawer}
        searchButtonOnClickHandler={() => {
          setShowSearchModal(true);
        }}
        group={group}
        setGroup={setGroup}
        groupUsers={groupUsers}
        setGroupUsers={setGroupUsers}
        isEditingGroup={isEditingGroup}
        setIsEditingGroup={setIsEditingGroup}
        setIdToAddUsersToGroup={setIdToAddUsersToGroup}
        usersToAddToGroup={usersToAddToGroup}
        setUsersToAddToGroup={setUsersToAddToGroup}
        loadGroups={loadGroups}
        loadGroup={loadGroup}
        isTacEnabled={isTacEnabled}
      />
      {showSearchModal && (
        <SearchUserDrawer
          open={customGroupDrawerState}
          onClose={toggleShowSearchModal}
          idToAddUsersToGroup={idToAddUsersToGroup}
          setIdToAddUsersToGroup={setIdToAddUsersToGroup}
          setUsersToAddToGroup={setUsersToAddToGroup}
          usersToAddToGroup={usersToAddToGroup}
        />
      )}
      <Modal
        open={openModal}
        onClose={handleCloseModal}
        aria-labelledby="modal-title"
        aria-describedby="modal-description"
        className={styles.mainModalBox}
      >
        <Box className={styles.modalBox}>
          {/* Modal Content Based on Selected Action */}
          {selectedAction === "ImportGroups" && (
            <>
              <Box className={styles.modalHeader}>
              <Box>
                  <Box display="flex" alignItems="center">
                    <Typography variant="h6">Bulk Import Groups</Typography>
                    <Tooltip title="Bulk operation only does incremental sync: it will only add new users or update existing ones since the last run; deletions (users removed from groups) are not processed." arrow>
                      <IconButton size="small">
                        <PublicIcon fontSize="small" color="action" />
                      </IconButton>
                    </Tooltip>
                  </Box>
                  <Typography component="p">
                  Synchronize your groups from Active Directory
                  </Typography>
                </Box>

                <CloseSharpIcon
                  className={styles.closeIcon}
                  onClick={handleClose}
                />
              </Box>

              <Box className={styles.modalBody}>
                <label
                  sx={{
                    fontWeight: "600",
                    fontSize: "14px",
                    color: " #6c757d",
                  }}
                >
                  Domains
                </label>
                <Select
                value={selectedDomain}
                onChange={handleDomainSelectForGroups}
                fullWidth
                displayEmpty
                className={styles.inputSelect}
                >
                <MenuItem value="-1" disabled>
                  Select a Domain
                </MenuItem>
                  {domains.map(domain => (
                    <MenuItem key={domain._id} value={domain._id}>
                      <Box display="flex" justifyContent="space-between" width="100%">
                        <Typography component="span">
                          {domain.domainName}
                        </Typography>
                        <Typography
                          component="span"
                          className={`${styles.badge} ${styles.badgePrimary}`}
                        >
                          {domain.domainType === 'Outlook'
                            ? domain.domainTypeForOutlook
                            : domain.domainType}
                        </Typography>
                      </Box>
                    </MenuItem>
                  ))}
              </Select>
              <Alert className={styles.alert} severity="info">Your remaining total user limit is {remainingUserLimit ? remainingUserLimit : ''}. Ensure your group has no more than {remainingUserLimit ? remainingUserLimit : ''} users; otherwise, only the first {remainingUserLimit ? remainingUserLimit : ''} users will be synced.</Alert>
              </Box>

              {selectedDomain != "-1" ? (
                <Autocomplete
                  multiple
                  options={groups}
                  getOptionLabel={(option) => option.label}
                  value={selectedGroups}
                  onChange={handleGroupSelect}
                  filterSelectedOptions
                  filterOptions={(options) => options}
                  onInputChange={handleSearchInputChange}
                  renderInput={(params) => (
                    <TextField
                      {...params}
                      label="Search and Select Groups"
                      placeholder="Groups"
                      sx={{ mt: 2 }}
                    />
                  )}
                />
              ) : (
                ""
              )}

              <Box className={styles.modalFooter}>
                <Grid container>
                  <Grid item xs={12} md={12} align="right" position="relative">
                    <Button variant="contained" onClick={syncGroups}>
                      Sync Groups
                    </Button>
                  </Grid>
                </Grid>
              </Box>
            </>
          )}

          {selectedAction === "UploadUsers" && (
            <>
              <Box className={styles.modalHeader}>
                <Box>
                  <Typography variant="h6">Import Users From CSV</Typography>
                  <Typography component="p">
                  Select the domain and group for which you want to add users
                  </Typography>
                </Box>

                <CloseSharpIcon
                  className={styles.closeIcon}
                  onClick={handleClose}
                />
              </Box>

              <Box className={styles.modalBody}>
                <label
                  sx={{
                    fontWeight: "600",
                    fontSize: "14px",
                    color: " #6c757d",
                  }}
                >
                  Domains
                </label>
                <Select
                  value={selectedDomain}
                  onChange={handleDomainSelect}
                  fullWidth
                  displayEmpty
                  className={styles.inputSelect}
                >
                  <MenuItem value="-1" disabled>
                    Select a Domain
                  </MenuItem>
                  {domains.map((domain) => (
                    <MenuItem key={domain._id} value={domain._id}>
                      {domain.domainName}{" "}
                      {/* Replace with actual domain name field */}
                    </MenuItem>
                  ))}
                </Select>
              </Box>



              {selectedDomain && selectedDomain !== "-1" && selectedGroupForUploadingUser ? (
                <Box className={styles.rightContent}>
                    <Typography variant="h5">Upload File</Typography>
                    <TextField
                    size="small"
                    type="file"
                    id="myFile"
                    inputRef={fileInputRef}
                    onChange={uploadUsersFile}
                    name="filename"
                    accept=".csv, .xlsx, .xls"
                    fullWidth
                    sx={{ mb: "14px" }}
                    />
                </Box>
                ) : null}

            {selectedDomain!=='-1' && fileData && selectedGroupForUploadingUser &&
              (<Box className={styles.modalFooter}>
                <Grid container>
                  <Grid item xs={12} md={12} align="right" position="relative">
                    <Button variant="contained" onClick={UploadUsers}>
                      Upload users
                    </Button>
                  </Grid>
                </Grid>
              </Box>)
            }    
            </>
          )}
           
        </Box>
      </Modal>

      

{/* Configure Modal */}
        <Modal
          open={openConfigure}
          onClose={handleConfigureClose}
          aria-labelledby="add domain"
          aria-describedby="add domain"
         className={`${styles.modal} ${styles.configureModal}`}
        >
          <Box className={styles.modalBox}>
            <Box className={styles.modalHeader}>
              <Typography id="modal-modal-title" variant="h6" component="h2">
               Configure Auto Sync <br></br>
                <span>Auto Sync Configurations</span>
              </Typography>
              <CloseSharpIcon
                className={styles.closeIcon}
                onClick={handleConfigureClose}
              />
            </Box>

            <Box className={`${styles.EpmloyeeModal} ${styles.timePacker}`}>
            <Box className={styles.syncContainer}>
            {/* No auto sync setup box */}
            {userCron?.autoSyncDomains && Array.isArray(userCron.autoSyncDomains) && userCron.autoSyncDomains.length === 0 && (
              <Box
                sx={{
                  border: '1px dashed #ccc',
                  borderRadius: 2,
                 padding:'20px',
                  textAlign: 'center',
                  backgroundColor: '#f9f9f9',
                  height: '100%',
                  display: 'flex',
                  justifyContent: 'center',
                  alignItems: 'center',
                }}
              >
                <Stack spacing={2} alignItems="center">
                  <PublicIcon sx={{ fontSize: 40, color: '#7b7f86' }} />
                  <Typography variant="h6" fontWeight={500} sx={{fontSize:"18px"}}>
                    No Domains Configured
                  </Typography>
                  <Typography variant="body2" color="text.secondary" sx={{marginTop:"5px !important"}}>
                    You haven't set up any domains for auto-syncing yet.
                  </Typography>
                 
                </Stack>
              </Box>  
            )}
            {/* No auto sync box */}

              <Box className={styles.syncList}>
                {userCron?.autoSyncDomains?.length > 0 &&
                  userCron.autoSyncDomains.map((domain, index) => (
                    <Card className={styles.syncCard} key={index}>
                      <Box className={styles.synccardContent}>
                        <Box>
                          <Box display="flex" alignItems="center">
                            <h3 className={styles.syncDomain}>{domain?.domainName}</h3>
                            <Typography
                              component="span"
                              className={`${styles.badge} ${styles.badgePrimary}`}
                              sx={{ marginLeft: '0.5rem' }}
                            >
                              {domain.domainType === 'Outlook'
                                ? domain.domainTypeForOutlook
                                : domain.domainType}
                            </Typography>
                          </Box>
                          <p className={styles.syncSchedule}>
                            {getScheduleDescription({
                              daysOfWeek: domain?.isScheduledSyncing?.daysOfWeek,
                              timeZone: domain?.isScheduledSyncing?.timeZone,
                              hour: domain?.isScheduledSyncing?.hour,
                              minute: domain?.isScheduledSyncing?.minute,
                            })}
                          </p>
                        </Box>
                        <Box className={styles.syncActions}>
                          <button
                            className={styles.iconButton}
                            onClick={() => toggleDrawer(true, domain._id)()}
                          >
                            <FaRegEdit size={16} />
                          </button>
                          <button
                            className={styles.iconButton}
                            onClick={() => removeAutoSync(domain._id)}
                          >
                            <TfiTrash size={16} />
                          </button>
                        </Box>
                      </Box>
                    </Card>
                  ))}
                <button
                  className={styles.configurationBtn}
                  style={{ backgroundColor: '#0e2954', color: 'white' }}
                  onClick={() => toggleDrawer(true, null)()}
                >
                  Add New Configuration
                </button>
              </Box>
             </Box>
            </Box>

            
            </Box>
        </Modal>

        <Drawer
            anchor="right"
            open={openSettime}
            onClose={toggleDrawer(false)}
            className={`${styles.Linkmaindrawer} ${styles.configureSettingsModal}`}
          >
          <Box className={styles.closebtn}>
            <IoCloseOutline onClick={closeSettingDrawer} />
          </Box>

          <Box className={styles.commonModalWrapper}>
            <Box className={styles.modalHeader}>
              <Typography variant="h6">Set Now</Typography>
              <Typography component="p">Configure your settings</Typography>
            </Box>
          </Box>

            <Box className={`${styles.EpmloyeeModal} ${styles.timePacker}`} sx={{ display: 'flex', flexDirection: 'column', height: '90vh' }}>
              <Box className={`${styles.AddEmployeeModal} ${styles.modalScroll}`} sx={{ flexGrow: 1, overflowY: 'auto', padding: '16px' }}>
                <>
                  {/* Select Domain */}
                  <Box className={styles.modalinputField}>
                    <FormControl fullWidth>
                      <label>Select Domain</label>
                      <Select
                        labelId="demo-simple-select-label"
                        id="demo-simple-select"
                        disabled={userCron?.isEditingConfig}
                        value={userCron?.selectedDomain?.domainId}
                        onChange={handleDomainChangeForAutoSync}
                        displayEmpty
                        size="small"
                        className="selectTimeZone"
                        sx={{ marginBottom: "14px", fontSize: "14px" }}
                      >
                        <MenuItem value="-1" disabled>Select Domain</MenuItem>
                          {domains.map((domain, index) => (
                            <MenuItem
                              key={index}
                              value={domain._id}
                              sx={{ fontSize: "14px", marginTop: "0.5rem" }}
                            >
                              <Box display="flex" justifyContent="space-between" width="100%">
                                <Typography component="span">
                                  {domain.domainName}
                                </Typography>
                                <Typography
                                  component="span"
                                  className={`${styles.badge} ${styles.badgePrimary}`}
                                >
                                  {domain.domainType === 'Outlook'
                                    ? domain.domainTypeForOutlook
                                    : domain.domainType}
                                </Typography>
                              </Box>
                            </MenuItem>
                          ))}
                      </Select>
                    </FormControl>
                  </Box>

                  {/* Select Target */}
                  {userCron.selectedDomain.domainId !== '-1' && (
                    <Box className={styles.modalinputField}>
                      <FormControl component="fieldset">
                        <FormLabel component="legend">Select Target</FormLabel>
                        <RadioGroup
                          row
                          name="targetOption"
                          value={userCron?.targetOption || "allUsers"}
                          onChange={(e) =>
                            setUserCron((prev) => ({
                              ...prev,
                              targetOption: e.target.value,
                            }))
                          }
                        >
                          <FormControlLabel value="allUsers" control={<Radio />} label="All Users" />
                          <FormControlLabel value="specificGroups" control={<Radio />} label="Specific Groups" />
                        </RadioGroup>
                      </FormControl>
                    </Box>
                  )}

                  {userCron.selectedDomain.domainId !== '-1' && (
                    <Box className={styles.modalinputField}>
                      <FormControl component="fieldset">
                        <FormLabel component="legend">Sync Type</FormLabel>
                        <RadioGroup
                          row
                          name="isUserSyncMirrored"
                          value={userCron?.isUserSyncMirrored ? 'mirror' : 'incremental'}
                          onChange={(e) =>
                            setUserCron((prev) => ({
                              ...prev,
                              isUserSyncMirrored: e.target.value === 'mirror',
                            }))
                          }
                        >
                          <FormControlLabel value="incremental" control={<Radio />} label="Incremental Sync" />
                          <FormControlLabel value="mirror" control={<Radio />} label="Mirror Sync" />
                        </RadioGroup>
                      </FormControl>
                    </Box>
                  )}  

                  {/* Select Groups */}
                  {userCron.targetOption === "specificGroups" && (
                    <Box className={styles.modalinputField}>
                      <label>Select Groups</label>
                      <Autocomplete
                        multiple
                        size="small"
                        options={availableGroups}
                        getOptionLabel={(option) => option.name}
                        value={userCron.selectedGroups}
                        filterSelectedOptions
                        onChange={(event, newValue) => {
                          setUserCron((prev) => ({
                            ...prev,
                            selectedGroups: newValue,
                          }));
                        }}
                        onInputChange={(event, value, reason) => {
                          clearTimeout(debounceRef.current);
                        
                          if (reason === "input") {
                            if (value.trim() === "") {
                              setAvailableGroups([]);
                            } else {
                              debounceRef.current = setTimeout(() => {
                                fetchGroupsAutoSync(userCron.selectedDomain.domainId, value);
                              }, 1000);
                            }
                          }
                        
                          if (reason === "clear" || reason === "reset") {
                            setAvailableGroups([]);
                          }
                        }}
                        isOptionEqualToValue={(option, value) => option._id === value._id}
                        renderInput={(params) => (
                          <TextField {...params} placeholder="Search groups to select" />
                        )}
                      />
                    </Box>
                  )}

                  {/* Select Timezone */}
                  <Box className={styles.modalinputField}>
                    <FormControl fullWidth>
                      <label>Select Timezone</label>
                      <Select
                        labelId="demo-simple-select-label"
                        id="demo-simple-select"
                        value={userCron.timeZone}
                        onChange={handleTimeZoneChange}
                        displayEmpty
                        size="small"
                        className="selectTimeZone"
                        sx={{ marginBottom: "14px", fontSize: "14px" }}
                      >
                        <MenuItem value="" disabled>Select Timezone</MenuItem>
                        {timezones.map((timezone, index) => (
                          <MenuItem
                            key={index}
                            value={timezone}
                            sx={{ fontSize: "14px", marginTop: "0.5rem" }}
                          >
                            {timezone}
                          </MenuItem>
                        ))}
                      </Select>
                    </FormControl>
                  </Box>

                  {/* Select Time */}
                  <Box className={styles.modalinputField}>
                    <label>Select Time</label>
                    <TextField
                      className={styles.inputfild}
                      id="time"
                      type="time"
                      value={`${userCron.hour}:${userCron.minute}`}
                      onChange={handleTimeChange}
                      InputLabelProps={{ shrink: true }}
                      inputProps={{ step: 300 }}
                    />
                  </Box>

                  {/* Select Days */}
                  <Box className={styles.checkBox}>
                    <label
                      sx={{
                        fontWeight: "600",
                        fontSize: "14px",
                        color: " #6c757d",
                      }}
                    >
                      Select Days
                    </label>

                    <Box className={styles.dFlex}>
                      {/* First Column */}
                      <Box>
                        <FormGroup>
                          {["All", "Monday", "Tuesday", "Wednesday"].map((day) => (
                            <FormControlLabel
                              key={day}
                              control={
                                <Checkbox
                                  name={day}
                                  checked={
                                    day === "All"
                                      ? ["Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"]
                                          .every(d => userCron.days.includes(d))
                                      : userCron.days.includes(day)
                                  }
                                />
                              }
                              onClick={(e) => {
                                const name = e.target.name;
                                if (name === "All") {
                                  setUserCron((prev) => ({
                                    ...prev,
                                    days: userCron.days.includes("All")
                                      ? []
                                      : [
                                          "All",
                                          "Monday",
                                          "Tuesday",
                                          "Wednesday",
                                          "Thursday",
                                          "Friday",
                                          "Saturday",
                                          "Sunday",
                                        ],
                                  }));
                                } else {
                                  setUserCron((prev) => ({
                                    ...prev,
                                    days: userCron.days.includes(name)
                                      ? userCron.days.filter((d) => d !== name)
                                      : [...userCron.days, name],
                                  }));
                                }
                              }}
                              label={day === "All" ? "All Days" : day}
                            />
                          ))}
                        </FormGroup>
                      </Box>

                      {/* Second Column */}
                      <Box>
                        <FormGroup>
                          {["Thursday", "Friday", "Saturday", "Sunday"].map((day) => (
                            <FormControlLabel
                              key={day}
                              control={
                                <Checkbox
                                  name={day}
                                  checked={userCron?.days?.includes(day)}
                                />
                              }
                              onClick={(e) => {
                                const name = e.target.name;
                                setUserCron((prev) => ({
                                  ...prev,
                                  days: userCron.days.includes(name)
                                    ? userCron.days.filter((d) => d !== name)
                                    : [...userCron.days, name],
                                }));
                              }}
                              label={day}
                            />
                          ))}
                        </FormGroup>
                      </Box>
                    </Box>
                  </Box>
                </>
              </Box>

              {/* Footer */}
              <Box className={styles.modalFooter} sx={{ padding: '12px 16px', borderTop: '1px solid #eee', backgroundColor: '#fff', position: 'sticky', bottom: 0, zIndex: 10, }}>
                <button
                  loadingposition="start"
                  id="employee"
                  variant="contained"
                  className={styles.primaryBtn}
                  sx={{ mb: "30px" }}
                  onClick={updateAutoSync}
                >
                  Save
                </button>
              </Box>
            </Box>
      </Drawer>

        
      
    </Box>
    
  );
}