import Link from "next/link";
import * as React from "react";
import dynamic from 'next/dynamic';
import PropTypes from 'prop-types';
import { styled } from '@mui/material/styles';
import { FaWhatsapp, FaRegCommentAlt } from "react-icons/fa";
import { TfiUser, TfiAlert, TfiEmail, TfiWorld, TfiCommentAlt, TfiLink } from "react-icons/tfi";
import { toast } from 'react-toastify';
import Alert from '@mui/material/Alert';
import IconButton from '@mui/material/IconButton';
import CloseIcon from '@mui/icons-material/Close';
import Collapse from '@mui/material/Collapse';
import { 
	Box, Grid, Typography, LinearProgress, linearProgressClasses,  
	TableRow, TableHead, TableContainer, TableCell, TableBody, Table, Tab, Tabs, Button
} from "@mui/material";
import Divider from '@mui/material/Divider';
import api from '../utils/api';
import routes from "../utils/routes";
import { useRouter } from 'next/router';
import { checkIsTacEnabled, getDate, getExtensionFromFileName, timeInAgoFormat1 } from "../utils/common";
import { apiError } from '../utils/error';
import styles from "../styles/dasboard.module.scss";
import { getDatewithoutTime, timeInAgoFormat } from '../utils/common';
import ModalCommon from "../components/modalCommon";
import { BsPersonBoundingBox } from "react-icons/bs";
import { BsLink45Deg} from "react-icons/bs";
import { AppContext } from "../components/appcontext";
import { BsPaperclip } from "react-icons/bs";
import { BsDownload } from "react-icons/bs";
import { AiOutlineCopy } from "react-icons/ai";
import Cookies from "js-cookie";
import { useFeatures } from "../utils/features";
import Image from "next/image";
import Listing from "../assets/taconnect/Listing.png";
import ConnectTaModal from "../components/connect-ta-modal/connect-ta"

import NewconnecttaModal from "../components/connect-ta-modal/new-connect"

import Gamesimg from "../assets/taconnect/Gamesimg.png";
import leaderboard from "../assets/taconnect/leaderboard.svg";

import TPIRQR from "../assets/taconnect/TPIR.png";

const Chart = dynamic(() => import('react-apexcharts'), { ssr: false });
// const Amchart = dynamic(() => import('../components/amchart'), { ssr: false });
// import Amchart from "../components/amchart"

const BorderLinearProgress = styled(LinearProgress)(({ theme }) => ({
	height: 10,
	borderRadius: 5,
	[`&.${linearProgressClasses.colorPrimary}`]: {
	  backgroundColor: theme.palette.grey[theme.palette.mode === 'light' ? 200 : 800],
	},
	[`& .${linearProgressClasses.bar}`]: {
	  borderRadius: 5,
	  backgroundColor: theme.palette.mode === 'light' ? '#1a90ff' : '#308fe8',
	},
}));

export default function Home(props) {
	const [openunle, setOpenunle] = React.useState(true);
	const [open, setOpen] = React.useState(true);
	const [openAlerttwo, setAlerttwoOpen] = React.useState(true);
	const [value, setValue] = React.useState(0)

	const { setDomains, setDomainChange } = React.useContext(AppContext);


	const [taStatus, setTaStatus] = React.useState({
		enabled: false,
		connecting: false,
		isNewCompany: false
	})  

	const [loadingTa, setLoadingTa] = React.useState(true)

	console.log({taStatus})

	const router = useRouter();

	
	const isMessengerLimitReached = Cookies.get("MessengerLimitReached")
	const isEmailLimitReached = Cookies.get("EmailLimitReached")


	const [ summary, setSummary ] = React.useState({
		totalReportedMails: '',
		domains: '',
		emailChecked: '',
		users: '',
		whatsappMessages: '',
		contacts:''
	})


	function TabPanel(props) {
		const { children, value, index, ...other } = props;
	  
		return (
		  <div
			role="tabpanel"
			hidden={value !== index}
			id={`vertical-tabpanel-${index}`}
			aria-labelledby={`vertical-tab-${index}`}
			{...other}
		  >
			{value === index && (
			  <Box sx={{ p: 3 }}>
				<Typography>{children}</Typography>
			  </Box>
			)}
		  </div>
		);
	  }

	  TabPanel.propTypes = {
		children: PropTypes.node,
		index: PropTypes.number.isRequired,
		value: PropTypes.number.isRequired,
	  };
	  

	function a11yProps(index) {
		return {
		  id: `simple-tab-${index}`,
		  'aria-controls': `simple-tabpanel-${index}`,
		};
	  }

	const [ recent, setRecent ] = React.useState([])
	const [ topReporters, setTopReporters ] = React.useState({
		reporters:[],
		total:''
	}) 
	const [ topSenders, setTopSenders ] = React.useState() 

	const [ dailyMails, setDailyMails ] = React.useState('') 

	const [highestReportedMails, setHighestReportedMails] = React.useState([])


	// const [taConnectopen, setTaOpen] = React.useState(false);
	// const taConnecthandleOpen = () => setTaOpen(true);
	// const taConnecthandleClose = () => setTaOpen(false);


// New TA Connect 
const [taConnectopen, setTaOpen] = React.useState(false);

const taConnecthandleOpen = () => setTaOpen(true);
const taConnecthandleClose = () => setTaOpen(false);


// End




	const [ whoElse, setWhoElse ] = React.useState({
		trashedMails: 0, 
		suspiciousMails: 0, 
		pendingMails: 0,
		safeMails: 0
	})

	const [ messengerOverview, setMessengerOverview ] = React.useState({
		dailyReportedMessages:[],
		topUrls:[],
		messages:[],
		topReporters:{},
		topSenders: [],
		recentUnsafeMessages: [],
		actionSummary:{}
	})

	const { loadFeatures, canAccessFeature, areFeaturesLoaded } = useFeatures();
  

	const { isLite } = React.useContext(AppContext);
	const donut = {
		series: [ whoElse.pendingMails, whoElse.safeMails, whoElse.trashedMails, whoElse.suspiciousMails ],
		options: {
			chart: {
				type: 'donut',
				colors: ['#000', '#E5C6A0',],
			},
			
			plotOptions: {
				pie: {
					donut: {
						size: '82%',
						labels: {
							show: true,
							total: {
								fontSize: 12,
								showAlways: true,
								show: true
							},
							name: {
								fontSize: 12,
							  },
							  value: {
								fontSize: 12,
								offsetY: -1,
							  }
						}
					}
				}
			},

			dataLabels: {
				enabled: false
			},
			
			legend: {
				show: false	
			},
			labels:["Action Pending","Recovered Mails","Trashed Mails","Deleted Mails"],
			responsive: [{
				breakpoint: 480,
				options: {
					chart: {
						width: 170
					},
					
				}
			}]
		},
	}

	const messageDonut = {
		series: [
			messengerOverview.actionSummary.safe,
			messengerOverview.actionSummary.unsafe,
			messengerOverview.actionSummary.dubious
		],
		options: {
			chart: {
				type: 'donut',
			},
			colors: ['#00E396', '#FF4560', '#FEB019'], // Green for safe, red for unsafe, orange for dubious
			
			plotOptions: {
				pie: {
					donut: {
						size: '82%',
						labels: {
							show: true,
							total: {
								fontSize: 12,
								showAlways: true,
								show: true
							},
							name: {
								fontSize: 12,
							},
							value: {
								fontSize: 12,
								offsetY: -1,
							}
						}
					}
				}
			},
	
			dataLabels: {
				enabled: false
			},
			
			legend: {
				show: false
			},
			labels: ["Safe Messages", "Unsafe Messages", "Dubious Messages"],
			responsive: [{
				breakpoint: 480,
				options: {
					chart: {
						width: 170
					},
				}
			}]
		}
	}
	


// Daily Mail Reported
const areaNew = {      
	series: [{
		name: 'Mails Reported',
	  data: [
		...dailyMails	
	  ]
	}],
	
	options: {
	  chart: {
		id: 'area-datetime',
		type: 'area',
		height: 350,
		toolbar:{
		  show:false
		},
		
		zoom: {
		  autoScaleYaxis: true
		}
	  },
	  dataLabels: {
		enabled: false,
	  },
	 
	  markers: {
		size: 0,
		style: 'hollow',
	  },
	
	  
	//   xaxis: {
	// 	type: 'datetime',
	// 	min: new Date(Date.now() - 30 * 24 * 60 * 60 * 1000).getTime(),
	// 	tickAmount: 6,
	// 	labels: {
    //         style: {
    //             fontSize: '11px'
    //         }
    //    }
	   xaxis: {
		type: 'datetime',
		range: 60 * 24 * 60 * 60 * 1000,
		tickAmount: 6,
		labels: {
			style: {
				fontSize: '11px'
			}
		}
	},

	//   tooltip: {
		
	// 	x: {
	// 	  format: 'dd MMM yyyy'
	// 	}
	//   },
	  fill: {
		type: 'gradient',
		colors: ['#3583cc'],
	
		gradient: {
		  shadeIntensity: 1,
		  opacityFrom: 0.7,
		  opacityTo: 0.9,
		  stops: [0, 100],
		}
	  },
	},
  
  
	selection: 'one_year',
  
  }; 
// end



	//  Bar Charts 
	const barchart = {
		  series: [
			  {
				name:"Messages Reported",
              data: topReporters ? topReporters.total.length ? topReporters.total : [] : []
            }],
            options: {
              chart: {
                type: 'bar',
                height: 150,
				toolbar:{
					show:false
				  },
              },
              plotOptions: {
                bar: {
                  borderRadius: 0,
                  horizontal: true,
				  barHeight:"20%"
                },
              },
              dataLabels: {
                enabled: false
              },
			  colors: ['#3583cc'],
              xaxis: {
                categories: topReporters ? topReporters.reporters.length ? topReporters.reporters : [] : [],
			
              }
            },
	}

	// end


	const barchartForMessenger = {
		series: [
			{
			name:"Messages Reported",
			data: messengerOverview ? messengerOverview.topReporters ? messengerOverview.topReporters.count ? messengerOverview.topReporters.count.length ?  messengerOverview.topReporters.count : [] : [] : [] : []
		  }],
		  options: {
			chart: {
			  type: 'bar',
			  height: 150,
			  toolbar:{
				  show:false
				},
			},
			plotOptions: {
			  bar: {
				borderRadius: 0,
				horizontal: true,
				barHeight:"20%"
			  },
			},
			dataLabels: {
			  enabled: false
			},
			colors: ['#3583cc'],
			xaxis: {
			  categories: messengerOverview ? messengerOverview.topReporters ? messengerOverview.topReporters.reporters ? messengerOverview.topReporters.reporters.length ? messengerOverview.topReporters.reporters : [] : [] : [] : [],
		  
			}
		  },
  }

	const areaNewForMessenger = {      
		series: [{
			name: 'Messages Reported',
		  data: [
			...messengerOverview.dailyReportedMessages	
		  ]
		}],
		
		options: {
		  chart: {
			id: 'area-datetime',
			type: 'area',
			height: 350,
			toolbar:{
			  show:false
			},
			
			zoom: {
			  autoScaleYaxis: true
			}
		  },
		  dataLabels: {
			enabled: false,
		  },
		 
		  markers: {
			size: 0,
			style: 'hollow',
		  },
		
		  
		//   xaxis: {
		// 	type: 'datetime',
		// 	min: new Date(Date.now() - 30 * 24 * 60 * 60 * 1000).getTime(),
		// 	tickAmount: 6,
		// 	labels: {
		// 		style: {
		// 			fontSize: '11px'
		// 		}
		//    }
	
		//   },

		  xaxis: {
				type: 'datetime',
				range: 60 * 24 * 60 * 60 * 1000,
				tickAmount: 6,
				labels: {
					style: {
						fontSize: '11px'
					}
				}
		},
	
		 
		 
		//   tooltip: {
			
		// 	x: {
		// 	  format: 'dd MMM yyyy'
		// 	}
		//   },
		  fill: {
			type: 'gradient',
			colors: ['#3583cc'],
		
			gradient: {
			  shadeIntensity: 1,
			  opacityFrom: 0.7,
			  opacityTo: 0.9,
			  stops: [0, 100],
			}
		  },
		},
	  
	  
		selection: 'one_year',
	  
	  }; 

	const summaryTable = () =>{
		api.get(routes.HOME.SUMMARY)
		.then(res=>res.data)
		.then((data)=>{
			const { reportedEmails, domains, emailChecked, users, whatsappReportings, contacts } = data
			setSummary({...summary, totalReportedMails: reportedEmails, domains, emailChecked, users, whatsappMessages: whatsappReportings, contacts })
		})
		.catch((error)=>{
			apiError(error)
		})
	}

	const recentTable = () =>{
		api.get(routes.HOME.RECENT)
		.then(res=>res.data)
		.then((data)=>{
			setRecent(data?.whatsappReported)
		})
		.catch((error)=>{
			apiError(error)
		})
	}

	const topReportersTable = () =>{
		api.get(routes.HOME.TOP_REPORTERS)
		.then(res=>res.data)
		.then((data)=>{
			let reporters = [];
			let count = []
			if (data && data.result) {
					data.result.forEach(reporter => {
						if (reporter) {
							reporters.push(reporter.email);
							count.push(reporter.count);
						}
					});
			}
			
			setTopReporters({
				reporters: reporters,
				total: count
			})
		})
		.catch((error)=>{
			apiError(error)
		})
	}

	const whoElseTable = () =>{
		api.get(routes.HOME.WHO_ELSE)
		.then(res=>res.data)
		.then((data)=>{
			setWhoElse({
				trashedMails: data.trashedMails, 
				suspiciousMails: data.suspiciousMails, 
				pendingMails: data.pendingMails,
				safeMails: data.safeMails
			})
		})
	}

	const highestReportedTable = () =>{
		api.get(routes.HOME.HIGHEST)
		.then(res=>res.data)
		.then((data)=>{
			setHighestReportedMails(data.reportedMails)
		})
	}

	const dailyMailsTable = () =>{
		api.get(routes.HOME.DAILY)
		.then(res=>res.data)
		.then((data)=>{
			const { result } = data		
			setDailyMails(result);
		})
		.catch((error)=>{
			apiError(error)
		})
	}

	const handleChange = (event, newValue) =>{
		setValue(newValue)
	}

	const getTopReporters = () =>{
		let data = [];
		const reporter = topReporters? topReporters.reporters.length !=0 ? topReporters.reporters : [] : []
		reporter.forEach((reporter => {
            data.push(
				<TableContainer className={styles.tableContainer}>
					<Table aria-label="simple table">	
						<TableBody className={`${styles.mailRepWrap} ${styles.datareportTableWidth}`}>
							<TableRow >
								<TableCell className={styles.td1} component="td" scope="row">{reporter._id}</TableCell>
								<TableCell className={styles.td2} component="td" scope="row"><BorderLinearProgress variant="determinate" value={(reporter.count/topReporters.total)*100} /></TableCell>
								<TableCell className={styles.td3} component="td" scope="row">({reporter.count}/{topReporters.total})</TableCell>
							</TableRow>
						</TableBody>  
							</Table>
						</TableContainer>
				
            )
        }))
        return data;
	}

	const [ license, setLicense ] = React.useState({
		totalUsersEmail: '',
		totalUsersMessenger:'',
		expiry: '',
		utilisedEmailLimit: '',
		utilisedMessengerLimit: ''
	})



	const loadLicence = () => {
		api.get(routes.HOME.LICENCE)
		.then(res=>res.data)
		.then((data)=>{
			setLicense((prevState) => ({...prevState, totalUsersEmail: data.user, totalUsersMessenger: data.messenger, expiry: data.expiry, utilisedEmailLimit: data.utilisedEmailLimit, utilisedMessengerLimit: data.utilisedMessengerLimit }))
			Cookies.set("URL",data.remainingUserLimit)
			Cookies.set("EmailLimitReached",data.utilisedEmailLimit >= data.user)
			Cookies.set("MessengerLimitReached",data.utilisedMessengerLimit >= data.messenger)
		})
		.catch((error)=>{
			apiError(error)
		})
	}



	const [vulnerableAttachments, setVulnerableAttachments] = React.useState('')
	const [vulnerableUrls, setVulnerableUrls] = React.useState('')


	const loadVulnerableAttachmentAndLinks = () =>{
		api.get(routes.HOME.VULNERABLEATTACHMENTANDURL)
		.then(res=>{

			// console.log("/// from home js ",res.data)
			return res.data;
		})
		.then((data)=>{
			// console.log("/// from home js ",data)
			setVulnerableAttachments(data.topAttachments)
			setVulnerableUrls(data.topUrls)
		})
		.catch(error=>{
			console.log(error);
		})
	}

	const loadTopSender = ()=>{
		api.get(routes.HOME.TOP_SENDERS)
		.then(res=>res.data)
		.then((data)=>{
			setTopSenders(data.senders)
		})
		.catch(error=>{
			console.log(error);
		})
	}

	const downloadAttachment = (id,fileName)=>{
        api.get(routes.FILES.DOWNLOAD,{
            params:{
                attachmentId:id
            },
            responseType: 'blob',
        })
        .then(response => {
            const url = window.URL.createObjectURL(new Blob([response.data]));
            const link = document.createElement('a');
            link.href = url;
            link.setAttribute('download', fileName);
            document.body.appendChild(link);
            link.click();
            })
          .catch(error => {
            console.log('Error fetching file:', error);
            toast.error("Error Downloading File!")
        });  
    }

	const loadWhatsappDetails = () =>{
		api.get(routes.WHATSAPP.OVERVIEW)
		.then(res=>res.data)
		.then((data)=>{	
			let reporters = [];
			let count = []

			if(data.topReporters.length){
				data.topReporters.forEach((reporter)=>{
					reporters.push(reporter.name)
					count.push(reporter.count)
				})
			}
			
			setMessengerOverview((prevState)=>({...prevState, dailyReportedMessages: data.dailyReportedMessages, 
				topUrls: data.topUrls,
				topReporters: {reporters, count},
				messages: data.whatsappReported, 
				topSenders: data.topSenders,
				recentUnsafeMessages: data.recentUnsafeMessages,
				actionSummary:{safe: data.safeMessagesCount, unsafe: data.unsafeMessagesCount, dubious: data.dubiousMessagesCount}
			}))

		})
	}
	const [loadingTaConnection, setLoadingTaConnection] = React.useState(false)

	const changeConnectionStatusWithTa = async (status) => {
		setLoadingTaConnection(true)
		try {
		  setTaStatus({ ...taStatus, enabled: false, connecting: status });
	  
		  const response = await api.post(routes.TA.CONNECT, { connectionStatus: status });
		  const { success } = response.data;
	  
		  if (success) {
			toast.success(response.data.message);
			if (status) setTaOpen(false);
		  }
		} catch (error) {
		  setTaOpen(false);
		  console.error("Error from TA-Connection:", error);
		}
		finally{
			setLoadingTaConnection(false)
		}
	  };

	const syncPackage = () =>{
		api.get(routes.PACKAGE.SYNC)
		.then(res=>res.data)
		.then((data)=>{
			console.log("Sync Package Called",data)
		})
		.catch((error)=>{
			console.log("Error from package",error)
		})
	}

	// const syncOrganisationDetails = () =>{
	// 	api.get(routes.HOME.SYNC_ORGANIZATION_DETAILS)
	// 	.then(res=>res.data)
	// 	.then((data)=>{
	// 		console.log("Sync Organisation Details",data)
	// 	})
	// 	.catch((error)=>{
	// 		console.log("Error from sync organisation details",error)
	// 	})
	// }
	
	const checkTaConnection = () =>{
		setLoadingTa(true)
		api.get(routes.TA.CHECK_CONNECTION)
		.then(res=>res.data)
		.then((data)=>{
			setLoadingTa(false)
			setTaStatus({...taStatus, ...data.taStatus })
			Cookies.set('isTacEnabled', data.taStatus.enabled)
			if (sessionStorage.getItem('firstLogin') === 'true' && !data.taStatus.connecting && !data.taStatus.enabled) {
				setTaOpen(false) //remove to show modal
				sessionStorage.removeItem('firstLogin'); 
			}
		})
		.catch((error)=>{
			setLoadingTa(false)
			console.log("Error from TA-Connection",error)
		})
	}

	const syncDomainsTa = () =>{
		setLoadingTa(true)
		api.get(routes.DOMAIN.SYNC_FROM_TA)
		.then(res=>res.data)
		.then((data)=>{
			setDomains("");
			setDomainChange((prevState) => !prevState);
		})
		.catch((error)=>{
			console.log("Error from TA syncing domains",error)
		})
	}

	const fetchGroupUserCount = () =>{
		api.get(routes.ADMIN_CENTRAL.FETCH_GROUP_USER_COUNT)
		.then(res=>res.data)
		.then((data)=>{

		})
		.catch((error)=>{
			console.log("Error from TA syncing group user counts",error)
		})
	}


	React.useEffect(() => {
        let interval;

        if (taStatus.connecting) {
            interval = setInterval(() => {
                checkTaConnection();
            }, 10000); 
        }

        return () => {
            if (interval) clearInterval(interval);
        };
    }, [taStatus.connecting]); 


	React.useEffect(()=>{
        loadFeatures()
    },[])	
	
	React.useEffect(()=>{
		if(taStatus.enabled){
			syncDomainsTa()
			fetchGroupUserCount()
		}		
	},[taStatus.enabled])	

	React.useEffect(()=>{
		summaryTable()
		recentTable()
		loadLicence()
		topReportersTable()
		dailyMailsTable()
		whoElseTable()
		highestReportedTable()
		loadVulnerableAttachmentAndLinks()
		loadTopSender()
		// loadWhatsappDetails()
		syncPackage()
		checkTaConnection()
		//syncOrganisationDetails()
	}, [])

	React.useEffect(()=>{
		if(areFeaturesLoaded && canAccessFeature("TPIR-WA")) loadWhatsappDetails()
	}, [areFeaturesLoaded])


  	return (
		!areFeaturesLoaded ? <box>Loading</box> :
    	<>
		<Box className={styles.MainCardBox}>

		{isEmailLimitReached && isEmailLimitReached == "true" &&
		<Collapse in={open}>
		<Alert sx={{margin: "5px 5px 10px 5px"}} severity="error" className={styles.alert} 
		action={
            <IconButton
              aria-label="close"
              color="inherit"
              size="medium"
              onClick={() => {
                setOpen(false);
              }}
            >
              <CloseIcon fontSize="medium"/>
            </IconButton>
          }
		>
			
			Your user license limit for Email Reporting has been reached.
			 To add more users, please upgrade your license or remove existing users</Alert>
		</Collapse>
		}

		{areFeaturesLoaded && canAccessFeature("TPIR-WA") && isMessengerLimitReached && isMessengerLimitReached == "true" && 
		<Collapse in={openAlerttwo}>
		<Alert sx={{margin: "5px 5px 10px 5px"}} severity="error" className={styles.alert} 
		action={
            <IconButton
              aria-label="close"
              color="inherit"
              size="medium"
              onClick={() => {
                setAlerttwoOpen(false);
              }}
            >
              <CloseIcon fontSize="medium"/>
            </IconButton>
          }
		>
			
			Your user license limit for Whatsapp Reporting has been reached.
			 To add more users, please upgrade your license or remove existing users</Alert>
		</Collapse>
		}

					
		<Grid item md={12} lg={12}>
		{!loadingTa && !taStatus.isNewCompany && !taStatus.enabled && taStatus.connecting && 
			<Box className="statusBanner">
				<Alert severity="success" className="alertcss">
				<Typography component="p">Your integration with Threatcop Admin is currently in progress.
							While we connect TPIR with Threatcop Admin, we kindly request 
							you to refrain from performing any operations on Users, Groups, or Integrations during this process.</Typography>
						<span>Connecting With TA Please Wait...</span>
				</Alert>
			</Box>		
		}	



{/* Cyber Olympics 2025 */}

			{/* {openunle && (
				<Box className="unleashedBanner ">
					<Box className="alertcyberolympics">
						<IconButton
							className="closeBtn"
							aria-label="close"
							color="inherit"
							size="small"
							onClick={() => {
								setOpenunle(false);
							}}
						>
							<CloseIcon fontSize="inherit" className="alertcloseIcon"/>
						</IconButton>
						<Grid container spacing={2} sx={{alignItems:'center',justifyContent:'space-between'}}>
							<Grid item md={7} lg={7}>
								<Box className="content">
									<Typography variant="h4">
										Cyber Olympics 2025
									</Typography>
									<Typography variant="h5">
										This October - Learn, Compete, Secure with Cyber Olympics
									</Typography>
								</Box>
								<Box className="imgSection">
									<Image src={Gamesimg}></Image>
								</Box>
							</Grid>
							<Grid item md={4} lg={4} className="rightImg">
								<Box className="rightDflex">
									<Box className="leaderboardimg">
										<Image src={leaderboard} ></Image>
									</Box>
									<Box sx={{marginLeft:"20px"}}>
										<Box className="rightDflexInner">
											<Image src={TPIRQR} className="scannerimg" />
										</Box>
										<Button variant="contained" className="hrefBtn" href="https://threatcop.com/cyber-security-awareness-month?utm_source=tpir&utm_medium=social&utm_campaign=tools" target="_blank" rel="noopener noreferrer">Register Here</Button>
									</Box>
								</Box>
							</Grid>
						</Grid>
					</Box>
				</Box>
			)} */}
		

{/* End */}


{/* 

			{!loadingTa && !taStatus.isNewCompany && !taStatus.enabled && !taStatus.connecting &&
			<Box className="connectTaAdminBtn">
						<Collapse in={open}>
							<Alert
							action={
								<IconButton
								aria-label="close"
								color="inherit"
								size="small"
								onClick={() => {
									setOpen(false);
								}}
								>
								<CloseIcon fontSize="inherit" className="alertcloseIcon"/>
								</IconButton>
							}>
							

							<Grid container>
								<Grid item md={7} lg={7}>

									<Box className="content">
										<Typography variant="h4">
											Introducing Threatcop Admin!<sup>New Product</sup>
										</Typography>
										<span>Take control of all your Threatcop products in one place.</span>
										<Typography component="p">
										Manage all your Threatcop applications, users, subscriptions, and operations effortlessly with Threatcop Admin. 
										Experience a unified platform designed for better decision-making and productivity.
										</Typography>

										

										<Button variant="contained" className={`${styles.btn} ${styles.btnPrimary}`} onClick={taConnecthandleOpen}><TfiLink style={{ marginRight: '5px' }}/>Start Integration</Button>

									
									</Box>

								</Grid>

								<Grid item md={5} lg={5}>
									<Image src={Listing}></Image>
								</Grid>

							</Grid>

						
							</Alert>
						</Collapse>
						
   				</Box>
			} */}

						<Box className="dashboardBreadcrumbbar">
							<Grid container>
								<Grid item md={6} lg={6} className="dFlex">
									<Box className="page-head">
										<Typography variant="h4">
												Dashboard
										</Typography>

									</Box>
								</Grid>

								<Grid item md={6} lg={6} className=" dflexRight">
									<Box className="dashTab" sx={{ borderBottom: 0, borderColor: 'divider' }}>
										<Tabs value={value} onChange={handleChange} aria-label="basic tabs example" className={styles.TabItemButton}>
										<Tab label={<div style={{ display: 'flex', alignItems: 'center' }}><TfiEmail style={{ marginRight: '8px' }} />
          										Email Analytics</div>}  {...a11yProps(0)} />
										<Tab label={<div style={{ display: 'flex', alignItems: 'center' }}><FaWhatsapp style={{ marginRight: '8px' }} />
										Whatsapp Analytics</div>} {...a11yProps(1)} disabled={!(canAccessFeature("TPIR-WA") )}/>
										</Tabs>
										
									</Box>
								</Grid>
							</Grid>
						</Box>
				</Grid>


				<TabPanel value={value} index={0} className="dashtabPanel">
					<Grid container>
						<Grid item md={12} lg={12}>
							<Box className="miniInfoWrapper">
										<Grid container>
											<Grid item md={3} lg={3} className={styles.miniGrid}>
													<Box className="minInfoCard">
														<Box className="infoCardDflex">
															<Box className="infoIcon bgcolorOne">
																<TfiEmail/>
															</Box>
															<Box>
																<Typography variant="h6"> { summary.totalReportedMails } </Typography>
																<Typography component="p">Mails Reported</Typography>	
															</Box>
														</Box>
													</Box>
											</Grid>

											<Grid item md={3} lg={3} className={styles.miniGrid}>
												<Box className="minInfoCard">
													<Box className="infoCardDflex">
															<Box className="infoIcon bgcolorTwo">
																<TfiWorld/>
															</Box>
															<Box>
																<Typography variant="h6">{whoElse?.suspiciousMails} </Typography>
																<Typography component="p">Unsafe Mails</Typography>
															</Box>
														</Box>
													</Box>
											</Grid>

											<Grid item md={3} lg={3} className={styles.miniGrid}>
												<Box className="minInfoCard">
													<Box className="infoCardDflex">
															<Box className="infoIcon bgcolorSix">
																<TfiAlert/>
															</Box>
															<Box>
																<Typography variant="h6">{whoElse?.pendingMails}</Typography>
																<Typography component="p">Action Pending</Typography>
															</Box>
														</Box>
													</Box>
											</Grid>

											<Grid item md={3} lg={3} className={styles.miniGrid}>
													<Box className="minInfoCard">
														<Box className="infoCardDflex">
															<Box className="infoIcon bgcolorThree">
																<TfiUser/>
															</Box>
															<Box>
																<Typography variant="h6">{ summary.users }</Typography>
																<Typography component="p">Active Users  </Typography>
															</Box>
														</Box>
													</Box>
											</Grid>
											<Grid item md={3} lg={3} className={styles.miniGrid}>
												<Box className="minInfoCard">
													<Box className="infoCardDflex">
															<Box className="infoIcon bgcolorFour">
																<TfiWorld/>
															</Box>
															<Box>
																<Typography variant="h6">{ summary.domains }</Typography>
																<Typography component="p">Domains</Typography>
															</Box>
														</Box>
													</Box>
											</Grid>
										</Grid>
							</Box>	
						</Grid>

							<Grid item md={6} lg={6} className="quickBarDash ">
								<Box className="dashCard heightM">
									<Box className="cardHeader">
										<Typography variant="h1" className="cardTitle">
										Daily Mails Reported
										</Typography>
									</Box>
									<Box className="internalCardsec">	
										<Chart 
											options={areaNew.options}
											series={areaNew.series}
											type="area"
											height="210"
										/>
									
									</Box>	
								</Box>
							</Grid>

							<Grid item md={3} lg={3} className="quickBarDash">
								<Box className="dashCard heightM">
									<Box className="cardHeader">
										<Typography variant="h1" className="cardTitle">
											Mails Action Summary
										</Typography>
									</Box>
									<Box>
										{isLite ? 
										<Box className={styles.whatsappComing}>
											<Typography component="p">
												Please Upgrade
											</Typography>
											</Box> :
												<Box className="internalCardsec">
													<Chart options={donut.options}
															series={donut.series}
															type="donut"
															width="100%"
															height="140"
														/>	
															
														<Box className="donutlabelflex">
															<Box className="donutlabels">
																<Box className="labelsNumb"> 
																	<Typography component="p">
																		<span className="ic-circle colorOne"></span>{whoElse.pendingMails} 
																	</Typography>	
																</Box>	
																<Typography variant="h4">
																Action Pending
																</Typography>
															</Box>

															<Box className="donutlabels">
																<Box className="labelsNumb"> 
																		<Typography component="p">
																		<span className="ic-circle colorThree"></span>{whoElse.trashedMails} 
																		</Typography>	
																	</Box>	
																	<Typography variant="h4">
																	Trashed Mails
																	</Typography>
															</Box>
														</Box>

														<Box className="donutlabelflex">
															<Box className="donutlabels">
															<Box className="labelsNumb"> 
																	<Typography component="p">
																	<span className="ic-circle colorTwo"></span> {whoElse.safeMails} 
																	</Typography>	
																</Box>	
																<Typography variant="h4">
																Recovered Mails
																</Typography>
															
															</Box>

														<Box className="donutlabels">
															<Box className="labelsNumb"> 
																		<Typography component="p">
																		<span className="ic-circle colorFour"></span> {whoElse.suspiciousMails} 
																		</Typography>	
																	</Box>	
																	<Typography variant="h4">
																	Deleted Mails
																	</Typography>
																	
																</Box>
														</Box>	
												</Box>
												}
												</Box>
										</Box>
							</Grid>

							<Grid item md={3} lg={3} className="quickBarDash">
								<Box className="dashCard heightM">
										<Box className="cardHeader">
											<Typography variant="h1" className="cardTitle">
												Email Reporting License
											</Typography>
										</Box>
										<Box className="internalCardsec">
													<Box className={styles.topReportHeader}>
														{/* <Box className={styles.tpirPackage}>
																<Box className={styles.packageCount}>
																	<Typography variant="h6">
																		{license.addedDomains} of {license.totalDomains}
																	</Typography>
																	<Typography component='p'>Domains</Typography>
																</Box>	
																	<BorderLinearProgress variant="determinate" value= {(license.addedDomains/license.totalDomains)*100} />
															</Box> */}
															<Box className={styles.tpirPackage}>
																<Box className={styles.packageCount}>
																<Typography component='p'>Users Consumed </Typography>
																		<Typography variant="h6">
																			<span>{license?.utilisedEmailLimit}</span>/{license.totalUsersEmail}
																		</Typography>
																		
																	</Box>	
																<BorderLinearProgress variant="determinate" value= {(license?.utilisedEmailLimit/license.totalUsersEmail)*100} />
															</Box>	
														
															<Box className={`${styles.packageCount} ${styles.timePack}`}>
															<Typography component='p'>Expires On </Typography>
																<Typography variant="h6">Expires In</Typography>
															
															</Box>
								
															<Box className={`${styles.packageCount} ${styles.monthDate}`}>
															<Typography component='p'>{getDatewithoutTime(license.expiry)} </Typography>
																<Typography variant="h6">
																	{ timeInAgoFormat1(new Date(license.expiry))  } 
																</Typography>
																
															</Box>

														</Box>
										</Box>
								</Box>
							</Grid>

							<Grid item md={5} lg={5} className="quickBarDash">
								<Box className="dashCard heightM">
										<Box className="cardHeader">
											<Typography variant="h1" className="cardTitle">
											Top Email Reporters
											</Typography>
										</Box>
											<Box className="setMargin">
													<Chart 
													options={barchart.options}
													series={barchart.series}
													type="bar"
													height="230"
												/>
											</Box>	
									</Box>
							</Grid>

							<Grid item md={7} lg={7} className="quickBarDash">
								<Box className="dashCard hRepTable heightM">
									<Box className="cardHeader">
										<Typography variant="h1" className="cardTitle">
											Highest Reported Mails
										</Typography>
									</Box>
									{(highestReportedMails && highestReportedMails.length)?
									<Box className={`${styles.tableBody} ${styles.setScroll}`}>
											<Box className="internalCardsec">
												<TableContainer className={styles.tableContainer}>
													<Table aria-label="simple table">
														<TableHead className={styles.thead_background}>
															<TableRow>
																<TableCell className="w-25">Sender</TableCell>
																<TableCell className="w-30">Subject</TableCell>
																<TableCell className="w-10">Reporters</TableCell>
																<TableCell className="w-20">Date</TableCell>
																<TableCell className="w-15">Status</TableCell>	
															</TableRow>
														</TableHead>
														<TableBody className={styles.mailRepWrap}>
															{ highestReportedMails.map((data,index)=>(
																	<TableRow key = {index}>
																		<TableCell component="td" scope="row">
																		<Typography variant="h6">{data?.fromName}</Typography>
																		<Typography component="p">{data?.from}</Typography> </TableCell>
																		<TableCell component="td" scope="row">{data?.subject} </TableCell>
																		<TableCell component="td" scope="row"  sx={{textAlign:"center"}}>{data?.totalReporters+1}</TableCell>
																		<TableCell component="td" scope="row" >{getDatewithoutTime(data.createdAt)}</TableCell>
																		<TableCell component="td" scope="row"><span className={styles.reposrtedStatus}>{
																			data.isDeletedEmail == 'true' ? <span className={`${styles.typeBadges} ${styles.DeleteColor}`}>Deleted</span> : data.isTrashedEmail == 'true' ? <span className={`${styles.typeBadges} ${styles.TrashColor}`}>Trashed</span> : 
																			data.isRecoveredEmail == 'true' ? <span className={`${styles.typeBadges} ${styles.RecoverColor}`}>Recovered</span> :  <span className={`${styles.typeBadges} ${styles.NoActionColor}`}>No Action</span>
																		}</span></TableCell>
																	</TableRow>
																))
															}
														</TableBody>   
													</Table>
												</TableContainer>	
												</Box>							
											</Box>:<Typography component="p" className={styles.maliciousCenter}>
																	No Mail(s) Found
															</Typography>}
									</Box>
							</Grid>

							<Grid item md={6} lg={6} className="quickBarDash">
								<Box className="dashCard hRepTable heightM">
									<Box className="cardHeader">
										<Typography variant="h1" className="cardTitle">
											Top Vulnerable Attachments
										</Typography>
									</Box>
									{(vulnerableAttachments && vulnerableAttachments.length) ? 
										<Box className={`${styles.tableBody} ${styles.setScroll}`}>
											<Box className="internalCardsec">
												<TableContainer className={styles.tableContainer}>
													<Table aria-label="simple table">
														<TableHead className={styles.thead_background}>
															<TableRow>
																<TableCell className="w-50">Attachment</TableCell>
																<TableCell className="w-20">Scan Score</TableCell>
																<TableCell className="w-20">Sender</TableCell>
															</TableRow>
														</TableHead>
														<TableBody className={styles.mailRepWrap}>
														{vulnerableAttachments.map((attachment)=>{
														return <TableRow >
																<TableCell component="td" scope="row">
																	<Box className={styles.iconFlex}>
																			<span><BsPaperclip/></span>
																			<Box className={styles.rightIcon}>
																			<Typography variant="h6">{attachment?.originalName}</Typography>
																				<Typography component="p">{getExtensionFromFileName(attachment?.originalName)}</Typography> 
																			</Box>
																		</Box>
																
																</TableCell>
																<TableCell component="td" scope="row" >{Math.round(attachment?.score)}%</TableCell>
																<TableCell component="td" scope="row">
																	<Box className={styles.iconFlex}>
																	<Box className={styles.rightIcon}>
																		<Typography variant="h6">{attachment?.reportedMailId?.fromName}</Typography>
																		<Typography component="p">{attachment?.reportedMailId?.from}</Typography> 
																		</Box>
																	</Box>
																</TableCell>
																<TableCell component="td" scope="row">
																	<BsDownload className="cursorPointer setColor" onClick={()=>downloadAttachment(attachment._id, attachment.fileName)}/>
																</TableCell>
															</TableRow>
														})}
														</TableBody>   
													</Table>
												</TableContainer>	
											</Box>		
										</Box>:<Typography component="p" className={styles.maliciousCenter}>
																	No Vulnerable Attachment(s)
															</Typography>}
									</Box>
							</Grid>

							<Grid item md={6} lg={6} className="quickBarDash">
								<Box className="dashCard hRepTable heightM">
									<Box className="cardHeader">
										<Typography variant="h1" className="cardTitle">
											Top Vulnerable Links
										</Typography>
									</Box> 
									{(vulnerableUrls && vulnerableUrls.length) ?
									<Box className={`${styles.tableBody} ${styles.setScroll}`}>
											<Box className="internalCardsec">
												<TableContainer className={styles.tableContainer}>
													<Table aria-label="simple table">
														<TableHead className={styles.thead_background}>
															<TableRow>
																<TableCell className="w-45">URL</TableCell>
																<TableCell className="w-20" sx={{textAlign:"center"}}>Scan Score</TableCell>
																<TableCell className="w-25" >Sender</TableCell>
																<TableCell className="w-5" ><AiOutlineCopy/></TableCell>
															</TableRow>
														</TableHead>
														<TableBody className={styles.mailRepWrap}>
														{vulnerableUrls.sort((a,b) =>{
															return Math.round(b.score) - Math.round(a.score)
														}).map((url)=>{
															return <TableRow >
																	<TableCell component="td" scope="row">
																		<Box className={styles.iconFlex}>
																			<span><BsLink45Deg/></span>
																			<Box className={styles.rightIcon}>
																				<Typography component="p" className={styles.dashUrl}>{url.url.slice(0, 55) + "..."}</Typography>
																			</Box>
																		</Box>
																		</TableCell>
																		<TableCell component="td" scope="row" sx={{textAlign:"center"}}>{Math.round(url.score)}%</TableCell>
																		<TableCell component="td" scope="row">
																			<Box className={styles.iconFlex}>
																			
																				<Box className={styles.rightIcon}>
																					<Typography variant="h6">{url?.reportedMailId?.fromName}</Typography>
																					<Typography component="p">{url?.reportedMailId?.from}</Typography> 
																				</Box>
																			</Box>
																		</TableCell>

																		<TableCell component="td" scope="row">
																			<AiOutlineCopy className="cursorPointer setColor" onClick={async ()=>{
																				await navigator.clipboard.writeText(url.url);
																				toast.success("Copied To Clipboard!")
																			}} />
																		</TableCell>
															</TableRow>

														})}

														</TableBody>   
													</Table>
												</TableContainer>	
												</Box>							
											</Box>
									:<Typography component="p" className={styles.maliciousCenter}>
																	No Vulnerable Url(s)
															</Typography>}
									</Box>
							</Grid>

							<Grid item md={6} lg={6} className="quickBarDash">
								<Box className="dashCard hRepTable heightM">
									<Box className="cardHeader">
										<Typography variant="h1" className="cardTitle">
											Top Malicious Senders
										</Typography>
									</Box>
									{(topSenders && topSenders.length) ?
									<Box className={`${styles.tableBody} ${styles.setScroll}`}>
											<Box className="internalCardsec">
												<TableContainer className={styles.tableContainer}>
													<Table aria-label="simple table">
														<TableHead className={styles.thead_background}>
															<TableRow>
																<TableCell className="w-25">Sender</TableCell>
																<TableCell className="w-30" sx={{textAlign:"center"}}>Total Emails</TableCell>
																<TableCell className="w-15" sx={{textAlign:"center"}}>Receivers</TableCell>
															</TableRow>
														</TableHead>
														<TableBody className={styles.mailRepWrap}>
															{ topSenders.map((sender)=>{
																return <TableRow >
																		<TableCell component="td" scope="row">
																			<Box className={styles.iconFlex}>
																				<span><BsPersonBoundingBox/></span>
																				<Box className={styles.rightIcon}>
																					<Typography variant="h6">{sender.name}</Typography>
																					<Typography component="p">{sender._id}</Typography> 
																				</Box>
																			</Box>
																		</TableCell>
																		<TableCell component="td" scope="row" sx={{textAlign:"center"}}>{sender.reportedMailCount}</TableCell>
																		<TableCell component="td" scope="row" sx={{textAlign:"center"}}>{sender.whoElseCount}</TableCell>
															</TableRow>
															})}
															

														</TableBody>   
													</Table>
												</TableContainer>	
												</Box>							
											</Box>:	<Typography component="p" className={styles.maliciousCenter}>
																	No Malicious Sender(s)
															</Typography>
									}
									</Box>
							</Grid>


							
					</Grid>
				</TabPanel>

				<TabPanel value={value} index={1} className="dashtabPanel">
					<Grid container>
						<Grid item md={12} lg={12}>
							<Box className="miniInfoWrapper">
										<Grid container>

											<Grid item md={3} lg={3} className={styles.miniGrid} onClick={()=>router.push('/whatsapp')}>
												<Box className="minInfoCard">
													<Box className="infoCardDflex" >
														<Box className="infoIcon bgcolorFive">
															<TfiCommentAlt/>
														</Box>
														<Box>
															<Typography variant="h6"> {summary.whatsappMessages}</Typography>
															<Typography component="p">Messages Reported</Typography>
														</Box>
													</Box>	
												</Box>
											</Grid>

											<Grid item md={3} lg={3} className={styles.miniGrid}>
													<Box className="minInfoCard">
														<Box className="infoCardDflex">
															<Box className="infoIcon bgcolorThree">
																<TfiUser/>
															</Box>
															<Box>
																<Typography variant="h6">{ summary.contacts }</Typography>
																<Typography component="p">Contacts  </Typography>
															</Box>
														</Box>
													</Box>
											</Grid>
										</Grid>
							</Box>	
						</Grid>

							<Grid item md={6} lg={6} className="quickBarDash ">
								<Box className="dashCard heightM">
									<Box className="cardHeader">
										<Typography variant="h1" className="cardTitle">
										Daily Messages Reported
										</Typography>
									</Box>
									<Box className="internalCardsec">	
										<Chart 
											options={areaNewForMessenger.options}
											series={areaNewForMessenger.series}
											type="area"
											height="210"
										/>
									
									</Box>	
								</Box>
							</Grid>

							<Grid item md={3} lg={3} className="quickBarDash">
								<Box className="dashCard heightM">
									<Box className="cardHeader">
										<Typography variant="h1" className="cardTitle">
											Message Action Summary
										</Typography>
									</Box>
									<Box>
										{isLite ? 
										<Box className={styles.whatsappComing}>
											<Typography component="p">
												Please Upgrade
											</Typography>
											</Box> :
												<Box className="internalCardsec">
													<Chart options={messageDonut.options}
															series={messageDonut.series}
															type="donut"
															width="100%"
															height="140"
														/>	
															
														<Box className="donutlabelflex">
															

															<Box className="donutlabels">
																<Box className="labelsNumb"> 
																		<Typography component="p">
																		<span className="ic-circle colorThree"></span>{messengerOverview.actionSummary.dubious} 
																		</Typography>	
																	</Box>	
																	<Typography variant="h4">
																	Dubious Messages
																	</Typography>
															</Box>
														</Box>

														<Box className="donutlabelflex">
															<Box className="donutlabels">
															<Box className="labelsNumb"> 
																	<Typography component="p">
																	<span className="ic-circle colorTwo"></span> {messengerOverview.actionSummary.safe} 
																	</Typography>	
																</Box>	
																<Typography variant="h4">
																Safe Messages
																</Typography>
															
															</Box>

														<Box className="donutlabels">
															<Box className="labelsNumb"> 
																		<Typography component="p">
																		<span className="ic-circle colorFour"></span> {messengerOverview.actionSummary.unsafe} 
																		</Typography>	
																	</Box>	
																	<Typography variant="h4">
																	Unsafe Messages
																	</Typography>
																	
																</Box>
														</Box>	
												</Box>
												}
												</Box>
										</Box>
							</Grid>

							<Grid item md={3} lg={3} className="quickBarDash">
								<Box className="dashCard heightM">
										<Box className="cardHeader">
											<Typography variant="h1" className="cardTitle">
												Whatsapp Reporting License
											</Typography>
										</Box>
										<Box className="internalCardsec">
													<Box className={styles.topReportHeader}>
														{/* <Box className={styles.tpirPackage}>
																<Box className={styles.packageCount}>
																	<Typography variant="h6">
																		{license.addedDomains} of {license.totalDomains}
																	</Typography>
																	<Typography component='p'>Messages</Typography>
																</Box>	
																	<BorderLinearProgress variant="determinate" value= {(license.addedDomains/license.totalDomains)*100} />
															</Box> */}
															<Box className={styles.tpirPackage}>
																<Box className={styles.packageCount}>
																<Typography component='p'>Users Consumed </Typography>
																		<Typography variant="h6">
																			<span>{license.utilisedMessengerLimit}</span>/{license.totalUsersMessenger}
																		</Typography>
																		
																	</Box>	
																<BorderLinearProgress variant="determinate" value= {(license.utilisedMessengerLimit/license.totalUsersMessenger)*100} />
															</Box>	
															<Box className={`${styles.packageCount} ${styles.timePack}`}>
															<Typography component='p'>Expires On </Typography>
																<Typography variant="h6">Expires In</Typography>
															
															</Box>
								
															<Box className={`${styles.packageCount} ${styles.monthDate}`}>
															<Typography component='p'>{getDatewithoutTime(license.expiry)} </Typography>
																<Typography variant="h6">
																	{ timeInAgoFormat1(new Date(license.expiry))  } 
																</Typography>
																
															</Box>
														</Box>
										</Box>
								</Box>
							</Grid>

							

							<Grid item md={5} lg={5} className="quickBarDash">
								<Box className="dashCard heightM">
										<Box className="cardHeader">
											<Typography variant="h1" className="cardTitle">
											Top Message Reporters
											</Typography>
										</Box>
											<Box className="setMargin">
													<Chart 
													options={barchartForMessenger.options}
													series={barchartForMessenger.series}
													type="bar"
													height="230"
												/>
											</Box>	
									</Box>
							</Grid>

							<Grid item md={7} lg={7} className="quickBarDash">
								<Box className="dashCard hRepTable heightM">
									<Box className="cardHeader">
										<Typography variant="h1" className="cardTitle">
											Recent Unsafe Messages
										</Typography>
									</Box>
									{(messengerOverview && messengerOverview.recentUnsafeMessages.length)?
									<Box className={`${styles.tableBody} ${styles.setScroll}`}>
											<Box className="internalCardsec">
												<TableContainer className={styles.tableContainer}>
													<Table aria-label="simple table">
														<TableHead className={styles.thead_background}>
															<TableRow>
																<TableCell className="w-50">Message</TableCell>
																<TableCell className="w-15">Date</TableCell>
																<TableCell className="w-20">Sender</TableCell>
																<TableCell className="w-15">Status</TableCell>	
															</TableRow>
														</TableHead>
														<TableBody className={styles.mailRepWrap}>
															{ messengerOverview.recentUnsafeMessages.map((data,index)=>(
																	<TableRow key = {index}>
																		<TableCell component="td" scope="row"><h6>{data.messageSummary}</h6></TableCell>
																		<TableCell component="td" scope="row" >{getDatewithoutTime(data.createdAt)}</TableCell>
																		<TableCell component="td" scope="row" >{data.sender}</TableCell>
																		<TableCell component="td" scope="row"><span className={styles.reposrtedStatus}>{<span className={`${styles.typeBadges} ${styles.DeleteColor}`}>Unsafe</span>
																		}</span></TableCell>
																	</TableRow>
																))
															}
														</TableBody>   
													</Table>
												</TableContainer>	
												</Box>							
											</Box>:<Typography component="p" className={styles.maliciousCenter}>
																	No Mail(s) Found
															</Typography>}
									</Box>
							</Grid>

							

							<Grid item md={6} lg={6} className="quickBarDash">
								<Box className="dashCard hRepTable heightM">
									<Box className="cardHeader">
										<Typography variant="h1" className="cardTitle">
											Top Vulnerable Links
										</Typography>
									</Box> 
									{(messengerOverview && messengerOverview.topUrls.length) ?
									<Box className={`${styles.tableBody} ${styles.setScroll}`}>
											<Box className="internalCardsec">
												<TableContainer className={styles.tableContainer}>
													<Table aria-label="simple table">
														<TableHead className={styles.thead_background}>
															<TableRow>
																<TableCell className="w-45">URL</TableCell>
																<TableCell className="w-20" sx={{textAlign:"center"}}>Scan Score</TableCell>
																<TableCell className="w-25" >Receiver</TableCell>
																<TableCell className="w-5" ><AiOutlineCopy/></TableCell>
															</TableRow>
														</TableHead>
														<TableBody className={styles.mailRepWrap}>
														{messengerOverview.topUrls.sort((a,b) =>{
															return Math.round(b.score) - Math.round(a.score)
														}).map((url)=>{
															return <TableRow >
																	<TableCell component="td" scope="row">
																		<Box className={styles.iconFlex}>
																			<span><BsLink45Deg/></span>
																			<Box className={styles.rightIcon}>
																				<Typography component="p" className={styles.dashUrl}>{url.url.slice(0, 55) + "..."}</Typography>
																			</Box>
																		</Box>
																		</TableCell>
																		<TableCell component="td" scope="row" sx={{textAlign:"center"}}>{Math.round(url.score)}%</TableCell>
																		<TableCell component="td" scope="row">
																			<Box className={styles.iconFlex}>
																			
																				<Box className={styles.rightIcon}>
																					<Typography variant="h6">{url?.whatsappMessageId?.from}</Typography>
																					<Typography component="p">{url?.whatsappMessageId?.phoneNumber}</Typography> 
																				</Box>
																			</Box>
																		</TableCell>

																		<TableCell component="td" scope="row">
																			<AiOutlineCopy className="cursorPointer setColor" onClick={async ()=>{
																				await navigator.clipboard.writeText(url.url);
																				toast.success("Copied To Clipboard!")
																			}} />
																		</TableCell>
															</TableRow>

														})}

														</TableBody>   
													</Table>
												</TableContainer>	
												</Box>							
											</Box>
									:<Typography component="p" className={styles.maliciousCenter}>
																	No Vulnerable Url(s)
															</Typography>}
									</Box>
							</Grid>

							<Grid item md={6} lg={6} className="quickBarDash">
								<Box className="dashCard hRepTable heightM">
									<Box className="cardHeader">
										<Typography variant="h1" className="cardTitle">
											Top Malicious Senders
										</Typography>
									</Box>
									{(topSenders && topSenders.length) ?
									<Box className={`${styles.tableBody} ${styles.setScroll}`}>
											<Box className="internalCardsec">
												<TableContainer className={styles.tableContainer}>
													<Table aria-label="simple table">
														<TableHead className={styles.thead_background}>
															<TableRow>
																<TableCell className="w-25">Sender</TableCell>
																<TableCell className="w-30" sx={{textAlign:"center"}}>Total Messages</TableCell>
																<TableCell className="w-15" sx={{textAlign:"center"}}>Receivers</TableCell>
															</TableRow>
														</TableHead>
														<TableBody className={styles.mailRepWrap}>
															{ messengerOverview && messengerOverview.topSenders && messengerOverview.topSenders.map((sender)=>{
																return <TableRow >
																		<TableCell component="td" scope="row">
																			<Box className={styles.iconFlex}>
																				<span><BsPersonBoundingBox/></span>
																				<Box className={styles.rightIcon}>
																					<Typography variant="h6">{sender.sender ? sender.sender : 'Unkown'}</Typography>
																					<Typography component="p">{sender._id}</Typography> 
																				</Box>
																			</Box>
																		</TableCell>
																		<TableCell component="td" scope="row" sx={{textAlign:"center"}}>{sender.count}</TableCell>
																		<TableCell component="td" scope="row" sx={{textAlign:"center"}}>{sender.count}</TableCell>
															</TableRow>
															})}
															

														</TableBody>   
													</Table>
												</TableContainer>	
												</Box>							
											</Box>:	<Typography component="p" className={styles.maliciousCenter}>
																	No Malicious Sender(s)
															</Typography>
									}
									</Box>
							</Grid>
					</Grid>
				</TabPanel>


						{/* Modal Component */}
						<NewconnecttaModal
							taConnecthandleClose={taConnecthandleClose}
							taConnectopen={taConnectopen}
							changeConnectionStatusWithTa={() => console.log("Change Connection Status")}
						/>
				</Box>   
		</>
  	)
}

