import React from "react";
import { IoSearchOutline } from "react-icons/io5";
import { 
	Box, TextField, Typography, TableRow, Table,
	TableHead, TableContainer, TableCell, TableBody, Grid, Stack,FormControl, Select, MenuItem
} from "@mui/material";

import api from "../utils/api";
import routes from '../utils/routes';
import { apiError } from "../utils/error";
import { getDate } from "../utils/common";
import styles from "../styles/home.module.scss";
import Loader from '../components/loader/loader';
import Pagination from "../components/globlePagination";

export default function Domain() {

	const [ page, setPage ] = React.useState(1);
	const [ limit, setLimit ] = React.useState(10);
	const [ count, setCount ] = React.useState(10);
	const [ search, setSearch ] = React.useState('');
	const [ events, setEvents ] = React.useState([]);
	const [loader, setLoader] = React.useState(false);

	const handlePageChange = (event, value) => {
        setPage(value);
    };

	const loadEmail = () => {
		setLoader(true);
		api.get(routes.REPORTED_EMAIL.EVENT, {
			params: {
				page, limit, search
			}
		})
		.then(res => res.data)
		.then(data => {
			setLoader(false);
			setCount(data.count);
			setEvents(data.results);
		})
		.catch(err => {
			setLoader(false);
			apiError(err)
		})
	}

	React.useEffect(()=>{
		loadEmail()
	}, [ page, limit, search ])

	React.useEffect(() => {
        setPage(1)
    }, [ search ])
	return (
		<Box className={styles.ReportedBox}>	
			<Box className={styles.containerbar}>
				<Box className={styles.breadcrumbBar}>
                    <Grid container direction="row" justifyContent="center" alignItems="center" >
                        <Grid item xs={4}>
                            <Typography component='h4' variant='h4' className={styles.page_title}>Email Checked Events</Typography>
                        </Grid>

                        <Grid item xs={8} align="right">
                        </Grid>
                    </Grid>
                </Box>

				<Box className={styles.filterWrapper}>
					<Grid container direction="row" justifyContent="end" alignItems="center">
						<Grid item xs={12} md={4} align="right" position="relative">
								<TextField
									className={styles.searchBar}
									placeholder="Search"
									size="small"
									fullWidth
									value={search}
									onChange={e => setSearch(e.target.value)}
								/>
								<Typography component="span" className={styles.search_icon}>
								<IoSearchOutline />{" "}
								</Typography>
							</Grid>

							<Grid item xs={12} md={8} align="right" position="relative">
									<FormControl sx={{ minWidth: 100, borderLeft:'1px solid #e4e4e4;', textAlign:'center' }} size="small">
										<Select
											labelId="demo-simple-select-autowidth-label"
											id="demo-simple-select-autowidth"
											value={limit}
											onChange={e => setLimit(e.target.value)}
											autoWidth
											displayEmpty
											sx={{ boxShadow: 'none', '.MuiOutlinedInput-notchedOutline': { borderRadius: '0px', border: '1px solid #f8f8f8', paddginLeft: '20px' } }}
										>
											<MenuItem value="10">10 </MenuItem>
											<MenuItem value="25">25 </MenuItem>
											<MenuItem value="50">50 </MenuItem>
											<MenuItem value="100">100 </MenuItem>
										</Select>
									</FormControl>
							</Grid>
					</Grid>
				</Box>

				<Box className={styles.contentbarWrap}>
					<TableContainer className={styles.tableContainer}>
						<Table sx={{ minWidth: 650 }} aria-label="simple table" className={styles.ReportedMailTable}>
							<TableHead className={styles.thead_background}>
								<TableRow>
								<TableCell className={styles.mChecktd1}>From</TableCell>
								<TableCell className={styles.mChecktd2}>To</TableCell>
								<TableCell className={styles.mChecktd3}>Subject</TableCell>
								<TableCell className={styles.mChecktd4}>Mail Recieved Time</TableCell>
								<TableCell>Mail Checked Time</TableCell>
								<TableCell >Type</TableCell>
								<TableCell>Score</TableCell>
								</TableRow>
							</TableHead>
							<TableBody>
							{events.map((data, index) => (
								<TableRow sx={{ "&:last-child td, &:last-child th": { border: 0 } }}>
									
									<TableCell component="td" scope="row">
										{data.from}
									</TableCell>
									<TableCell component="td" scope="row">
										{data.to}
									</TableCell>
									<TableCell component="td" scope="row">
										{data.subject}
									</TableCell>
									<TableCell component="td" scope="row">
										{getDate(data.mailRecievedTime)}
									</TableCell>
									<TableCell component="td" scope="row">
										{getDate(data.createdAt)}
									</TableCell>
									<TableCell component="td" scope="row">{data.mailType}</TableCell>
									<TableCell component="td" scope="row">
												{data.score}
									</TableCell>
								</TableRow>
							))}
							</TableBody>
						</Table>
						{events && events.length > 0?
					<Stack spacing={2} direction="row" justifyContent='space-between' alignItems="center">
					<Pagination 
						count={count} 
						page={page}
						limit={limit}
						handlePageChange={handlePageChange}
					></Pagination>                    
				</Stack>:
                    <>{ !loader?
                            <Box className={styles.noRecordMail}>
                                <Typography component="p">No Records Found!</Typography>
                            </Box>:
                            <Box className={styles.noRecordMail}>
                                <Typography component="p" style={{color: "green"}}>Loading...</Typography>
                            </Box>
                        }
                    </>
                }
					</TableContainer>
				</Box>

				
			</Box>
			{/* { loader && <Loader />} */}
		</Box>	
	);
}
