import React from 'react';
import { useRouter } from 'next/router';
import { IoSearchOutline, IoCalendarClearOutline } from "react-icons/io5";
import {
    Box, Grid, TextField, Typography, MenuItem,
    Select, FormControl, TableRow, TableHead,
    TableContainer, TableCell, TableBody, Table, Button
} from '@mui/material'
import { TfiClose, TfiReload, TfiTrash, TfiArrowLeft } from "react-icons/tfi";
import { MdBlock } from "react-icons/md";

import Link from 'next/link';
import api from '../../../utils/api';
import routes from '../../../utils/routes';
import { apiError } from '../../../utils/error';
import { getDate } from '../../../utils/common';
import styles from '../../../styles/home.module.scss';
import Loader from '../../../components/loader/loader';
import Tooltip from '@mui/material/Tooltip';
import { TfiEmail } from "react-icons/tfi";
import Pagination from '../../../components/globlePagination';
import ModalCommon from '../../../components/modalCommon';
import Popover from '@mui/material/Popover';
import Radio from '@mui/material/Radio';
import RadioGroup from '@mui/material/RadioGroup';
import FormControlLabel from '@mui/material/FormControlLabel';
import DatePicker from "react-datepicker";
import "react-datepicker/dist/react-datepicker.css";
import { TfiDownload } from "react-icons/tfi";
import CircularProgress from '@mui/material/CircularProgress';
import { useFeatures } from '../../../utils/features';
import { FaCircle } from "react-icons/fa";
// import swalAlertBtn from '../../../utils/swal-types/swal-with-btn';
// import swalAlertRadio from '../../../utils/swal-types/swal-with-radio';
// import swalAlertDefault from '../../../utils/swal-types/swal-default';


export default function IgnoredEmails() {
    const router = useRouter()
    const [page, setPage] = React.useState(1);
    const [count, setCount] = React.useState(1);
    const [limit, setLimit] = React.useState(10);
    const [search, setSearch] = React.useState('');
    const [loader, setLoader] = React.useState(false);
    const [domains, setDomains] = React.useState([]);
    const [reportedMails, setReportedMails] = React.useState([]);
    const [ignoredMails, setIgnoredMails] = React.useState([]);
    const [selectedDomainId, setSelectedDomainId] = React.useState('-1')
    const [anchorEl, setAnchorEl] = React.useState(null);
    const [startDate, setStartDate] = React.useState(new Date());
    const [showBroadcastMails, setShowBroadcastMails] = React.useState(false)
    const { loadFeatures, canAccessFeature, areFeaturesLoaded } = useFeatures();
    const [selectedItems, setSelectedItems] = React.useState(new Set());
    const [selectAllCurrentPage, setSelectAllCurrentPage] = React.useState(false);
    const [showDomain, setShowDomain] = React.useState(false)
    const [showSearch, setShowSearch] = React.useState(false)
    const [isLite, setisLite] = React.useState(false)
    const [showLiteModal, setShowLiteModal] = React.useState(false)

    const [filter, setFilter] = React.useState({
        last15: false,
        last30: false,
        custom: false,
        none: false,
        fromDate: new Date(new Date().setDate(new Date().getDate() - 1)),
        toDate: new Date()
    })

    const [filterError, setFilterError] = React.useState({
        fromDate: { status: false, message: '' },
        toDate: { status: false, message: '' }
    })



        // Add this common function before your component functions
    const handleMailAction = (action, scope = null, customCallback = null) => {
        if (selectedItems.size === 0) {
            return;
        }
    
        const payload = {
            ids: Array.from(selectedItems),
            action: action
        };
    
        // Add scope if provided
        if (scope) {
            payload.scope = scope;
        }
    
        api.post(routes.WHO_ELSE.MAIL_ACTIONS, payload)
            .then((result) => {
                // Execute custom callback if provided, otherwise use default behavior
                if (customCallback) {
                    customCallback(result);
                } else {
                    fetchAllIgnoredMails();
                    setSelectedItems(new Set());
                }
            })
            .catch((error) => {
                console.error("Error", error);
            });
    };


    const handleRemoveMails = () => {
        swalAlertDefault({
            title: "Remove Email",
            text: "Remove Email",
            type: "remove",
            description: "The email is no longer available.",
            subDescription: "",
            icon: "danger",
            buttons: "Remove",
        }).then((result) => {
            if (result.success) {
                handleMailAction("remove", result.scope);
            }
        });
    }

    const handleDeleteMails = () => {
        swalAlertRadio({
            title: "Delete Record",
            text: "Delete Record",
            type: "delete",
            description: "Once deleted the data cannot be recovered.",
            subDescription: "",
            icon: "danger",
            buttons: "Delete",
            radioText1: "Who else Recipients",
            radioText2: "Similar Emails Recipients",
        }).then((result) => {
            if (result.success) {
                handleMailAction("delete", result.scope);
            } else {
                console.log("User cancelled the operation.");
            }
        });
    };

    const handleRecoveryMails = () => {
        swalAlertRadio({
            title: "Recover Complete",
            text: "Recover Complete",
            type: "recover",
            description: "Recovered data can be deleted or trash again",
            subDescription: "",
            icon: "success",
            buttons: "Recover",
            radioText1: "Who else Recipients",
            radioText2: "Similar Emails Recipients",
        }).then((result) => {
            if (result.success) {
                handleMailAction("recover", result.scope);
            }
        });
    };

    const handleTrashMails = () => {
        swalAlertRadio({
            title: "Sent to Trash ",
            text: "Sent to Trash",
            type: "trash",
            description: "Trash items can be recovered or permanently deleted.",
            subDescription: "",
            icon: "warning",
            buttons: "Trash",
            radioText1: "Who else Recipients",
            radioText2: "Similar Emails Recipients",

        }).then((result) => {
            if (result.success) {
                handleMailAction("trash", result.scope);
            }
        });
    };

    const handleClick = (event) => {

        setAnchorEl(event.currentTarget);
    };

    const handleClose = () => {
        setAnchorEl(null);
    };

    const open = Boolean(anchorEl);
    const id = open ? 'simple-popover' : undefined;

    const handleSelectedDomain = (event) => {
        const domainId = event.target.value
        setSelectedDomainId(domainId);
        setPage(1)
    };
    const handlePageChange = (event, value) => {
        setPage(value);
    };

    const loadReportedEmails = () => {
        setLoader(true);
        api.get(routes.REPORTED_EMAIL.LIST, {
            params: {
                page, limit, search,
                domainId: selectedDomainId && selectedDomainId !== '-1' ? selectedDomainId : null,
                isRecoveredEmail: false, isTrashedEmail: false, isDeletedEmail: false,
                mailType: '', last15: filter.last15, last30: filter.last30, custom: filter.custom, toDate: filter.toDate,
                fromDate: filter.fromDate,
            }
        })
            .then(res => res.data)
            .then(data => {
                setLoader(false)
                // setCount(data.countReportedEmails)
                setReportedMails(data.reportedEmails);
                setShowBroadcastMails(data.isBroadcast)
                // setFilter({...filter, last15:false, last30:false, custom:false})
            })
            .catch(err => {
                setLoader(false)
                apiError(err);
            })
    }

    const reportedMail = (reportId) => {
        router.push(`/reported-emails/${reportId}`)

    }

    const domainList = () => {
        api.get(routes.DOMAIN.LIST)
            .then(res => res.data)
            .then((data) => {
                if (data.domains.length && data.domains.length > 0) {
                    const domain = data.domains.filter((element) => {
                        if (element.isCredential !== false && element.domainTypeForOutlook != 'EXCHANGE') return element
                    })
                    setDomains(domain)
                    setShowDomain(true)
                }
            })
            .catch((error) => {
                if (!(error && error.response && error.response && error?.response?.status === 403)) apiError(error)
                else {
                    setShowDomain(false)
                }
            })
    }

    const openLiteModal = () => {
        setShowLiteModal(true)
    }
    const closeLiteModal = () => {
        setShowLiteModal(false)
    }


    const checkPackage = () => {
        api.get(routes.SETTINGS.CHECK_PACKAGE)
            .then(res => res.data)
            .then((data) => {
                setisLite(data.isLite)
            })
    }
    const showResultsbetweenDate = (e) => {
        if (e.target.value == 'none') {
            setFilter({ ...filter, last15: false, last30: false, custom: false, none: true })
            setShowSearch(false)
            handleClose()
        }
        if (e.target.value == 'last15') {
            setFilter({ ...filter, last15: new Date(new Date().setDate(new Date().getDate() - 15)).setHours(0, 0, 0, 0), last30: false, custom: false, none: false })
            setShowSearch(false)
            handleClose()
        }
        else if (e.target.value == 'last30') {
            setFilter({ ...filter, last30: new Date(new Date().setDate(new Date().getDate() - 30)).setHours(0, 0, 0, 0), last15: false, custom: false, none: false })
            setShowSearch(false)
            handleClose()
        }
        else if (e.target.value == 'date') {
            setShowSearch(true)
        }

    }

    const downloadMails = () => {
        filter['type'] = 'outlookOrGsuite'
        filter['isRecoveredEmail'] = false;
        filter['isTrashedEmail'] = false;
        filter['isDeletedEmail'] = false
        filter['domainId'] = selectedDomainId
        filter['search'] = search

        api.get(routes.REPORTED_EMAIL.DOWNLOAD_CSV, {
            params: {
                filter
            },
            responseType: 'blob'
        })
            .then((res) => res.data)
            .then((data) => {
                const blob = new Blob([data], { type: 'text/csv' });

                // Create a URL for the blob
                const url = URL.createObjectURL(blob);

                // Create a temporary link and trigger the download
                const link = document.createElement('a');
                link.href = url;
                link.download = 'reported_mails.csv'; // Set the download file name
                document.body.appendChild(link);
                link.click();

                // Clean up the temporary URL and link
                URL.revokeObjectURL(url);
                document.body.removeChild(link);
            })
            .catch((error) => {
                console.log(error);
            })
    }



    // Calculate current page item IDs
    const currentPageItemIds = React.useMemo(() => {
        return ignoredMails?.map(item => item._id) || [];
    }, [ignoredMails]);

    // Check if all items on current page are selected
    React.useEffect(() => {
        if (currentPageItemIds.length > 0) {
            const allCurrentPageSelected = currentPageItemIds.every(id => selectedItems.has(id));
            setSelectAllCurrentPage(allCurrentPageSelected);
        } else {
            setSelectAllCurrentPage(false);
        }
    }, [currentPageItemIds, selectedItems]);

    // Handle individual item selection
    const handleSelectItem = (itemId) => {
        const newSelectedItems = new Set(selectedItems);

        if (newSelectedItems.has(itemId)) {
            newSelectedItems.delete(itemId);
        } else {
            newSelectedItems.add(itemId);
        }

        setSelectedItems(newSelectedItems);
    };

    // Handle select all on current page
    const handleSelectAllCurrentPage = (event) => {
        const newSelectedItems = new Set(selectedItems);

        if (event.target.checked) {
            // Add all current page items
            currentPageItemIds.forEach(id => newSelectedItems.add(id));
        } else {
            // Remove all current page items
            currentPageItemIds.forEach(id => newSelectedItems.delete(id));
        }

        setSelectedItems(newSelectedItems);
    };

    // Reset selections when page changes
    React.useEffect(() => {
        if (currentPageItemIds.length > 0) {
            const allCurrentPageSelected = currentPageItemIds.every(id => selectedItems.has(id));
            setSelectAllCurrentPage(allCurrentPageSelected);
        } else {
            setSelectAllCurrentPage(false);
        }
    }, [page, currentPageItemIds, selectedItems]);

    const fetchAllIgnoredMails = () => {
        api.get(routes.REPORTED_EMAIL.IGNORED_LIST, {
            params: {
                page, limit, search,
                domainId: selectedDomainId && selectedDomainId !== '-1' ? selectedDomainId : null,
                isRecoveredEmail: false, isTrashedEmail: false, isDeletedEmail: false,
                mailType: '', last15: filter.last15, last30: filter.last30, custom: filter.custom, toDate: filter.toDate,
                fromDate: filter.fromDate,
            }
        })
            .then(res => res.data)
            .then((data) => {
                console.log("ignoredMails", data)
                setIgnoredMails(data.reportedEmails);
                setCount(data.countReportedEmails);
                setShowBroadcastMails(data.isBroadcast);

            })
            .catch((error) => {
                console.log(error);
            })
    }

    React.useEffect(() => {
        fetchAllIgnoredMails();
    }, []);



    React.useEffect(() => {
        if (filter.last15 || filter.last30 || filter.custom || filter.none) {
            setPage(1)
            fetchAllIgnoredMails()
        }
    }, [filter.last15, filter.last30, filter.custom, filter.none])

    React.useEffect(() => {
        domainList();
        checkPackage()
    }, []);

    React.useEffect(() => {
        fetchAllIgnoredMails();
    }, [limit, page, selectedDomainId, search])

    React.useEffect(() => {
        setPage(1)
    }, [search])

    React.useEffect(() => {
        loadFeatures()
    }, [])



    return (
        !areFeaturesLoaded ? <box>Loading</box> :
            <Box className={styles.ReportedBox}>
                <Box className={styles.containerbar}>
                    <Box className={styles.breadcrumbBar}>

                        <Grid container direction="row" justifyContent="center" alignItems="center" >
                            <Grid item xs={4}>
                                <Typography component='h4' variant='h4' className={styles.page_title}> <span className='backArrow' onClick={() => router.back()}><TfiArrowLeft /></span> All Ignored  Mails</Typography>
                            </Grid>

                            <Grid item xs={8} align="right">
                            </Grid>
                        </Grid>

                    </Box>
                    <Box className={styles.filterWrapper}>
                        <Grid container direction="row" justifyContent="center" alignItems="center" >
                            <Grid item xs={12} md={4}>
                                <Box className={styles.filterSearchBar}>
                                    <TextField
                                        className={styles.searchBar}
                                        placeholder='Search'
                                        size="small"
                                        value={search}
                                        onChange={e => setSearch(e.target.value)}
                                    />
                                    <Typography component="span" className={styles.search_icon} ><IoSearchOutline /> </Typography>
                                </Box>
                            </Grid>
                            <Grid item xs={12} md={8}>
                                <Box className={styles.RightFilterBox}>
                                    <Box className={styles.iconFilter} onClick={fetchAllIgnoredMails}>
                                        <TfiReload className={styles.refreshIcon} />
                                    </Box>
                                    <Box className={styles.datepickerWrap}>
                                        <Box onClick={handleClick} className={styles.iconFilter}>
                                            <IoCalendarClearOutline />
                                        </Box>
                                        <Popover
                                            id={id}
                                            open={open}
                                            anchorEl={anchorEl}
                                            onClose={handleClose}
                                            anchorOrigin={{
                                                vertical: 'bottom',
                                            }}
                                            sx={{ borderRadius: "5px", overflow: "visible" }} className={styles.abc}>
                                            <Box className={styles.dateinnerBox}>
                                                <FormControl>
                                                    <RadioGroup
                                                        aria-labelledby="demo-radio-buttons-group-label"
                                                        defaultValue="female"
                                                        name="radio-buttons-group"
                                                        onChange={(e) => showResultsbetweenDate(e)}
                                                    >
                                                        <FormControlLabel className={styles.svgCircle} value="none" control={<Radio />}
                                                            label={<Typography component="p">
                                                                None
                                                            </Typography>
                                                            }>
                                                        </FormControlLabel>
                                                        <FormControlLabel className={styles.svgCircle} value="last15" control={<Radio />}
                                                            label={<Typography component="p">
                                                                Within the last 15 Days
                                                            </Typography>
                                                            }>
                                                        </FormControlLabel>

                                                        <FormControlLabel value="last30" className={styles.svgCircle} control={<Radio />}
                                                            label={
                                                                <Typography component="p">
                                                                    Within the last 30 Days
                                                                </Typography>
                                                            }>
                                                        </FormControlLabel>


                                                        <Box className={styles.fromtoDate}>
                                                            <FormControlLabel className={styles.svgCircle} value="date" control={<Radio />}
                                                                sx={{ marginRight: "0px" }}>
                                                            </FormControlLabel>
                                                            <Box>
                                                                <Box className={styles.datePicker}>
                                                                    <Typography component="p">From</Typography>
                                                                    <DatePicker
                                                                        error={filterError.fromDate.status}
                                                                        helperText={filterError.fromDate.message}
                                                                        dateFormat="yyyy/MM/dd"
                                                                        disabledKeyboardNavigation
                                                                        selected={filter.fromDate}
                                                                        onChange={(date) => {
                                                                            setFilter({ ...filter, fromDate: new Date(new Date(date).setHours(0, 0, 0, 0)) });
                                                                            setFilterError({
                                                                                ...filterError,
                                                                                fromDate: { status: false, message: "" },
                                                                            });
                                                                        }}
                                                                        onKeyDown={(e) => e.preventDefault()}
                                                                        maxDate={filter.toDate ? filter.toDate : new Date()}
                                                                        className={styles.InputFieldBox}
                                                                    />

                                                                </Box>

                                                                <Box className={styles.datePicker}>
                                                                    <Typography component="p">To</Typography>
                                                                    <DatePicker
                                                                        error={filterError.toDate.status}
                                                                        helperText={filterError.toDate.message}
                                                                        dateFormat="yyyy/MM/dd"
                                                                        selected={filter.toDate}
                                                                        disabledKeyboarsdNavigation
                                                                        onChange={(date) => {
                                                                            setFilter({ ...filter, toDate: new Date(new Date(date).setHours(23, 59, 59, 999)) });
                                                                            setFilterError({
                                                                                ...filterError,
                                                                                toDate: { status: false, message: "" },
                                                                            });
                                                                        }}
                                                                        onKeyDown={(e) => e.preventDefault()}
                                                                        maxDate={new Date()}
                                                                        minDate={filter.fromDate}
                                                                        className={styles.InputFieldBox}
                                                                    />
                                                                </Box>

                                                            </Box>


                                                        </Box>

                                                    </RadioGroup>
                                                </FormControl>
                                                {showSearch ? <Box className={styles.searchBtn}>
                                                    <Button variant="contained" className={styles.primaryBtn} onClick={(e) => {
                                                        setFilter({ ...filter, last15: false, last30: false, custom: true, none: false })
                                                        handleClose()
                                                        setShowSearch(false)
                                                        if (filter.custom) {
                                                            setPage(1)
                                                            fetchAllIgnoredMails()
                                                        }
                                                    }} >Search</Button>
                                                </Box> : ''}

                                            </Box>
                                        </Popover>
                                    </Box>

                                    {showDomain &&
                                        <Box>
                                            <Select
                                                labelId="demo-simple-select-autowidth-label"
                                                id="demo-simple-select-autowidth"
                                                value={selectedDomainId}
                                                onChange={handleSelectedDomain}
                                                autoWidth
                                                displayEmpty
                                                size='small'
                                                className={styles.selectFilterBox}
                                            >
                                                <MenuItem value="-1">Domains</MenuItem>
                                                {domains.map((data) => <MenuItem value={data._id} key={data._id}>{data.domainName} ({data.domainType}) </MenuItem>)}
                                            </Select>
                                        </Box>
                                    }


                                    <Box>
                                        <Select
                                            labelId="demo-simple-select-autowidth-label"
                                            id="demo-simple-select-autowidth"
                                            value={limit}
                                            onChange={e => setLimit(e.target.value)}
                                            autoWidth
                                            displayEmpty
                                            size='small'
                                            className={styles.selectFilterBox}
                                        >
                                            <MenuItem value="10">10 </MenuItem>
                                            <MenuItem value="25">25 </MenuItem>
                                            <MenuItem value="50">50 </MenuItem>
                                            <MenuItem value="100">100 </MenuItem>
                                        </Select>
                                    </Box>
                                </Box>
                            </Grid>


                        </Grid>
                    </Box>

                    <Box className={styles.contentbarWrap}>
                        {/* <Box className={styles.filterInsideContentBar}>
                            <Grid container direction="row" justifyContent="center" alignItems="center" >
                                <Grid item xs={12} md={6}>
                                    <Typography component="p" className={styles.filterHeading}>List</Typography>
                                </Grid>
                                <Grid item xs={12} md={6} align="right">
                                    <Box className={styles.filterRightBox}>

                                        {
                                            selectedItems.size > 0 && <>
                                                <Button
                                                    variant="contained"
                                                    className={`${styles.btn} ${styles.btnSecondary}`} onClick={() => handleRemoveMails()}>
                                                    Remove
                                                </Button>
                                                <Button
                                                    variant="contained"
                                                    className={`${styles.btnIcon} ${styles.btnIconSecondary}`}
                                                    onClick={() => handleTrashMails()}>
                                                    <TfiTrash />
                                                </Button>
                                                <Button
                                                    variant="contained"
                                                    className={`${styles.btnIcon} ${styles.btnIconSuccess}`}
                                                    onClick={() => handleRecoveryMails()} >
                                                    <TfiReload />
                                                </Button>
                                                <Button
                                                    variant="contained"
                                                    className={`${styles.btnIcon} ${styles.btnIconDanger}`}
                                                    onClick={() => handleDeleteMails()} >
                                                    <TfiClose />
                                                </Button>
                                            </>
                                        }
                                    </Box>
                                </Grid>
                            </Grid>

                        </Box> */}
                        <TableContainer className={styles.tableContainer}>
                            <Table sx={{ minWidth: 650 }} aria-label="simple table" className={styles.ReportedMailTable}>
                                <TableHead className={styles.thead_background}>
                                    <TableRow>
                                        {/* <TableCell sx={{ width: "0%", textAlign: "center" }}><TfiEmail /></TableCell> */}
                                        {/* <TableCell padding="checkbox">
                                            <input
                                                type="checkbox"
                                                checked={selectAllCurrentPage}
                                                onChange={handleSelectAllCurrentPage}
                                                style={{
                                                    transform: 'scale(1.2)',
                                                    accentColor: '#1976d2'
                                                }}
                                            />
                                        </TableCell> */}
                                        <TableCell  >Reported By</TableCell>
                                        <TableCell className={styles.td2}>Sender</TableCell>
                                        <TableCell className={styles.td3}>Subject</TableCell>
                                        <TableCell className={styles.td5}>Type</TableCell>
                                        <TableCell className={styles.td4}>Who Else Count</TableCell>
                                        <TableCell >Reported Time</TableCell>
                                    </TableRow>
                                </TableHead>
                                <TableBody className={styles.reportedMail}>
                                    {ignoredMails?.length > 0 ? ignoredMails.map((data, index) => (
                                        <TableRow key={index} sx={{ '&:last-child td, &:last-child th': { border: 0 } }} onClick={!canAccessFeature("TPIR-VRE") ? () => router.push("/feature-unavailable") : () => reportedMail(data._id)}>
                                            {/* <TableCell ><TfiEmail className={styles.emailIcon} /></TableCell> */}
                                            {/* <TableCell padding="checkbox" onClick={(e) => e.stopPropagation()}>
                                                <input
                                                    type="checkbox"
                                                    checked={selectedItems.has(data._id)}
                                                    onChange={(e) => {
                                                        e.stopPropagation();
                                                        handleSelectItem(data._id);
                                                    }}
                                                    style={{
                                                        transform: 'scale(1.2)',
                                                        accentColor: '#1976d2'
                                                    }}
                                                />
                                            </TableCell> */}
                                            <TableCell component="td" scope="row">

                                                <Box className={styles.reportDflex} style={data.isRead ? { paddingLeft: 0 } : {}}>
                                                    <Box>
                                                        <Typography component="p"><b className={styles.reportName}>{data.toName && data.toName}{(data.isMailActionProcessing !== null) ?
                                                            <CircularProgress />
                                                            : ''}</b></Typography>
                                                        {data.to} {data && data.reporters && data.reporters.length != 0 && <Tooltip title={data.reporters.map((reporter) => { return <><span>{reporter.email}</span><br /></> })} placement="bottom" ><span className={styles.in_queue}>+{data.reporters.length}</span></Tooltip>}
                                                    </Box>
                                                    <Box sx={{ display: 'flex' }} className={styles.repLoader}></Box>

                                                    {
                                                        !data.isRead && (
                                                            <span className="circlePrimaryIcon"> <FaCircle /> </span>
                                                        )
                                                    }

                                                </Box>

                                            </TableCell>
                                            <TableCell component="td" scope="row">
                                                <Typography component="p"><b className={styles.reportName}>{data.fromName && data.fromName}</b></Typography>
                                                <Typography component="p"> {` ${data.from}`}</Typography>
                                            </TableCell>
                                            <TableCell component="td" scope="row">{data && data.subject && data.subject.slice(0, 50) + "..."}</TableCell>
                                            <TableCell component="td" scope="row">{data.mailType}</TableCell>
                                            <TableCell component="td" scope="row" sx={{ textAlign: "center", fontWeight: "700" }}>{data.emailCount}</TableCell>
                                            <TableCell component="td" scope="row">
                                                <Box className={styles.mddelete}>
                                                    <Typography component="p">{getDate(data.createdAt)}</Typography>
                                                </Box>
                                            </TableCell>

                                        </TableRow>
                                    )) : (
                                        !loader &&
                                        <TableRow>
                                            <TableCell colSpan={6}>
                                                No Ignored Mails Found!
                                               
                                            </TableCell>
                                        </TableRow>
                                    )
                                    }
                                </TableBody>
                            </Table>
                            {ignoredMails && ignoredMails.length ?
                                <Pagination
                                    count={count}
                                    page={page}
                                    limit={limit}
                                    handlePageChange={handlePageChange}
                                ></Pagination> : ""
                            }
                        </TableContainer>
                    </Box>
                    {/* { loader && <Loader />} */}
                    <ModalCommon open={showLiteModal} onClick={closeLiteModal} />

                </Box>
            </Box>
    );
}