import React, { useEffect, useState } from "react";
import {
  Box,
  Chip,
  Grid,
  Switch,
  label,
  Modal,
  TextField,
  ListItemText,
  InputLabel,
  Tooltip,
  MenuItem,
  FormControl,
  Select,
  Menu,
  Typography,
  Stack,
  Tab,
  Tabs,
  Button,
  TableRow,
  TableHead,
  TableContainer,
  TableCell,
  TableBody,
  Table,
  IconButton,
} from "@mui/material";
import styles from "../styles/home.module.scss";
import Image from "next/image";
import Icon from "../assets/logo/Group.png";
import { MdTrackChanges, MdAccessTime } from "react-icons/md";
import { TbEdit } from "react-icons/tb";
import { TfiEye } from "react-icons/tfi";
import {
  IoSearchOutline,
  IoTrash,
  IoAdd,
  IoAddCircleOutline,
  IoMailOutline,
} from "react-icons/io5";
import { useRouter } from "next/router";
import api from "../utils/api";
import routes from "../utils/routes";
import { toast } from "react-toastify";

export default function Domain() {
  const router = useRouter();
  const [bannerEnabled, setBannerEnabled] = useState(false);
  const [toggleLoading, setToggleLoading] = useState(false);

  // Fetch initial enabled/disabled state
  useEffect(() => {
    let cancelled = false;
    setToggleLoading(true);
    api
      .get(routes.SMART_BANNER.GET_STATUS)
      .then(res => {
        if (!cancelled && res?.data && typeof res.data.status === 'boolean') {
          setBannerEnabled(res.data.status);
        }
      })
      .catch(err => {
        console.error('Failed to fetch smart banner status', err);
      })
      .finally(() => {
        if (!cancelled) setToggleLoading(false);
      });
    return () => { cancelled = true; };
  }, []);

  const handleToggle = async (event) => {
    const next = event.target.checked;
    setBannerEnabled(next); // optimistic update
    setToggleLoading(true);
    try {
  const res = await api.post(routes.SMART_BANNER.ENABLE_DISABLE, { status: next });
  const msg = res?.data?.message || res?.data?.Message || `Banner ${next ? "enabled" : "disabled"}`;
  toast.success(msg);
    } catch (err) {
      // revert on error
      setBannerEnabled(!next);
  const apiMsg = err?.response?.data?.message || err?.response?.data?.error || err?.message || 'Failed to update banner status';
  toast.error(apiMsg);
  console.error("Smart Banner toggle error", err);
    } finally {
      setToggleLoading(false);
    }
  };
  return (
    <Box className={styles.contentbar}>
      <Box className={styles.containerbar}>
        {/*============ breadcrumbBar Starts ============= */}
        <Box className={styles.breadcrumbBar}>
          <Grid
            container
            direction="row"
            justifyContent="center"
            alignItems="center"
          >
            <Grid item xs={4}>
              <Typography
                component="h4"
                variant="h4"
                className={styles.page_title}
              >
                Smart Banner Workflow
              </Typography>
            </Grid>
            <Grid item xs={8} align="right">
              {" "}
            </Grid>
          </Grid>
        </Box>
        {/*============ breadcrumbBar Ends ============= */}

        <Box className={styles.contentbarWrap}>
          {/* <Box className={styles.workflowsSwitchBar}>
            <Typography component="p" variant="p">
              Enable all workflows
            </Typography>
            <Switch {...label} label="Required" className={styles.switch} />
          </Box> */}

          <Box className={styles.workflowsListCard}>
         
              <Grid container spacing={2}>
                <Grid item xs={12} sm={4} md={4}>
                  <Box className={styles.workflowCard}>
                    <Box className={styles.CardOne}>
                        <Box className={styles.workflowCardHeader}>
                          <Box className={styles.DflexRow}>
                            <Box className={styles.leftBox}>
                              <Box className={styles.iconBox}>
                                <Image src={Icon} alt="Smart Banner Icon" />
                              </Box>
                              <Box>
                                <Typography component="h4" variant="h4">
                                  Threshold Auto-Banner
                                </Typography>
                                <Typography component="p" variant="p">
                                  Inject warning banner for all recipients
                                </Typography>
                              </Box>
                            </Box>

                            <Box>
                              <Switch
                                checked={bannerEnabled}
                                onChange={handleToggle}
                                disabled={toggleLoading}
                                className={styles.switch}
                                inputProps={{ 'aria-label': 'Enable Smart Banner' }}
                              />
                            </Box>
                          </Box>

                          {/* <Box className={styles.timeBox}>
                            <Box className={`${styles.timeFlex} ${styles.timeBorder}`}>
                              <MdTrackChanges />
                              <Box className={styles.timeContent}>
                                <Typography component="h6" variant="h6">
                                  Triggered : 
                                </Typography>
                                <Typography component="p" variant="p">
                                   12 times
                                </Typography>
                              </Box>
                            </Box>
                            <Box className={styles.timeFlex}>
                              <MdTrackChanges />
                              <Box className={styles.timeContent}>
                                <Typography component="h6" variant="h6">
                                  Last Triggered: 
                                </Typography>
                                <Typography component="p" variant="p">
                                   2 hours ago
                                </Typography>
                              </Box>
                            </Box>
                          </Box> */}
                        </Box>
                     </Box>


                     <Box className={styles.workflowCardFooter}>
                      <Box className={styles.alertBox}>
                        <Box className={styles.alertInnerBox}>
                           <Box className={styles.logo}>
                            <Image src="https://tpir.threatcop.com/favicon.png" alt="Alert Icon" width={32} height={32} />
                          </Box>
                          <Typography component="p" variant="p">
                              Unusual activity has been detected in your email account, possibly indicating phishing, spoofing, or unauthorized access. Please review the flagged emails and avoid clicking unknown links or downloading suspicious attachments.
                          </Typography>
                          {/* <Box className={styles.secondaryMessage}>
                             <Typography variant="h5" component="h5">Secondary Message</Typography>
                          </Box> */}
                        </Box>
                         
                      </Box>

                      {/* <Box className={styles.previewBox}>
                       <Button
                           className={styles.previewButton}
                           onClick={()=>router.push("/smart-banner/[id]", "/smart-banner/1")}
                       >
                           <span className={styles.previewText}><TbEdit/></span> Edit
                       </Button>


                          <Button
                            className={styles.previewButton}
                          > 
                           <span className={styles.previewText}><TfiEye/></span> Preview 
                        </Button>
                      </Box> */}
                    
                     </Box>
                      
                  </Box>
                </Grid>
                 {/* <Grid item xs={12} sm={4} md={4}>
                  <Box className={styles.workflowCard}>
                    <Box className={styles.CardOne}>
                        <Box className={styles.workflowCardHeader}>
                          <Box className={styles.DflexRow}>
                            <Box className={styles.leftBox}>
                              <Box className={styles.iconBox}>
                                <Image src={Icon} alt="Smart Banner Icon" />
                              </Box>
                              <Box>
                                <Typography component="h4" variant="h4">
                                  Threshold Auto-Banner
                                </Typography>
                                <Typography component="p" variant="p">
                                  Inject warning banner for all recipients
                                </Typography>
                              </Box>
                            </Box>

                            <Box>
                              <Switch
                                {...label}
                                label="Required"
                                className={styles.switch}
                              />
                            </Box>
                          </Box>

                          <Box className={styles.timeBox}>
                            <Box className={`${styles.timeFlex} ${styles.timeBorder}`}>
                              <MdTrackChanges />
                              <Box className={styles.timeContent}>
                                <Typography component="h6" variant="h6">
                                  Triggered : 
                                </Typography>
                                <Typography component="p" variant="p">
                                   12 times
                                </Typography>
                              </Box>
                            </Box>
                            <Box className={styles.timeFlex}>
                              <MdTrackChanges />
                              <Box className={styles.timeContent}>
                                <Typography component="h6" variant="h6">
                                  Last Triggered: 
                                </Typography>
                                <Typography component="p" variant="p">
                                   2 hours ago
                                </Typography>
                              </Box>
                            </Box>
                          </Box>
                        </Box>
                     </Box>


                     <Box className={styles.workflowCardFooter}>
                      <Box className={styles.alertBox}>
                        <Box className={styles.alertInnerBox}>
                           <Box className={styles.logo}>
                            <Image src={Icon} alt="Alert Icon" />
                          </Box>
                          <Typography component="p" variant="p">
                              Unusual activity has been detected in your email account, possibly indicating phishing, spoofing, or unauthorized access. Please review the flagged emails and avoid clicking unknown links or downloading suspicious attachments.
                          </Typography>
                          <Box className={styles.secondaryMessage}>
                             <Typography variant="h5" component="h5">Secondary Message</Typography>
                          </Box>
                        </Box>
                         
                      </Box>

                      <Box className={styles.previewBox}>
                       <Button
                           className={styles.previewButton}
                       >
                           <span className={styles.previewText}><TbEdit/></span> Edit
                       </Button>


                          <Button
                            className={styles.previewButton}
                          > 
                           <span className={styles.previewText}><TfiEye/></span> Preview 
                        </Button>
                      </Box>
                    
                     </Box>
                      
                  </Box>
                </Grid>
                 <Grid item xs={12} sm={4} md={4}>
                  <Box className={styles.workflowCard}>
                    <Box className={styles.CardOne}>
                        <Box className={styles.workflowCardHeader}>
                          <Box className={styles.DflexRow}>
                            <Box className={styles.leftBox}>
                              <Box className={styles.iconBox}>
                                <Image src={Icon} alt="Smart Banner Icon" />
                              </Box>
                              <Box>
                                <Typography component="h4" variant="h4">
                                  Threshold Auto-Banner
                                </Typography>
                                <Typography component="p" variant="p">
                                  Inject warning banner for all recipients
                                </Typography>
                              </Box>
                            </Box>

                            <Box>
                              <Switch
                                {...label}
                                label="Required"
                                className={styles.switch}
                              />
                            </Box>
                          </Box>

                          <Box className={styles.timeBox}>
                            <Box className={`${styles.timeFlex} ${styles.timeBorder}`}>
                              <MdTrackChanges />
                              <Box className={styles.timeContent}>
                                <Typography component="h6" variant="h6">
                                  Triggered : 
                                </Typography>
                                <Typography component="p" variant="p">
                                   12 times
                                </Typography>
                              </Box>
                            </Box>
                            <Box className={styles.timeFlex}>
                              <MdTrackChanges />
                              <Box className={styles.timeContent}>
                                <Typography component="h6" variant="h6">
                                  Last Triggered: 
                                </Typography>
                                <Typography component="p" variant="p">
                                   2 hours ago
                                </Typography>
                              </Box>
                            </Box>
                          </Box>
                        </Box>
                     </Box>


                     <Box className={styles.workflowCardFooter}>
                      <Box className={styles.alertBox}>
                        <Box className={styles.alertInnerBox}>
                           <Box className={styles.logo}>
                            <Image src={Icon} alt="Alert Icon" />
                          </Box>
                          <Typography component="p" variant="p">
                              Unusual activity has been detected in your email account, possibly indicating phishing, spoofing, or unauthorized access. Please review the flagged emails and avoid clicking unknown links or downloading suspicious attachments.
                          </Typography>
                          <Box className={styles.secondaryMessage}>
                             <Typography variant="h5" component="h5">Secondary Message</Typography>
                          </Box>
                        </Box>
                         
                      </Box>

                      <Box className={styles.previewBox}>
                       <Button
                           className={styles.previewButton}
                       >
                           <span className={styles.previewText}><TbEdit/></span> Edit
                       </Button>


                          <Button
                            className={styles.previewButton}
                          > 
                           <span className={styles.previewText}><TfiEye/></span> Preview 
                        </Button>
                      </Box>
                    
                     </Box>
                      
                  </Box>
                </Grid>

                 <Grid item xs={12} sm={4} md={4}>
                  <Box className={styles.workflowCard}>
                    <Box className={styles.CardOne}>
                        <Box className={styles.workflowCardHeader}>
                          <Box className={styles.DflexRow}>
                            <Box className={styles.leftBox}>
                              <Box className={styles.iconBox}>
                                <Image src={Icon} alt="Smart Banner Icon" />
                              </Box>
                              <Box>
                                <Typography component="h4" variant="h4">
                                  Threshold Auto-Banner
                                </Typography>
                                <Typography component="p" variant="p">
                                  Inject warning banner for all recipients
                                </Typography>
                              </Box>
                            </Box>

                            <Box>
                              <Switch
                                {...label}
                                label="Required"
                                className={styles.switch}
                              />
                            </Box>
                          </Box>

                          <Box className={styles.timeBox}>
                            <Box className={`${styles.timeFlex} ${styles.timeBorder}`}>
                              <MdTrackChanges />
                              <Box className={styles.timeContent}>
                                <Typography component="h6" variant="h6">
                                  Triggered : 
                                </Typography>
                                <Typography component="p" variant="p">
                                   12 times
                                </Typography>
                              </Box>
                            </Box>
                            <Box className={styles.timeFlex}>
                              <MdTrackChanges />
                              <Box className={styles.timeContent}>
                                <Typography component="h6" variant="h6">
                                  Last Triggered: 
                                </Typography>
                                <Typography component="p" variant="p">
                                   2 hours ago
                                </Typography>
                              </Box>
                            </Box>
                          </Box>
                        </Box>
                     </Box>


                     <Box className={styles.workflowCardFooter}>
                      <Box className={styles.alertBox}>
                        <Box className={styles.alertInnerBox}>
                           <Box className={styles.logo}>
                            <Image src={Icon} alt="Alert Icon" />
                          </Box>
                          <Typography component="p" variant="p">
                              Unusual activity has been detected in your email account, possibly indicating phishing, spoofing, or unauthorized access. Please review the flagged emails and avoid clicking unknown links or downloading suspicious attachments.
                          </Typography>
                          <Box className={styles.secondaryMessage}>
                             <Typography variant="h5" component="h5">Secondary Message</Typography>
                          </Box>
                        </Box>
                         
                      </Box>

                      <Box className={styles.previewBox}>
                       <Button
                           className={styles.previewButton}
                       >
                           <span className={styles.previewText}><TbEdit/></span> Edit
                       </Button>


                          <Button
                            className={styles.previewButton}
                          > 
                           <span className={styles.previewText}><TfiEye/></span> Preview 
                        </Button>
                      </Box>
                    
                     </Box>
                      
                  </Box>
                </Grid>

                 <Grid item xs={12} sm={4} md={4}>
                  <Box className={styles.workflowCard}>
                    <Box className={styles.CardOne}>
                        <Box className={styles.workflowCardHeader}>
                          <Box className={styles.DflexRow}>
                            <Box className={styles.leftBox}>
                              <Box className={styles.iconBox}>
                                <Image src={Icon} alt="Smart Banner Icon" />
                              </Box>
                              <Box>
                                <Typography component="h4" variant="h4">
                                  Threshold Auto-Banner
                                </Typography>
                                <Typography component="p" variant="p">
                                  Inject warning banner for all recipients
                                </Typography>
                              </Box>
                            </Box>

                            <Box>
                              <Switch
                                {...label}
                                label="Required"
                                className={styles.switch}
                              />
                            </Box>
                          </Box>

                          <Box className={styles.timeBox}>
                            <Box className={`${styles.timeFlex} ${styles.timeBorder}`}>
                              <MdTrackChanges />
                              <Box className={styles.timeContent}>
                                <Typography component="h6" variant="h6">
                                  Triggered : 
                                </Typography>
                                <Typography component="p" variant="p">
                                   12 times
                                </Typography>
                              </Box>
                            </Box>
                            <Box className={styles.timeFlex}>
                              <MdTrackChanges />
                              <Box className={styles.timeContent}>
                                <Typography component="h6" variant="h6">
                                  Last Triggered: 
                                </Typography>
                                <Typography component="p" variant="p">
                                   2 hours ago
                                </Typography>
                              </Box>
                            </Box>
                          </Box>
                        </Box>
                     </Box>


                     <Box className={styles.workflowCardFooter}>
                      <Box className={styles.alertBox}>
                        <Box className={styles.alertInnerBox}>
                           <Box className={styles.logo}>
                            <Image src={Icon} alt="Alert Icon" />
                          </Box>
                          <Typography component="p" variant="p">
                              Unusual activity has been detected in your email account, possibly indicating phishing, spoofing, or unauthorized access. Please review the flagged emails and avoid clicking unknown links or downloading suspicious attachments.
                          </Typography>
                          <Box className={styles.secondaryMessage}>
                             <Typography variant="h5" component="h5">Secondary Message</Typography>
                          </Box>
                        </Box>
                         
                      </Box>

                      <Box className={styles.previewBox}>
                       <Button
                           className={styles.previewButton}
                       >
                           <span className={styles.previewText}><TbEdit/></span> Edit
                       </Button>


                          <Button
                            className={styles.previewButton}
                          > 
                           <span className={styles.previewText}><TfiEye/></span> Preview 
                        </Button>
                      </Box>
                    
                     </Box>
                      
                  </Box>
                </Grid>

                 <Grid item xs={12} sm={4} md={4}>
                  <Box className={styles.workflowCard}>
                    <Box className={styles.CardOne}>
                        <Box className={styles.workflowCardHeader}>
                          <Box className={styles.DflexRow}>
                            <Box className={styles.leftBox}>
                              <Box className={styles.iconBox}>
                                <Image src={Icon} alt="Smart Banner Icon" />
                              </Box>
                              <Box>
                                <Typography component="h4" variant="h4">
                                  Threshold Auto-Banner
                                </Typography>
                                <Typography component="p" variant="p">
                                  Inject warning banner for all recipients
                                </Typography>
                              </Box>
                            </Box>

                            <Box>
                              <Switch
                                {...label}
                                label="Required"
                                className={styles.switch}
                              />
                            </Box>
                          </Box>

                          <Box className={styles.timeBox}>
                            <Box className={`${styles.timeFlex} ${styles.timeBorder}`}>
                              <MdTrackChanges />
                              <Box className={styles.timeContent}>
                                <Typography component="h6" variant="h6">
                                  Triggered : 
                                </Typography>
                                <Typography component="p" variant="p">
                                   12 times
                                </Typography>
                              </Box>
                            </Box>
                            <Box className={styles.timeFlex}>
                              <MdTrackChanges />
                              <Box className={styles.timeContent}>
                                <Typography component="h6" variant="h6">
                                  Last Triggered: 
                                </Typography>
                                <Typography component="p" variant="p">
                                   2 hours ago
                                </Typography>
                              </Box>
                            </Box>
                          </Box>
                        </Box>
                     </Box>


                     <Box className={styles.workflowCardFooter}>
                      <Box className={styles.alertBox}>
                        <Box className={styles.alertInnerBox}>
                           <Box className={styles.logo}>
                            <Image src={Icon} alt="Alert Icon" />
                          </Box>
                          <Typography component="p" variant="p">
                              Unusual activity has been detected in your email account, possibly indicating phishing, spoofing, or unauthorized access. Please review the flagged emails and avoid clicking unknown links or downloading suspicious attachments.
                          </Typography>
                          <Box className={styles.secondaryMessage}>
                             <Typography variant="h5" component="h5">Secondary Message</Typography>
                          </Box>
                        </Box>
                         
                      </Box>

                      <Box className={styles.previewBox}>
                       <Button
                           className={styles.previewButton}
                       >
                           <span className={styles.previewText}><TbEdit/></span> Edit
                       </Button>


                          <Button
                            className={styles.previewButton}
                          > 
                           <span className={styles.previewText}><TfiEye/></span> Preview 
                        </Button>
                      </Box>
                    
                     </Box>
                      
                  </Box>
                </Grid> */}
              </Grid>
          

          </Box>
        </Box>
      </Box>
    </Box>
  );
}
