import React from 'react';
import { IoSearchOutline,IoTrash } from "react-icons/io5";
import { 
    Box, Grid, Chip, TextField, Switch, Typography, 
    MenuItem, Select, FormControl, Stack, Button, TableRow, 
    TableHead, TableContainer, TableCell, TableBody, Modal, Table, Menu,  Tabs, Tab, Tooltip, IconButton 
} from '@mui/material'
import swal from 'sweetalert'
import PropTypes from 'prop-types';
import OutlinedInput from '@mui/material/OutlinedInput';
import InputLabel from '@mui/material/InputLabel';
import ListItemText from '@mui/material/ListItemText';
import Checkbox from '@mui/material/Checkbox';
import FormGroup from '@mui/material/FormGroup';
import FormControlLabel from '@mui/material/FormControlLabel';
import { FaWhatsapp, FaRegCommentAlt } from "react-icons/fa";
import { TfiDownload, TfiCalendar, TfiEmail, TfiUser } from "react-icons/tfi";
import ArrowDropDownIcon from '@mui/icons-material/ArrowDropDown';
import CloseSharpIcon from "@mui/icons-material/CloseSharp";
import styles from '../styles/home.module.scss'
import api from '../utils/api';
import routes from '../utils/routes';
import { apiError } from '../utils/error';
import { checkIsTacEnabled, downloadURI } from '../utils/common';
import Loader from '../components/loader/loader';
import Pagination from '../components/globlePagination';
import UserDrawer from '../components/reported-mails/drawer/user-drawer'
import { ConstructionOutlined } from '@mui/icons-material';
import { AppContext } from '../components/appcontext';
import Alert from '@mui/material/Alert';
import { toast } from 'react-toastify';
import CloseIcon from '@mui/icons-material/Close';
import Collapse from '@mui/material/Collapse';
import Cookies from 'js-cookie';
import { useRouter } from 'next/router';
import { useFeatures } from '../utils/features';
import PublicIcon from '@mui/icons-material/Public';
import FilterListIcon from '@mui/icons-material/FilterList';



const ITEM_HEIGHT = 48;
const ITEM_PADDING_TOP = 8;
const MenuProps = {
    PaperProps: {
        style: {
          overflow: 'auto', // Add this line to enable scrolling
          '.MuiOutlinedInput-notchedOutline': { borderRadius: '0px', paddingLeft: '20px' },
        },
      },
};

const names = [
  'Oliver Hansen',
  'Van Henry',
  'April Tucker',
];

export default function Domain() {
    const router = useRouter();

    const isInitialRender = React.useRef(true);
    const [value, setValue] = React.useState(0);
    const [anchorEl, setAnchorEl] = React.useState(null); 
    const [openModal, setOpenModal] = React.useState(false);
    const [selectedAction, setSelectedAction] = React.useState(null);
    const [domains, setDomains] = React.useState([])
    const isTacEnabled = checkIsTacEnabled();
    const [open, setOpen] = React.useState(true);

    const [alertopen, setAlertOpen] = React.useState(true);
    
    const remainingUserLimit  = Cookies.get("URL")
    const isMessengerLimitReached = Cookies.get("MessengerLimitReached")
	const isEmailLimitReached = Cookies.get("EmailLimitReached")

    const { canAccessFeature, loadFeatures, areFeaturesLoaded } = useFeatures()


        
    const [ usersData, setUsersData ] =  React.useState([]);
    const [ usersEmailData, setUsersEmailData ] =  React.useState([]);
    const [ usersWhatsappData, setUsersWhatsappData ] =  React.useState([]);
    const [ page, setPage ] = React.useState(1);
    const [ limit, setLimit ] = React.useState(10);
    const [ search, setSearch ] = React.useState('');
    const [ count, setCount ] = React.useState(1);  
    const [ emailUsersCount, setEmailUsersCount ] = React.useState(1);  
    const [ whatsappUsersCount, setWhatsappUsersCount ] = React.useState(1);  
    const [ activeUsers, setActiveUsers ] = React.useState({})
    const [ activeUsersMessenger, setActiveUsersMessenger ] = React.useState({})
    const [loader, setLoader] = React.useState(false);
    const [userDrawerState, setUserDrawerState] = React.useState({right: false });
    const [ userDetails, setUserDetails ] = React.useState({ reportedMails:'', reportedMessages:'', userStats:''  });
    const [ userReportPagination, setUserReportPagination ] = React.useState({
        page:1,
        limit:10,
        count:1
    })
    const [ userReportMessagePagination, setUserReportMessagePagination ] = React.useState({
        page:1,
        limit:10,
        count:1
    })
  const [debouncedUserSearch, setDebouncedUserSearch] = React.useState("")

  //Importing all-users-tpir of a domain
  const [selectedDomain, setSelectedDomain] = React.useState("-1");

  const handleDomainSelect = (event) => {
    const domainId = event.target.value;
    setSelectedDomain(domainId);
  };


    const switchTab = (event, newValue) => {
        setValue(newValue);
        setPage(1)
    };
    function TabPanel(props) {
        const { children, value, index, ...other } = props;
        return (
            <div
                role="tabpanel"
                hidden={value !== index}
                id={`simple-tabpanel-${index}`}
                aria-labelledby={`simple-tab-${index}`}
                {...other}
            >
                {value === index && <Box sx={{ p: 3 }}>{children}</Box>}
            </div>
        );
    }

    TabPanel.propTypes = {
        children: PropTypes.node,
        index: PropTypes.number.isRequired,
        value: PropTypes.number.isRequired,
    };

    function a11yProps(index) {
        return {
            id: `simple-tab-${index}`,
            'aria-controls': `simple-tabpanel-${index}`,
        };
    }

      

    const toggleUserDrawer = (open, email, phoneNumber) => {
        if(open){
            api.post(routes.USERS.REPORT,{
                page: userReportPagination.page, limit: userReportPagination.limit, email, phoneNumber
            })
            .then((res)=>res.data)
            .then((data)=>{
                setUserDetails({ reportedMails: data.reportedMails, userStats: data.userStats, reportedMessages: data.reportedMessages })
                setUserDrawerState({ ...userDrawerState, right: open });
                setUserReportPagination({...userReportPagination, count: data.count});
                setUserReportMessagePagination({...userReportMessagePagination, count: data.messengerCount})
            })
            .catch((error)=>{
                apiError(error)
            })
        }
        else  setUserDrawerState({ ...userDrawerState, right: open });
        
    };

    const handlePageChangeReports = (event, value) => {
        setUserReportPagination({...userReportPagination, page: value})  
    };

    const handlePageChangeMessageReports = (event, value) => {
        setUserReportMessagePagination({...userReportMessagePagination, page: value})  
    };

    
    const handlePageChange = (event, value) => {
        setPage(value);
    };


    const handleCloseModal = () => {
        setOpenModal(false);
      };


    const deleteUserSwal = async (userId) =>{
        const willDelete = await swal({
            title: "Are you sure?",
            text: "Are you sure you want to Delete this User?",
            icon: "warning",
            dangerMode: true,
            closeOnEsc: true,
            buttons: {
                cancel: true,
                confirm: true,
              },
        });
           
        console.log({willDelete});
        if (willDelete) {
            deleteUser(userId)
        }
    }

    // FILTER STATES
    const [statusFilter, setStatusFilter] = React.useState('all'); // 'all', 'active', 'inactive'
    const [statusFilterWhatsapp, setStatusFilterWhatsapp] = React.useState('all');
    const [anchorElStatus, setAnchorElStatus] = React.useState(null);
    const [anchorElStatusWhatsapp, setAnchorElStatusWhatsapp] = React.useState(null);

    // Update loadUsersList to use backend filtering
    const loadUsersList = () => {
        let params = { page, limit, search };
        if (value === 1) {
            params.isActiveEmail = statusFilter;
        }
        if (value === 2) {
            params.isActiveWhatsapp = statusFilterWhatsapp;
        }
        api.get(routes.USERS.LIST, { params })
        .then(res => res.data)
        .then(data => {
            let activeState = {};
            let activeStateForMessenger = {};
            for(let i=0; i<data.emailUsers.length; i++){
                activeState[data.emailUsers[i]._id] = data.emailUsers[i].isActive
            }
            for(let i=0; i<data.whatsappUsers.length; i++){
                activeStateForMessenger[data.whatsappUsers[i]._id] = data.whatsappUsers[i].isActiveMessenger
            }
            setActiveUsers(activeState);
            setActiveUsersMessenger(activeStateForMessenger)
            setCount(data.count);
            setUsersData(data.users);
            setUsersEmailData(data.emailUsers)
            setUsersWhatsappData(data.whatsappUsers)
            setEmailUsersCount(data.emailUsersCount)
            setWhatsappUsersCount(data.whatsappUsersCount)
        })
        .catch(err => {
            apiError(err);
        })
    }

    // Call loadUsersList when filter changes
    React.useEffect(() => {
        loadUsersList();
    }, [limit, page, debouncedUserSearch, statusFilter, statusFilterWhatsapp, value]);

    const handleClose = () => setOpenModal(false);
    const handleDropdownClick = (event) => {
      setAnchorEl(event.currentTarget); 
    };
  
    const handleDropdownClose = () => {
      setAnchorEl(null);
    };


    const handleMenuItemClick = (action) => {
        setSelectedAction(action);
        setOpenModal(true); // Open modal on selecting an action
        handleDropdownClose();
        // if (action == "ImportAllUsers" || action == "ImportGroups")
        //   setIsAdSync(true);
       loadDomainList()
      };

      const loadDomainList = () => {
        api
          .get(routes.DOMAIN.LIST)
          .then((res) => res.data)
          .then((data) => {
            setDomains(data?.domains.filter((domain) => domain.isCredential));
          })
          .catch((error) => {
            apiError(error);
          });
      };

      const syncAllUsers = () => {
        if (selectedDomain == "-1") toast.error("Select a domain!");
        else {
          api
            .post(routes.USERS.SYNC, { groups: null, domainId: selectedDomain })
            .then((res) => res.data)
            .then(async (data) => {
              toast.success(data.message);
              loadUsersList();
              handleCloseModal();
              const decision = await swal({
                text:"Only unique users will be added and users that already belong to group with current access and accordingly access of group will be updated!",
                icon: "warning",
                dangerMode: true,
                closeOnEsc: true,
                buttons: {
                  Close: true,
                },
              });
            })
            .catch((err) => {
              console.log("------", err);
              handleCloseModal();
              apiError(err);
            });
        }
      };


    const downloadUsers = () => {
        api.get(routes.USERS.DOWNLOAD)
        .then(response => response.data)
        .then((data) =>{
            downloadURI(data.url,data.fileName)
        })
        .catch((error) =>{
            apiError(error)
        })
    }

    const changeStatus = (status, userId) =>{
        api.post(routes.USERS.CHANGE_STATUS, {
            status: !status,
            userId
        })
        .then(r => {
            setActiveUsers((prevState) => ({...prevState, [userId]: !activeUsers[userId]}))
            loadUsersList()
        })
        .catch((error)=>{
            apiError(error)
        })
    }

    const changeStatusMessenger = (status, userId) =>{
        api.post(routes.USERS.CHANGE_STATUS_MESSENGER, {
            messengerStatus: !status,
            userId,
        })
        .then(r => {
            setActiveUsersMessenger((prevState) => ({...prevState, [userId]: !activeUsersMessenger[userId]}))
        })
        .catch((error)=>{
            apiError(error)
        })
    }

     

    const deleteUser = (userId) =>{
        api.delete(routes.USERS.DELETE, {
            params:{
                userId
            }
        })
        .then(res => res.data)
        .then((data) => {
            swal("Deleted!", "User has been deleted!", "success", { buttons: false, timer: 1000 });
            loadUsersList();
        })
        .catch((error)=>{
            if(error.response.status == 403) apiError(error)
            else swal("Some error occured!", "Error Deleting user!", "error", { buttons: false, timer: 1000 });
        })    
    }

    
    const loadLicence = () => {
		api.get(routes.HOME.LICENCE)
		.then(res=>res.data)
		.then((data)=>{
 			Cookies.set("URL",data.remainingUserLimit)
			Cookies.set("EmailLimitReached",data.utilisedEmailLimit >= data.user)
			Cookies.set("MessengerLimitReached",data.utilisedMessengerLimit >= data.messenger)
            isEmailLimitReached = Cookies.get("EmailLimitReached")
            isMessengerLimitReached = Cookies.get("MessengerLimitReached")
		})
		.catch((error)=>{
			apiError(error)
		})
	}


    React.useEffect(() => {
        if (!isInitialRender.current) {
            toggleUserDrawer(true, userDetails.userStats.email, userDetails?.userStats?.phoneNumber);
          } else {
            isInitialRender.current = false;
          }
    }, [ userReportPagination.limit, userReportPagination.page ])

    React.useEffect(() => {
        loadLicence();
    }, [])

    React.useEffect(() => {
        loadUsersList();
    }, [ limit, page ])


    React.useEffect(() => {
        loadUsersList()
    }, [ debouncedUserSearch ])

    React.useEffect(() => {
        const handler = setTimeout(()=>{
            setDebouncedUserSearch(search)
        },1000)

        return ()=>{
            clearTimeout(handler)
          }
    }, [ search ])

    React.useEffect(() => {
        setPage(1)
    }, [ search ])

    React.useEffect(()=>{
        loadFeatures()
    },[])


    return (
     <Box className={styles.contentbar}>
           
             <Box className={styles.containerbar}>
              
                <Box className={styles.breadcrumbBar}>
                    <Grid container direction="row" justifyContent="center" alignItems="center" >
                        <Grid item xs={4}>
                            <Typography component='h4' variant='h4' className={styles.page_title}>Users</Typography>
                        </Grid>

                        <Grid item xs={8} align="right">
                       {!isTacEnabled &&  <Button
                            variant="contained"
                            className={`${styles.btn} ${styles.btnSecondary}`}
                            onClick={handleDropdownClick}
                            style={{ marginLeft: "10px" }}
                            endIcon={<ArrowDropDownIcon />}
                        >
                            Bulk Operation
                        </Button>
                       }

                                {/* Dropdown Menu */}
                                <Menu
                                    anchorEl={anchorEl}
                                    open={Boolean(anchorEl)}
                                    onClose={handleDropdownClose}
                                >
                                    <MenuItem onClick={() => handleMenuItemClick("ImportAllUsers")}>Import Users From AD</MenuItem>
                                </Menu>


                            <Button variant="contained" className={`${styles.btn} ${styles.btnPrimary}`} onClick={() => downloadUsers()}><TfiDownload className={styles.icon_position}/>Download Users</Button>
                        </Grid>
                    </Grid>
                </Box>



            <Box className={styles.filterWrapper}>
                <Grid container direction="row" justifyContent="center" alignItems="center" >
                     <Grid item xs={12} md={4} align="left" position="relative">
                         <Box className={styles.TABAnalysis}>
                                <Box sx={{borderColor: 'divider' }}>
                                    <Tabs value={value} onChange={switchTab} aria-label="basic tabs example" className={styles.TabItemButton}>

                                    <Tab label={`All Users  (${count})`} {...a11yProps(0)} />

                                        <Tab label={
                                            <span style={{ display: 'flex', alignItems: 'center', gap: '8px' }}>
                                            <TfiEmail /> {/* Icon */}
                                            Email ({emailUsersCount ? emailUsersCount : 0}) {/* Label */}
                                            </span>
                                            }
                                            {...a11yProps(1)}
                                            />
                                       {areFeaturesLoaded &&  canAccessFeature("TPIR-WA") && <Tab label={
                                                <span style={{ display: 'flex', alignItems: 'center', gap: '8px' }}>
                                                <FaRegCommentAlt /> {/* Icon */}
                                                Whatsapp ({whatsappUsersCount ? whatsappUsersCount : 0}) {/* Label */}
                                                </span>
                                            }
                                            {...a11yProps(2)}
                                            />
                                       }
                                            </Tabs>
                                </Box>
                            </Box>
                    </Grid>

                    <Grid item xs={12} md={8}>
                        <Box className={styles.reportFitter}>
                            <Box display="flex" alignItems="center" gap={1}>
                                {value === 1 && (
                                    <Tooltip title="Filter by Status">
                                        <IconButton onClick={e => setAnchorElStatus(e.currentTarget)}>
                                            <FilterListIcon />
                                        </IconButton>
                                    </Tooltip>
                                )}
                                {value === 2 && (
                                    <Tooltip title="Filter by Status">
                                        <IconButton onClick={e => setAnchorElStatusWhatsapp(e.currentTarget)}>
                                            <FilterListIcon />
                                        </IconButton>
                                    </Tooltip>
                                )}
                                {value === 1 && (
                                    <Menu anchorEl={anchorElStatus} open={Boolean(anchorElStatus)} onClose={() => setAnchorElStatus(null)}>
                                        <MenuItem selected={statusFilter === 'all'} onClick={() => { setStatusFilter('all'); setAnchorElStatus(null); setPage(1); }}>All</MenuItem>
                                        <MenuItem selected={statusFilter === 'active'} onClick={() => { setStatusFilter('active'); setAnchorElStatus(null); setPage(1); }}>Active</MenuItem>
                                        <MenuItem selected={statusFilter === 'inactive'} onClick={() => { setStatusFilter('inactive'); setAnchorElStatus(null); setPage(1); }}>Inactive</MenuItem>
                                    </Menu>
                                )}
                                {value === 2 && (
                                    <Menu anchorEl={anchorElStatusWhatsapp} open={Boolean(anchorElStatusWhatsapp)} onClose={() => setAnchorElStatusWhatsapp(null)}>
                                        <MenuItem selected={statusFilterWhatsapp === 'all'} onClick={() => { setStatusFilterWhatsapp('all'); setAnchorElStatusWhatsapp(null); setPage(1); }}>All</MenuItem>
                                        <MenuItem selected={statusFilterWhatsapp === 'active'} onClick={() => { setStatusFilterWhatsapp('active'); setAnchorElStatusWhatsapp(null); setPage(1); }}>Active</MenuItem>
                                        <MenuItem selected={statusFilterWhatsapp === 'inactive'} onClick={() => { setStatusFilterWhatsapp('inactive'); setAnchorElStatusWhatsapp(null); setPage(1); }}>Inactive</MenuItem>
                                    </Menu>
                                )}
                            </Box>
                                    <Box
                                    className={`${styles.filterSearchBar} ${styles.groupsearchIcon}`}
                                    >
                                    <TextField
                                        className={styles.searchBar}
                                        placeholder="Users"
                                        size="small"
                                        fullWidth
                                        value={search}
                                        onChange={(e) => setSearch(e.target.value)}
                                    />
                                    <Typography component="span" className={styles.search_icon}>
                                        <IoSearchOutline />
                                    </Typography>
                                    </Box>
                        </Box>
                    </Grid>
                 
                   
                </Grid>
            </Box>

            <TabPanel value={value} index={0} className={styles.commontabPanel}>
                 <Box className={styles.contentbarWrap}>  
                 {isEmailLimitReached && isEmailLimitReached == 'true' &&
                 <Collapse in={open}>
		        <Alert sx={{ mb: 2 }} severity="error" className={styles.alert} 
                action={
                    <IconButton
                    aria-label="close"
                    color="inherit"
                    size="medium"
                    onClick={() => {
                        setOpen(false);
                    }}
                    >
                    <CloseIcon fontSize="medium" />
                    </IconButton>
                }
                >
			
			Your user license limit for Email Reporting has been reached.
			 To add more users, please upgrade your license or remove existing users</Alert>
			    </Collapse> 
                 }

                 {areFeaturesLoaded && canAccessFeature("TPIR-WA") && isMessengerLimitReached && isMessengerLimitReached == 'true' &&
                <Collapse in={alertopen}>
		        <Alert sx={{ mb: 2 }} severity="error" className={styles.alert} 
                action={
                    <IconButton
                    aria-label="close"
                    color="inherit"
                    size="medium"
                    onClick={() => {
                        setAlertOpen(false);
                    }}
                    >
                    <CloseIcon fontSize="medium" />
                    </IconButton>
                }
                >
			
			Your user license limit for Whatsapp Reporting has been reached.
			 To add more users, please upgrade your license or remove existing users</Alert>
			</Collapse> 
                 }


                    <TableContainer className={styles.tableContainer}>
                        <Table sx={{ minWidth: 650 }} aria-label="simple table">
                            <TableHead className={styles.thead_background}>
                                <TableRow>
                                    <TableCell >Name / Email</TableCell>
                                    <TableCell >Contact</TableCell>
                                    <TableCell >Type</TableCell>
                                    <TableCell >Reporting Access</TableCell>
                                    {!isTacEnabled && <TableCell>Action</TableCell>}
                                </TableRow>
                                    </TableHead>
                                    
                            <TableBody className={styles.DomainUser}>
                                        {usersData.sort((a, b) => a.name.localeCompare(b.name)).map((data, index) =>(
                                    <TableRow key={index} sx={{ '&:last-child td, &:last-child th': { border: 0 } }}>
                                        <TableCell component="td" className={styles.onlyForPinter} scope="row" style={{ cursor: "pointer" }} onClick={
                                            () => toggleUserDrawer(true,  data.email, data?.phoneNumber)}>
                                                <Box className={styles.flexTableData}>
                                                            <Box className={styles.circle}>
                                                                <Typography component="p" className={styles.circleInner}>
                                                                    {data.name[0]}
                                                                </Typography>
                                                            </Box>

                                                            <Box>
                                                                <Typography variant='h5'>
                                                                    {data.name}
                                                                </Typography>
                                                                <Typography component="span">
                                                                {data.email}
                                                                </Typography>
                                                            </Box>

                                                        </Box>
                                        
                                            </TableCell>

                                        <TableCell component="td" scope="row">{data.phoneNumber ? `+${data.phoneNumber}` : '-'}</TableCell>
                                        <TableCell component="td" scope="row">{data.emailType}</TableCell>
                                        <TableCell component="td" scope="row">
                                            <Box className={styles.dFlexbadge}>
                                            {data.belongToAGroupWithEmailAccess &&
                                                <Typography component="span" className={`${styles.badge} ${styles.badgePrimary}`}>
                                                        Email
                                                </Typography>
                                            }
                                            {data.belongToAGroupWithMessengerAccess && 
                                                <Typography component="span" className={`${styles.badge} ${styles.badgeSuccess}`}>
                                                    Whatsapp
                                                </Typography>
                                            }
                                            </Box>

                                        </TableCell>
                                        {!isTacEnabled && <TableCell>
                                            <Tooltip title="Delete" placement="top-start">
                                                <IconButton aria-label="delete" className={`${styles.actionBtn} ${styles.deleteActionIcon}`}  onClick={() => deleteUserSwal(data._id)}>
                                                    <IoTrash />
                                                </IconButton>
                                            </Tooltip>
                                        </TableCell>}
                                    </TableRow>
                                ))}
                            </TableBody>
                        </Table>
                            {usersData && usersData.length > 0?
                        <Stack spacing={2} direction="row" justifyContent='space-between' alignItems="center">
                            <Pagination 
                                count={count} 
                                page={page}
                                limit={limit}
                                handlePageChange={handlePageChange}
                            ></Pagination>                    
                        </Stack>:
                            <>{ !loader?
                                    <Box className={styles.noRecordMail}>
                                        <Typography component="p">No Records Found!</Typography>
                                    </Box>:
                                    <Box className={styles.noRecordMail}>
                                        <Typography component="p" style={{color: "green"}}>Loading...</Typography>
                                    </Box>
                                }
                            </>
                        }           
                    </TableContainer>
                        
                </Box>
            </TabPanel>

            <TabPanel value={value} index={1} className={styles.commontabPanel}>
                <Box className={styles.contentbarWrap}>
                 <Alert className='alert' sx={{ mb: 2 }} severity="info">To enable email reporting for users, please activate the selected member group in the Groups section. <a href="#" onClick={(e)=> {e.preventDefault(), router.push('/groups')}}>View Groups</a></Alert>
                  
                    <TableContainer className={styles.tableContainer}>
                        <Table sx={{ minWidth: 650 }} aria-label="simple table">
                            <TableHead className={styles.thead_background}>
                                <TableRow>
                                    <TableCell >Name / Email</TableCell>
                                    <TableCell >Group</TableCell>
                                    <TableCell >Contact</TableCell>
                                    <TableCell >Type</TableCell> 
                                    <TableCell >Status</TableCell>
                                </TableRow>
                                    </TableHead>
                                    
                            <TableBody className={styles.DomainUser}>
                                        {usersEmailData.sort((a, b) => a.name.localeCompare(b.name)).map((data, index) =>(
                                    <TableRow key={index} sx={{ '&:last-child td, &:last-child th': { border: 0 } }}>
                                      
                                        <TableCell component="td" className={styles.onlyForPinter} scope="row" style={{ cursor: "pointer" }} onClick={()=> toggleUserDrawer(true,  data.email, data?.phoneNumber)}>
                                                <Box className={styles.flexTableData}>
                                                            <Box className={styles.circle}>
                                                                <Typography component="p" className={styles.circleInner}>
                                                                    {data.name[0]}
                                                                </Typography>
                                                            </Box>

                                                            <Box>
                                                                <Typography variant='h5'>
                                                                    {data.name}
                                                                </Typography>
                                                                <Typography component="span">
                                                                {data.email}
                                                                </Typography>
                                                            </Box>

                                                        </Box>
                                        
                                            </TableCell>
                                            <TableCell component="td" scope="row">All-Users-TPIR</TableCell>
                                        <TableCell component="td" scope="row">{data.phoneNumber ? `+${data.phoneNumber}` : '-'}</TableCell>
                                        <TableCell component="td" scope="row">{data.emailType}</TableCell>
                                        <TableCell component="td" scope="row"><Switch className={styles.SwitchTab} size="small" color="success" checked={activeUsers[data._id]} onClick={() => changeStatus(activeUsers[data._id], data._id)} /></TableCell>
                                      
                                    </TableRow>
                                ))}
                            </TableBody>
                        </Table>
                            {usersEmailData && usersEmailData.length > 0?
                        <Stack spacing={2} direction="row" justifyContent='space-between' alignItems="center">
                            <Pagination 
                                count={emailUsersCount} 
                                page={page}
                                limit={limit}
                                handlePageChange={handlePageChange}
                            ></Pagination>                    
                        </Stack>:
                            <>{ !loader?
                                    <Box className={styles.noRecordMail}>
                                        <Typography component="p">No Records Found!</Typography>
                                    </Box>:
                                    <Box className={styles.noRecordMail}>
                                        <Typography component="p" style={{color: "green"}}>Loading...</Typography>
                                    </Box>
                                }
                            </>
                        }           
                    </TableContainer>
                        
                </Box>
            </TabPanel>

            <TabPanel value={value} index={2} className={styles.commontabPanel}>
            <Box className={styles.contentbarWrap}>
                <Alert className='alert' sx={{ mb: 2 }} severity="info">To enable whatsapp reporting for users, please activate the selected member group in the Groups section. <a href="#" onClick={(e)=> {e.preventDefault(), router.push('/groups')}}>View Groups</a></Alert>
                    <TableContainer className={styles.tableContainer}>
                        <Table sx={{ minWidth: 650 }} aria-label="simple table">
                            <TableHead className={styles.thead_background}>
                                <TableRow>
                                    <TableCell >Name / Email</TableCell>
                                    <TableCell >Group</TableCell>
                                    <TableCell >Contact</TableCell>
                                    <TableCell >Type</TableCell>
                                   
                                    <TableCell >Status</TableCell>
                                </TableRow>
                                    </TableHead>
                                    
                            <TableBody className={styles.DomainUser}>
                                        {usersWhatsappData.sort((a, b) => a.name.localeCompare(b.name)).map((data, index) =>(
                                    <TableRow key={index} sx={{ '&:last-child td, &:last-child th': { border: 0 } }}>
                                        <TableCell component="td" className={styles.onlyForPinter} scope="row" style={{ cursor: "pointer" }} onClick={()=> toggleUserDrawer(true,  data.email, data?.phoneNumber)}>
                                                <Box className={styles.flexTableData}>
                                                            <Box className={styles.circle}>
                                                                <Typography component="p" className={styles.circleInner}>
                                                                    {data.name[0]}
                                                                </Typography>
                                                            </Box>
                                                            

                                                            <Box>
                                                                <Typography variant='h5'>
                                                                    {data.name}
                                                                </Typography>
                                                                <Typography component="span">
                                                                {data.email}
                                                                </Typography>
                                                            </Box>

                                                        </Box>
                                        
                                            </TableCell>
                                            <TableCell component="td" scope="row">All-Users-TPIR</TableCell>

                                        <TableCell component="td" scope="row">{data.phoneNumber ? `+${data.phoneNumber}` : '-'}</TableCell>
                                        <TableCell component="td" scope="row">{data.emailType}</TableCell>
                                      

                                        <TableCell component="td" scope="row"><Switch className={styles.SwitchTab} size="small" color="success" checked={activeUsersMessenger[data._id]} onClick={() => changeStatusMessenger(activeUsersMessenger[data._id], data._id)} /></TableCell>
                                    </TableRow>
                                ))}
                            </TableBody>
                        </Table>
                            {usersWhatsappData && usersWhatsappData.length > 0?
                        <Stack spacing={2} direction="row" justifyContent='space-between' alignItems="center">
                            <Pagination 
                                count={whatsappUsersCount} 
                                page={page}
                                limit={limit}
                                handlePageChange={handlePageChange}
                            ></Pagination>                    
                        </Stack>:
                            <>{ !loader?
                                    <Box className={styles.noRecordMail}>
                                        <Typography component="p">No Records Found!</Typography>
                                    </Box>:
                                    <Box className={styles.noRecordMail}>
                                        <Typography component="p" style={{color: "green"}}>Loading...</Typography>
                                    </Box>
                                }
                            </>
                        }           
                    </TableContainer>
                        
                </Box>
            </TabPanel>




          

         </Box>
         
         <UserDrawer toggleUserDrawer={toggleUserDrawer} userDrawerState={userDrawerState} userStats={userDetails.userStats} reportedMails = {userDetails.reportedMails} reportedMessages = {userDetails.reportedMessages} userReportPagination={userReportPagination} setUserReportPagination={setUserReportPagination} userReportMessagePagination={userReportMessagePagination} setUserReportMessagePagination={setUserReportMessagePagination} handlePageChangeReports={handlePageChangeReports} handlePageChangeMessageReports={handlePageChangeMessageReports}   ></UserDrawer>



<Modal
open={openModal}
onClose={handleCloseModal}
aria-labelledby="modal-title"
aria-describedby="modal-description"
className={styles.mainModalBox}
>
<Box className={styles.modalBox}>
  {/* Modal Content Based on Selected Action */}
              <Box className={styles.modalHeader}>
                <Box>
                    <Box display="flex" alignItems="center">
                        <Typography variant="h6">Bulk Import Groups</Typography>
                        <Tooltip title="Bulk operation only does incremental sync: it will only add new users or update existing ones since the last run; deletions (users removed from AD) are not processed." arrow>
                        <IconButton size="small">
                            <PublicIcon fontSize="small" color="action" />
                        </IconButton>
                        </Tooltip>
                    </Box>
                  <Typography component="p">
                  Synchronize your groups from Active Directory
                  </Typography>
                </Box>

                <CloseSharpIcon
                  className={styles.closeIcon}
                  onClick={handleCloseModal}
                />
              </Box>

              <Box className={styles.modalBody}>
                <label
                  sx={{
                    fontWeight: "600",
                    fontSize: "14px",
                    color: " #6c757d",
                  }}
                >
                  Select Domain 
                </label>
                <Select
                  value={selectedDomain}
                  onChange={handleDomainSelect}
                  fullWidth
                  displayEmpty
                  className={styles.inputSelect}
                >
                  <MenuItem value="-1" disabled>
                    Select Domain
                  </MenuItem>
                    {domains.map((domain) => (
                        <MenuItem
                            key={domain._id}
                            value={domain._id}
                            sx={{ fontSize: "14px", marginTop: "0.5rem" }}
                        >
                            <Box display="flex" justifyContent="space-between" width="100%">
                            <Typography component="span">
                                {domain.domainName}
                            </Typography>
                            <Typography
                                component="span"
                                className={`${styles.badge} ${styles.badgePrimary}`}
                            >
                                {domain.domainType === 'Outlook'
                                ? domain.domainTypeForOutlook
                                : domain.domainType}
                            </Typography>
                            </Box>
                        </MenuItem>
                        ))}
                </Select>

                <Alert className={styles.alert} severity="info">Your remaining total user limit is {remainingUserLimit ? remainingUserLimit : ''}. Ensure your group has no more than {remainingUserLimit ? remainingUserLimit : ''} users; otherwise, only the first {remainingUserLimit ? remainingUserLimit : ''} users will be synced.</Alert>
              </Box>

              <Box className={styles.modalFooter}>
                <Grid container>
                  <Grid item xs={12} md={12} align="right" position="relative">
                    <Button variant="contained" onClick={syncAllUsers}>
                      Sync users
                    </Button>
                  </Grid>
                </Grid>
              </Box>

</Box>
</Modal>
    </Box>







      );

}