import React from 'react';
import { useRouter } from 'next/router';
import { IoSearchOutline } from "react-icons/io5";
import {
    Box, Grid, TextField, Typography, MenuItem,
    Select, FormControl, TableRow, TableHead,
    TableContainer, TableCell, TableBody, Table
} from '@mui/material'

import api from '../../utils/api';
import routes from '../../utils/routes';
import { apiError } from '../../utils/error';
import { getDate } from '../../utils/common';
import styles from '../../styles/home.module.scss';
import { FaWhatsapp } from "react-icons/fa";
import Pagination from '../../components/globlePagination';
import { AppContext } from '../../components/appcontext';
import { useFeatures } from '../../utils/features';


export default function Reported() {
    const router = useRouter()
    const { loadFeatures, canAccessFeature, areFeaturesLoaded } = useFeatures()

    const [ page, setPage ] = React.useState(1);
    const [ count, setCount ] = React.useState(1);
    const [ limit, setLimit ] = React.useState(10);
    const [ search, setSearch ] = React.useState('');
    const [ loader, setLoader ] = React.useState(false);
    const [ domains,setDomains] = React.useState([])
    const [ selectedDomain, setSelectedDomain ] = React.useState('-1');
    const [ reportedMessages, setReportedMessages ] = React.useState([]);

    
    const handleSelectedDomain = (event) => {
        setSelectedDomain(event.target.value)
        setPage(1)
    }

    const handlePageChange = (event, value) => {
        setPage(value);
    };

    const domainList = () =>{
        api.get(routes.DOMAIN.LIST)
        .then(res => res.data)
        .then((data) =>{
            if(data.domains.length && data.domains.length > 0) {
                const domain = data.domains.filter((element)=>{
                    if(element.isCredential !== false) return element
                })
                setDomains(domain)
            }
        })
        .catch((error)=>{
            apiError(error)
        })
    }

    const loadReportedMessages = () => {
        setLoader(true);
        api.get(routes.WHATSAPP.LIST, { 
            params: { 
                page, limit, search, 
            } 
        })
        .then(res => res.data)
        .then(data => {
            setLoader(false)
            setCount(data.count)
            setReportedMessages(data.messages);
        })
        .catch(err => {
            setLoader(false)
            apiError(err);
        })
    }

    const reportedMessage = (id) =>{
       router.push(`/whatsapp/${id}`)
        
    }

    React.useEffect(()=>{
        loadFeatures()
    },[])
  
    React.useEffect(() => {
        loadReportedMessages();
    }, [ limit, page, search ])


    React.useEffect(() => {
        domainList()
    }, [ ])

    React.useEffect(() => {
        setPage(1)
    }, [ search ])

    
    React.useEffect(() => {
        if(canAccessFeature("TPIR-WA")){
            loadReportedMessages()
        }
        else{
            if(areFeaturesLoaded) router.push('/feature-unavailable')
        }
    }, [ areFeaturesLoaded ])

    return (
        !areFeaturesLoaded ? <box>Loading</box> :

        <Box className={styles.ReportedBox}>
            <Box className={styles.containerbar}>
                <Box className={styles.breadcrumbBar}>

                    <Grid container direction="row" justifyContent="center" alignItems="center" >
                        <Grid item xs={4}>
                            <Typography component='h4' variant='h4' className={styles.page_title} sx={{marginTop:"6px"}}>Whatsapp Reporting</Typography>
                        </Grid>
                        <Grid item xs={8}>
                        </Grid>
                    </Grid>
                    
                </Box>
                <Box className={styles.filterWrapper}>
                    <Grid container direction="row" justifyContent="center" alignItems="center" >
                    <Grid item xs={12} md={4} align="left" position="relative">
                         <Box className={styles.filterSearchBar}>
                            <TextField 
                                className={styles.searchBar} 
                                placeholder='Search' 
                                size="small" 
                                fullWidth
                                value={search} 
                                onChange={e => setSearch(e.target.value)}
                            />
                       
                            <Typography component="span" className={styles.search_icon} ><IoSearchOutline /> </Typography>
                            </Box>
                        </Grid>
                        <Grid item xs={12} md={8}>
                        <Box className={styles.reportFitter}>
                            {/* <FormControl sx={{ minWidth: 100 }} size="small">
                                <Select 
                                 className={`${styles.btn} ${styles.btnPrimaryDrop}`}
                                    labelId="demo-simple-select-autowidth-label"
                                    id="demo-simple-select-autowidth"
                                    value={selectedDomain}
                                    onChange={handleSelectedDomain}
                                    autoWidth
                                    displayEmpty
                                    sx={{ boxShadow: 'none', '.MuiOutlinedInput-notchedOutline': { borderRadius: '0px', paddginLeft: '20px' } }}
                                >
                                    <MenuItem value="-1">Select Domain</MenuItem>
                                    {domains.map((data) => <MenuItem value={data._id}  key={data._id} >{data.domainName} ({data.domainType}) </MenuItem>)}
                                </Select>
                            </FormControl> */}

                            <FormControl >
                                    <Select
                                    className={`${styles.btn} ${styles.btnPrimaryDrop}`}
                                        labelId="demo-simple-select-autowidth-label"
                                        id="demo-simple-select-autowidth"
                                        value={limit}
                                        onChange={e => setLimit(e.target.value)}
                                        autoWidth
                                        displayEmpty
                                        sx={{ boxShadow: 'none', '.MuiOutlinedInput-notchedOutline': { borderRadius: '0px', border: '1px solid #f8f8f8', paddginLeft: '20px' } }}
                                    >
                                        <MenuItem value="10">10 </MenuItem>
                                        <MenuItem value="25">25 </MenuItem>
                                        <MenuItem value="50">50 </MenuItem>
                                        <MenuItem value="100">100 </MenuItem>
                                    </Select>
                                </FormControl>
                        </Box>
                        </Grid>

                     

                       
                    </Grid>
                </Box>

   <Box className={styles.contentbarWrap}>
                <TableContainer className={styles.tableContainer}>
                    <Table sx={{ minWidth: 650 }} aria-label="simple table" className={styles.ReportedMailTable}>
                        <TableHead className={styles.thead_background}>
                            <TableRow>
                                 <TableCell sx={{width:"0%"}}><FaWhatsapp/></TableCell>
                                <TableCell className={styles.td1} >Reported By</TableCell>
                                <TableCell className={styles.td2}>Phone</TableCell>
                                {/* <TableCell className={styles.td3}>Message</TableCell>                                 */}
                                <TableCell>Reported Date & Time</TableCell> 
                                {/* <TableCell>AI Detected Result</TableCell>  */}
                                {/* <TableCell>Marked As</TableCell>                                */}
                            </TableRow>
                        </TableHead>
                        {reportedMessages && reportedMessages.length > 0 &&
                            <TableBody className={styles.reportedMail}>
                                {reportedMessages.map((data, index) => (
                                    <TableRow key={index} sx={{ '&:last-child td, &:last-child th': { border: 0 } }} onClick={()=>reportedMessage(data._id)}>
                                         <TableCell><FaWhatsapp className={styles.emailIcon}/></TableCell>
                                        <TableCell component="td" scope="row">
                                        <Typography component="p"><b className={styles.reportName}> {data.from}</b> </Typography>
                                         {/* <Typography component="p">ashutosh.kumar@kratikal.com</Typography> */}
                                      </TableCell>
                                        <TableCell component="td" scope="row">
                                            <Typography component="p"><b>+{data.phoneNumber}</b></Typography>
                                        </TableCell>
                                       
                                        {/* <TableCell component="td" scope="row" style={{ maxWidth: '200px', whiteSpace: 'nowrap', overflow: 'hidden', textOverflow: 'ellipsis' }}>{data.message ? data.message : "No text found in image"}</TableCell> */}
                                      
                                        <TableCell component="td" scope="row">
                                            <Box className={styles.mddelete}>
                                                <Typography component="p">{getDate(data.createdAt)}</Typography>
                                            </Box>
                                        </TableCell>
                                        {/* <TableCell component="td" scope="row" ><Typography component="p"><span className={data.result == 'Safe' ? `${styles.WhatSappStatus} ${styles.whatSappStatusgreen}`:data.result == 'Unsafe' ? `${styles.WhatSappStatus} ` : ''}>{data.result == 'Safe' || data.result == 'Unsafe' ? data.result : <span >Invalid Content</span>}</span></Typography></TableCell> */}
                                        {/* <TableCell component="td" scope="row" >{data.result !== null ? data.status == 'No Action' ? "Pending" : data.status : 'Invalid Content' }</TableCell> */}
                                        {/* <TableCell component="td" scope="row" >  <Typography component="p" className={data.status == 'No Action' ? `${styles.whatsappResultAdmin}` : data.status == 'Safe' ? `${styles.whatsappResultAdminSafe}` : `${styles.whatsappResultAdminUnsafe}` }>{data.result !== null ? data.status == 'No Action' ? "Pending" : data.status : <Typography>-</Typography> }</Typography></TableCell> */}
                                    </TableRow>
                                ))}
                            </TableBody>
                        }
                    </Table>
                    {reportedMessages && reportedMessages.length > 0?
                    <Pagination
                        count={count}
                        page={page}
                        limit={limit}
                        handlePageChange={handlePageChange}
                    ></Pagination>:
                    <>{ !loader?
                            <Box className={styles.noRecordMail}>
                                <Typography component="p">No Records Found!</Typography>
                            </Box>:
                            <Box className={styles.noRecordMail}>
                                <Typography component="p" style={{color: "green"}}>Loading...</Typography>
                            </Box>
                        }
                    </>
                }
                </TableContainer>
                </Box>
             
                {/* { loader && <Loader />} */}
            </Box>
        </Box>
    );
}
