import Axios from "axios";
import Cookies from 'js-cookie';
import CryptoJS from 'crypto-js';


const url = `${process.env.NEXT_PUBLIC_API_URL}`;

const api = Axios.create({
    baseURL: `${url}/api/v1`,
    withCredentials: true,
    headers: {
        'Accept': 'application/json',
        'Content-Type': 'application/json'
    }
});

const includedRoutes = [
    '/admin/change-password',
    '/admin/login',
    '/admin/register',
    '/admin/reset-password',
    '/settings/updateSmtp',
    '/settings/virus-total',
    '/domain/domain-credential-outlook',
    '/domain/domain-credential-gsuite'
];

const secretKey = `${process.env.NEXT_PUBLIC_SECRET_KEY}`; 

// api.defaults.headers.common['Authorization'] = `Bearer ${Cookies.get('token')}`;
// api.defaults.headers.common['Referrer-Policy'] = 'origin';
// api.defaults.headers.common['X-Content-Type-Options'] = 'nosniff';
// api.defaults.headers.common['Content-Security-Policy'] = 'default-src none';
// api.defaults.headers.common['Strict-Transport-Security'] = ' max-age=63072000; includeSubDomains; preload';
api.interceptors.request.use(config => {
    if (includedRoutes.includes(config.url)) {
        if (config.data && typeof config.data === 'object') {
            config.data = Object.fromEntries(
                Object.entries(config.data).map(([key, value]) => {
                    const encrypted = CryptoJS.AES.encrypt(JSON.stringify(value), secretKey).toString();
                    return [key, encrypted];
                })
            );
        }
    }
    return config;
}, error => {
    return Promise.reject(error);
});



export default api;