import React, { useState, useEffect, useCallback } from 'react';
import api from '../utils/api';
import routes from '../utils/routes';


export async function getCompanyFeatures() {
  try {
    const { data } = await api.get(routes.PACKAGE.CHECK);
    return data.success ? data.features : [];
  } catch {
    return [];
  }
}


export const useFeatures = () => {
  const [features, setFeatures] = useState([]);
  const [areFeaturesLoaded, setAreFeaturesLoaded] = useState(false);

  const loadFeatures = useCallback(async () => {
    try {
      const { data } = await api.get(routes.PACKAGE.CHECK);
      setFeatures(data.success ? data.features : []);
    } catch {
      setFeatures([]);
    } finally {
      setAreFeaturesLoaded(true);
    }
  }, []);

  useEffect(() => {
    loadFeatures();
  }, [loadFeatures]);

  const canAccessFeature = feature => {
    console.log('Checking feature:', feature);
    return areFeaturesLoaded && features.includes(feature);
  };

  return { features, areFeaturesLoaded, loadFeatures, canAccessFeature };
};
